/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.models.awd.v2024_05_09;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.threeten.bp.OffsetDateTime;
import software.amazon.spapi.models.awd.v2024_05_09.Address;
import software.amazon.spapi.models.awd.v2024_05_09.CarrierCode;
import software.amazon.spapi.models.awd.v2024_05_09.DistributionPackageQuantity;
import software.amazon.spapi.models.awd.v2024_05_09.InboundShipmentStatus;
import software.amazon.spapi.models.awd.v2024_05_09.InventoryQuantity;
import software.amazon.spapi.models.awd.v2024_05_09.SkuQuantity;

@Schema(description="Represents an AWD inbound shipment.")
public class InboundShipment {
    @SerializedName(value="carrierCode")
    private CarrierCode carrierCode = null;
    @SerializedName(value="createdAt")
    private OffsetDateTime createdAt = null;
    @SerializedName(value="destinationAddress")
    private Address destinationAddress = null;
    @SerializedName(value="externalReferenceId")
    private String externalReferenceId = null;
    @SerializedName(value="orderId")
    private String orderId = null;
    @SerializedName(value="originAddress")
    private Address originAddress = null;
    @SerializedName(value="receivedQuantity")
    private List<InventoryQuantity> receivedQuantity = null;
    @SerializedName(value="shipBy")
    private OffsetDateTime shipBy = null;
    @SerializedName(value="shipmentContainerQuantities")
    private List<DistributionPackageQuantity> shipmentContainerQuantities = new ArrayList<DistributionPackageQuantity>();
    @SerializedName(value="shipmentId")
    private String shipmentId = null;
    @SerializedName(value="shipmentSkuQuantities")
    private List<SkuQuantity> shipmentSkuQuantities = null;
    @SerializedName(value="destinationRegion")
    private String destinationRegion = null;
    @SerializedName(value="shipmentStatus")
    private InboundShipmentStatus shipmentStatus = null;
    @SerializedName(value="trackingId")
    private String trackingId = null;
    @SerializedName(value="updatedAt")
    private OffsetDateTime updatedAt = null;
    @SerializedName(value="warehouseReferenceId")
    private String warehouseReferenceId = null;

    public InboundShipment carrierCode(CarrierCode carrierCode) {
        this.carrierCode = carrierCode;
        return this;
    }

    @Schema(description="")
    public CarrierCode getCarrierCode() {
        return this.carrierCode;
    }

    public void setCarrierCode(CarrierCode carrierCode) {
        this.carrierCode = carrierCode;
    }

    public InboundShipment createdAt(OffsetDateTime createdAt) {
        this.createdAt = createdAt;
        return this;
    }

    @Schema(description="Timestamp when the shipment was created. The date is returned in <a href='https://developer-docs.amazon.com/sp-api/docs/iso-8601'>ISO 8601</a> format.")
    public OffsetDateTime getCreatedAt() {
        return this.createdAt;
    }

    public void setCreatedAt(OffsetDateTime createdAt) {
        this.createdAt = createdAt;
    }

    public InboundShipment destinationAddress(Address destinationAddress) {
        this.destinationAddress = destinationAddress;
        return this;
    }

    @Schema(required=true, description="")
    public Address getDestinationAddress() {
        return this.destinationAddress;
    }

    public void setDestinationAddress(Address destinationAddress) {
        this.destinationAddress = destinationAddress;
    }

    public InboundShipment externalReferenceId(String externalReferenceId) {
        this.externalReferenceId = externalReferenceId;
        return this;
    }

    @Schema(example="TestReferenceId", description="Client-provided reference ID that can correlate this shipment to client resources. For example, to map this shipment to an internal bookkeeping order record.")
    public String getExternalReferenceId() {
        return this.externalReferenceId;
    }

    public void setExternalReferenceId(String externalReferenceId) {
        this.externalReferenceId = externalReferenceId;
    }

    public InboundShipment orderId(String orderId) {
        this.orderId = orderId;
        return this;
    }

    @Schema(required=true, description="The AWD inbound order ID that this inbound shipment belongs to.")
    public String getOrderId() {
        return this.orderId;
    }

    public void setOrderId(String orderId) {
        this.orderId = orderId;
    }

    public InboundShipment originAddress(Address originAddress) {
        this.originAddress = originAddress;
        return this;
    }

    @Schema(required=true, description="")
    public Address getOriginAddress() {
        return this.originAddress;
    }

    public void setOriginAddress(Address originAddress) {
        this.originAddress = originAddress;
    }

    public InboundShipment receivedQuantity(List<InventoryQuantity> receivedQuantity) {
        this.receivedQuantity = receivedQuantity;
        return this;
    }

    public InboundShipment addReceivedQuantityItem(InventoryQuantity receivedQuantityItem) {
        if (this.receivedQuantity == null) {
            this.receivedQuantity = new ArrayList<InventoryQuantity>();
        }
        this.receivedQuantity.add(receivedQuantityItem);
        return this;
    }

    @Schema(description="Quantity received (at the receiving end) as part of this shipment.")
    public List<InventoryQuantity> getReceivedQuantity() {
        return this.receivedQuantity;
    }

    public void setReceivedQuantity(List<InventoryQuantity> receivedQuantity) {
        this.receivedQuantity = receivedQuantity;
    }

    public InboundShipment shipBy(OffsetDateTime shipBy) {
        this.shipBy = shipBy;
        return this;
    }

    @Schema(description="Timestamp when the shipment will be shipped.")
    public OffsetDateTime getShipBy() {
        return this.shipBy;
    }

    public void setShipBy(OffsetDateTime shipBy) {
        this.shipBy = shipBy;
    }

    public InboundShipment shipmentContainerQuantities(List<DistributionPackageQuantity> shipmentContainerQuantities) {
        this.shipmentContainerQuantities = shipmentContainerQuantities;
        return this;
    }

    public InboundShipment addShipmentContainerQuantitiesItem(DistributionPackageQuantity shipmentContainerQuantitiesItem) {
        this.shipmentContainerQuantities.add(shipmentContainerQuantitiesItem);
        return this;
    }

    @Schema(required=true, description="Packages that are part of this shipment.")
    public List<DistributionPackageQuantity> getShipmentContainerQuantities() {
        return this.shipmentContainerQuantities;
    }

    public void setShipmentContainerQuantities(List<DistributionPackageQuantity> shipmentContainerQuantities) {
        this.shipmentContainerQuantities = shipmentContainerQuantities;
    }

    public InboundShipment shipmentId(String shipmentId) {
        this.shipmentId = shipmentId;
        return this;
    }

    @Schema(required=true, description="Unique shipment ID.")
    public String getShipmentId() {
        return this.shipmentId;
    }

    public void setShipmentId(String shipmentId) {
        this.shipmentId = shipmentId;
    }

    public InboundShipment shipmentSkuQuantities(List<SkuQuantity> shipmentSkuQuantities) {
        this.shipmentSkuQuantities = shipmentSkuQuantities;
        return this;
    }

    public InboundShipment addShipmentSkuQuantitiesItem(SkuQuantity shipmentSkuQuantitiesItem) {
        if (this.shipmentSkuQuantities == null) {
            this.shipmentSkuQuantities = new ArrayList<SkuQuantity>();
        }
        this.shipmentSkuQuantities.add(shipmentSkuQuantitiesItem);
        return this;
    }

    @Schema(description="Quantity details at SKU level for the shipment. This attribute will only appear if the skuQuantities parameter in the request is set to SHOW.")
    public List<SkuQuantity> getShipmentSkuQuantities() {
        return this.shipmentSkuQuantities;
    }

    public void setShipmentSkuQuantities(List<SkuQuantity> shipmentSkuQuantities) {
        this.shipmentSkuQuantities = shipmentSkuQuantities;
    }

    public InboundShipment destinationRegion(String destinationRegion) {
        this.destinationRegion = destinationRegion;
        return this;
    }

    @Schema(example="us-west", description="Assigned region where the order will be shipped. This can differ from what was passed as preference. AWD currently supports following region IDs: [us-west, us-east, us-southcentral, us-southeast]")
    public String getDestinationRegion() {
        return this.destinationRegion;
    }

    public void setDestinationRegion(String destinationRegion) {
        this.destinationRegion = destinationRegion;
    }

    public InboundShipment shipmentStatus(InboundShipmentStatus shipmentStatus) {
        this.shipmentStatus = shipmentStatus;
        return this;
    }

    @Schema(required=true, description="")
    public InboundShipmentStatus getShipmentStatus() {
        return this.shipmentStatus;
    }

    public void setShipmentStatus(InboundShipmentStatus shipmentStatus) {
        this.shipmentStatus = shipmentStatus;
    }

    public InboundShipment trackingId(String trackingId) {
        this.trackingId = trackingId;
        return this;
    }

    @Schema(description="Carrier-unique tracking ID for this shipment.")
    public String getTrackingId() {
        return this.trackingId;
    }

    public void setTrackingId(String trackingId) {
        this.trackingId = trackingId;
    }

    public InboundShipment updatedAt(OffsetDateTime updatedAt) {
        this.updatedAt = updatedAt;
        return this;
    }

    @Schema(description="Timestamp when the shipment was updated. The date is returned in <a href='https://developer-docs.amazon.com/sp-api/docs/iso-8601'>ISO 8601</a> format.")
    public OffsetDateTime getUpdatedAt() {
        return this.updatedAt;
    }

    public void setUpdatedAt(OffsetDateTime updatedAt) {
        this.updatedAt = updatedAt;
    }

    public InboundShipment warehouseReferenceId(String warehouseReferenceId) {
        this.warehouseReferenceId = warehouseReferenceId;
        return this;
    }

    @Schema(example="TestWarehouseReferenceId", description="An AWD-provided reference ID that you can use to interact with the warehouse. For example, a carrier appointment booking.")
    public String getWarehouseReferenceId() {
        return this.warehouseReferenceId;
    }

    public void setWarehouseReferenceId(String warehouseReferenceId) {
        this.warehouseReferenceId = warehouseReferenceId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InboundShipment inboundShipment = (InboundShipment)o;
        return Objects.equals(this.carrierCode, inboundShipment.carrierCode) && Objects.equals(this.createdAt, inboundShipment.createdAt) && Objects.equals(this.destinationAddress, inboundShipment.destinationAddress) && Objects.equals(this.externalReferenceId, inboundShipment.externalReferenceId) && Objects.equals(this.orderId, inboundShipment.orderId) && Objects.equals(this.originAddress, inboundShipment.originAddress) && Objects.equals(this.receivedQuantity, inboundShipment.receivedQuantity) && Objects.equals(this.shipBy, inboundShipment.shipBy) && Objects.equals(this.shipmentContainerQuantities, inboundShipment.shipmentContainerQuantities) && Objects.equals(this.shipmentId, inboundShipment.shipmentId) && Objects.equals(this.shipmentSkuQuantities, inboundShipment.shipmentSkuQuantities) && Objects.equals(this.destinationRegion, inboundShipment.destinationRegion) && Objects.equals((Object)this.shipmentStatus, (Object)inboundShipment.shipmentStatus) && Objects.equals(this.trackingId, inboundShipment.trackingId) && Objects.equals(this.updatedAt, inboundShipment.updatedAt) && Objects.equals(this.warehouseReferenceId, inboundShipment.warehouseReferenceId);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.carrierCode, this.createdAt, this.destinationAddress, this.externalReferenceId, this.orderId, this.originAddress, this.receivedQuantity, this.shipBy, this.shipmentContainerQuantities, this.shipmentId, this.shipmentSkuQuantities, this.destinationRegion, this.shipmentStatus, this.trackingId, this.updatedAt, this.warehouseReferenceId});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class InboundShipment {\n");
        sb.append("    carrierCode: ").append(this.toIndentedString(this.carrierCode)).append("\n");
        sb.append("    createdAt: ").append(this.toIndentedString(this.createdAt)).append("\n");
        sb.append("    destinationAddress: ").append(this.toIndentedString(this.destinationAddress)).append("\n");
        sb.append("    externalReferenceId: ").append(this.toIndentedString(this.externalReferenceId)).append("\n");
        sb.append("    orderId: ").append(this.toIndentedString(this.orderId)).append("\n");
        sb.append("    originAddress: ").append(this.toIndentedString(this.originAddress)).append("\n");
        sb.append("    receivedQuantity: ").append(this.toIndentedString(this.receivedQuantity)).append("\n");
        sb.append("    shipBy: ").append(this.toIndentedString(this.shipBy)).append("\n");
        sb.append("    shipmentContainerQuantities: ").append(this.toIndentedString(this.shipmentContainerQuantities)).append("\n");
        sb.append("    shipmentId: ").append(this.toIndentedString(this.shipmentId)).append("\n");
        sb.append("    shipmentSkuQuantities: ").append(this.toIndentedString(this.shipmentSkuQuantities)).append("\n");
        sb.append("    destinationRegion: ").append(this.toIndentedString(this.destinationRegion)).append("\n");
        sb.append("    shipmentStatus: ").append(this.toIndentedString((Object)this.shipmentStatus)).append("\n");
        sb.append("    trackingId: ").append(this.toIndentedString(this.trackingId)).append("\n");
        sb.append("    updatedAt: ").append(this.toIndentedString(this.updatedAt)).append("\n");
        sb.append("    warehouseReferenceId: ").append(this.toIndentedString(this.warehouseReferenceId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

