/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.models.awd.v2024_05_09;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;

@Schema(description="Preferences that can be passed in context of an inbound order")
public class InboundPreferences {
    @SerializedName(value="destinationRegion")
    private String destinationRegion = null;

    public InboundPreferences destinationRegion(String destinationRegion) {
        this.destinationRegion = destinationRegion;
        return this;
    }

    @Schema(description="Pass a preferred region so that the inbound order can be shipped to an AWD warehouse located in that region. This doesn't guarantee the order to be assigned in the specified destination region as it depends on warehouse capacity availability. AWD currently supports following region IDs: [us-west, us-east, us-southcentral, us-southeast]")
    public String getDestinationRegion() {
        return this.destinationRegion;
    }

    public void setDestinationRegion(String destinationRegion) {
        this.destinationRegion = destinationRegion;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InboundPreferences inboundPreferences = (InboundPreferences)o;
        return Objects.equals(this.destinationRegion, inboundPreferences.destinationRegion);
    }

    public int hashCode() {
        return Objects.hash(this.destinationRegion);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class InboundPreferences {\n");
        sb.append("    destinationRegion: ").append(this.toIndentedString(this.destinationRegion)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

