/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.models.awd.v2024_05_09;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import software.amazon.spapi.models.awd.v2024_05_09.Address;
import software.amazon.spapi.models.awd.v2024_05_09.DistributionPackageQuantity;
import software.amazon.spapi.models.awd.v2024_05_09.InboundPreferences;

@Schema(description="Payload for creating an inbound order.")
public class InboundOrderCreationData {
    @SerializedName(value="externalReferenceId")
    private String externalReferenceId = null;
    @SerializedName(value="originAddress")
    private Address originAddress = null;
    @SerializedName(value="packagesToInbound")
    private List<DistributionPackageQuantity> packagesToInbound = new ArrayList<DistributionPackageQuantity>();
    @SerializedName(value="preferences")
    private InboundPreferences preferences = null;

    public InboundOrderCreationData externalReferenceId(String externalReferenceId) {
        this.externalReferenceId = externalReferenceId;
        return this;
    }

    @Schema(example="TestReferenceId", description="Reference ID that can be used to correlate the order with partner resources.")
    public String getExternalReferenceId() {
        return this.externalReferenceId;
    }

    public void setExternalReferenceId(String externalReferenceId) {
        this.externalReferenceId = externalReferenceId;
    }

    public InboundOrderCreationData originAddress(Address originAddress) {
        this.originAddress = originAddress;
        return this;
    }

    @Schema(required=true, description="")
    public Address getOriginAddress() {
        return this.originAddress;
    }

    public void setOriginAddress(Address originAddress) {
        this.originAddress = originAddress;
    }

    public InboundOrderCreationData packagesToInbound(List<DistributionPackageQuantity> packagesToInbound) {
        this.packagesToInbound = packagesToInbound;
        return this;
    }

    public InboundOrderCreationData addPackagesToInboundItem(DistributionPackageQuantity packagesToInboundItem) {
        this.packagesToInbound.add(packagesToInboundItem);
        return this;
    }

    @Schema(example="[{\"count\":1,\"distributionPackage\":{\"contents\":{\"products\":[{\"quantity\":1,\"sku\":\"testPen\"}]},\"measurements\":{\"dimensions\":{\"height\":1,\"length\":1,\"unitOfMeasurement\":\"INCHES\",\"width\":1},\"volume\":{\"unitOfMeasurement\":\"CUIN\",\"volume\":1},\"weight\":{\"unitOfMeasurement\":\"POUNDS\",\"weight\":1}},\"type\":\"CASE\"}}]", required=true, description="List of packages to be inbounded.")
    public List<DistributionPackageQuantity> getPackagesToInbound() {
        return this.packagesToInbound;
    }

    public void setPackagesToInbound(List<DistributionPackageQuantity> packagesToInbound) {
        this.packagesToInbound = packagesToInbound;
    }

    public InboundOrderCreationData preferences(InboundPreferences preferences) {
        this.preferences = preferences;
        return this;
    }

    @Schema(description="")
    public InboundPreferences getPreferences() {
        return this.preferences;
    }

    public void setPreferences(InboundPreferences preferences) {
        this.preferences = preferences;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InboundOrderCreationData inboundOrderCreationData = (InboundOrderCreationData)o;
        return Objects.equals(this.externalReferenceId, inboundOrderCreationData.externalReferenceId) && Objects.equals(this.originAddress, inboundOrderCreationData.originAddress) && Objects.equals(this.packagesToInbound, inboundOrderCreationData.packagesToInbound) && Objects.equals(this.preferences, inboundOrderCreationData.preferences);
    }

    public int hashCode() {
        return Objects.hash(this.externalReferenceId, this.originAddress, this.packagesToInbound, this.preferences);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class InboundOrderCreationData {\n");
        sb.append("    externalReferenceId: ").append(this.toIndentedString(this.externalReferenceId)).append("\n");
        sb.append("    originAddress: ").append(this.toIndentedString(this.originAddress)).append("\n");
        sb.append("    packagesToInbound: ").append(this.toIndentedString(this.packagesToInbound)).append("\n");
        sb.append("    preferences: ").append(this.toIndentedString(this.preferences)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

