/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.models.awd.v2024_05_09;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.threeten.bp.OffsetDateTime;
import software.amazon.spapi.models.awd.v2024_05_09.Address;
import software.amazon.spapi.models.awd.v2024_05_09.DestinationDetails;
import software.amazon.spapi.models.awd.v2024_05_09.DistributionPackageQuantity;
import software.amazon.spapi.models.awd.v2024_05_09.InboundPreferences;
import software.amazon.spapi.models.awd.v2024_05_09.InboundStatus;

@Schema(description="Represents an AWD inbound order.")
public class InboundOrder {
    @SerializedName(value="createdAt")
    private OffsetDateTime createdAt = null;
    @SerializedName(value="destinationDetails")
    private DestinationDetails destinationDetails = null;
    @SerializedName(value="externalReferenceId")
    private String externalReferenceId = null;
    @SerializedName(value="orderId")
    private String orderId = null;
    @SerializedName(value="orderStatus")
    private InboundStatus orderStatus = null;
    @SerializedName(value="originAddress")
    private Address originAddress = null;
    @SerializedName(value="packagesToInbound")
    private List<DistributionPackageQuantity> packagesToInbound = new ArrayList<DistributionPackageQuantity>();
    @SerializedName(value="preferences")
    private InboundPreferences preferences = null;
    @SerializedName(value="updatedAt")
    private OffsetDateTime updatedAt = null;

    public InboundOrder createdAt(OffsetDateTime createdAt) {
        this.createdAt = createdAt;
        return this;
    }

    @Schema(required=true, description="Date when this order was created.")
    public OffsetDateTime getCreatedAt() {
        return this.createdAt;
    }

    public void setCreatedAt(OffsetDateTime createdAt) {
        this.createdAt = createdAt;
    }

    public InboundOrder destinationDetails(DestinationDetails destinationDetails) {
        this.destinationDetails = destinationDetails;
        return this;
    }

    @Schema(description="")
    public DestinationDetails getDestinationDetails() {
        return this.destinationDetails;
    }

    public void setDestinationDetails(DestinationDetails destinationDetails) {
        this.destinationDetails = destinationDetails;
    }

    public InboundOrder externalReferenceId(String externalReferenceId) {
        this.externalReferenceId = externalReferenceId;
        return this;
    }

    @Schema(example="TestReferenceId", description="Reference ID that can be used to correlate the order with partner resources.")
    public String getExternalReferenceId() {
        return this.externalReferenceId;
    }

    public void setExternalReferenceId(String externalReferenceId) {
        this.externalReferenceId = externalReferenceId;
    }

    public InboundOrder orderId(String orderId) {
        this.orderId = orderId;
        return this;
    }

    @Schema(required=true, description="Inbound order ID.")
    public String getOrderId() {
        return this.orderId;
    }

    public void setOrderId(String orderId) {
        this.orderId = orderId;
    }

    public InboundOrder orderStatus(InboundStatus orderStatus) {
        this.orderStatus = orderStatus;
        return this;
    }

    @Schema(required=true, description="")
    public InboundStatus getOrderStatus() {
        return this.orderStatus;
    }

    public void setOrderStatus(InboundStatus orderStatus) {
        this.orderStatus = orderStatus;
    }

    public InboundOrder originAddress(Address originAddress) {
        this.originAddress = originAddress;
        return this;
    }

    @Schema(required=true, description="")
    public Address getOriginAddress() {
        return this.originAddress;
    }

    public void setOriginAddress(Address originAddress) {
        this.originAddress = originAddress;
    }

    public InboundOrder packagesToInbound(List<DistributionPackageQuantity> packagesToInbound) {
        this.packagesToInbound = packagesToInbound;
        return this;
    }

    public InboundOrder addPackagesToInboundItem(DistributionPackageQuantity packagesToInboundItem) {
        this.packagesToInbound.add(packagesToInboundItem);
        return this;
    }

    @Schema(required=true, description="List of packages to be inbounded.")
    public List<DistributionPackageQuantity> getPackagesToInbound() {
        return this.packagesToInbound;
    }

    public void setPackagesToInbound(List<DistributionPackageQuantity> packagesToInbound) {
        this.packagesToInbound = packagesToInbound;
    }

    public InboundOrder preferences(InboundPreferences preferences) {
        this.preferences = preferences;
        return this;
    }

    @Schema(description="")
    public InboundPreferences getPreferences() {
        return this.preferences;
    }

    public void setPreferences(InboundPreferences preferences) {
        this.preferences = preferences;
    }

    public InboundOrder updatedAt(OffsetDateTime updatedAt) {
        this.updatedAt = updatedAt;
        return this;
    }

    @Schema(description="Date when this order was last updated.")
    public OffsetDateTime getUpdatedAt() {
        return this.updatedAt;
    }

    public void setUpdatedAt(OffsetDateTime updatedAt) {
        this.updatedAt = updatedAt;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InboundOrder inboundOrder = (InboundOrder)o;
        return Objects.equals(this.createdAt, inboundOrder.createdAt) && Objects.equals(this.destinationDetails, inboundOrder.destinationDetails) && Objects.equals(this.externalReferenceId, inboundOrder.externalReferenceId) && Objects.equals(this.orderId, inboundOrder.orderId) && Objects.equals((Object)this.orderStatus, (Object)inboundOrder.orderStatus) && Objects.equals(this.originAddress, inboundOrder.originAddress) && Objects.equals(this.packagesToInbound, inboundOrder.packagesToInbound) && Objects.equals(this.preferences, inboundOrder.preferences) && Objects.equals(this.updatedAt, inboundOrder.updatedAt);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.createdAt, this.destinationDetails, this.externalReferenceId, this.orderId, this.orderStatus, this.originAddress, this.packagesToInbound, this.preferences, this.updatedAt});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class InboundOrder {\n");
        sb.append("    createdAt: ").append(this.toIndentedString(this.createdAt)).append("\n");
        sb.append("    destinationDetails: ").append(this.toIndentedString(this.destinationDetails)).append("\n");
        sb.append("    externalReferenceId: ").append(this.toIndentedString(this.externalReferenceId)).append("\n");
        sb.append("    orderId: ").append(this.toIndentedString(this.orderId)).append("\n");
        sb.append("    orderStatus: ").append(this.toIndentedString((Object)this.orderStatus)).append("\n");
        sb.append("    originAddress: ").append(this.toIndentedString(this.originAddress)).append("\n");
        sb.append("    packagesToInbound: ").append(this.toIndentedString(this.packagesToInbound)).append("\n");
        sb.append("    preferences: ").append(this.toIndentedString(this.preferences)).append("\n");
        sb.append("    updatedAt: ").append(this.toIndentedString(this.updatedAt)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

