/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.models.awd.v2024_05_09;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import software.amazon.spapi.models.awd.v2024_05_09.Address;

@Schema(description="Destination details of an inbound order based on the assigned region and DC for the order.")
public class DestinationDetails {
    @SerializedName(value="destinationAddress")
    private Address destinationAddress = null;
    @SerializedName(value="destinationRegion")
    private String destinationRegion = null;
    @SerializedName(value="shipmentId")
    private String shipmentId = null;

    public DestinationDetails destinationAddress(Address destinationAddress) {
        this.destinationAddress = destinationAddress;
        return this;
    }

    @Schema(description="")
    public Address getDestinationAddress() {
        return this.destinationAddress;
    }

    public void setDestinationAddress(Address destinationAddress) {
        this.destinationAddress = destinationAddress;
    }

    public DestinationDetails destinationRegion(String destinationRegion) {
        this.destinationRegion = destinationRegion;
        return this;
    }

    @Schema(example="us-west", description="Assigned region where the order will be shipped. This can differ from what was passed as preference. AWD currently supports following region IDs: [us-west, us-east, us-southcentral, us-southeast]")
    public String getDestinationRegion() {
        return this.destinationRegion;
    }

    public void setDestinationRegion(String destinationRegion) {
        this.destinationRegion = destinationRegion;
    }

    public DestinationDetails shipmentId(String shipmentId) {
        this.shipmentId = shipmentId;
        return this;
    }

    @Schema(description="Unique ID of the confirmed shipment being shipped to the assigned destination. This will be available only after an inbound order is confirmed and can be used to track the shipment.")
    public String getShipmentId() {
        return this.shipmentId;
    }

    public void setShipmentId(String shipmentId) {
        this.shipmentId = shipmentId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DestinationDetails destinationDetails = (DestinationDetails)o;
        return Objects.equals(this.destinationAddress, destinationDetails.destinationAddress) && Objects.equals(this.destinationRegion, destinationDetails.destinationRegion) && Objects.equals(this.shipmentId, destinationDetails.shipmentId);
    }

    public int hashCode() {
        return Objects.hash(this.destinationAddress, this.destinationRegion, this.shipmentId);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DestinationDetails {\n");
        sb.append("    destinationAddress: ").append(this.toIndentedString(this.destinationAddress)).append("\n");
        sb.append("    destinationRegion: ").append(this.toIndentedString(this.destinationRegion)).append("\n");
        sb.append("    shipmentId: ").append(this.toIndentedString(this.shipmentId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

