/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.models.awd.v2024_05_09;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;

@Schema(description="Shipping address that represents the origin or destination location.")
public class Address {
    @SerializedName(value="addressLine1")
    private String addressLine1 = null;
    @SerializedName(value="addressLine2")
    private String addressLine2 = null;
    @SerializedName(value="addressLine3")
    private String addressLine3 = null;
    @SerializedName(value="city")
    private String city = null;
    @SerializedName(value="countryCode")
    private String countryCode = null;
    @SerializedName(value="county")
    private String county = null;
    @SerializedName(value="district")
    private String district = null;
    @SerializedName(value="name")
    private String name = null;
    @SerializedName(value="phoneNumber")
    private String phoneNumber = null;
    @SerializedName(value="postalCode")
    private String postalCode = null;
    @SerializedName(value="stateOrRegion")
    private String stateOrRegion = null;

    public Address addressLine1(String addressLine1) {
        this.addressLine1 = addressLine1;
        return this;
    }

    @Schema(required=true, description="First line of the address text.")
    public String getAddressLine1() {
        return this.addressLine1;
    }

    public void setAddressLine1(String addressLine1) {
        this.addressLine1 = addressLine1;
    }

    public Address addressLine2(String addressLine2) {
        this.addressLine2 = addressLine2;
        return this;
    }

    @Schema(description="Optional second line of the address text.")
    public String getAddressLine2() {
        return this.addressLine2;
    }

    public void setAddressLine2(String addressLine2) {
        this.addressLine2 = addressLine2;
    }

    public Address addressLine3(String addressLine3) {
        this.addressLine3 = addressLine3;
        return this;
    }

    @Schema(description="Optional third line of the address text.")
    public String getAddressLine3() {
        return this.addressLine3;
    }

    public void setAddressLine3(String addressLine3) {
        this.addressLine3 = addressLine3;
    }

    public Address city(String city) {
        this.city = city;
        return this;
    }

    @Schema(description="Optional city where this address is located.")
    public String getCity() {
        return this.city;
    }

    public void setCity(String city) {
        this.city = city;
    }

    public Address countryCode(String countryCode) {
        this.countryCode = countryCode;
        return this;
    }

    @Schema(required=true, description="Two-digit, ISO 3166-1 alpha-2 formatted country code where this address is located.")
    public String getCountryCode() {
        return this.countryCode;
    }

    public void setCountryCode(String countryCode) {
        this.countryCode = countryCode;
    }

    public Address county(String county) {
        this.county = county;
        return this;
    }

    @Schema(example="Washington", description="Optional county where this address is located.")
    public String getCounty() {
        return this.county;
    }

    public void setCounty(String county) {
        this.county = county;
    }

    public Address district(String district) {
        this.district = district;
        return this;
    }

    @Schema(description="Optional district where this address is located.")
    public String getDistrict() {
        return this.district;
    }

    public void setDistrict(String district) {
        this.district = district;
    }

    public Address name(String name) {
        this.name = name;
        return this;
    }

    @Schema(required=true, description="Name of the person, business, or institution at this address.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Address phoneNumber(String phoneNumber) {
        this.phoneNumber = phoneNumber;
        return this;
    }

    @Schema(example="+14155552671", description="Optional E.164-formatted phone number for an available contact at this address.")
    public String getPhoneNumber() {
        return this.phoneNumber;
    }

    public void setPhoneNumber(String phoneNumber) {
        this.phoneNumber = phoneNumber;
    }

    public Address postalCode(String postalCode) {
        this.postalCode = postalCode;
        return this;
    }

    @Schema(description="Optional postal code where this address is located.")
    public String getPostalCode() {
        return this.postalCode;
    }

    public void setPostalCode(String postalCode) {
        this.postalCode = postalCode;
    }

    public Address stateOrRegion(String stateOrRegion) {
        this.stateOrRegion = stateOrRegion;
        return this;
    }

    @Schema(required=true, description="State or region where this address is located. Note that this is contextual to the specified country code.")
    public String getStateOrRegion() {
        return this.stateOrRegion;
    }

    public void setStateOrRegion(String stateOrRegion) {
        this.stateOrRegion = stateOrRegion;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Address address = (Address)o;
        return Objects.equals(this.addressLine1, address.addressLine1) && Objects.equals(this.addressLine2, address.addressLine2) && Objects.equals(this.addressLine3, address.addressLine3) && Objects.equals(this.city, address.city) && Objects.equals(this.countryCode, address.countryCode) && Objects.equals(this.county, address.county) && Objects.equals(this.district, address.district) && Objects.equals(this.name, address.name) && Objects.equals(this.phoneNumber, address.phoneNumber) && Objects.equals(this.postalCode, address.postalCode) && Objects.equals(this.stateOrRegion, address.stateOrRegion);
    }

    public int hashCode() {
        return Objects.hash(this.addressLine1, this.addressLine2, this.addressLine3, this.city, this.countryCode, this.county, this.district, this.name, this.phoneNumber, this.postalCode, this.stateOrRegion);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Address {\n");
        sb.append("    addressLine1: ").append(this.toIndentedString(this.addressLine1)).append("\n");
        sb.append("    addressLine2: ").append(this.toIndentedString(this.addressLine2)).append("\n");
        sb.append("    addressLine3: ").append(this.toIndentedString(this.addressLine3)).append("\n");
        sb.append("    city: ").append(this.toIndentedString(this.city)).append("\n");
        sb.append("    countryCode: ").append(this.toIndentedString(this.countryCode)).append("\n");
        sb.append("    county: ").append(this.toIndentedString(this.county)).append("\n");
        sb.append("    district: ").append(this.toIndentedString(this.district)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    phoneNumber: ").append(this.toIndentedString(this.phoneNumber)).append("\n");
        sb.append("    postalCode: ").append(this.toIndentedString(this.postalCode)).append("\n");
        sb.append("    stateOrRegion: ").append(this.toIndentedString(this.stateOrRegion)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

