/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.api.vendor.transactionstatus.v1;

import com.amazon.SellingPartnerAPIAA.LWAAccessTokenCache;
import com.amazon.SellingPartnerAPIAA.LWAAccessTokenCacheImpl;
import com.amazon.SellingPartnerAPIAA.LWAAuthorizationCredentials;
import com.amazon.SellingPartnerAPIAA.LWAAuthorizationSigner;
import com.amazon.SellingPartnerAPIAA.LWAException;
import com.amazon.SellingPartnerAPIAA.RestrictedDataTokenSigner;
import com.google.gson.reflect.TypeToken;
import io.github.bucket4j.Bucket;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import okhttp3.Call;
import okhttp3.Request;
import software.amazon.spapi.ApiCallback;
import software.amazon.spapi.ApiClient;
import software.amazon.spapi.ApiException;
import software.amazon.spapi.ApiResponse;
import software.amazon.spapi.Configuration;
import software.amazon.spapi.Pair;
import software.amazon.spapi.ProgressRequestBody;
import software.amazon.spapi.StringUtil;
import software.amazon.spapi.models.vendor.transactionstatus.v1.GetTransactionResponse;

public class VendorTransactionApi {
    private ApiClient apiClient;
    private Boolean disableRateLimiting;
    private final Configuration config = Configuration.get();
    public final Bucket getTransactionBucket = Bucket.builder().addLimit(this.config.getLimit("VendorTransactionApi-getTransaction")).build();

    public VendorTransactionApi(ApiClient apiClient, Boolean disableRateLimiting) {
        this.apiClient = apiClient;
        this.disableRateLimiting = disableRateLimiting;
    }

    private Call getTransactionCall(String transactionId, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        Object localVarPostBody = null;
        String localVarPath = "/vendor/transactions/v1/transactions/{transactionId}".equals("/uploads/2020-11-01/uploadDestinations/{resource}") ? "/vendor/transactions/v1/transactions/{transactionId}".replaceAll("\\{transactionId\\}", transactionId.toString()) : "/vendor/transactions/v1/transactions/{transactionId}".replaceAll("\\{transactionId\\}", this.apiClient.escapeString(transactionId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, progressRequestListener);
    }

    private Call getTransactionValidateBeforeCall(String transactionId, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        if (transactionId == null) {
            throw new ApiException("Missing the required parameter 'transactionId' when calling getTransaction(Async)");
        }
        return this.getTransactionCall(transactionId, progressRequestListener);
    }

    public GetTransactionResponse getTransaction(String transactionId, String restrictedDataToken) throws ApiException, LWAException {
        ApiResponse<GetTransactionResponse> resp = this.getTransactionWithHttpInfo(transactionId, restrictedDataToken);
        return resp.getData();
    }

    public GetTransactionResponse getTransaction(String transactionId) throws ApiException, LWAException {
        ApiResponse<GetTransactionResponse> resp = this.getTransactionWithHttpInfo(transactionId, null);
        return resp.getData();
    }

    public ApiResponse<GetTransactionResponse> getTransactionWithHttpInfo(String transactionId, String restrictedDataToken) throws ApiException, LWAException {
        Call call = this.getTransactionValidateBeforeCall(transactionId, null);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "VendorTransactionApi-getTransaction");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.getTransactionBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<GetTransactionResponse>(){}.getType();
            return this.apiClient.execute(call, localVarReturnType);
        }
        throw new ApiException.RateLimitExceeded("getTransaction operation exceeds rate limit");
    }

    public ApiResponse<GetTransactionResponse> getTransactionWithHttpInfo(String transactionId) throws ApiException, LWAException {
        return this.getTransactionWithHttpInfo(transactionId, null);
    }

    public Call getTransactionAsync(String transactionId, ApiCallback<GetTransactionResponse> callback) throws ApiException, LWAException {
        return this.getTransactionAsync(transactionId, callback, null);
    }

    public Call getTransactionAsync(String transactionId, ApiCallback<GetTransactionResponse> callback, String restrictedDataToken) throws ApiException, LWAException {
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressRequestListener = callback::onUploadProgress;
        }
        Call call = this.getTransactionValidateBeforeCall(transactionId, progressRequestListener);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "VendorTransactionApi-getTransaction");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.getTransactionBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<GetTransactionResponse>(){}.getType();
            this.apiClient.executeAsync(call, localVarReturnType, callback);
            return call;
        }
        throw new ApiException.RateLimitExceeded("getTransaction operation exceeds rate limit");
    }

    public static class Builder {
        private LWAAuthorizationCredentials lwaAuthorizationCredentials;
        private String endpoint;
        private LWAAccessTokenCache lwaAccessTokenCache;
        private Boolean disableAccessTokenCache = false;
        private Boolean disableRateLimiting = false;

        public Builder lwaAuthorizationCredentials(LWAAuthorizationCredentials lwaAuthorizationCredentials) {
            this.lwaAuthorizationCredentials = lwaAuthorizationCredentials;
            return this;
        }

        public Builder endpoint(String endpoint) {
            this.endpoint = endpoint;
            return this;
        }

        public Builder lwaAccessTokenCache(LWAAccessTokenCache lwaAccessTokenCache) {
            this.lwaAccessTokenCache = lwaAccessTokenCache;
            return this;
        }

        public Builder disableAccessTokenCache() {
            this.disableAccessTokenCache = true;
            return this;
        }

        public Builder disableRateLimiting() {
            this.disableRateLimiting = true;
            return this;
        }

        public VendorTransactionApi build() {
            if (this.lwaAuthorizationCredentials == null) {
                throw new RuntimeException("LWAAuthorizationCredentials not set");
            }
            if (StringUtil.isEmpty(this.endpoint)) {
                throw new RuntimeException("Endpoint not set");
            }
            LWAAuthorizationSigner lwaAuthorizationSigner = null;
            if (this.disableAccessTokenCache.booleanValue()) {
                lwaAuthorizationSigner = new LWAAuthorizationSigner(this.lwaAuthorizationCredentials);
            } else {
                if (this.lwaAccessTokenCache == null) {
                    this.lwaAccessTokenCache = new LWAAccessTokenCacheImpl();
                }
                lwaAuthorizationSigner = new LWAAuthorizationSigner(this.lwaAuthorizationCredentials, this.lwaAccessTokenCache);
            }
            return new VendorTransactionApi(new ApiClient().setLWAAuthorizationSigner(lwaAuthorizationSigner).setBasePath(this.endpoint), this.disableRateLimiting);
        }
    }
}

