/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.api.vendor.orders.v1;

import com.amazon.SellingPartnerAPIAA.LWAAccessTokenCache;
import com.amazon.SellingPartnerAPIAA.LWAAccessTokenCacheImpl;
import com.amazon.SellingPartnerAPIAA.LWAAuthorizationCredentials;
import com.amazon.SellingPartnerAPIAA.LWAAuthorizationSigner;
import com.amazon.SellingPartnerAPIAA.LWAException;
import com.amazon.SellingPartnerAPIAA.RestrictedDataTokenSigner;
import com.google.gson.reflect.TypeToken;
import io.github.bucket4j.Bucket;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import okhttp3.Call;
import okhttp3.Request;
import org.threeten.bp.OffsetDateTime;
import software.amazon.spapi.ApiCallback;
import software.amazon.spapi.ApiClient;
import software.amazon.spapi.ApiException;
import software.amazon.spapi.ApiResponse;
import software.amazon.spapi.Configuration;
import software.amazon.spapi.Pair;
import software.amazon.spapi.ProgressRequestBody;
import software.amazon.spapi.StringUtil;
import software.amazon.spapi.models.vendor.orders.v1.GetPurchaseOrderResponse;
import software.amazon.spapi.models.vendor.orders.v1.GetPurchaseOrdersResponse;
import software.amazon.spapi.models.vendor.orders.v1.GetPurchaseOrdersStatusResponse;
import software.amazon.spapi.models.vendor.orders.v1.SubmitAcknowledgementRequest;
import software.amazon.spapi.models.vendor.orders.v1.SubmitAcknowledgementResponse;

public class VendorOrdersApi {
    private ApiClient apiClient;
    private Boolean disableRateLimiting;
    private final Configuration config = Configuration.get();
    public final Bucket getPurchaseOrderBucket = Bucket.builder().addLimit(this.config.getLimit("VendorOrdersApi-getPurchaseOrder")).build();
    public final Bucket getPurchaseOrdersBucket = Bucket.builder().addLimit(this.config.getLimit("VendorOrdersApi-getPurchaseOrders")).build();
    public final Bucket getPurchaseOrdersStatusBucket = Bucket.builder().addLimit(this.config.getLimit("VendorOrdersApi-getPurchaseOrdersStatus")).build();
    public final Bucket submitAcknowledgementBucket = Bucket.builder().addLimit(this.config.getLimit("VendorOrdersApi-submitAcknowledgement")).build();

    public VendorOrdersApi(ApiClient apiClient, Boolean disableRateLimiting) {
        this.apiClient = apiClient;
        this.disableRateLimiting = disableRateLimiting;
    }

    private Call getPurchaseOrderCall(String purchaseOrderNumber, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        Object localVarPostBody = null;
        String localVarPath = "/vendor/orders/v1/purchaseOrders/{purchaseOrderNumber}".equals("/uploads/2020-11-01/uploadDestinations/{resource}") ? "/vendor/orders/v1/purchaseOrders/{purchaseOrderNumber}".replaceAll("\\{purchaseOrderNumber\\}", purchaseOrderNumber.toString()) : "/vendor/orders/v1/purchaseOrders/{purchaseOrderNumber}".replaceAll("\\{purchaseOrderNumber\\}", this.apiClient.escapeString(purchaseOrderNumber.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, progressRequestListener);
    }

    private Call getPurchaseOrderValidateBeforeCall(String purchaseOrderNumber, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        if (purchaseOrderNumber == null) {
            throw new ApiException("Missing the required parameter 'purchaseOrderNumber' when calling getPurchaseOrder(Async)");
        }
        return this.getPurchaseOrderCall(purchaseOrderNumber, progressRequestListener);
    }

    public GetPurchaseOrderResponse getPurchaseOrder(String purchaseOrderNumber, String restrictedDataToken) throws ApiException, LWAException {
        ApiResponse<GetPurchaseOrderResponse> resp = this.getPurchaseOrderWithHttpInfo(purchaseOrderNumber, restrictedDataToken);
        return resp.getData();
    }

    public GetPurchaseOrderResponse getPurchaseOrder(String purchaseOrderNumber) throws ApiException, LWAException {
        ApiResponse<GetPurchaseOrderResponse> resp = this.getPurchaseOrderWithHttpInfo(purchaseOrderNumber, null);
        return resp.getData();
    }

    public ApiResponse<GetPurchaseOrderResponse> getPurchaseOrderWithHttpInfo(String purchaseOrderNumber, String restrictedDataToken) throws ApiException, LWAException {
        Call call = this.getPurchaseOrderValidateBeforeCall(purchaseOrderNumber, null);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "VendorOrdersApi-getPurchaseOrder");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.getPurchaseOrderBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<GetPurchaseOrderResponse>(){}.getType();
            return this.apiClient.execute(call, localVarReturnType);
        }
        throw new ApiException.RateLimitExceeded("getPurchaseOrder operation exceeds rate limit");
    }

    public ApiResponse<GetPurchaseOrderResponse> getPurchaseOrderWithHttpInfo(String purchaseOrderNumber) throws ApiException, LWAException {
        return this.getPurchaseOrderWithHttpInfo(purchaseOrderNumber, null);
    }

    public Call getPurchaseOrderAsync(String purchaseOrderNumber, ApiCallback<GetPurchaseOrderResponse> callback) throws ApiException, LWAException {
        return this.getPurchaseOrderAsync(purchaseOrderNumber, callback, null);
    }

    public Call getPurchaseOrderAsync(String purchaseOrderNumber, ApiCallback<GetPurchaseOrderResponse> callback, String restrictedDataToken) throws ApiException, LWAException {
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressRequestListener = callback::onUploadProgress;
        }
        Call call = this.getPurchaseOrderValidateBeforeCall(purchaseOrderNumber, progressRequestListener);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "VendorOrdersApi-getPurchaseOrder");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.getPurchaseOrderBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<GetPurchaseOrderResponse>(){}.getType();
            this.apiClient.executeAsync(call, localVarReturnType, callback);
            return call;
        }
        throw new ApiException.RateLimitExceeded("getPurchaseOrder operation exceeds rate limit");
    }

    private Call getPurchaseOrdersCall(Long limit, OffsetDateTime createdAfter, OffsetDateTime createdBefore, String sortOrder, String nextToken, String includeDetails, OffsetDateTime changedAfter, OffsetDateTime changedBefore, String poItemState, String isPOChanged, String purchaseOrderState, String orderingVendorCode, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        Object localVarPostBody = null;
        String localVarPath = "/vendor/orders/v1/purchaseOrders".equals("/uploads/2020-11-01/uploadDestinations/{resource}") ? "/vendor/orders/v1/purchaseOrders" : "/vendor/orders/v1/purchaseOrders";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (limit != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("limit", limit));
        }
        if (createdAfter != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("createdAfter", createdAfter));
        }
        if (createdBefore != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("createdBefore", createdBefore));
        }
        if (sortOrder != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("sortOrder", sortOrder));
        }
        if (nextToken != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("nextToken", nextToken));
        }
        if (includeDetails != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("includeDetails", includeDetails));
        }
        if (changedAfter != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("changedAfter", changedAfter));
        }
        if (changedBefore != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("changedBefore", changedBefore));
        }
        if (poItemState != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("poItemState", poItemState));
        }
        if (isPOChanged != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("isPOChanged", isPOChanged));
        }
        if (purchaseOrderState != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("purchaseOrderState", purchaseOrderState));
        }
        if (orderingVendorCode != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("orderingVendorCode", orderingVendorCode));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "payload"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, progressRequestListener);
    }

    private Call getPurchaseOrdersValidateBeforeCall(Long limit, OffsetDateTime createdAfter, OffsetDateTime createdBefore, String sortOrder, String nextToken, String includeDetails, OffsetDateTime changedAfter, OffsetDateTime changedBefore, String poItemState, String isPOChanged, String purchaseOrderState, String orderingVendorCode, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        return this.getPurchaseOrdersCall(limit, createdAfter, createdBefore, sortOrder, nextToken, includeDetails, changedAfter, changedBefore, poItemState, isPOChanged, purchaseOrderState, orderingVendorCode, progressRequestListener);
    }

    public GetPurchaseOrdersResponse getPurchaseOrders(Long limit, OffsetDateTime createdAfter, OffsetDateTime createdBefore, String sortOrder, String nextToken, String includeDetails, OffsetDateTime changedAfter, OffsetDateTime changedBefore, String poItemState, String isPOChanged, String purchaseOrderState, String orderingVendorCode, String restrictedDataToken) throws ApiException, LWAException {
        ApiResponse<GetPurchaseOrdersResponse> resp = this.getPurchaseOrdersWithHttpInfo(limit, createdAfter, createdBefore, sortOrder, nextToken, includeDetails, changedAfter, changedBefore, poItemState, isPOChanged, purchaseOrderState, orderingVendorCode, restrictedDataToken);
        return resp.getData();
    }

    public GetPurchaseOrdersResponse getPurchaseOrders(Long limit, OffsetDateTime createdAfter, OffsetDateTime createdBefore, String sortOrder, String nextToken, String includeDetails, OffsetDateTime changedAfter, OffsetDateTime changedBefore, String poItemState, String isPOChanged, String purchaseOrderState, String orderingVendorCode) throws ApiException, LWAException {
        ApiResponse<GetPurchaseOrdersResponse> resp = this.getPurchaseOrdersWithHttpInfo(limit, createdAfter, createdBefore, sortOrder, nextToken, includeDetails, changedAfter, changedBefore, poItemState, isPOChanged, purchaseOrderState, orderingVendorCode, null);
        return resp.getData();
    }

    public ApiResponse<GetPurchaseOrdersResponse> getPurchaseOrdersWithHttpInfo(Long limit, OffsetDateTime createdAfter, OffsetDateTime createdBefore, String sortOrder, String nextToken, String includeDetails, OffsetDateTime changedAfter, OffsetDateTime changedBefore, String poItemState, String isPOChanged, String purchaseOrderState, String orderingVendorCode, String restrictedDataToken) throws ApiException, LWAException {
        Call call = this.getPurchaseOrdersValidateBeforeCall(limit, createdAfter, createdBefore, sortOrder, nextToken, includeDetails, changedAfter, changedBefore, poItemState, isPOChanged, purchaseOrderState, orderingVendorCode, null);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "VendorOrdersApi-getPurchaseOrders");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.getPurchaseOrdersBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<GetPurchaseOrdersResponse>(){}.getType();
            return this.apiClient.execute(call, localVarReturnType);
        }
        throw new ApiException.RateLimitExceeded("getPurchaseOrders operation exceeds rate limit");
    }

    public ApiResponse<GetPurchaseOrdersResponse> getPurchaseOrdersWithHttpInfo(Long limit, OffsetDateTime createdAfter, OffsetDateTime createdBefore, String sortOrder, String nextToken, String includeDetails, OffsetDateTime changedAfter, OffsetDateTime changedBefore, String poItemState, String isPOChanged, String purchaseOrderState, String orderingVendorCode) throws ApiException, LWAException {
        return this.getPurchaseOrdersWithHttpInfo(limit, createdAfter, createdBefore, sortOrder, nextToken, includeDetails, changedAfter, changedBefore, poItemState, isPOChanged, purchaseOrderState, orderingVendorCode, null);
    }

    public Call getPurchaseOrdersAsync(Long limit, OffsetDateTime createdAfter, OffsetDateTime createdBefore, String sortOrder, String nextToken, String includeDetails, OffsetDateTime changedAfter, OffsetDateTime changedBefore, String poItemState, String isPOChanged, String purchaseOrderState, String orderingVendorCode, ApiCallback<GetPurchaseOrdersResponse> callback) throws ApiException, LWAException {
        return this.getPurchaseOrdersAsync(limit, createdAfter, createdBefore, sortOrder, nextToken, includeDetails, changedAfter, changedBefore, poItemState, isPOChanged, purchaseOrderState, orderingVendorCode, callback, null);
    }

    public Call getPurchaseOrdersAsync(Long limit, OffsetDateTime createdAfter, OffsetDateTime createdBefore, String sortOrder, String nextToken, String includeDetails, OffsetDateTime changedAfter, OffsetDateTime changedBefore, String poItemState, String isPOChanged, String purchaseOrderState, String orderingVendorCode, ApiCallback<GetPurchaseOrdersResponse> callback, String restrictedDataToken) throws ApiException, LWAException {
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressRequestListener = callback::onUploadProgress;
        }
        Call call = this.getPurchaseOrdersValidateBeforeCall(limit, createdAfter, createdBefore, sortOrder, nextToken, includeDetails, changedAfter, changedBefore, poItemState, isPOChanged, purchaseOrderState, orderingVendorCode, progressRequestListener);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "VendorOrdersApi-getPurchaseOrders");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.getPurchaseOrdersBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<GetPurchaseOrdersResponse>(){}.getType();
            this.apiClient.executeAsync(call, localVarReturnType, callback);
            return call;
        }
        throw new ApiException.RateLimitExceeded("getPurchaseOrders operation exceeds rate limit");
    }

    private Call getPurchaseOrdersStatusCall(Long limit, String sortOrder, String nextToken, OffsetDateTime createdAfter, OffsetDateTime createdBefore, OffsetDateTime updatedAfter, OffsetDateTime updatedBefore, String purchaseOrderNumber, String purchaseOrderStatus, String itemConfirmationStatus, String itemReceiveStatus, String orderingVendorCode, String shipToPartyId, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        Object localVarPostBody = null;
        String localVarPath = "/vendor/orders/v1/purchaseOrdersStatus".equals("/uploads/2020-11-01/uploadDestinations/{resource}") ? "/vendor/orders/v1/purchaseOrdersStatus" : "/vendor/orders/v1/purchaseOrdersStatus";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (limit != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("limit", limit));
        }
        if (sortOrder != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("sortOrder", sortOrder));
        }
        if (nextToken != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("nextToken", nextToken));
        }
        if (createdAfter != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("createdAfter", createdAfter));
        }
        if (createdBefore != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("createdBefore", createdBefore));
        }
        if (updatedAfter != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("updatedAfter", updatedAfter));
        }
        if (updatedBefore != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("updatedBefore", updatedBefore));
        }
        if (purchaseOrderNumber != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("purchaseOrderNumber", purchaseOrderNumber));
        }
        if (purchaseOrderStatus != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("purchaseOrderStatus", purchaseOrderStatus));
        }
        if (itemConfirmationStatus != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("itemConfirmationStatus", itemConfirmationStatus));
        }
        if (itemReceiveStatus != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("itemReceiveStatus", itemReceiveStatus));
        }
        if (orderingVendorCode != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("orderingVendorCode", orderingVendorCode));
        }
        if (shipToPartyId != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("shipToPartyId", shipToPartyId));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, progressRequestListener);
    }

    private Call getPurchaseOrdersStatusValidateBeforeCall(Long limit, String sortOrder, String nextToken, OffsetDateTime createdAfter, OffsetDateTime createdBefore, OffsetDateTime updatedAfter, OffsetDateTime updatedBefore, String purchaseOrderNumber, String purchaseOrderStatus, String itemConfirmationStatus, String itemReceiveStatus, String orderingVendorCode, String shipToPartyId, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        return this.getPurchaseOrdersStatusCall(limit, sortOrder, nextToken, createdAfter, createdBefore, updatedAfter, updatedBefore, purchaseOrderNumber, purchaseOrderStatus, itemConfirmationStatus, itemReceiveStatus, orderingVendorCode, shipToPartyId, progressRequestListener);
    }

    public GetPurchaseOrdersStatusResponse getPurchaseOrdersStatus(Long limit, String sortOrder, String nextToken, OffsetDateTime createdAfter, OffsetDateTime createdBefore, OffsetDateTime updatedAfter, OffsetDateTime updatedBefore, String purchaseOrderNumber, String purchaseOrderStatus, String itemConfirmationStatus, String itemReceiveStatus, String orderingVendorCode, String shipToPartyId, String restrictedDataToken) throws ApiException, LWAException {
        ApiResponse<GetPurchaseOrdersStatusResponse> resp = this.getPurchaseOrdersStatusWithHttpInfo(limit, sortOrder, nextToken, createdAfter, createdBefore, updatedAfter, updatedBefore, purchaseOrderNumber, purchaseOrderStatus, itemConfirmationStatus, itemReceiveStatus, orderingVendorCode, shipToPartyId, restrictedDataToken);
        return resp.getData();
    }

    public GetPurchaseOrdersStatusResponse getPurchaseOrdersStatus(Long limit, String sortOrder, String nextToken, OffsetDateTime createdAfter, OffsetDateTime createdBefore, OffsetDateTime updatedAfter, OffsetDateTime updatedBefore, String purchaseOrderNumber, String purchaseOrderStatus, String itemConfirmationStatus, String itemReceiveStatus, String orderingVendorCode, String shipToPartyId) throws ApiException, LWAException {
        ApiResponse<GetPurchaseOrdersStatusResponse> resp = this.getPurchaseOrdersStatusWithHttpInfo(limit, sortOrder, nextToken, createdAfter, createdBefore, updatedAfter, updatedBefore, purchaseOrderNumber, purchaseOrderStatus, itemConfirmationStatus, itemReceiveStatus, orderingVendorCode, shipToPartyId, null);
        return resp.getData();
    }

    public ApiResponse<GetPurchaseOrdersStatusResponse> getPurchaseOrdersStatusWithHttpInfo(Long limit, String sortOrder, String nextToken, OffsetDateTime createdAfter, OffsetDateTime createdBefore, OffsetDateTime updatedAfter, OffsetDateTime updatedBefore, String purchaseOrderNumber, String purchaseOrderStatus, String itemConfirmationStatus, String itemReceiveStatus, String orderingVendorCode, String shipToPartyId, String restrictedDataToken) throws ApiException, LWAException {
        Call call = this.getPurchaseOrdersStatusValidateBeforeCall(limit, sortOrder, nextToken, createdAfter, createdBefore, updatedAfter, updatedBefore, purchaseOrderNumber, purchaseOrderStatus, itemConfirmationStatus, itemReceiveStatus, orderingVendorCode, shipToPartyId, null);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "VendorOrdersApi-getPurchaseOrdersStatus");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.getPurchaseOrdersStatusBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<GetPurchaseOrdersStatusResponse>(){}.getType();
            return this.apiClient.execute(call, localVarReturnType);
        }
        throw new ApiException.RateLimitExceeded("getPurchaseOrdersStatus operation exceeds rate limit");
    }

    public ApiResponse<GetPurchaseOrdersStatusResponse> getPurchaseOrdersStatusWithHttpInfo(Long limit, String sortOrder, String nextToken, OffsetDateTime createdAfter, OffsetDateTime createdBefore, OffsetDateTime updatedAfter, OffsetDateTime updatedBefore, String purchaseOrderNumber, String purchaseOrderStatus, String itemConfirmationStatus, String itemReceiveStatus, String orderingVendorCode, String shipToPartyId) throws ApiException, LWAException {
        return this.getPurchaseOrdersStatusWithHttpInfo(limit, sortOrder, nextToken, createdAfter, createdBefore, updatedAfter, updatedBefore, purchaseOrderNumber, purchaseOrderStatus, itemConfirmationStatus, itemReceiveStatus, orderingVendorCode, shipToPartyId, null);
    }

    public Call getPurchaseOrdersStatusAsync(Long limit, String sortOrder, String nextToken, OffsetDateTime createdAfter, OffsetDateTime createdBefore, OffsetDateTime updatedAfter, OffsetDateTime updatedBefore, String purchaseOrderNumber, String purchaseOrderStatus, String itemConfirmationStatus, String itemReceiveStatus, String orderingVendorCode, String shipToPartyId, ApiCallback<GetPurchaseOrdersStatusResponse> callback) throws ApiException, LWAException {
        return this.getPurchaseOrdersStatusAsync(limit, sortOrder, nextToken, createdAfter, createdBefore, updatedAfter, updatedBefore, purchaseOrderNumber, purchaseOrderStatus, itemConfirmationStatus, itemReceiveStatus, orderingVendorCode, shipToPartyId, callback, null);
    }

    public Call getPurchaseOrdersStatusAsync(Long limit, String sortOrder, String nextToken, OffsetDateTime createdAfter, OffsetDateTime createdBefore, OffsetDateTime updatedAfter, OffsetDateTime updatedBefore, String purchaseOrderNumber, String purchaseOrderStatus, String itemConfirmationStatus, String itemReceiveStatus, String orderingVendorCode, String shipToPartyId, ApiCallback<GetPurchaseOrdersStatusResponse> callback, String restrictedDataToken) throws ApiException, LWAException {
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressRequestListener = callback::onUploadProgress;
        }
        Call call = this.getPurchaseOrdersStatusValidateBeforeCall(limit, sortOrder, nextToken, createdAfter, createdBefore, updatedAfter, updatedBefore, purchaseOrderNumber, purchaseOrderStatus, itemConfirmationStatus, itemReceiveStatus, orderingVendorCode, shipToPartyId, progressRequestListener);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "VendorOrdersApi-getPurchaseOrdersStatus");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.getPurchaseOrdersStatusBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<GetPurchaseOrdersStatusResponse>(){}.getType();
            this.apiClient.executeAsync(call, localVarReturnType, callback);
            return call;
        }
        throw new ApiException.RateLimitExceeded("getPurchaseOrdersStatus operation exceeds rate limit");
    }

    private Call submitAcknowledgementCall(SubmitAcknowledgementRequest body, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        SubmitAcknowledgementRequest localVarPostBody = body;
        String localVarPath = "/vendor/orders/v1/acknowledgements".equals("/uploads/2020-11-01/uploadDestinations/{resource}") ? "/vendor/orders/v1/acknowledgements" : "/vendor/orders/v1/acknowledgements";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, progressRequestListener);
    }

    private Call submitAcknowledgementValidateBeforeCall(SubmitAcknowledgementRequest body, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling submitAcknowledgement(Async)");
        }
        return this.submitAcknowledgementCall(body, progressRequestListener);
    }

    public SubmitAcknowledgementResponse submitAcknowledgement(SubmitAcknowledgementRequest body, String restrictedDataToken) throws ApiException, LWAException {
        ApiResponse<SubmitAcknowledgementResponse> resp = this.submitAcknowledgementWithHttpInfo(body, restrictedDataToken);
        return resp.getData();
    }

    public SubmitAcknowledgementResponse submitAcknowledgement(SubmitAcknowledgementRequest body) throws ApiException, LWAException {
        ApiResponse<SubmitAcknowledgementResponse> resp = this.submitAcknowledgementWithHttpInfo(body, null);
        return resp.getData();
    }

    public ApiResponse<SubmitAcknowledgementResponse> submitAcknowledgementWithHttpInfo(SubmitAcknowledgementRequest body, String restrictedDataToken) throws ApiException, LWAException {
        Call call = this.submitAcknowledgementValidateBeforeCall(body, null);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "VendorOrdersApi-submitAcknowledgement");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.submitAcknowledgementBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<SubmitAcknowledgementResponse>(){}.getType();
            return this.apiClient.execute(call, localVarReturnType);
        }
        throw new ApiException.RateLimitExceeded("submitAcknowledgement operation exceeds rate limit");
    }

    public ApiResponse<SubmitAcknowledgementResponse> submitAcknowledgementWithHttpInfo(SubmitAcknowledgementRequest body) throws ApiException, LWAException {
        return this.submitAcknowledgementWithHttpInfo(body, null);
    }

    public Call submitAcknowledgementAsync(SubmitAcknowledgementRequest body, ApiCallback<SubmitAcknowledgementResponse> callback) throws ApiException, LWAException {
        return this.submitAcknowledgementAsync(body, callback, null);
    }

    public Call submitAcknowledgementAsync(SubmitAcknowledgementRequest body, ApiCallback<SubmitAcknowledgementResponse> callback, String restrictedDataToken) throws ApiException, LWAException {
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressRequestListener = callback::onUploadProgress;
        }
        Call call = this.submitAcknowledgementValidateBeforeCall(body, progressRequestListener);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "VendorOrdersApi-submitAcknowledgement");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.submitAcknowledgementBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<SubmitAcknowledgementResponse>(){}.getType();
            this.apiClient.executeAsync(call, localVarReturnType, callback);
            return call;
        }
        throw new ApiException.RateLimitExceeded("submitAcknowledgement operation exceeds rate limit");
    }

    public static class Builder {
        private LWAAuthorizationCredentials lwaAuthorizationCredentials;
        private String endpoint;
        private LWAAccessTokenCache lwaAccessTokenCache;
        private Boolean disableAccessTokenCache = false;
        private Boolean disableRateLimiting = false;

        public Builder lwaAuthorizationCredentials(LWAAuthorizationCredentials lwaAuthorizationCredentials) {
            this.lwaAuthorizationCredentials = lwaAuthorizationCredentials;
            return this;
        }

        public Builder endpoint(String endpoint) {
            this.endpoint = endpoint;
            return this;
        }

        public Builder lwaAccessTokenCache(LWAAccessTokenCache lwaAccessTokenCache) {
            this.lwaAccessTokenCache = lwaAccessTokenCache;
            return this;
        }

        public Builder disableAccessTokenCache() {
            this.disableAccessTokenCache = true;
            return this;
        }

        public Builder disableRateLimiting() {
            this.disableRateLimiting = true;
            return this;
        }

        public VendorOrdersApi build() {
            if (this.lwaAuthorizationCredentials == null) {
                throw new RuntimeException("LWAAuthorizationCredentials not set");
            }
            if (StringUtil.isEmpty(this.endpoint)) {
                throw new RuntimeException("Endpoint not set");
            }
            LWAAuthorizationSigner lwaAuthorizationSigner = null;
            if (this.disableAccessTokenCache.booleanValue()) {
                lwaAuthorizationSigner = new LWAAuthorizationSigner(this.lwaAuthorizationCredentials);
            } else {
                if (this.lwaAccessTokenCache == null) {
                    this.lwaAccessTokenCache = new LWAAccessTokenCacheImpl();
                }
                lwaAuthorizationSigner = new LWAAuthorizationSigner(this.lwaAuthorizationCredentials, this.lwaAccessTokenCache);
            }
            return new VendorOrdersApi(new ApiClient().setLWAAuthorizationSigner(lwaAuthorizationSigner).setBasePath(this.endpoint), this.disableRateLimiting);
        }
    }
}

