/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.api.vendor.df.shipping.v2021_12_28;

import com.amazon.SellingPartnerAPIAA.LWAAccessTokenCache;
import com.amazon.SellingPartnerAPIAA.LWAAccessTokenCacheImpl;
import com.amazon.SellingPartnerAPIAA.LWAAuthorizationCredentials;
import com.amazon.SellingPartnerAPIAA.LWAAuthorizationSigner;
import com.amazon.SellingPartnerAPIAA.LWAException;
import com.amazon.SellingPartnerAPIAA.RestrictedDataTokenSigner;
import com.google.gson.reflect.TypeToken;
import io.github.bucket4j.Bucket;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import okhttp3.Call;
import okhttp3.Request;
import org.threeten.bp.OffsetDateTime;
import software.amazon.spapi.ApiCallback;
import software.amazon.spapi.ApiClient;
import software.amazon.spapi.ApiException;
import software.amazon.spapi.ApiResponse;
import software.amazon.spapi.Configuration;
import software.amazon.spapi.Pair;
import software.amazon.spapi.ProgressRequestBody;
import software.amazon.spapi.StringUtil;
import software.amazon.spapi.models.vendor.df.shipping.v2021_12_28.CreateShippingLabelsRequest;
import software.amazon.spapi.models.vendor.df.shipping.v2021_12_28.ShippingLabel;
import software.amazon.spapi.models.vendor.df.shipping.v2021_12_28.ShippingLabelList;
import software.amazon.spapi.models.vendor.df.shipping.v2021_12_28.SubmitShippingLabelsRequest;
import software.amazon.spapi.models.vendor.df.shipping.v2021_12_28.TransactionReference;

public class VendorShippingLabelsApi {
    private ApiClient apiClient;
    private Boolean disableRateLimiting;
    private final Configuration config = Configuration.get();
    public final Bucket createShippingLabelsBucket = Bucket.builder().addLimit(this.config.getLimit("VendorShippingLabelsApi-createShippingLabels")).build();
    public final Bucket getShippingLabelBucket = Bucket.builder().addLimit(this.config.getLimit("VendorShippingLabelsApi-getShippingLabel")).build();
    public final Bucket getShippingLabelsBucket = Bucket.builder().addLimit(this.config.getLimit("VendorShippingLabelsApi-getShippingLabels")).build();
    public final Bucket submitShippingLabelRequestBucket = Bucket.builder().addLimit(this.config.getLimit("VendorShippingLabelsApi-submitShippingLabelRequest")).build();

    public VendorShippingLabelsApi(ApiClient apiClient, Boolean disableRateLimiting) {
        this.apiClient = apiClient;
        this.disableRateLimiting = disableRateLimiting;
    }

    private Call createShippingLabelsCall(CreateShippingLabelsRequest body, String purchaseOrderNumber, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        CreateShippingLabelsRequest localVarPostBody = body;
        String localVarPath = "/vendor/directFulfillment/shipping/2021-12-28/shippingLabels/{purchaseOrderNumber}".equals("/uploads/2020-11-01/uploadDestinations/{resource}") ? "/vendor/directFulfillment/shipping/2021-12-28/shippingLabels/{purchaseOrderNumber}".replaceAll("\\{purchaseOrderNumber\\}", purchaseOrderNumber.toString()) : "/vendor/directFulfillment/shipping/2021-12-28/shippingLabels/{purchaseOrderNumber}".replaceAll("\\{purchaseOrderNumber\\}", this.apiClient.escapeString(purchaseOrderNumber.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, progressRequestListener);
    }

    private Call createShippingLabelsValidateBeforeCall(CreateShippingLabelsRequest body, String purchaseOrderNumber, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling createShippingLabels(Async)");
        }
        if (purchaseOrderNumber == null) {
            throw new ApiException("Missing the required parameter 'purchaseOrderNumber' when calling createShippingLabels(Async)");
        }
        return this.createShippingLabelsCall(body, purchaseOrderNumber, progressRequestListener);
    }

    public ShippingLabel createShippingLabels(CreateShippingLabelsRequest body, String purchaseOrderNumber, String restrictedDataToken) throws ApiException, LWAException {
        ApiResponse<ShippingLabel> resp = this.createShippingLabelsWithHttpInfo(body, purchaseOrderNumber, restrictedDataToken);
        return resp.getData();
    }

    public ShippingLabel createShippingLabels(CreateShippingLabelsRequest body, String purchaseOrderNumber) throws ApiException, LWAException {
        ApiResponse<ShippingLabel> resp = this.createShippingLabelsWithHttpInfo(body, purchaseOrderNumber, null);
        return resp.getData();
    }

    public ApiResponse<ShippingLabel> createShippingLabelsWithHttpInfo(CreateShippingLabelsRequest body, String purchaseOrderNumber, String restrictedDataToken) throws ApiException, LWAException {
        Call call = this.createShippingLabelsValidateBeforeCall(body, purchaseOrderNumber, null);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "VendorShippingLabelsApi-createShippingLabels");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.createShippingLabelsBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<ShippingLabel>(){}.getType();
            return this.apiClient.execute(call, localVarReturnType);
        }
        throw new ApiException.RateLimitExceeded("createShippingLabels operation exceeds rate limit");
    }

    public ApiResponse<ShippingLabel> createShippingLabelsWithHttpInfo(CreateShippingLabelsRequest body, String purchaseOrderNumber) throws ApiException, LWAException {
        return this.createShippingLabelsWithHttpInfo(body, purchaseOrderNumber, null);
    }

    public Call createShippingLabelsAsync(CreateShippingLabelsRequest body, String purchaseOrderNumber, ApiCallback<ShippingLabel> callback) throws ApiException, LWAException {
        return this.createShippingLabelsAsync(body, purchaseOrderNumber, callback, null);
    }

    public Call createShippingLabelsAsync(CreateShippingLabelsRequest body, String purchaseOrderNumber, ApiCallback<ShippingLabel> callback, String restrictedDataToken) throws ApiException, LWAException {
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressRequestListener = callback::onUploadProgress;
        }
        Call call = this.createShippingLabelsValidateBeforeCall(body, purchaseOrderNumber, progressRequestListener);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "VendorShippingLabelsApi-createShippingLabels");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.createShippingLabelsBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<ShippingLabel>(){}.getType();
            this.apiClient.executeAsync(call, localVarReturnType, callback);
            return call;
        }
        throw new ApiException.RateLimitExceeded("createShippingLabels operation exceeds rate limit");
    }

    private Call getShippingLabelCall(String purchaseOrderNumber, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        Object localVarPostBody = null;
        String localVarPath = "/vendor/directFulfillment/shipping/2021-12-28/shippingLabels/{purchaseOrderNumber}".equals("/uploads/2020-11-01/uploadDestinations/{resource}") ? "/vendor/directFulfillment/shipping/2021-12-28/shippingLabels/{purchaseOrderNumber}".replaceAll("\\{purchaseOrderNumber\\}", purchaseOrderNumber.toString()) : "/vendor/directFulfillment/shipping/2021-12-28/shippingLabels/{purchaseOrderNumber}".replaceAll("\\{purchaseOrderNumber\\}", this.apiClient.escapeString(purchaseOrderNumber.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, progressRequestListener);
    }

    private Call getShippingLabelValidateBeforeCall(String purchaseOrderNumber, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        if (purchaseOrderNumber == null) {
            throw new ApiException("Missing the required parameter 'purchaseOrderNumber' when calling getShippingLabel(Async)");
        }
        return this.getShippingLabelCall(purchaseOrderNumber, progressRequestListener);
    }

    public ShippingLabel getShippingLabel(String purchaseOrderNumber, String restrictedDataToken) throws ApiException, LWAException {
        ApiResponse<ShippingLabel> resp = this.getShippingLabelWithHttpInfo(purchaseOrderNumber, restrictedDataToken);
        return resp.getData();
    }

    public ShippingLabel getShippingLabel(String purchaseOrderNumber) throws ApiException, LWAException {
        ApiResponse<ShippingLabel> resp = this.getShippingLabelWithHttpInfo(purchaseOrderNumber, null);
        return resp.getData();
    }

    public ApiResponse<ShippingLabel> getShippingLabelWithHttpInfo(String purchaseOrderNumber, String restrictedDataToken) throws ApiException, LWAException {
        Call call = this.getShippingLabelValidateBeforeCall(purchaseOrderNumber, null);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "VendorShippingLabelsApi-getShippingLabel");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.getShippingLabelBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<ShippingLabel>(){}.getType();
            return this.apiClient.execute(call, localVarReturnType);
        }
        throw new ApiException.RateLimitExceeded("getShippingLabel operation exceeds rate limit");
    }

    public ApiResponse<ShippingLabel> getShippingLabelWithHttpInfo(String purchaseOrderNumber) throws ApiException, LWAException {
        return this.getShippingLabelWithHttpInfo(purchaseOrderNumber, null);
    }

    public Call getShippingLabelAsync(String purchaseOrderNumber, ApiCallback<ShippingLabel> callback) throws ApiException, LWAException {
        return this.getShippingLabelAsync(purchaseOrderNumber, callback, null);
    }

    public Call getShippingLabelAsync(String purchaseOrderNumber, ApiCallback<ShippingLabel> callback, String restrictedDataToken) throws ApiException, LWAException {
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressRequestListener = callback::onUploadProgress;
        }
        Call call = this.getShippingLabelValidateBeforeCall(purchaseOrderNumber, progressRequestListener);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "VendorShippingLabelsApi-getShippingLabel");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.getShippingLabelBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<ShippingLabel>(){}.getType();
            this.apiClient.executeAsync(call, localVarReturnType, callback);
            return call;
        }
        throw new ApiException.RateLimitExceeded("getShippingLabel operation exceeds rate limit");
    }

    private Call getShippingLabelsCall(OffsetDateTime createdAfter, OffsetDateTime createdBefore, String shipFromPartyId, Integer limit, String sortOrder, String nextToken, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        Object localVarPostBody = null;
        String localVarPath = "/vendor/directFulfillment/shipping/2021-12-28/shippingLabels".equals("/uploads/2020-11-01/uploadDestinations/{resource}") ? "/vendor/directFulfillment/shipping/2021-12-28/shippingLabels" : "/vendor/directFulfillment/shipping/2021-12-28/shippingLabels";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (shipFromPartyId != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("shipFromPartyId", shipFromPartyId));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("limit", limit));
        }
        if (createdAfter != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("createdAfter", createdAfter));
        }
        if (createdBefore != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("createdBefore", createdBefore));
        }
        if (sortOrder != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("sortOrder", sortOrder));
        }
        if (nextToken != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("nextToken", nextToken));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "pagination", "shippingLabels"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, progressRequestListener);
    }

    private Call getShippingLabelsValidateBeforeCall(OffsetDateTime createdAfter, OffsetDateTime createdBefore, String shipFromPartyId, Integer limit, String sortOrder, String nextToken, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        if (createdAfter == null) {
            throw new ApiException("Missing the required parameter 'createdAfter' when calling getShippingLabels(Async)");
        }
        if (createdBefore == null) {
            throw new ApiException("Missing the required parameter 'createdBefore' when calling getShippingLabels(Async)");
        }
        return this.getShippingLabelsCall(createdAfter, createdBefore, shipFromPartyId, limit, sortOrder, nextToken, progressRequestListener);
    }

    public ShippingLabelList getShippingLabels(OffsetDateTime createdAfter, OffsetDateTime createdBefore, String shipFromPartyId, Integer limit, String sortOrder, String nextToken, String restrictedDataToken) throws ApiException, LWAException {
        ApiResponse<ShippingLabelList> resp = this.getShippingLabelsWithHttpInfo(createdAfter, createdBefore, shipFromPartyId, limit, sortOrder, nextToken, restrictedDataToken);
        return resp.getData();
    }

    public ShippingLabelList getShippingLabels(OffsetDateTime createdAfter, OffsetDateTime createdBefore, String shipFromPartyId, Integer limit, String sortOrder, String nextToken) throws ApiException, LWAException {
        ApiResponse<ShippingLabelList> resp = this.getShippingLabelsWithHttpInfo(createdAfter, createdBefore, shipFromPartyId, limit, sortOrder, nextToken, null);
        return resp.getData();
    }

    public ApiResponse<ShippingLabelList> getShippingLabelsWithHttpInfo(OffsetDateTime createdAfter, OffsetDateTime createdBefore, String shipFromPartyId, Integer limit, String sortOrder, String nextToken, String restrictedDataToken) throws ApiException, LWAException {
        Call call = this.getShippingLabelsValidateBeforeCall(createdAfter, createdBefore, shipFromPartyId, limit, sortOrder, nextToken, null);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "VendorShippingLabelsApi-getShippingLabels");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.getShippingLabelsBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<ShippingLabelList>(){}.getType();
            return this.apiClient.execute(call, localVarReturnType);
        }
        throw new ApiException.RateLimitExceeded("getShippingLabels operation exceeds rate limit");
    }

    public ApiResponse<ShippingLabelList> getShippingLabelsWithHttpInfo(OffsetDateTime createdAfter, OffsetDateTime createdBefore, String shipFromPartyId, Integer limit, String sortOrder, String nextToken) throws ApiException, LWAException {
        return this.getShippingLabelsWithHttpInfo(createdAfter, createdBefore, shipFromPartyId, limit, sortOrder, nextToken, null);
    }

    public Call getShippingLabelsAsync(OffsetDateTime createdAfter, OffsetDateTime createdBefore, String shipFromPartyId, Integer limit, String sortOrder, String nextToken, ApiCallback<ShippingLabelList> callback) throws ApiException, LWAException {
        return this.getShippingLabelsAsync(createdAfter, createdBefore, shipFromPartyId, limit, sortOrder, nextToken, callback, null);
    }

    public Call getShippingLabelsAsync(OffsetDateTime createdAfter, OffsetDateTime createdBefore, String shipFromPartyId, Integer limit, String sortOrder, String nextToken, ApiCallback<ShippingLabelList> callback, String restrictedDataToken) throws ApiException, LWAException {
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressRequestListener = callback::onUploadProgress;
        }
        Call call = this.getShippingLabelsValidateBeforeCall(createdAfter, createdBefore, shipFromPartyId, limit, sortOrder, nextToken, progressRequestListener);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "VendorShippingLabelsApi-getShippingLabels");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.getShippingLabelsBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<ShippingLabelList>(){}.getType();
            this.apiClient.executeAsync(call, localVarReturnType, callback);
            return call;
        }
        throw new ApiException.RateLimitExceeded("getShippingLabels operation exceeds rate limit");
    }

    private Call submitShippingLabelRequestCall(SubmitShippingLabelsRequest body, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        SubmitShippingLabelsRequest localVarPostBody = body;
        String localVarPath = "/vendor/directFulfillment/shipping/2021-12-28/shippingLabels".equals("/uploads/2020-11-01/uploadDestinations/{resource}") ? "/vendor/directFulfillment/shipping/2021-12-28/shippingLabels" : "/vendor/directFulfillment/shipping/2021-12-28/shippingLabels";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, progressRequestListener);
    }

    private Call submitShippingLabelRequestValidateBeforeCall(SubmitShippingLabelsRequest body, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling submitShippingLabelRequest(Async)");
        }
        return this.submitShippingLabelRequestCall(body, progressRequestListener);
    }

    public TransactionReference submitShippingLabelRequest(SubmitShippingLabelsRequest body, String restrictedDataToken) throws ApiException, LWAException {
        ApiResponse<TransactionReference> resp = this.submitShippingLabelRequestWithHttpInfo(body, restrictedDataToken);
        return resp.getData();
    }

    public TransactionReference submitShippingLabelRequest(SubmitShippingLabelsRequest body) throws ApiException, LWAException {
        ApiResponse<TransactionReference> resp = this.submitShippingLabelRequestWithHttpInfo(body, null);
        return resp.getData();
    }

    public ApiResponse<TransactionReference> submitShippingLabelRequestWithHttpInfo(SubmitShippingLabelsRequest body, String restrictedDataToken) throws ApiException, LWAException {
        Call call = this.submitShippingLabelRequestValidateBeforeCall(body, null);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "VendorShippingLabelsApi-submitShippingLabelRequest");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.submitShippingLabelRequestBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<TransactionReference>(){}.getType();
            return this.apiClient.execute(call, localVarReturnType);
        }
        throw new ApiException.RateLimitExceeded("submitShippingLabelRequest operation exceeds rate limit");
    }

    public ApiResponse<TransactionReference> submitShippingLabelRequestWithHttpInfo(SubmitShippingLabelsRequest body) throws ApiException, LWAException {
        return this.submitShippingLabelRequestWithHttpInfo(body, null);
    }

    public Call submitShippingLabelRequestAsync(SubmitShippingLabelsRequest body, ApiCallback<TransactionReference> callback) throws ApiException, LWAException {
        return this.submitShippingLabelRequestAsync(body, callback, null);
    }

    public Call submitShippingLabelRequestAsync(SubmitShippingLabelsRequest body, ApiCallback<TransactionReference> callback, String restrictedDataToken) throws ApiException, LWAException {
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressRequestListener = callback::onUploadProgress;
        }
        Call call = this.submitShippingLabelRequestValidateBeforeCall(body, progressRequestListener);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "VendorShippingLabelsApi-submitShippingLabelRequest");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.submitShippingLabelRequestBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<TransactionReference>(){}.getType();
            this.apiClient.executeAsync(call, localVarReturnType, callback);
            return call;
        }
        throw new ApiException.RateLimitExceeded("submitShippingLabelRequest operation exceeds rate limit");
    }

    public static class Builder {
        private LWAAuthorizationCredentials lwaAuthorizationCredentials;
        private String endpoint;
        private LWAAccessTokenCache lwaAccessTokenCache;
        private Boolean disableAccessTokenCache = false;
        private Boolean disableRateLimiting = false;

        public Builder lwaAuthorizationCredentials(LWAAuthorizationCredentials lwaAuthorizationCredentials) {
            this.lwaAuthorizationCredentials = lwaAuthorizationCredentials;
            return this;
        }

        public Builder endpoint(String endpoint) {
            this.endpoint = endpoint;
            return this;
        }

        public Builder lwaAccessTokenCache(LWAAccessTokenCache lwaAccessTokenCache) {
            this.lwaAccessTokenCache = lwaAccessTokenCache;
            return this;
        }

        public Builder disableAccessTokenCache() {
            this.disableAccessTokenCache = true;
            return this;
        }

        public Builder disableRateLimiting() {
            this.disableRateLimiting = true;
            return this;
        }

        public VendorShippingLabelsApi build() {
            if (this.lwaAuthorizationCredentials == null) {
                throw new RuntimeException("LWAAuthorizationCredentials not set");
            }
            if (StringUtil.isEmpty(this.endpoint)) {
                throw new RuntimeException("Endpoint not set");
            }
            LWAAuthorizationSigner lwaAuthorizationSigner = null;
            if (this.disableAccessTokenCache.booleanValue()) {
                lwaAuthorizationSigner = new LWAAuthorizationSigner(this.lwaAuthorizationCredentials);
            } else {
                if (this.lwaAccessTokenCache == null) {
                    this.lwaAccessTokenCache = new LWAAccessTokenCacheImpl();
                }
                lwaAuthorizationSigner = new LWAAuthorizationSigner(this.lwaAuthorizationCredentials, this.lwaAccessTokenCache);
            }
            return new VendorShippingLabelsApi(new ApiClient().setLWAAuthorizationSigner(lwaAuthorizationSigner).setBasePath(this.endpoint), this.disableRateLimiting);
        }
    }
}

