/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.api.vendor.df.shipping.v2021_12_28;

import com.amazon.SellingPartnerAPIAA.LWAAccessTokenCache;
import com.amazon.SellingPartnerAPIAA.LWAAccessTokenCacheImpl;
import com.amazon.SellingPartnerAPIAA.LWAAuthorizationCredentials;
import com.amazon.SellingPartnerAPIAA.LWAAuthorizationSigner;
import com.amazon.SellingPartnerAPIAA.LWAException;
import com.amazon.SellingPartnerAPIAA.RestrictedDataTokenSigner;
import com.google.gson.reflect.TypeToken;
import io.github.bucket4j.Bucket;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import okhttp3.Call;
import okhttp3.Request;
import org.threeten.bp.OffsetDateTime;
import software.amazon.spapi.ApiCallback;
import software.amazon.spapi.ApiClient;
import software.amazon.spapi.ApiException;
import software.amazon.spapi.ApiResponse;
import software.amazon.spapi.Configuration;
import software.amazon.spapi.Pair;
import software.amazon.spapi.ProgressRequestBody;
import software.amazon.spapi.StringUtil;
import software.amazon.spapi.models.vendor.df.shipping.v2021_12_28.PackingSlip;
import software.amazon.spapi.models.vendor.df.shipping.v2021_12_28.PackingSlipList;
import software.amazon.spapi.models.vendor.df.shipping.v2021_12_28.SubmitShipmentConfirmationsRequest;
import software.amazon.spapi.models.vendor.df.shipping.v2021_12_28.SubmitShipmentStatusUpdatesRequest;
import software.amazon.spapi.models.vendor.df.shipping.v2021_12_28.TransactionReference;

public class VendorShippingApi {
    private ApiClient apiClient;
    private Boolean disableRateLimiting;
    private final Configuration config = Configuration.get();
    public final Bucket getPackingSlipBucket = Bucket.builder().addLimit(this.config.getLimit("VendorShippingApi-getPackingSlip")).build();
    public final Bucket getPackingSlipsBucket = Bucket.builder().addLimit(this.config.getLimit("VendorShippingApi-getPackingSlips")).build();
    public final Bucket submitShipmentConfirmationsBucket = Bucket.builder().addLimit(this.config.getLimit("VendorShippingApi-submitShipmentConfirmations")).build();
    public final Bucket submitShipmentStatusUpdatesBucket = Bucket.builder().addLimit(this.config.getLimit("VendorShippingApi-submitShipmentStatusUpdates")).build();

    public VendorShippingApi(ApiClient apiClient, Boolean disableRateLimiting) {
        this.apiClient = apiClient;
        this.disableRateLimiting = disableRateLimiting;
    }

    private Call getPackingSlipCall(String purchaseOrderNumber, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        Object localVarPostBody = null;
        String localVarPath = "/vendor/directFulfillment/shipping/2021-12-28/packingSlips/{purchaseOrderNumber}".equals("/uploads/2020-11-01/uploadDestinations/{resource}") ? "/vendor/directFulfillment/shipping/2021-12-28/packingSlips/{purchaseOrderNumber}".replaceAll("\\{purchaseOrderNumber\\}", purchaseOrderNumber.toString()) : "/vendor/directFulfillment/shipping/2021-12-28/packingSlips/{purchaseOrderNumber}".replaceAll("\\{purchaseOrderNumber\\}", this.apiClient.escapeString(purchaseOrderNumber.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, progressRequestListener);
    }

    private Call getPackingSlipValidateBeforeCall(String purchaseOrderNumber, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        if (purchaseOrderNumber == null) {
            throw new ApiException("Missing the required parameter 'purchaseOrderNumber' when calling getPackingSlip(Async)");
        }
        return this.getPackingSlipCall(purchaseOrderNumber, progressRequestListener);
    }

    public PackingSlip getPackingSlip(String purchaseOrderNumber, String restrictedDataToken) throws ApiException, LWAException {
        ApiResponse<PackingSlip> resp = this.getPackingSlipWithHttpInfo(purchaseOrderNumber, restrictedDataToken);
        return resp.getData();
    }

    public PackingSlip getPackingSlip(String purchaseOrderNumber) throws ApiException, LWAException {
        ApiResponse<PackingSlip> resp = this.getPackingSlipWithHttpInfo(purchaseOrderNumber, null);
        return resp.getData();
    }

    public ApiResponse<PackingSlip> getPackingSlipWithHttpInfo(String purchaseOrderNumber, String restrictedDataToken) throws ApiException, LWAException {
        Call call = this.getPackingSlipValidateBeforeCall(purchaseOrderNumber, null);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "VendorShippingApi-getPackingSlip");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.getPackingSlipBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<PackingSlip>(){}.getType();
            return this.apiClient.execute(call, localVarReturnType);
        }
        throw new ApiException.RateLimitExceeded("getPackingSlip operation exceeds rate limit");
    }

    public ApiResponse<PackingSlip> getPackingSlipWithHttpInfo(String purchaseOrderNumber) throws ApiException, LWAException {
        return this.getPackingSlipWithHttpInfo(purchaseOrderNumber, null);
    }

    public Call getPackingSlipAsync(String purchaseOrderNumber, ApiCallback<PackingSlip> callback) throws ApiException, LWAException {
        return this.getPackingSlipAsync(purchaseOrderNumber, callback, null);
    }

    public Call getPackingSlipAsync(String purchaseOrderNumber, ApiCallback<PackingSlip> callback, String restrictedDataToken) throws ApiException, LWAException {
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressRequestListener = callback::onUploadProgress;
        }
        Call call = this.getPackingSlipValidateBeforeCall(purchaseOrderNumber, progressRequestListener);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "VendorShippingApi-getPackingSlip");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.getPackingSlipBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<PackingSlip>(){}.getType();
            this.apiClient.executeAsync(call, localVarReturnType, callback);
            return call;
        }
        throw new ApiException.RateLimitExceeded("getPackingSlip operation exceeds rate limit");
    }

    private Call getPackingSlipsCall(OffsetDateTime createdAfter, OffsetDateTime createdBefore, String shipFromPartyId, Integer limit, String sortOrder, String nextToken, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        Object localVarPostBody = null;
        String localVarPath = "/vendor/directFulfillment/shipping/2021-12-28/packingSlips".equals("/uploads/2020-11-01/uploadDestinations/{resource}") ? "/vendor/directFulfillment/shipping/2021-12-28/packingSlips" : "/vendor/directFulfillment/shipping/2021-12-28/packingSlips";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (shipFromPartyId != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("shipFromPartyId", shipFromPartyId));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("limit", limit));
        }
        if (createdAfter != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("createdAfter", createdAfter));
        }
        if (createdBefore != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("createdBefore", createdBefore));
        }
        if (sortOrder != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("sortOrder", sortOrder));
        }
        if (nextToken != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("nextToken", nextToken));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, progressRequestListener);
    }

    private Call getPackingSlipsValidateBeforeCall(OffsetDateTime createdAfter, OffsetDateTime createdBefore, String shipFromPartyId, Integer limit, String sortOrder, String nextToken, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        if (createdAfter == null) {
            throw new ApiException("Missing the required parameter 'createdAfter' when calling getPackingSlips(Async)");
        }
        if (createdBefore == null) {
            throw new ApiException("Missing the required parameter 'createdBefore' when calling getPackingSlips(Async)");
        }
        return this.getPackingSlipsCall(createdAfter, createdBefore, shipFromPartyId, limit, sortOrder, nextToken, progressRequestListener);
    }

    public PackingSlipList getPackingSlips(OffsetDateTime createdAfter, OffsetDateTime createdBefore, String shipFromPartyId, Integer limit, String sortOrder, String nextToken, String restrictedDataToken) throws ApiException, LWAException {
        ApiResponse<PackingSlipList> resp = this.getPackingSlipsWithHttpInfo(createdAfter, createdBefore, shipFromPartyId, limit, sortOrder, nextToken, restrictedDataToken);
        return resp.getData();
    }

    public PackingSlipList getPackingSlips(OffsetDateTime createdAfter, OffsetDateTime createdBefore, String shipFromPartyId, Integer limit, String sortOrder, String nextToken) throws ApiException, LWAException {
        ApiResponse<PackingSlipList> resp = this.getPackingSlipsWithHttpInfo(createdAfter, createdBefore, shipFromPartyId, limit, sortOrder, nextToken, null);
        return resp.getData();
    }

    public ApiResponse<PackingSlipList> getPackingSlipsWithHttpInfo(OffsetDateTime createdAfter, OffsetDateTime createdBefore, String shipFromPartyId, Integer limit, String sortOrder, String nextToken, String restrictedDataToken) throws ApiException, LWAException {
        Call call = this.getPackingSlipsValidateBeforeCall(createdAfter, createdBefore, shipFromPartyId, limit, sortOrder, nextToken, null);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "VendorShippingApi-getPackingSlips");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.getPackingSlipsBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<PackingSlipList>(){}.getType();
            return this.apiClient.execute(call, localVarReturnType);
        }
        throw new ApiException.RateLimitExceeded("getPackingSlips operation exceeds rate limit");
    }

    public ApiResponse<PackingSlipList> getPackingSlipsWithHttpInfo(OffsetDateTime createdAfter, OffsetDateTime createdBefore, String shipFromPartyId, Integer limit, String sortOrder, String nextToken) throws ApiException, LWAException {
        return this.getPackingSlipsWithHttpInfo(createdAfter, createdBefore, shipFromPartyId, limit, sortOrder, nextToken, null);
    }

    public Call getPackingSlipsAsync(OffsetDateTime createdAfter, OffsetDateTime createdBefore, String shipFromPartyId, Integer limit, String sortOrder, String nextToken, ApiCallback<PackingSlipList> callback) throws ApiException, LWAException {
        return this.getPackingSlipsAsync(createdAfter, createdBefore, shipFromPartyId, limit, sortOrder, nextToken, callback, null);
    }

    public Call getPackingSlipsAsync(OffsetDateTime createdAfter, OffsetDateTime createdBefore, String shipFromPartyId, Integer limit, String sortOrder, String nextToken, ApiCallback<PackingSlipList> callback, String restrictedDataToken) throws ApiException, LWAException {
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressRequestListener = callback::onUploadProgress;
        }
        Call call = this.getPackingSlipsValidateBeforeCall(createdAfter, createdBefore, shipFromPartyId, limit, sortOrder, nextToken, progressRequestListener);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "VendorShippingApi-getPackingSlips");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.getPackingSlipsBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<PackingSlipList>(){}.getType();
            this.apiClient.executeAsync(call, localVarReturnType, callback);
            return call;
        }
        throw new ApiException.RateLimitExceeded("getPackingSlips operation exceeds rate limit");
    }

    private Call submitShipmentConfirmationsCall(SubmitShipmentConfirmationsRequest body, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        SubmitShipmentConfirmationsRequest localVarPostBody = body;
        String localVarPath = "/vendor/directFulfillment/shipping/2021-12-28/shipmentConfirmations".equals("/uploads/2020-11-01/uploadDestinations/{resource}") ? "/vendor/directFulfillment/shipping/2021-12-28/shipmentConfirmations" : "/vendor/directFulfillment/shipping/2021-12-28/shipmentConfirmations";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, progressRequestListener);
    }

    private Call submitShipmentConfirmationsValidateBeforeCall(SubmitShipmentConfirmationsRequest body, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling submitShipmentConfirmations(Async)");
        }
        return this.submitShipmentConfirmationsCall(body, progressRequestListener);
    }

    public TransactionReference submitShipmentConfirmations(SubmitShipmentConfirmationsRequest body, String restrictedDataToken) throws ApiException, LWAException {
        ApiResponse<TransactionReference> resp = this.submitShipmentConfirmationsWithHttpInfo(body, restrictedDataToken);
        return resp.getData();
    }

    public TransactionReference submitShipmentConfirmations(SubmitShipmentConfirmationsRequest body) throws ApiException, LWAException {
        ApiResponse<TransactionReference> resp = this.submitShipmentConfirmationsWithHttpInfo(body, null);
        return resp.getData();
    }

    public ApiResponse<TransactionReference> submitShipmentConfirmationsWithHttpInfo(SubmitShipmentConfirmationsRequest body, String restrictedDataToken) throws ApiException, LWAException {
        Call call = this.submitShipmentConfirmationsValidateBeforeCall(body, null);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "VendorShippingApi-submitShipmentConfirmations");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.submitShipmentConfirmationsBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<TransactionReference>(){}.getType();
            return this.apiClient.execute(call, localVarReturnType);
        }
        throw new ApiException.RateLimitExceeded("submitShipmentConfirmations operation exceeds rate limit");
    }

    public ApiResponse<TransactionReference> submitShipmentConfirmationsWithHttpInfo(SubmitShipmentConfirmationsRequest body) throws ApiException, LWAException {
        return this.submitShipmentConfirmationsWithHttpInfo(body, null);
    }

    public Call submitShipmentConfirmationsAsync(SubmitShipmentConfirmationsRequest body, ApiCallback<TransactionReference> callback) throws ApiException, LWAException {
        return this.submitShipmentConfirmationsAsync(body, callback, null);
    }

    public Call submitShipmentConfirmationsAsync(SubmitShipmentConfirmationsRequest body, ApiCallback<TransactionReference> callback, String restrictedDataToken) throws ApiException, LWAException {
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressRequestListener = callback::onUploadProgress;
        }
        Call call = this.submitShipmentConfirmationsValidateBeforeCall(body, progressRequestListener);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "VendorShippingApi-submitShipmentConfirmations");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.submitShipmentConfirmationsBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<TransactionReference>(){}.getType();
            this.apiClient.executeAsync(call, localVarReturnType, callback);
            return call;
        }
        throw new ApiException.RateLimitExceeded("submitShipmentConfirmations operation exceeds rate limit");
    }

    private Call submitShipmentStatusUpdatesCall(SubmitShipmentStatusUpdatesRequest body, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        SubmitShipmentStatusUpdatesRequest localVarPostBody = body;
        String localVarPath = "/vendor/directFulfillment/shipping/2021-12-28/shipmentStatusUpdates".equals("/uploads/2020-11-01/uploadDestinations/{resource}") ? "/vendor/directFulfillment/shipping/2021-12-28/shipmentStatusUpdates" : "/vendor/directFulfillment/shipping/2021-12-28/shipmentStatusUpdates";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, progressRequestListener);
    }

    private Call submitShipmentStatusUpdatesValidateBeforeCall(SubmitShipmentStatusUpdatesRequest body, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling submitShipmentStatusUpdates(Async)");
        }
        return this.submitShipmentStatusUpdatesCall(body, progressRequestListener);
    }

    public TransactionReference submitShipmentStatusUpdates(SubmitShipmentStatusUpdatesRequest body, String restrictedDataToken) throws ApiException, LWAException {
        ApiResponse<TransactionReference> resp = this.submitShipmentStatusUpdatesWithHttpInfo(body, restrictedDataToken);
        return resp.getData();
    }

    public TransactionReference submitShipmentStatusUpdates(SubmitShipmentStatusUpdatesRequest body) throws ApiException, LWAException {
        ApiResponse<TransactionReference> resp = this.submitShipmentStatusUpdatesWithHttpInfo(body, null);
        return resp.getData();
    }

    public ApiResponse<TransactionReference> submitShipmentStatusUpdatesWithHttpInfo(SubmitShipmentStatusUpdatesRequest body, String restrictedDataToken) throws ApiException, LWAException {
        Call call = this.submitShipmentStatusUpdatesValidateBeforeCall(body, null);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "VendorShippingApi-submitShipmentStatusUpdates");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.submitShipmentStatusUpdatesBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<TransactionReference>(){}.getType();
            return this.apiClient.execute(call, localVarReturnType);
        }
        throw new ApiException.RateLimitExceeded("submitShipmentStatusUpdates operation exceeds rate limit");
    }

    public ApiResponse<TransactionReference> submitShipmentStatusUpdatesWithHttpInfo(SubmitShipmentStatusUpdatesRequest body) throws ApiException, LWAException {
        return this.submitShipmentStatusUpdatesWithHttpInfo(body, null);
    }

    public Call submitShipmentStatusUpdatesAsync(SubmitShipmentStatusUpdatesRequest body, ApiCallback<TransactionReference> callback) throws ApiException, LWAException {
        return this.submitShipmentStatusUpdatesAsync(body, callback, null);
    }

    public Call submitShipmentStatusUpdatesAsync(SubmitShipmentStatusUpdatesRequest body, ApiCallback<TransactionReference> callback, String restrictedDataToken) throws ApiException, LWAException {
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressRequestListener = callback::onUploadProgress;
        }
        Call call = this.submitShipmentStatusUpdatesValidateBeforeCall(body, progressRequestListener);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "VendorShippingApi-submitShipmentStatusUpdates");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.submitShipmentStatusUpdatesBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<TransactionReference>(){}.getType();
            this.apiClient.executeAsync(call, localVarReturnType, callback);
            return call;
        }
        throw new ApiException.RateLimitExceeded("submitShipmentStatusUpdates operation exceeds rate limit");
    }

    public static class Builder {
        private LWAAuthorizationCredentials lwaAuthorizationCredentials;
        private String endpoint;
        private LWAAccessTokenCache lwaAccessTokenCache;
        private Boolean disableAccessTokenCache = false;
        private Boolean disableRateLimiting = false;

        public Builder lwaAuthorizationCredentials(LWAAuthorizationCredentials lwaAuthorizationCredentials) {
            this.lwaAuthorizationCredentials = lwaAuthorizationCredentials;
            return this;
        }

        public Builder endpoint(String endpoint) {
            this.endpoint = endpoint;
            return this;
        }

        public Builder lwaAccessTokenCache(LWAAccessTokenCache lwaAccessTokenCache) {
            this.lwaAccessTokenCache = lwaAccessTokenCache;
            return this;
        }

        public Builder disableAccessTokenCache() {
            this.disableAccessTokenCache = true;
            return this;
        }

        public Builder disableRateLimiting() {
            this.disableRateLimiting = true;
            return this;
        }

        public VendorShippingApi build() {
            if (this.lwaAuthorizationCredentials == null) {
                throw new RuntimeException("LWAAuthorizationCredentials not set");
            }
            if (StringUtil.isEmpty(this.endpoint)) {
                throw new RuntimeException("Endpoint not set");
            }
            LWAAuthorizationSigner lwaAuthorizationSigner = null;
            if (this.disableAccessTokenCache.booleanValue()) {
                lwaAuthorizationSigner = new LWAAuthorizationSigner(this.lwaAuthorizationCredentials);
            } else {
                if (this.lwaAccessTokenCache == null) {
                    this.lwaAccessTokenCache = new LWAAccessTokenCacheImpl();
                }
                lwaAuthorizationSigner = new LWAAuthorizationSigner(this.lwaAuthorizationCredentials, this.lwaAccessTokenCache);
            }
            return new VendorShippingApi(new ApiClient().setLWAAuthorizationSigner(lwaAuthorizationSigner).setBasePath(this.endpoint), this.disableRateLimiting);
        }
    }
}

