/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.api.vendor.df.shipping.v2021_12_28;

import com.amazon.SellingPartnerAPIAA.LWAAccessTokenCache;
import com.amazon.SellingPartnerAPIAA.LWAAccessTokenCacheImpl;
import com.amazon.SellingPartnerAPIAA.LWAAuthorizationCredentials;
import com.amazon.SellingPartnerAPIAA.LWAAuthorizationSigner;
import com.amazon.SellingPartnerAPIAA.LWAException;
import com.amazon.SellingPartnerAPIAA.RestrictedDataTokenSigner;
import com.google.gson.reflect.TypeToken;
import io.github.bucket4j.Bucket;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import okhttp3.Call;
import okhttp3.Request;
import org.threeten.bp.OffsetDateTime;
import software.amazon.spapi.ApiCallback;
import software.amazon.spapi.ApiClient;
import software.amazon.spapi.ApiException;
import software.amazon.spapi.ApiResponse;
import software.amazon.spapi.Configuration;
import software.amazon.spapi.Pair;
import software.amazon.spapi.ProgressRequestBody;
import software.amazon.spapi.StringUtil;
import software.amazon.spapi.models.vendor.df.shipping.v2021_12_28.CustomerInvoice;
import software.amazon.spapi.models.vendor.df.shipping.v2021_12_28.CustomerInvoiceList;

public class CustomerInvoicesApi {
    private ApiClient apiClient;
    private Boolean disableRateLimiting;
    private final Configuration config = Configuration.get();
    public final Bucket getCustomerInvoiceBucket = Bucket.builder().addLimit(this.config.getLimit("CustomerInvoicesApi-getCustomerInvoice")).build();
    public final Bucket getCustomerInvoicesBucket = Bucket.builder().addLimit(this.config.getLimit("CustomerInvoicesApi-getCustomerInvoices")).build();

    public CustomerInvoicesApi(ApiClient apiClient, Boolean disableRateLimiting) {
        this.apiClient = apiClient;
        this.disableRateLimiting = disableRateLimiting;
    }

    private Call getCustomerInvoiceCall(String purchaseOrderNumber, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        Object localVarPostBody = null;
        String localVarPath = "/vendor/directFulfillment/shipping/2021-12-28/customerInvoices/{purchaseOrderNumber}".equals("/uploads/2020-11-01/uploadDestinations/{resource}") ? "/vendor/directFulfillment/shipping/2021-12-28/customerInvoices/{purchaseOrderNumber}".replaceAll("\\{purchaseOrderNumber\\}", purchaseOrderNumber.toString()) : "/vendor/directFulfillment/shipping/2021-12-28/customerInvoices/{purchaseOrderNumber}".replaceAll("\\{purchaseOrderNumber\\}", this.apiClient.escapeString(purchaseOrderNumber.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, progressRequestListener);
    }

    private Call getCustomerInvoiceValidateBeforeCall(String purchaseOrderNumber, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        if (purchaseOrderNumber == null) {
            throw new ApiException("Missing the required parameter 'purchaseOrderNumber' when calling getCustomerInvoice(Async)");
        }
        return this.getCustomerInvoiceCall(purchaseOrderNumber, progressRequestListener);
    }

    public CustomerInvoice getCustomerInvoice(String purchaseOrderNumber, String restrictedDataToken) throws ApiException, LWAException {
        ApiResponse<CustomerInvoice> resp = this.getCustomerInvoiceWithHttpInfo(purchaseOrderNumber, restrictedDataToken);
        return resp.getData();
    }

    public CustomerInvoice getCustomerInvoice(String purchaseOrderNumber) throws ApiException, LWAException {
        ApiResponse<CustomerInvoice> resp = this.getCustomerInvoiceWithHttpInfo(purchaseOrderNumber, null);
        return resp.getData();
    }

    public ApiResponse<CustomerInvoice> getCustomerInvoiceWithHttpInfo(String purchaseOrderNumber, String restrictedDataToken) throws ApiException, LWAException {
        Call call = this.getCustomerInvoiceValidateBeforeCall(purchaseOrderNumber, null);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "CustomerInvoicesApi-getCustomerInvoice");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.getCustomerInvoiceBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<CustomerInvoice>(){}.getType();
            return this.apiClient.execute(call, localVarReturnType);
        }
        throw new ApiException.RateLimitExceeded("getCustomerInvoice operation exceeds rate limit");
    }

    public ApiResponse<CustomerInvoice> getCustomerInvoiceWithHttpInfo(String purchaseOrderNumber) throws ApiException, LWAException {
        return this.getCustomerInvoiceWithHttpInfo(purchaseOrderNumber, null);
    }

    public Call getCustomerInvoiceAsync(String purchaseOrderNumber, ApiCallback<CustomerInvoice> callback) throws ApiException, LWAException {
        return this.getCustomerInvoiceAsync(purchaseOrderNumber, callback, null);
    }

    public Call getCustomerInvoiceAsync(String purchaseOrderNumber, ApiCallback<CustomerInvoice> callback, String restrictedDataToken) throws ApiException, LWAException {
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressRequestListener = callback::onUploadProgress;
        }
        Call call = this.getCustomerInvoiceValidateBeforeCall(purchaseOrderNumber, progressRequestListener);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "CustomerInvoicesApi-getCustomerInvoice");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.getCustomerInvoiceBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<CustomerInvoice>(){}.getType();
            this.apiClient.executeAsync(call, localVarReturnType, callback);
            return call;
        }
        throw new ApiException.RateLimitExceeded("getCustomerInvoice operation exceeds rate limit");
    }

    private Call getCustomerInvoicesCall(OffsetDateTime createdAfter, OffsetDateTime createdBefore, String shipFromPartyId, Integer limit, String sortOrder, String nextToken, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        Object localVarPostBody = null;
        String localVarPath = "/vendor/directFulfillment/shipping/2021-12-28/customerInvoices".equals("/uploads/2020-11-01/uploadDestinations/{resource}") ? "/vendor/directFulfillment/shipping/2021-12-28/customerInvoices" : "/vendor/directFulfillment/shipping/2021-12-28/customerInvoices";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (shipFromPartyId != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("shipFromPartyId", shipFromPartyId));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("limit", limit));
        }
        if (createdAfter != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("createdAfter", createdAfter));
        }
        if (createdBefore != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("createdBefore", createdBefore));
        }
        if (sortOrder != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("sortOrder", sortOrder));
        }
        if (nextToken != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("nextToken", nextToken));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "payload"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, progressRequestListener);
    }

    private Call getCustomerInvoicesValidateBeforeCall(OffsetDateTime createdAfter, OffsetDateTime createdBefore, String shipFromPartyId, Integer limit, String sortOrder, String nextToken, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        if (createdAfter == null) {
            throw new ApiException("Missing the required parameter 'createdAfter' when calling getCustomerInvoices(Async)");
        }
        if (createdBefore == null) {
            throw new ApiException("Missing the required parameter 'createdBefore' when calling getCustomerInvoices(Async)");
        }
        return this.getCustomerInvoicesCall(createdAfter, createdBefore, shipFromPartyId, limit, sortOrder, nextToken, progressRequestListener);
    }

    public CustomerInvoiceList getCustomerInvoices(OffsetDateTime createdAfter, OffsetDateTime createdBefore, String shipFromPartyId, Integer limit, String sortOrder, String nextToken, String restrictedDataToken) throws ApiException, LWAException {
        ApiResponse<CustomerInvoiceList> resp = this.getCustomerInvoicesWithHttpInfo(createdAfter, createdBefore, shipFromPartyId, limit, sortOrder, nextToken, restrictedDataToken);
        return resp.getData();
    }

    public CustomerInvoiceList getCustomerInvoices(OffsetDateTime createdAfter, OffsetDateTime createdBefore, String shipFromPartyId, Integer limit, String sortOrder, String nextToken) throws ApiException, LWAException {
        ApiResponse<CustomerInvoiceList> resp = this.getCustomerInvoicesWithHttpInfo(createdAfter, createdBefore, shipFromPartyId, limit, sortOrder, nextToken, null);
        return resp.getData();
    }

    public ApiResponse<CustomerInvoiceList> getCustomerInvoicesWithHttpInfo(OffsetDateTime createdAfter, OffsetDateTime createdBefore, String shipFromPartyId, Integer limit, String sortOrder, String nextToken, String restrictedDataToken) throws ApiException, LWAException {
        Call call = this.getCustomerInvoicesValidateBeforeCall(createdAfter, createdBefore, shipFromPartyId, limit, sortOrder, nextToken, null);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "CustomerInvoicesApi-getCustomerInvoices");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.getCustomerInvoicesBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<CustomerInvoiceList>(){}.getType();
            return this.apiClient.execute(call, localVarReturnType);
        }
        throw new ApiException.RateLimitExceeded("getCustomerInvoices operation exceeds rate limit");
    }

    public ApiResponse<CustomerInvoiceList> getCustomerInvoicesWithHttpInfo(OffsetDateTime createdAfter, OffsetDateTime createdBefore, String shipFromPartyId, Integer limit, String sortOrder, String nextToken) throws ApiException, LWAException {
        return this.getCustomerInvoicesWithHttpInfo(createdAfter, createdBefore, shipFromPartyId, limit, sortOrder, nextToken, null);
    }

    public Call getCustomerInvoicesAsync(OffsetDateTime createdAfter, OffsetDateTime createdBefore, String shipFromPartyId, Integer limit, String sortOrder, String nextToken, ApiCallback<CustomerInvoiceList> callback) throws ApiException, LWAException {
        return this.getCustomerInvoicesAsync(createdAfter, createdBefore, shipFromPartyId, limit, sortOrder, nextToken, callback, null);
    }

    public Call getCustomerInvoicesAsync(OffsetDateTime createdAfter, OffsetDateTime createdBefore, String shipFromPartyId, Integer limit, String sortOrder, String nextToken, ApiCallback<CustomerInvoiceList> callback, String restrictedDataToken) throws ApiException, LWAException {
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressRequestListener = callback::onUploadProgress;
        }
        Call call = this.getCustomerInvoicesValidateBeforeCall(createdAfter, createdBefore, shipFromPartyId, limit, sortOrder, nextToken, progressRequestListener);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "CustomerInvoicesApi-getCustomerInvoices");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.getCustomerInvoicesBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<CustomerInvoiceList>(){}.getType();
            this.apiClient.executeAsync(call, localVarReturnType, callback);
            return call;
        }
        throw new ApiException.RateLimitExceeded("getCustomerInvoices operation exceeds rate limit");
    }

    public static class Builder {
        private LWAAuthorizationCredentials lwaAuthorizationCredentials;
        private String endpoint;
        private LWAAccessTokenCache lwaAccessTokenCache;
        private Boolean disableAccessTokenCache = false;
        private Boolean disableRateLimiting = false;

        public Builder lwaAuthorizationCredentials(LWAAuthorizationCredentials lwaAuthorizationCredentials) {
            this.lwaAuthorizationCredentials = lwaAuthorizationCredentials;
            return this;
        }

        public Builder endpoint(String endpoint) {
            this.endpoint = endpoint;
            return this;
        }

        public Builder lwaAccessTokenCache(LWAAccessTokenCache lwaAccessTokenCache) {
            this.lwaAccessTokenCache = lwaAccessTokenCache;
            return this;
        }

        public Builder disableAccessTokenCache() {
            this.disableAccessTokenCache = true;
            return this;
        }

        public Builder disableRateLimiting() {
            this.disableRateLimiting = true;
            return this;
        }

        public CustomerInvoicesApi build() {
            if (this.lwaAuthorizationCredentials == null) {
                throw new RuntimeException("LWAAuthorizationCredentials not set");
            }
            if (StringUtil.isEmpty(this.endpoint)) {
                throw new RuntimeException("Endpoint not set");
            }
            LWAAuthorizationSigner lwaAuthorizationSigner = null;
            if (this.disableAccessTokenCache.booleanValue()) {
                lwaAuthorizationSigner = new LWAAuthorizationSigner(this.lwaAuthorizationCredentials);
            } else {
                if (this.lwaAccessTokenCache == null) {
                    this.lwaAccessTokenCache = new LWAAccessTokenCacheImpl();
                }
                lwaAuthorizationSigner = new LWAAuthorizationSigner(this.lwaAuthorizationCredentials, this.lwaAccessTokenCache);
            }
            return new CustomerInvoicesApi(new ApiClient().setLWAAuthorizationSigner(lwaAuthorizationSigner).setBasePath(this.endpoint), this.disableRateLimiting);
        }
    }
}

