/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.api.vendor.df.orders.v2021_12_28;

import com.amazon.SellingPartnerAPIAA.LWAAccessTokenCache;
import com.amazon.SellingPartnerAPIAA.LWAAccessTokenCacheImpl;
import com.amazon.SellingPartnerAPIAA.LWAAuthorizationCredentials;
import com.amazon.SellingPartnerAPIAA.LWAAuthorizationSigner;
import com.amazon.SellingPartnerAPIAA.LWAException;
import com.amazon.SellingPartnerAPIAA.RestrictedDataTokenSigner;
import com.google.gson.reflect.TypeToken;
import io.github.bucket4j.Bucket;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import okhttp3.Call;
import okhttp3.Request;
import org.threeten.bp.OffsetDateTime;
import software.amazon.spapi.ApiCallback;
import software.amazon.spapi.ApiClient;
import software.amazon.spapi.ApiException;
import software.amazon.spapi.ApiResponse;
import software.amazon.spapi.Configuration;
import software.amazon.spapi.Pair;
import software.amazon.spapi.ProgressRequestBody;
import software.amazon.spapi.StringUtil;
import software.amazon.spapi.models.vendor.df.orders.v2021_12_28.Order;
import software.amazon.spapi.models.vendor.df.orders.v2021_12_28.OrderList;
import software.amazon.spapi.models.vendor.df.orders.v2021_12_28.SubmitAcknowledgementRequest;
import software.amazon.spapi.models.vendor.df.orders.v2021_12_28.TransactionId;

public class VendorOrdersApi {
    private ApiClient apiClient;
    private Boolean disableRateLimiting;
    private final Configuration config = Configuration.get();
    public final Bucket getOrderBucket = Bucket.builder().addLimit(this.config.getLimit("VendorOrdersApi-getOrder")).build();
    public final Bucket getOrdersBucket = Bucket.builder().addLimit(this.config.getLimit("VendorOrdersApi-getOrders")).build();
    public final Bucket submitAcknowledgementBucket = Bucket.builder().addLimit(this.config.getLimit("VendorOrdersApi-submitAcknowledgement")).build();

    public VendorOrdersApi(ApiClient apiClient, Boolean disableRateLimiting) {
        this.apiClient = apiClient;
        this.disableRateLimiting = disableRateLimiting;
    }

    private Call getOrderCall(String purchaseOrderNumber, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        Object localVarPostBody = null;
        String localVarPath = "/vendor/directFulfillment/orders/2021-12-28/purchaseOrders/{purchaseOrderNumber}".equals("/uploads/2020-11-01/uploadDestinations/{resource}") ? "/vendor/directFulfillment/orders/2021-12-28/purchaseOrders/{purchaseOrderNumber}".replaceAll("\\{purchaseOrderNumber\\}", purchaseOrderNumber.toString()) : "/vendor/directFulfillment/orders/2021-12-28/purchaseOrders/{purchaseOrderNumber}".replaceAll("\\{purchaseOrderNumber\\}", this.apiClient.escapeString(purchaseOrderNumber.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, progressRequestListener);
    }

    private Call getOrderValidateBeforeCall(String purchaseOrderNumber, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        if (purchaseOrderNumber == null) {
            throw new ApiException("Missing the required parameter 'purchaseOrderNumber' when calling getOrder(Async)");
        }
        return this.getOrderCall(purchaseOrderNumber, progressRequestListener);
    }

    public Order getOrder(String purchaseOrderNumber, String restrictedDataToken) throws ApiException, LWAException {
        ApiResponse<Order> resp = this.getOrderWithHttpInfo(purchaseOrderNumber, restrictedDataToken);
        return resp.getData();
    }

    public Order getOrder(String purchaseOrderNumber) throws ApiException, LWAException {
        ApiResponse<Order> resp = this.getOrderWithHttpInfo(purchaseOrderNumber, null);
        return resp.getData();
    }

    public ApiResponse<Order> getOrderWithHttpInfo(String purchaseOrderNumber, String restrictedDataToken) throws ApiException, LWAException {
        Call call = this.getOrderValidateBeforeCall(purchaseOrderNumber, null);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "VendorOrdersApi-getOrder");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.getOrderBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<Order>(){}.getType();
            return this.apiClient.execute(call, localVarReturnType);
        }
        throw new ApiException.RateLimitExceeded("getOrder operation exceeds rate limit");
    }

    public ApiResponse<Order> getOrderWithHttpInfo(String purchaseOrderNumber) throws ApiException, LWAException {
        return this.getOrderWithHttpInfo(purchaseOrderNumber, null);
    }

    public Call getOrderAsync(String purchaseOrderNumber, ApiCallback<Order> callback) throws ApiException, LWAException {
        return this.getOrderAsync(purchaseOrderNumber, callback, null);
    }

    public Call getOrderAsync(String purchaseOrderNumber, ApiCallback<Order> callback, String restrictedDataToken) throws ApiException, LWAException {
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressRequestListener = callback::onUploadProgress;
        }
        Call call = this.getOrderValidateBeforeCall(purchaseOrderNumber, progressRequestListener);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "VendorOrdersApi-getOrder");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.getOrderBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<Order>(){}.getType();
            this.apiClient.executeAsync(call, localVarReturnType, callback);
            return call;
        }
        throw new ApiException.RateLimitExceeded("getOrder operation exceeds rate limit");
    }

    private Call getOrdersCall(OffsetDateTime createdAfter, OffsetDateTime createdBefore, String shipFromPartyId, String status, Long limit, String sortOrder, String nextToken, String includeDetails, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        Object localVarPostBody = null;
        String localVarPath = "/vendor/directFulfillment/orders/2021-12-28/purchaseOrders".equals("/uploads/2020-11-01/uploadDestinations/{resource}") ? "/vendor/directFulfillment/orders/2021-12-28/purchaseOrders" : "/vendor/directFulfillment/orders/2021-12-28/purchaseOrders";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (shipFromPartyId != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("shipFromPartyId", shipFromPartyId));
        }
        if (status != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("status", status));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("limit", limit));
        }
        if (createdAfter != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("createdAfter", createdAfter));
        }
        if (createdBefore != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("createdBefore", createdBefore));
        }
        if (sortOrder != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("sortOrder", sortOrder));
        }
        if (nextToken != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("nextToken", nextToken));
        }
        if (includeDetails != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("includeDetails", includeDetails));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "pagination", "orders"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, progressRequestListener);
    }

    private Call getOrdersValidateBeforeCall(OffsetDateTime createdAfter, OffsetDateTime createdBefore, String shipFromPartyId, String status, Long limit, String sortOrder, String nextToken, String includeDetails, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        if (createdAfter == null) {
            throw new ApiException("Missing the required parameter 'createdAfter' when calling getOrders(Async)");
        }
        if (createdBefore == null) {
            throw new ApiException("Missing the required parameter 'createdBefore' when calling getOrders(Async)");
        }
        return this.getOrdersCall(createdAfter, createdBefore, shipFromPartyId, status, limit, sortOrder, nextToken, includeDetails, progressRequestListener);
    }

    public OrderList getOrders(OffsetDateTime createdAfter, OffsetDateTime createdBefore, String shipFromPartyId, String status, Long limit, String sortOrder, String nextToken, String includeDetails, String restrictedDataToken) throws ApiException, LWAException {
        ApiResponse<OrderList> resp = this.getOrdersWithHttpInfo(createdAfter, createdBefore, shipFromPartyId, status, limit, sortOrder, nextToken, includeDetails, restrictedDataToken);
        return resp.getData();
    }

    public OrderList getOrders(OffsetDateTime createdAfter, OffsetDateTime createdBefore, String shipFromPartyId, String status, Long limit, String sortOrder, String nextToken, String includeDetails) throws ApiException, LWAException {
        ApiResponse<OrderList> resp = this.getOrdersWithHttpInfo(createdAfter, createdBefore, shipFromPartyId, status, limit, sortOrder, nextToken, includeDetails, null);
        return resp.getData();
    }

    public ApiResponse<OrderList> getOrdersWithHttpInfo(OffsetDateTime createdAfter, OffsetDateTime createdBefore, String shipFromPartyId, String status, Long limit, String sortOrder, String nextToken, String includeDetails, String restrictedDataToken) throws ApiException, LWAException {
        Call call = this.getOrdersValidateBeforeCall(createdAfter, createdBefore, shipFromPartyId, status, limit, sortOrder, nextToken, includeDetails, null);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "VendorOrdersApi-getOrders");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.getOrdersBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<OrderList>(){}.getType();
            return this.apiClient.execute(call, localVarReturnType);
        }
        throw new ApiException.RateLimitExceeded("getOrders operation exceeds rate limit");
    }

    public ApiResponse<OrderList> getOrdersWithHttpInfo(OffsetDateTime createdAfter, OffsetDateTime createdBefore, String shipFromPartyId, String status, Long limit, String sortOrder, String nextToken, String includeDetails) throws ApiException, LWAException {
        return this.getOrdersWithHttpInfo(createdAfter, createdBefore, shipFromPartyId, status, limit, sortOrder, nextToken, includeDetails, null);
    }

    public Call getOrdersAsync(OffsetDateTime createdAfter, OffsetDateTime createdBefore, String shipFromPartyId, String status, Long limit, String sortOrder, String nextToken, String includeDetails, ApiCallback<OrderList> callback) throws ApiException, LWAException {
        return this.getOrdersAsync(createdAfter, createdBefore, shipFromPartyId, status, limit, sortOrder, nextToken, includeDetails, callback, null);
    }

    public Call getOrdersAsync(OffsetDateTime createdAfter, OffsetDateTime createdBefore, String shipFromPartyId, String status, Long limit, String sortOrder, String nextToken, String includeDetails, ApiCallback<OrderList> callback, String restrictedDataToken) throws ApiException, LWAException {
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressRequestListener = callback::onUploadProgress;
        }
        Call call = this.getOrdersValidateBeforeCall(createdAfter, createdBefore, shipFromPartyId, status, limit, sortOrder, nextToken, includeDetails, progressRequestListener);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "VendorOrdersApi-getOrders");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.getOrdersBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<OrderList>(){}.getType();
            this.apiClient.executeAsync(call, localVarReturnType, callback);
            return call;
        }
        throw new ApiException.RateLimitExceeded("getOrders operation exceeds rate limit");
    }

    private Call submitAcknowledgementCall(SubmitAcknowledgementRequest body, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        SubmitAcknowledgementRequest localVarPostBody = body;
        String localVarPath = "/vendor/directFulfillment/orders/2021-12-28/acknowledgements".equals("/uploads/2020-11-01/uploadDestinations/{resource}") ? "/vendor/directFulfillment/orders/2021-12-28/acknowledgements" : "/vendor/directFulfillment/orders/2021-12-28/acknowledgements";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, progressRequestListener);
    }

    private Call submitAcknowledgementValidateBeforeCall(SubmitAcknowledgementRequest body, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling submitAcknowledgement(Async)");
        }
        return this.submitAcknowledgementCall(body, progressRequestListener);
    }

    public TransactionId submitAcknowledgement(SubmitAcknowledgementRequest body, String restrictedDataToken) throws ApiException, LWAException {
        ApiResponse<TransactionId> resp = this.submitAcknowledgementWithHttpInfo(body, restrictedDataToken);
        return resp.getData();
    }

    public TransactionId submitAcknowledgement(SubmitAcknowledgementRequest body) throws ApiException, LWAException {
        ApiResponse<TransactionId> resp = this.submitAcknowledgementWithHttpInfo(body, null);
        return resp.getData();
    }

    public ApiResponse<TransactionId> submitAcknowledgementWithHttpInfo(SubmitAcknowledgementRequest body, String restrictedDataToken) throws ApiException, LWAException {
        Call call = this.submitAcknowledgementValidateBeforeCall(body, null);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "VendorOrdersApi-submitAcknowledgement");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.submitAcknowledgementBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<TransactionId>(){}.getType();
            return this.apiClient.execute(call, localVarReturnType);
        }
        throw new ApiException.RateLimitExceeded("submitAcknowledgement operation exceeds rate limit");
    }

    public ApiResponse<TransactionId> submitAcknowledgementWithHttpInfo(SubmitAcknowledgementRequest body) throws ApiException, LWAException {
        return this.submitAcknowledgementWithHttpInfo(body, null);
    }

    public Call submitAcknowledgementAsync(SubmitAcknowledgementRequest body, ApiCallback<TransactionId> callback) throws ApiException, LWAException {
        return this.submitAcknowledgementAsync(body, callback, null);
    }

    public Call submitAcknowledgementAsync(SubmitAcknowledgementRequest body, ApiCallback<TransactionId> callback, String restrictedDataToken) throws ApiException, LWAException {
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressRequestListener = callback::onUploadProgress;
        }
        Call call = this.submitAcknowledgementValidateBeforeCall(body, progressRequestListener);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "VendorOrdersApi-submitAcknowledgement");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.submitAcknowledgementBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<TransactionId>(){}.getType();
            this.apiClient.executeAsync(call, localVarReturnType, callback);
            return call;
        }
        throw new ApiException.RateLimitExceeded("submitAcknowledgement operation exceeds rate limit");
    }

    public static class Builder {
        private LWAAuthorizationCredentials lwaAuthorizationCredentials;
        private String endpoint;
        private LWAAccessTokenCache lwaAccessTokenCache;
        private Boolean disableAccessTokenCache = false;
        private Boolean disableRateLimiting = false;

        public Builder lwaAuthorizationCredentials(LWAAuthorizationCredentials lwaAuthorizationCredentials) {
            this.lwaAuthorizationCredentials = lwaAuthorizationCredentials;
            return this;
        }

        public Builder endpoint(String endpoint) {
            this.endpoint = endpoint;
            return this;
        }

        public Builder lwaAccessTokenCache(LWAAccessTokenCache lwaAccessTokenCache) {
            this.lwaAccessTokenCache = lwaAccessTokenCache;
            return this;
        }

        public Builder disableAccessTokenCache() {
            this.disableAccessTokenCache = true;
            return this;
        }

        public Builder disableRateLimiting() {
            this.disableRateLimiting = true;
            return this;
        }

        public VendorOrdersApi build() {
            if (this.lwaAuthorizationCredentials == null) {
                throw new RuntimeException("LWAAuthorizationCredentials not set");
            }
            if (StringUtil.isEmpty(this.endpoint)) {
                throw new RuntimeException("Endpoint not set");
            }
            LWAAuthorizationSigner lwaAuthorizationSigner = null;
            if (this.disableAccessTokenCache.booleanValue()) {
                lwaAuthorizationSigner = new LWAAuthorizationSigner(this.lwaAuthorizationCredentials);
            } else {
                if (this.lwaAccessTokenCache == null) {
                    this.lwaAccessTokenCache = new LWAAccessTokenCacheImpl();
                }
                lwaAuthorizationSigner = new LWAAuthorizationSigner(this.lwaAuthorizationCredentials, this.lwaAccessTokenCache);
            }
            return new VendorOrdersApi(new ApiClient().setLWAAuthorizationSigner(lwaAuthorizationSigner).setBasePath(this.endpoint), this.disableRateLimiting);
        }
    }
}

