/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.api.vehicles.v2024_11_01;

import com.amazon.SellingPartnerAPIAA.LWAAccessTokenCache;
import com.amazon.SellingPartnerAPIAA.LWAAccessTokenCacheImpl;
import com.amazon.SellingPartnerAPIAA.LWAAuthorizationCredentials;
import com.amazon.SellingPartnerAPIAA.LWAAuthorizationSigner;
import com.amazon.SellingPartnerAPIAA.LWAException;
import com.amazon.SellingPartnerAPIAA.RestrictedDataTokenSigner;
import com.google.gson.reflect.TypeToken;
import io.github.bucket4j.Bucket;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import okhttp3.Call;
import okhttp3.Request;
import software.amazon.spapi.ApiCallback;
import software.amazon.spapi.ApiClient;
import software.amazon.spapi.ApiException;
import software.amazon.spapi.ApiResponse;
import software.amazon.spapi.Configuration;
import software.amazon.spapi.Pair;
import software.amazon.spapi.ProgressRequestBody;
import software.amazon.spapi.StringUtil;
import software.amazon.spapi.models.vehicles.v2024_11_01.VehiclesResponse;

public class VehiclesApi {
    private ApiClient apiClient;
    private Boolean disableRateLimiting;
    private final Configuration config = Configuration.get();
    public final Bucket getVehiclesBucket = Bucket.builder().addLimit(this.config.getLimit("VehiclesApi-getVehicles")).build();

    public VehiclesApi(ApiClient apiClient, Boolean disableRateLimiting) {
        this.apiClient = apiClient;
        this.disableRateLimiting = disableRateLimiting;
    }

    private Call getVehiclesCall(String marketplaceId, String vehicleType, String pageToken, String updatedAfter, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        Object localVarPostBody = null;
        String localVarPath = "/catalog/2024-11-01/automotive/vehicles".equals("/uploads/2020-11-01/uploadDestinations/{resource}") ? "/catalog/2024-11-01/automotive/vehicles" : "/catalog/2024-11-01/automotive/vehicles";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (pageToken != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("pageToken", pageToken));
        }
        if (marketplaceId != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("marketplaceId", marketplaceId));
        }
        if (vehicleType != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("vehicleType", vehicleType));
        }
        if (updatedAfter != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("updatedAfter", updatedAfter));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, progressRequestListener);
    }

    private Call getVehiclesValidateBeforeCall(String marketplaceId, String vehicleType, String pageToken, String updatedAfter, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        if (marketplaceId == null) {
            throw new ApiException("Missing the required parameter 'marketplaceId' when calling getVehicles(Async)");
        }
        if (vehicleType == null) {
            throw new ApiException("Missing the required parameter 'vehicleType' when calling getVehicles(Async)");
        }
        return this.getVehiclesCall(marketplaceId, vehicleType, pageToken, updatedAfter, progressRequestListener);
    }

    public VehiclesResponse getVehicles(String marketplaceId, String vehicleType, String pageToken, String updatedAfter, String restrictedDataToken) throws ApiException, LWAException {
        ApiResponse<VehiclesResponse> resp = this.getVehiclesWithHttpInfo(marketplaceId, vehicleType, pageToken, updatedAfter, restrictedDataToken);
        return resp.getData();
    }

    public VehiclesResponse getVehicles(String marketplaceId, String vehicleType, String pageToken, String updatedAfter) throws ApiException, LWAException {
        ApiResponse<VehiclesResponse> resp = this.getVehiclesWithHttpInfo(marketplaceId, vehicleType, pageToken, updatedAfter, null);
        return resp.getData();
    }

    public ApiResponse<VehiclesResponse> getVehiclesWithHttpInfo(String marketplaceId, String vehicleType, String pageToken, String updatedAfter, String restrictedDataToken) throws ApiException, LWAException {
        Call call = this.getVehiclesValidateBeforeCall(marketplaceId, vehicleType, pageToken, updatedAfter, null);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "VehiclesApi-getVehicles");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.getVehiclesBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<VehiclesResponse>(){}.getType();
            return this.apiClient.execute(call, localVarReturnType);
        }
        throw new ApiException.RateLimitExceeded("getVehicles operation exceeds rate limit");
    }

    public ApiResponse<VehiclesResponse> getVehiclesWithHttpInfo(String marketplaceId, String vehicleType, String pageToken, String updatedAfter) throws ApiException, LWAException {
        return this.getVehiclesWithHttpInfo(marketplaceId, vehicleType, pageToken, updatedAfter, null);
    }

    public Call getVehiclesAsync(String marketplaceId, String vehicleType, String pageToken, String updatedAfter, ApiCallback<VehiclesResponse> callback) throws ApiException, LWAException {
        return this.getVehiclesAsync(marketplaceId, vehicleType, pageToken, updatedAfter, callback, null);
    }

    public Call getVehiclesAsync(String marketplaceId, String vehicleType, String pageToken, String updatedAfter, ApiCallback<VehiclesResponse> callback, String restrictedDataToken) throws ApiException, LWAException {
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressRequestListener = callback::onUploadProgress;
        }
        Call call = this.getVehiclesValidateBeforeCall(marketplaceId, vehicleType, pageToken, updatedAfter, progressRequestListener);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "VehiclesApi-getVehicles");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.getVehiclesBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<VehiclesResponse>(){}.getType();
            this.apiClient.executeAsync(call, localVarReturnType, callback);
            return call;
        }
        throw new ApiException.RateLimitExceeded("getVehicles operation exceeds rate limit");
    }

    public static class Builder {
        private LWAAuthorizationCredentials lwaAuthorizationCredentials;
        private String endpoint;
        private LWAAccessTokenCache lwaAccessTokenCache;
        private Boolean disableAccessTokenCache = false;
        private Boolean disableRateLimiting = false;

        public Builder lwaAuthorizationCredentials(LWAAuthorizationCredentials lwaAuthorizationCredentials) {
            this.lwaAuthorizationCredentials = lwaAuthorizationCredentials;
            return this;
        }

        public Builder endpoint(String endpoint) {
            this.endpoint = endpoint;
            return this;
        }

        public Builder lwaAccessTokenCache(LWAAccessTokenCache lwaAccessTokenCache) {
            this.lwaAccessTokenCache = lwaAccessTokenCache;
            return this;
        }

        public Builder disableAccessTokenCache() {
            this.disableAccessTokenCache = true;
            return this;
        }

        public Builder disableRateLimiting() {
            this.disableRateLimiting = true;
            return this;
        }

        public VehiclesApi build() {
            if (this.lwaAuthorizationCredentials == null) {
                throw new RuntimeException("LWAAuthorizationCredentials not set");
            }
            if (StringUtil.isEmpty(this.endpoint)) {
                throw new RuntimeException("Endpoint not set");
            }
            LWAAuthorizationSigner lwaAuthorizationSigner = null;
            if (this.disableAccessTokenCache.booleanValue()) {
                lwaAuthorizationSigner = new LWAAuthorizationSigner(this.lwaAuthorizationCredentials);
            } else {
                if (this.lwaAccessTokenCache == null) {
                    this.lwaAccessTokenCache = new LWAAccessTokenCacheImpl();
                }
                lwaAuthorizationSigner = new LWAAuthorizationSigner(this.lwaAuthorizationCredentials, this.lwaAccessTokenCache);
            }
            return new VehiclesApi(new ApiClient().setLWAAuthorizationSigner(lwaAuthorizationSigner).setBasePath(this.endpoint), this.disableRateLimiting);
        }
    }
}

