/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.api.tokens.v2021_03_01;

import com.amazon.SellingPartnerAPIAA.LWAAccessTokenCache;
import com.amazon.SellingPartnerAPIAA.LWAAccessTokenCacheImpl;
import com.amazon.SellingPartnerAPIAA.LWAAuthorizationCredentials;
import com.amazon.SellingPartnerAPIAA.LWAAuthorizationSigner;
import com.amazon.SellingPartnerAPIAA.LWAException;
import com.amazon.SellingPartnerAPIAA.RestrictedDataTokenSigner;
import com.google.gson.reflect.TypeToken;
import io.github.bucket4j.Bucket;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import okhttp3.Call;
import okhttp3.Request;
import software.amazon.spapi.ApiCallback;
import software.amazon.spapi.ApiClient;
import software.amazon.spapi.ApiException;
import software.amazon.spapi.ApiResponse;
import software.amazon.spapi.Configuration;
import software.amazon.spapi.Pair;
import software.amazon.spapi.ProgressRequestBody;
import software.amazon.spapi.StringUtil;
import software.amazon.spapi.models.tokens.v2021_03_01.CreateRestrictedDataTokenRequest;
import software.amazon.spapi.models.tokens.v2021_03_01.CreateRestrictedDataTokenResponse;

public class TokensApi {
    private ApiClient apiClient;
    private Boolean disableRateLimiting;
    private final Configuration config = Configuration.get();
    public final Bucket createRestrictedDataTokenBucket = Bucket.builder().addLimit(this.config.getLimit("TokensApi-createRestrictedDataToken")).build();

    public TokensApi(ApiClient apiClient, Boolean disableRateLimiting) {
        this.apiClient = apiClient;
        this.disableRateLimiting = disableRateLimiting;
    }

    private Call createRestrictedDataTokenCall(CreateRestrictedDataTokenRequest body, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        CreateRestrictedDataTokenRequest localVarPostBody = body;
        String localVarPath = "/tokens/2021-03-01/restrictedDataToken".equals("/uploads/2020-11-01/uploadDestinations/{resource}") ? "/tokens/2021-03-01/restrictedDataToken" : "/tokens/2021-03-01/restrictedDataToken";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, progressRequestListener);
    }

    private Call createRestrictedDataTokenValidateBeforeCall(CreateRestrictedDataTokenRequest body, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling createRestrictedDataToken(Async)");
        }
        return this.createRestrictedDataTokenCall(body, progressRequestListener);
    }

    public CreateRestrictedDataTokenResponse createRestrictedDataToken(CreateRestrictedDataTokenRequest body, String restrictedDataToken) throws ApiException, LWAException {
        ApiResponse<CreateRestrictedDataTokenResponse> resp = this.createRestrictedDataTokenWithHttpInfo(body, restrictedDataToken);
        return resp.getData();
    }

    public CreateRestrictedDataTokenResponse createRestrictedDataToken(CreateRestrictedDataTokenRequest body) throws ApiException, LWAException {
        ApiResponse<CreateRestrictedDataTokenResponse> resp = this.createRestrictedDataTokenWithHttpInfo(body, null);
        return resp.getData();
    }

    public ApiResponse<CreateRestrictedDataTokenResponse> createRestrictedDataTokenWithHttpInfo(CreateRestrictedDataTokenRequest body, String restrictedDataToken) throws ApiException, LWAException {
        Call call = this.createRestrictedDataTokenValidateBeforeCall(body, null);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "TokensApi-createRestrictedDataToken");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.createRestrictedDataTokenBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<CreateRestrictedDataTokenResponse>(){}.getType();
            return this.apiClient.execute(call, localVarReturnType);
        }
        throw new ApiException.RateLimitExceeded("createRestrictedDataToken operation exceeds rate limit");
    }

    public ApiResponse<CreateRestrictedDataTokenResponse> createRestrictedDataTokenWithHttpInfo(CreateRestrictedDataTokenRequest body) throws ApiException, LWAException {
        return this.createRestrictedDataTokenWithHttpInfo(body, null);
    }

    public Call createRestrictedDataTokenAsync(CreateRestrictedDataTokenRequest body, ApiCallback<CreateRestrictedDataTokenResponse> callback) throws ApiException, LWAException {
        return this.createRestrictedDataTokenAsync(body, callback, null);
    }

    public Call createRestrictedDataTokenAsync(CreateRestrictedDataTokenRequest body, ApiCallback<CreateRestrictedDataTokenResponse> callback, String restrictedDataToken) throws ApiException, LWAException {
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressRequestListener = callback::onUploadProgress;
        }
        Call call = this.createRestrictedDataTokenValidateBeforeCall(body, progressRequestListener);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "TokensApi-createRestrictedDataToken");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.createRestrictedDataTokenBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<CreateRestrictedDataTokenResponse>(){}.getType();
            this.apiClient.executeAsync(call, localVarReturnType, callback);
            return call;
        }
        throw new ApiException.RateLimitExceeded("createRestrictedDataToken operation exceeds rate limit");
    }

    public static class Builder {
        private LWAAuthorizationCredentials lwaAuthorizationCredentials;
        private String endpoint;
        private LWAAccessTokenCache lwaAccessTokenCache;
        private Boolean disableAccessTokenCache = false;
        private Boolean disableRateLimiting = false;

        public Builder lwaAuthorizationCredentials(LWAAuthorizationCredentials lwaAuthorizationCredentials) {
            this.lwaAuthorizationCredentials = lwaAuthorizationCredentials;
            return this;
        }

        public Builder endpoint(String endpoint) {
            this.endpoint = endpoint;
            return this;
        }

        public Builder lwaAccessTokenCache(LWAAccessTokenCache lwaAccessTokenCache) {
            this.lwaAccessTokenCache = lwaAccessTokenCache;
            return this;
        }

        public Builder disableAccessTokenCache() {
            this.disableAccessTokenCache = true;
            return this;
        }

        public Builder disableRateLimiting() {
            this.disableRateLimiting = true;
            return this;
        }

        public TokensApi build() {
            if (this.lwaAuthorizationCredentials == null) {
                throw new RuntimeException("LWAAuthorizationCredentials not set");
            }
            if (StringUtil.isEmpty(this.endpoint)) {
                throw new RuntimeException("Endpoint not set");
            }
            LWAAuthorizationSigner lwaAuthorizationSigner = null;
            if (this.disableAccessTokenCache.booleanValue()) {
                lwaAuthorizationSigner = new LWAAuthorizationSigner(this.lwaAuthorizationCredentials);
            } else {
                if (this.lwaAccessTokenCache == null) {
                    this.lwaAccessTokenCache = new LWAAccessTokenCacheImpl();
                }
                lwaAuthorizationSigner = new LWAAuthorizationSigner(this.lwaAuthorizationCredentials, this.lwaAccessTokenCache);
            }
            return new TokensApi(new ApiClient().setLWAAuthorizationSigner(lwaAuthorizationSigner).setBasePath(this.endpoint), this.disableRateLimiting);
        }
    }
}

