/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.api.solicitations.v1;

import com.amazon.SellingPartnerAPIAA.LWAAccessTokenCache;
import com.amazon.SellingPartnerAPIAA.LWAAccessTokenCacheImpl;
import com.amazon.SellingPartnerAPIAA.LWAAuthorizationCredentials;
import com.amazon.SellingPartnerAPIAA.LWAAuthorizationSigner;
import com.amazon.SellingPartnerAPIAA.LWAException;
import com.amazon.SellingPartnerAPIAA.RestrictedDataTokenSigner;
import com.google.gson.reflect.TypeToken;
import io.github.bucket4j.Bucket;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import okhttp3.Call;
import okhttp3.Request;
import software.amazon.spapi.ApiCallback;
import software.amazon.spapi.ApiClient;
import software.amazon.spapi.ApiException;
import software.amazon.spapi.ApiResponse;
import software.amazon.spapi.Configuration;
import software.amazon.spapi.Pair;
import software.amazon.spapi.ProgressRequestBody;
import software.amazon.spapi.StringUtil;
import software.amazon.spapi.models.solicitations.v1.CreateProductReviewAndSellerFeedbackSolicitationResponse;
import software.amazon.spapi.models.solicitations.v1.GetSolicitationActionsForOrderResponse;

public class SolicitationsApi {
    private ApiClient apiClient;
    private Boolean disableRateLimiting;
    private final Configuration config = Configuration.get();
    public final Bucket createProductReviewAndSellerFeedbackSolicitationBucket = Bucket.builder().addLimit(this.config.getLimit("SolicitationsApi-createProductReviewAndSellerFeedbackSolicitation")).build();
    public final Bucket getSolicitationActionsForOrderBucket = Bucket.builder().addLimit(this.config.getLimit("SolicitationsApi-getSolicitationActionsForOrder")).build();

    public SolicitationsApi(ApiClient apiClient, Boolean disableRateLimiting) {
        this.apiClient = apiClient;
        this.disableRateLimiting = disableRateLimiting;
    }

    private Call createProductReviewAndSellerFeedbackSolicitationCall(String amazonOrderId, List<String> marketplaceIds, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        Object localVarPostBody = null;
        String localVarPath = "/solicitations/v1/orders/{amazonOrderId}/solicitations/productReviewAndSellerFeedback".equals("/uploads/2020-11-01/uploadDestinations/{resource}") ? "/solicitations/v1/orders/{amazonOrderId}/solicitations/productReviewAndSellerFeedback".replaceAll("\\{amazonOrderId\\}", amazonOrderId.toString()) : "/solicitations/v1/orders/{amazonOrderId}/solicitations/productReviewAndSellerFeedback".replaceAll("\\{amazonOrderId\\}", this.apiClient.escapeString(amazonOrderId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (marketplaceIds != null) {
            localVarCollectionQueryParams.addAll(this.apiClient.parameterToPairs("csv", "marketplaceIds", marketplaceIds));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/hal+json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, progressRequestListener);
    }

    private Call createProductReviewAndSellerFeedbackSolicitationValidateBeforeCall(String amazonOrderId, List<String> marketplaceIds, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        if (amazonOrderId == null) {
            throw new ApiException("Missing the required parameter 'amazonOrderId' when calling createProductReviewAndSellerFeedbackSolicitation(Async)");
        }
        if (marketplaceIds == null) {
            throw new ApiException("Missing the required parameter 'marketplaceIds' when calling createProductReviewAndSellerFeedbackSolicitation(Async)");
        }
        return this.createProductReviewAndSellerFeedbackSolicitationCall(amazonOrderId, marketplaceIds, progressRequestListener);
    }

    public CreateProductReviewAndSellerFeedbackSolicitationResponse createProductReviewAndSellerFeedbackSolicitation(String amazonOrderId, List<String> marketplaceIds, String restrictedDataToken) throws ApiException, LWAException {
        ApiResponse<CreateProductReviewAndSellerFeedbackSolicitationResponse> resp = this.createProductReviewAndSellerFeedbackSolicitationWithHttpInfo(amazonOrderId, marketplaceIds, restrictedDataToken);
        return resp.getData();
    }

    public CreateProductReviewAndSellerFeedbackSolicitationResponse createProductReviewAndSellerFeedbackSolicitation(String amazonOrderId, List<String> marketplaceIds) throws ApiException, LWAException {
        ApiResponse<CreateProductReviewAndSellerFeedbackSolicitationResponse> resp = this.createProductReviewAndSellerFeedbackSolicitationWithHttpInfo(amazonOrderId, marketplaceIds, null);
        return resp.getData();
    }

    public ApiResponse<CreateProductReviewAndSellerFeedbackSolicitationResponse> createProductReviewAndSellerFeedbackSolicitationWithHttpInfo(String amazonOrderId, List<String> marketplaceIds, String restrictedDataToken) throws ApiException, LWAException {
        Call call = this.createProductReviewAndSellerFeedbackSolicitationValidateBeforeCall(amazonOrderId, marketplaceIds, null);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "SolicitationsApi-createProductReviewAndSellerFeedbackSolicitation");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.createProductReviewAndSellerFeedbackSolicitationBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<CreateProductReviewAndSellerFeedbackSolicitationResponse>(){}.getType();
            return this.apiClient.execute(call, localVarReturnType);
        }
        throw new ApiException.RateLimitExceeded("createProductReviewAndSellerFeedbackSolicitation operation exceeds rate limit");
    }

    public ApiResponse<CreateProductReviewAndSellerFeedbackSolicitationResponse> createProductReviewAndSellerFeedbackSolicitationWithHttpInfo(String amazonOrderId, List<String> marketplaceIds) throws ApiException, LWAException {
        return this.createProductReviewAndSellerFeedbackSolicitationWithHttpInfo(amazonOrderId, marketplaceIds, null);
    }

    public Call createProductReviewAndSellerFeedbackSolicitationAsync(String amazonOrderId, List<String> marketplaceIds, ApiCallback<CreateProductReviewAndSellerFeedbackSolicitationResponse> callback) throws ApiException, LWAException {
        return this.createProductReviewAndSellerFeedbackSolicitationAsync(amazonOrderId, marketplaceIds, callback, null);
    }

    public Call createProductReviewAndSellerFeedbackSolicitationAsync(String amazonOrderId, List<String> marketplaceIds, ApiCallback<CreateProductReviewAndSellerFeedbackSolicitationResponse> callback, String restrictedDataToken) throws ApiException, LWAException {
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressRequestListener = callback::onUploadProgress;
        }
        Call call = this.createProductReviewAndSellerFeedbackSolicitationValidateBeforeCall(amazonOrderId, marketplaceIds, progressRequestListener);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "SolicitationsApi-createProductReviewAndSellerFeedbackSolicitation");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.createProductReviewAndSellerFeedbackSolicitationBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<CreateProductReviewAndSellerFeedbackSolicitationResponse>(){}.getType();
            this.apiClient.executeAsync(call, localVarReturnType, callback);
            return call;
        }
        throw new ApiException.RateLimitExceeded("createProductReviewAndSellerFeedbackSolicitation operation exceeds rate limit");
    }

    private Call getSolicitationActionsForOrderCall(String amazonOrderId, List<String> marketplaceIds, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        Object localVarPostBody = null;
        String localVarPath = "/solicitations/v1/orders/{amazonOrderId}".equals("/uploads/2020-11-01/uploadDestinations/{resource}") ? "/solicitations/v1/orders/{amazonOrderId}".replaceAll("\\{amazonOrderId\\}", amazonOrderId.toString()) : "/solicitations/v1/orders/{amazonOrderId}".replaceAll("\\{amazonOrderId\\}", this.apiClient.escapeString(amazonOrderId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (marketplaceIds != null) {
            localVarCollectionQueryParams.addAll(this.apiClient.parameterToPairs("csv", "marketplaceIds", marketplaceIds));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/hal+json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, progressRequestListener);
    }

    private Call getSolicitationActionsForOrderValidateBeforeCall(String amazonOrderId, List<String> marketplaceIds, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        if (amazonOrderId == null) {
            throw new ApiException("Missing the required parameter 'amazonOrderId' when calling getSolicitationActionsForOrder(Async)");
        }
        if (marketplaceIds == null) {
            throw new ApiException("Missing the required parameter 'marketplaceIds' when calling getSolicitationActionsForOrder(Async)");
        }
        return this.getSolicitationActionsForOrderCall(amazonOrderId, marketplaceIds, progressRequestListener);
    }

    public GetSolicitationActionsForOrderResponse getSolicitationActionsForOrder(String amazonOrderId, List<String> marketplaceIds, String restrictedDataToken) throws ApiException, LWAException {
        ApiResponse<GetSolicitationActionsForOrderResponse> resp = this.getSolicitationActionsForOrderWithHttpInfo(amazonOrderId, marketplaceIds, restrictedDataToken);
        return resp.getData();
    }

    public GetSolicitationActionsForOrderResponse getSolicitationActionsForOrder(String amazonOrderId, List<String> marketplaceIds) throws ApiException, LWAException {
        ApiResponse<GetSolicitationActionsForOrderResponse> resp = this.getSolicitationActionsForOrderWithHttpInfo(amazonOrderId, marketplaceIds, null);
        return resp.getData();
    }

    public ApiResponse<GetSolicitationActionsForOrderResponse> getSolicitationActionsForOrderWithHttpInfo(String amazonOrderId, List<String> marketplaceIds, String restrictedDataToken) throws ApiException, LWAException {
        Call call = this.getSolicitationActionsForOrderValidateBeforeCall(amazonOrderId, marketplaceIds, null);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "SolicitationsApi-getSolicitationActionsForOrder");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.getSolicitationActionsForOrderBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<GetSolicitationActionsForOrderResponse>(){}.getType();
            return this.apiClient.execute(call, localVarReturnType);
        }
        throw new ApiException.RateLimitExceeded("getSolicitationActionsForOrder operation exceeds rate limit");
    }

    public ApiResponse<GetSolicitationActionsForOrderResponse> getSolicitationActionsForOrderWithHttpInfo(String amazonOrderId, List<String> marketplaceIds) throws ApiException, LWAException {
        return this.getSolicitationActionsForOrderWithHttpInfo(amazonOrderId, marketplaceIds, null);
    }

    public Call getSolicitationActionsForOrderAsync(String amazonOrderId, List<String> marketplaceIds, ApiCallback<GetSolicitationActionsForOrderResponse> callback) throws ApiException, LWAException {
        return this.getSolicitationActionsForOrderAsync(amazonOrderId, marketplaceIds, callback, null);
    }

    public Call getSolicitationActionsForOrderAsync(String amazonOrderId, List<String> marketplaceIds, ApiCallback<GetSolicitationActionsForOrderResponse> callback, String restrictedDataToken) throws ApiException, LWAException {
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressRequestListener = callback::onUploadProgress;
        }
        Call call = this.getSolicitationActionsForOrderValidateBeforeCall(amazonOrderId, marketplaceIds, progressRequestListener);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "SolicitationsApi-getSolicitationActionsForOrder");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.getSolicitationActionsForOrderBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<GetSolicitationActionsForOrderResponse>(){}.getType();
            this.apiClient.executeAsync(call, localVarReturnType, callback);
            return call;
        }
        throw new ApiException.RateLimitExceeded("getSolicitationActionsForOrder operation exceeds rate limit");
    }

    public static class Builder {
        private LWAAuthorizationCredentials lwaAuthorizationCredentials;
        private String endpoint;
        private LWAAccessTokenCache lwaAccessTokenCache;
        private Boolean disableAccessTokenCache = false;
        private Boolean disableRateLimiting = false;

        public Builder lwaAuthorizationCredentials(LWAAuthorizationCredentials lwaAuthorizationCredentials) {
            this.lwaAuthorizationCredentials = lwaAuthorizationCredentials;
            return this;
        }

        public Builder endpoint(String endpoint) {
            this.endpoint = endpoint;
            return this;
        }

        public Builder lwaAccessTokenCache(LWAAccessTokenCache lwaAccessTokenCache) {
            this.lwaAccessTokenCache = lwaAccessTokenCache;
            return this;
        }

        public Builder disableAccessTokenCache() {
            this.disableAccessTokenCache = true;
            return this;
        }

        public Builder disableRateLimiting() {
            this.disableRateLimiting = true;
            return this;
        }

        public SolicitationsApi build() {
            if (this.lwaAuthorizationCredentials == null) {
                throw new RuntimeException("LWAAuthorizationCredentials not set");
            }
            if (StringUtil.isEmpty(this.endpoint)) {
                throw new RuntimeException("Endpoint not set");
            }
            LWAAuthorizationSigner lwaAuthorizationSigner = null;
            if (this.disableAccessTokenCache.booleanValue()) {
                lwaAuthorizationSigner = new LWAAuthorizationSigner(this.lwaAuthorizationCredentials);
            } else {
                if (this.lwaAccessTokenCache == null) {
                    this.lwaAccessTokenCache = new LWAAccessTokenCacheImpl();
                }
                lwaAuthorizationSigner = new LWAAuthorizationSigner(this.lwaAuthorizationCredentials, this.lwaAccessTokenCache);
            }
            return new SolicitationsApi(new ApiClient().setLWAAuthorizationSigner(lwaAuthorizationSigner).setBasePath(this.endpoint), this.disableRateLimiting);
        }
    }
}

