/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.api.services.v1;

import com.amazon.SellingPartnerAPIAA.LWAAccessTokenCache;
import com.amazon.SellingPartnerAPIAA.LWAAccessTokenCacheImpl;
import com.amazon.SellingPartnerAPIAA.LWAAuthorizationCredentials;
import com.amazon.SellingPartnerAPIAA.LWAAuthorizationSigner;
import com.amazon.SellingPartnerAPIAA.LWAException;
import com.amazon.SellingPartnerAPIAA.RestrictedDataTokenSigner;
import com.google.gson.reflect.TypeToken;
import io.github.bucket4j.Bucket;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import okhttp3.Call;
import okhttp3.Request;
import software.amazon.spapi.ApiCallback;
import software.amazon.spapi.ApiClient;
import software.amazon.spapi.ApiException;
import software.amazon.spapi.ApiResponse;
import software.amazon.spapi.Configuration;
import software.amazon.spapi.Pair;
import software.amazon.spapi.ProgressRequestBody;
import software.amazon.spapi.StringUtil;
import software.amazon.spapi.models.services.v1.AddAppointmentRequest;
import software.amazon.spapi.models.services.v1.AssignAppointmentResourcesRequest;
import software.amazon.spapi.models.services.v1.AssignAppointmentResourcesResponse;
import software.amazon.spapi.models.services.v1.CancelReservationResponse;
import software.amazon.spapi.models.services.v1.CancelServiceJobByServiceJobIdResponse;
import software.amazon.spapi.models.services.v1.CompleteServiceJobByServiceJobIdResponse;
import software.amazon.spapi.models.services.v1.CreateReservationRequest;
import software.amazon.spapi.models.services.v1.CreateReservationResponse;
import software.amazon.spapi.models.services.v1.CreateServiceDocumentUploadDestination;
import software.amazon.spapi.models.services.v1.FixedSlotCapacity;
import software.amazon.spapi.models.services.v1.FixedSlotCapacityQuery;
import software.amazon.spapi.models.services.v1.GetAppointmentSlotsResponse;
import software.amazon.spapi.models.services.v1.GetServiceJobByServiceJobIdResponse;
import software.amazon.spapi.models.services.v1.GetServiceJobsResponse;
import software.amazon.spapi.models.services.v1.RangeSlotCapacity;
import software.amazon.spapi.models.services.v1.RangeSlotCapacityQuery;
import software.amazon.spapi.models.services.v1.RescheduleAppointmentRequest;
import software.amazon.spapi.models.services.v1.ServiceUploadDocument;
import software.amazon.spapi.models.services.v1.SetAppointmentFulfillmentDataRequest;
import software.amazon.spapi.models.services.v1.SetAppointmentResponse;
import software.amazon.spapi.models.services.v1.UpdateReservationRequest;
import software.amazon.spapi.models.services.v1.UpdateReservationResponse;
import software.amazon.spapi.models.services.v1.UpdateScheduleRequest;
import software.amazon.spapi.models.services.v1.UpdateScheduleResponse;

public class ServiceApi {
    private ApiClient apiClient;
    private Boolean disableRateLimiting;
    private final Configuration config = Configuration.get();
    public final Bucket addAppointmentForServiceJobByServiceJobIdBucket = Bucket.builder().addLimit(this.config.getLimit("ServiceApi-addAppointmentForServiceJobByServiceJobId")).build();
    public final Bucket assignAppointmentResourcesBucket = Bucket.builder().addLimit(this.config.getLimit("ServiceApi-assignAppointmentResources")).build();
    public final Bucket cancelReservationBucket = Bucket.builder().addLimit(this.config.getLimit("ServiceApi-cancelReservation")).build();
    public final Bucket cancelServiceJobByServiceJobIdBucket = Bucket.builder().addLimit(this.config.getLimit("ServiceApi-cancelServiceJobByServiceJobId")).build();
    public final Bucket completeServiceJobByServiceJobIdBucket = Bucket.builder().addLimit(this.config.getLimit("ServiceApi-completeServiceJobByServiceJobId")).build();
    public final Bucket createReservationBucket = Bucket.builder().addLimit(this.config.getLimit("ServiceApi-createReservation")).build();
    public final Bucket createServiceDocumentUploadDestinationBucket = Bucket.builder().addLimit(this.config.getLimit("ServiceApi-createServiceDocumentUploadDestination")).build();
    public final Bucket getAppointmentSlotsBucket = Bucket.builder().addLimit(this.config.getLimit("ServiceApi-getAppointmentSlots")).build();
    public final Bucket getAppointmmentSlotsByJobIdBucket = Bucket.builder().addLimit(this.config.getLimit("ServiceApi-getAppointmmentSlotsByJobId")).build();
    public final Bucket getFixedSlotCapacityBucket = Bucket.builder().addLimit(this.config.getLimit("ServiceApi-getFixedSlotCapacity")).build();
    public final Bucket getRangeSlotCapacityBucket = Bucket.builder().addLimit(this.config.getLimit("ServiceApi-getRangeSlotCapacity")).build();
    public final Bucket getServiceJobByServiceJobIdBucket = Bucket.builder().addLimit(this.config.getLimit("ServiceApi-getServiceJobByServiceJobId")).build();
    public final Bucket getServiceJobsBucket = Bucket.builder().addLimit(this.config.getLimit("ServiceApi-getServiceJobs")).build();
    public final Bucket rescheduleAppointmentForServiceJobByServiceJobIdBucket = Bucket.builder().addLimit(this.config.getLimit("ServiceApi-rescheduleAppointmentForServiceJobByServiceJobId")).build();
    public final Bucket setAppointmentFulfillmentDataBucket = Bucket.builder().addLimit(this.config.getLimit("ServiceApi-setAppointmentFulfillmentData")).build();
    public final Bucket updateReservationBucket = Bucket.builder().addLimit(this.config.getLimit("ServiceApi-updateReservation")).build();
    public final Bucket updateScheduleBucket = Bucket.builder().addLimit(this.config.getLimit("ServiceApi-updateSchedule")).build();

    public ServiceApi(ApiClient apiClient, Boolean disableRateLimiting) {
        this.apiClient = apiClient;
        this.disableRateLimiting = disableRateLimiting;
    }

    private Call addAppointmentForServiceJobByServiceJobIdCall(AddAppointmentRequest body, String serviceJobId, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        AddAppointmentRequest localVarPostBody = body;
        String localVarPath = "/service/v1/serviceJobs/{serviceJobId}/appointments".equals("/uploads/2020-11-01/uploadDestinations/{resource}") ? "/service/v1/serviceJobs/{serviceJobId}/appointments".replaceAll("\\{serviceJobId\\}", serviceJobId.toString()) : "/service/v1/serviceJobs/{serviceJobId}/appointments".replaceAll("\\{serviceJobId\\}", this.apiClient.escapeString(serviceJobId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, progressRequestListener);
    }

    private Call addAppointmentForServiceJobByServiceJobIdValidateBeforeCall(AddAppointmentRequest body, String serviceJobId, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling addAppointmentForServiceJobByServiceJobId(Async)");
        }
        if (serviceJobId == null) {
            throw new ApiException("Missing the required parameter 'serviceJobId' when calling addAppointmentForServiceJobByServiceJobId(Async)");
        }
        return this.addAppointmentForServiceJobByServiceJobIdCall(body, serviceJobId, progressRequestListener);
    }

    public SetAppointmentResponse addAppointmentForServiceJobByServiceJobId(AddAppointmentRequest body, String serviceJobId, String restrictedDataToken) throws ApiException, LWAException {
        ApiResponse<SetAppointmentResponse> resp = this.addAppointmentForServiceJobByServiceJobIdWithHttpInfo(body, serviceJobId, restrictedDataToken);
        return resp.getData();
    }

    public SetAppointmentResponse addAppointmentForServiceJobByServiceJobId(AddAppointmentRequest body, String serviceJobId) throws ApiException, LWAException {
        ApiResponse<SetAppointmentResponse> resp = this.addAppointmentForServiceJobByServiceJobIdWithHttpInfo(body, serviceJobId, null);
        return resp.getData();
    }

    public ApiResponse<SetAppointmentResponse> addAppointmentForServiceJobByServiceJobIdWithHttpInfo(AddAppointmentRequest body, String serviceJobId, String restrictedDataToken) throws ApiException, LWAException {
        Call call = this.addAppointmentForServiceJobByServiceJobIdValidateBeforeCall(body, serviceJobId, null);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "ServiceApi-addAppointmentForServiceJobByServiceJobId");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.addAppointmentForServiceJobByServiceJobIdBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<SetAppointmentResponse>(){}.getType();
            return this.apiClient.execute(call, localVarReturnType);
        }
        throw new ApiException.RateLimitExceeded("addAppointmentForServiceJobByServiceJobId operation exceeds rate limit");
    }

    public ApiResponse<SetAppointmentResponse> addAppointmentForServiceJobByServiceJobIdWithHttpInfo(AddAppointmentRequest body, String serviceJobId) throws ApiException, LWAException {
        return this.addAppointmentForServiceJobByServiceJobIdWithHttpInfo(body, serviceJobId, null);
    }

    public Call addAppointmentForServiceJobByServiceJobIdAsync(AddAppointmentRequest body, String serviceJobId, ApiCallback<SetAppointmentResponse> callback) throws ApiException, LWAException {
        return this.addAppointmentForServiceJobByServiceJobIdAsync(body, serviceJobId, callback, null);
    }

    public Call addAppointmentForServiceJobByServiceJobIdAsync(AddAppointmentRequest body, String serviceJobId, ApiCallback<SetAppointmentResponse> callback, String restrictedDataToken) throws ApiException, LWAException {
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressRequestListener = callback::onUploadProgress;
        }
        Call call = this.addAppointmentForServiceJobByServiceJobIdValidateBeforeCall(body, serviceJobId, progressRequestListener);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "ServiceApi-addAppointmentForServiceJobByServiceJobId");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.addAppointmentForServiceJobByServiceJobIdBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<SetAppointmentResponse>(){}.getType();
            this.apiClient.executeAsync(call, localVarReturnType, callback);
            return call;
        }
        throw new ApiException.RateLimitExceeded("addAppointmentForServiceJobByServiceJobId operation exceeds rate limit");
    }

    private Call assignAppointmentResourcesCall(AssignAppointmentResourcesRequest body, String serviceJobId, String appointmentId, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        AssignAppointmentResourcesRequest localVarPostBody = body;
        String localVarPath = "/service/v1/serviceJobs/{serviceJobId}/appointments/{appointmentId}/resources".equals("/uploads/2020-11-01/uploadDestinations/{resource}") ? "/service/v1/serviceJobs/{serviceJobId}/appointments/{appointmentId}/resources".replaceAll("\\{serviceJobId\\}", serviceJobId.toString()).replaceAll("\\{appointmentId\\}", appointmentId.toString()) : "/service/v1/serviceJobs/{serviceJobId}/appointments/{appointmentId}/resources".replaceAll("\\{serviceJobId\\}", this.apiClient.escapeString(serviceJobId.toString())).replaceAll("\\{appointmentId\\}", this.apiClient.escapeString(appointmentId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        return this.apiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, progressRequestListener);
    }

    private Call assignAppointmentResourcesValidateBeforeCall(AssignAppointmentResourcesRequest body, String serviceJobId, String appointmentId, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling assignAppointmentResources(Async)");
        }
        if (serviceJobId == null) {
            throw new ApiException("Missing the required parameter 'serviceJobId' when calling assignAppointmentResources(Async)");
        }
        if (appointmentId == null) {
            throw new ApiException("Missing the required parameter 'appointmentId' when calling assignAppointmentResources(Async)");
        }
        return this.assignAppointmentResourcesCall(body, serviceJobId, appointmentId, progressRequestListener);
    }

    public AssignAppointmentResourcesResponse assignAppointmentResources(AssignAppointmentResourcesRequest body, String serviceJobId, String appointmentId, String restrictedDataToken) throws ApiException, LWAException {
        ApiResponse<AssignAppointmentResourcesResponse> resp = this.assignAppointmentResourcesWithHttpInfo(body, serviceJobId, appointmentId, restrictedDataToken);
        return resp.getData();
    }

    public AssignAppointmentResourcesResponse assignAppointmentResources(AssignAppointmentResourcesRequest body, String serviceJobId, String appointmentId) throws ApiException, LWAException {
        ApiResponse<AssignAppointmentResourcesResponse> resp = this.assignAppointmentResourcesWithHttpInfo(body, serviceJobId, appointmentId, null);
        return resp.getData();
    }

    public ApiResponse<AssignAppointmentResourcesResponse> assignAppointmentResourcesWithHttpInfo(AssignAppointmentResourcesRequest body, String serviceJobId, String appointmentId, String restrictedDataToken) throws ApiException, LWAException {
        Call call = this.assignAppointmentResourcesValidateBeforeCall(body, serviceJobId, appointmentId, null);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "ServiceApi-assignAppointmentResources");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.assignAppointmentResourcesBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<AssignAppointmentResourcesResponse>(){}.getType();
            return this.apiClient.execute(call, localVarReturnType);
        }
        throw new ApiException.RateLimitExceeded("assignAppointmentResources operation exceeds rate limit");
    }

    public ApiResponse<AssignAppointmentResourcesResponse> assignAppointmentResourcesWithHttpInfo(AssignAppointmentResourcesRequest body, String serviceJobId, String appointmentId) throws ApiException, LWAException {
        return this.assignAppointmentResourcesWithHttpInfo(body, serviceJobId, appointmentId, null);
    }

    public Call assignAppointmentResourcesAsync(AssignAppointmentResourcesRequest body, String serviceJobId, String appointmentId, ApiCallback<AssignAppointmentResourcesResponse> callback) throws ApiException, LWAException {
        return this.assignAppointmentResourcesAsync(body, serviceJobId, appointmentId, callback, null);
    }

    public Call assignAppointmentResourcesAsync(AssignAppointmentResourcesRequest body, String serviceJobId, String appointmentId, ApiCallback<AssignAppointmentResourcesResponse> callback, String restrictedDataToken) throws ApiException, LWAException {
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressRequestListener = callback::onUploadProgress;
        }
        Call call = this.assignAppointmentResourcesValidateBeforeCall(body, serviceJobId, appointmentId, progressRequestListener);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "ServiceApi-assignAppointmentResources");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.assignAppointmentResourcesBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<AssignAppointmentResourcesResponse>(){}.getType();
            this.apiClient.executeAsync(call, localVarReturnType, callback);
            return call;
        }
        throw new ApiException.RateLimitExceeded("assignAppointmentResources operation exceeds rate limit");
    }

    private Call cancelReservationCall(String reservationId, List<String> marketplaceIds, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        Object localVarPostBody = null;
        String localVarPath = "/service/v1/reservation/{reservationId}".equals("/uploads/2020-11-01/uploadDestinations/{resource}") ? "/service/v1/reservation/{reservationId}".replaceAll("\\{reservationId\\}", reservationId.toString()) : "/service/v1/reservation/{reservationId}".replaceAll("\\{reservationId\\}", this.apiClient.escapeString(reservationId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (marketplaceIds != null) {
            localVarCollectionQueryParams.addAll(this.apiClient.parameterToPairs("csv", "marketplaceIds", marketplaceIds));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        return this.apiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, progressRequestListener);
    }

    private Call cancelReservationValidateBeforeCall(String reservationId, List<String> marketplaceIds, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        if (reservationId == null) {
            throw new ApiException("Missing the required parameter 'reservationId' when calling cancelReservation(Async)");
        }
        if (marketplaceIds == null) {
            throw new ApiException("Missing the required parameter 'marketplaceIds' when calling cancelReservation(Async)");
        }
        return this.cancelReservationCall(reservationId, marketplaceIds, progressRequestListener);
    }

    public CancelReservationResponse cancelReservation(String reservationId, List<String> marketplaceIds, String restrictedDataToken) throws ApiException, LWAException {
        ApiResponse<CancelReservationResponse> resp = this.cancelReservationWithHttpInfo(reservationId, marketplaceIds, restrictedDataToken);
        return resp.getData();
    }

    public CancelReservationResponse cancelReservation(String reservationId, List<String> marketplaceIds) throws ApiException, LWAException {
        ApiResponse<CancelReservationResponse> resp = this.cancelReservationWithHttpInfo(reservationId, marketplaceIds, null);
        return resp.getData();
    }

    public ApiResponse<CancelReservationResponse> cancelReservationWithHttpInfo(String reservationId, List<String> marketplaceIds, String restrictedDataToken) throws ApiException, LWAException {
        Call call = this.cancelReservationValidateBeforeCall(reservationId, marketplaceIds, null);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "ServiceApi-cancelReservation");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.cancelReservationBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<CancelReservationResponse>(){}.getType();
            return this.apiClient.execute(call, localVarReturnType);
        }
        throw new ApiException.RateLimitExceeded("cancelReservation operation exceeds rate limit");
    }

    public ApiResponse<CancelReservationResponse> cancelReservationWithHttpInfo(String reservationId, List<String> marketplaceIds) throws ApiException, LWAException {
        return this.cancelReservationWithHttpInfo(reservationId, marketplaceIds, null);
    }

    public Call cancelReservationAsync(String reservationId, List<String> marketplaceIds, ApiCallback<CancelReservationResponse> callback) throws ApiException, LWAException {
        return this.cancelReservationAsync(reservationId, marketplaceIds, callback, null);
    }

    public Call cancelReservationAsync(String reservationId, List<String> marketplaceIds, ApiCallback<CancelReservationResponse> callback, String restrictedDataToken) throws ApiException, LWAException {
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressRequestListener = callback::onUploadProgress;
        }
        Call call = this.cancelReservationValidateBeforeCall(reservationId, marketplaceIds, progressRequestListener);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "ServiceApi-cancelReservation");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.cancelReservationBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<CancelReservationResponse>(){}.getType();
            this.apiClient.executeAsync(call, localVarReturnType, callback);
            return call;
        }
        throw new ApiException.RateLimitExceeded("cancelReservation operation exceeds rate limit");
    }

    private Call cancelServiceJobByServiceJobIdCall(String serviceJobId, String cancellationReasonCode, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        Object localVarPostBody = null;
        String localVarPath = "/service/v1/serviceJobs/{serviceJobId}/cancellations".equals("/uploads/2020-11-01/uploadDestinations/{resource}") ? "/service/v1/serviceJobs/{serviceJobId}/cancellations".replaceAll("\\{serviceJobId\\}", serviceJobId.toString()) : "/service/v1/serviceJobs/{serviceJobId}/cancellations".replaceAll("\\{serviceJobId\\}", this.apiClient.escapeString(serviceJobId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (cancellationReasonCode != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("cancellationReasonCode", cancellationReasonCode));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        return this.apiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, progressRequestListener);
    }

    private Call cancelServiceJobByServiceJobIdValidateBeforeCall(String serviceJobId, String cancellationReasonCode, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        if (serviceJobId == null) {
            throw new ApiException("Missing the required parameter 'serviceJobId' when calling cancelServiceJobByServiceJobId(Async)");
        }
        if (cancellationReasonCode == null) {
            throw new ApiException("Missing the required parameter 'cancellationReasonCode' when calling cancelServiceJobByServiceJobId(Async)");
        }
        return this.cancelServiceJobByServiceJobIdCall(serviceJobId, cancellationReasonCode, progressRequestListener);
    }

    public CancelServiceJobByServiceJobIdResponse cancelServiceJobByServiceJobId(String serviceJobId, String cancellationReasonCode, String restrictedDataToken) throws ApiException, LWAException {
        ApiResponse<CancelServiceJobByServiceJobIdResponse> resp = this.cancelServiceJobByServiceJobIdWithHttpInfo(serviceJobId, cancellationReasonCode, restrictedDataToken);
        return resp.getData();
    }

    public CancelServiceJobByServiceJobIdResponse cancelServiceJobByServiceJobId(String serviceJobId, String cancellationReasonCode) throws ApiException, LWAException {
        ApiResponse<CancelServiceJobByServiceJobIdResponse> resp = this.cancelServiceJobByServiceJobIdWithHttpInfo(serviceJobId, cancellationReasonCode, null);
        return resp.getData();
    }

    public ApiResponse<CancelServiceJobByServiceJobIdResponse> cancelServiceJobByServiceJobIdWithHttpInfo(String serviceJobId, String cancellationReasonCode, String restrictedDataToken) throws ApiException, LWAException {
        Call call = this.cancelServiceJobByServiceJobIdValidateBeforeCall(serviceJobId, cancellationReasonCode, null);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "ServiceApi-cancelServiceJobByServiceJobId");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.cancelServiceJobByServiceJobIdBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<CancelServiceJobByServiceJobIdResponse>(){}.getType();
            return this.apiClient.execute(call, localVarReturnType);
        }
        throw new ApiException.RateLimitExceeded("cancelServiceJobByServiceJobId operation exceeds rate limit");
    }

    public ApiResponse<CancelServiceJobByServiceJobIdResponse> cancelServiceJobByServiceJobIdWithHttpInfo(String serviceJobId, String cancellationReasonCode) throws ApiException, LWAException {
        return this.cancelServiceJobByServiceJobIdWithHttpInfo(serviceJobId, cancellationReasonCode, null);
    }

    public Call cancelServiceJobByServiceJobIdAsync(String serviceJobId, String cancellationReasonCode, ApiCallback<CancelServiceJobByServiceJobIdResponse> callback) throws ApiException, LWAException {
        return this.cancelServiceJobByServiceJobIdAsync(serviceJobId, cancellationReasonCode, callback, null);
    }

    public Call cancelServiceJobByServiceJobIdAsync(String serviceJobId, String cancellationReasonCode, ApiCallback<CancelServiceJobByServiceJobIdResponse> callback, String restrictedDataToken) throws ApiException, LWAException {
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressRequestListener = callback::onUploadProgress;
        }
        Call call = this.cancelServiceJobByServiceJobIdValidateBeforeCall(serviceJobId, cancellationReasonCode, progressRequestListener);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "ServiceApi-cancelServiceJobByServiceJobId");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.cancelServiceJobByServiceJobIdBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<CancelServiceJobByServiceJobIdResponse>(){}.getType();
            this.apiClient.executeAsync(call, localVarReturnType, callback);
            return call;
        }
        throw new ApiException.RateLimitExceeded("cancelServiceJobByServiceJobId operation exceeds rate limit");
    }

    private Call completeServiceJobByServiceJobIdCall(String serviceJobId, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        Object localVarPostBody = null;
        String localVarPath = "/service/v1/serviceJobs/{serviceJobId}/completions".equals("/uploads/2020-11-01/uploadDestinations/{resource}") ? "/service/v1/serviceJobs/{serviceJobId}/completions".replaceAll("\\{serviceJobId\\}", serviceJobId.toString()) : "/service/v1/serviceJobs/{serviceJobId}/completions".replaceAll("\\{serviceJobId\\}", this.apiClient.escapeString(serviceJobId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        return this.apiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, progressRequestListener);
    }

    private Call completeServiceJobByServiceJobIdValidateBeforeCall(String serviceJobId, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        if (serviceJobId == null) {
            throw new ApiException("Missing the required parameter 'serviceJobId' when calling completeServiceJobByServiceJobId(Async)");
        }
        return this.completeServiceJobByServiceJobIdCall(serviceJobId, progressRequestListener);
    }

    public CompleteServiceJobByServiceJobIdResponse completeServiceJobByServiceJobId(String serviceJobId, String restrictedDataToken) throws ApiException, LWAException {
        ApiResponse<CompleteServiceJobByServiceJobIdResponse> resp = this.completeServiceJobByServiceJobIdWithHttpInfo(serviceJobId, restrictedDataToken);
        return resp.getData();
    }

    public CompleteServiceJobByServiceJobIdResponse completeServiceJobByServiceJobId(String serviceJobId) throws ApiException, LWAException {
        ApiResponse<CompleteServiceJobByServiceJobIdResponse> resp = this.completeServiceJobByServiceJobIdWithHttpInfo(serviceJobId, null);
        return resp.getData();
    }

    public ApiResponse<CompleteServiceJobByServiceJobIdResponse> completeServiceJobByServiceJobIdWithHttpInfo(String serviceJobId, String restrictedDataToken) throws ApiException, LWAException {
        Call call = this.completeServiceJobByServiceJobIdValidateBeforeCall(serviceJobId, null);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "ServiceApi-completeServiceJobByServiceJobId");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.completeServiceJobByServiceJobIdBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<CompleteServiceJobByServiceJobIdResponse>(){}.getType();
            return this.apiClient.execute(call, localVarReturnType);
        }
        throw new ApiException.RateLimitExceeded("completeServiceJobByServiceJobId operation exceeds rate limit");
    }

    public ApiResponse<CompleteServiceJobByServiceJobIdResponse> completeServiceJobByServiceJobIdWithHttpInfo(String serviceJobId) throws ApiException, LWAException {
        return this.completeServiceJobByServiceJobIdWithHttpInfo(serviceJobId, null);
    }

    public Call completeServiceJobByServiceJobIdAsync(String serviceJobId, ApiCallback<CompleteServiceJobByServiceJobIdResponse> callback) throws ApiException, LWAException {
        return this.completeServiceJobByServiceJobIdAsync(serviceJobId, callback, null);
    }

    public Call completeServiceJobByServiceJobIdAsync(String serviceJobId, ApiCallback<CompleteServiceJobByServiceJobIdResponse> callback, String restrictedDataToken) throws ApiException, LWAException {
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressRequestListener = callback::onUploadProgress;
        }
        Call call = this.completeServiceJobByServiceJobIdValidateBeforeCall(serviceJobId, progressRequestListener);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "ServiceApi-completeServiceJobByServiceJobId");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.completeServiceJobByServiceJobIdBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<CompleteServiceJobByServiceJobIdResponse>(){}.getType();
            this.apiClient.executeAsync(call, localVarReturnType, callback);
            return call;
        }
        throw new ApiException.RateLimitExceeded("completeServiceJobByServiceJobId operation exceeds rate limit");
    }

    private Call createReservationCall(CreateReservationRequest body, List<String> marketplaceIds, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        CreateReservationRequest localVarPostBody = body;
        String localVarPath = "/service/v1/reservation".equals("/uploads/2020-11-01/uploadDestinations/{resource}") ? "/service/v1/reservation" : "/service/v1/reservation";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (marketplaceIds != null) {
            localVarCollectionQueryParams.addAll(this.apiClient.parameterToPairs("csv", "marketplaceIds", marketplaceIds));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, progressRequestListener);
    }

    private Call createReservationValidateBeforeCall(CreateReservationRequest body, List<String> marketplaceIds, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling createReservation(Async)");
        }
        if (marketplaceIds == null) {
            throw new ApiException("Missing the required parameter 'marketplaceIds' when calling createReservation(Async)");
        }
        return this.createReservationCall(body, marketplaceIds, progressRequestListener);
    }

    public CreateReservationResponse createReservation(CreateReservationRequest body, List<String> marketplaceIds, String restrictedDataToken) throws ApiException, LWAException {
        ApiResponse<CreateReservationResponse> resp = this.createReservationWithHttpInfo(body, marketplaceIds, restrictedDataToken);
        return resp.getData();
    }

    public CreateReservationResponse createReservation(CreateReservationRequest body, List<String> marketplaceIds) throws ApiException, LWAException {
        ApiResponse<CreateReservationResponse> resp = this.createReservationWithHttpInfo(body, marketplaceIds, null);
        return resp.getData();
    }

    public ApiResponse<CreateReservationResponse> createReservationWithHttpInfo(CreateReservationRequest body, List<String> marketplaceIds, String restrictedDataToken) throws ApiException, LWAException {
        Call call = this.createReservationValidateBeforeCall(body, marketplaceIds, null);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "ServiceApi-createReservation");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.createReservationBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<CreateReservationResponse>(){}.getType();
            return this.apiClient.execute(call, localVarReturnType);
        }
        throw new ApiException.RateLimitExceeded("createReservation operation exceeds rate limit");
    }

    public ApiResponse<CreateReservationResponse> createReservationWithHttpInfo(CreateReservationRequest body, List<String> marketplaceIds) throws ApiException, LWAException {
        return this.createReservationWithHttpInfo(body, marketplaceIds, null);
    }

    public Call createReservationAsync(CreateReservationRequest body, List<String> marketplaceIds, ApiCallback<CreateReservationResponse> callback) throws ApiException, LWAException {
        return this.createReservationAsync(body, marketplaceIds, callback, null);
    }

    public Call createReservationAsync(CreateReservationRequest body, List<String> marketplaceIds, ApiCallback<CreateReservationResponse> callback, String restrictedDataToken) throws ApiException, LWAException {
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressRequestListener = callback::onUploadProgress;
        }
        Call call = this.createReservationValidateBeforeCall(body, marketplaceIds, progressRequestListener);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "ServiceApi-createReservation");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.createReservationBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<CreateReservationResponse>(){}.getType();
            this.apiClient.executeAsync(call, localVarReturnType, callback);
            return call;
        }
        throw new ApiException.RateLimitExceeded("createReservation operation exceeds rate limit");
    }

    private Call createServiceDocumentUploadDestinationCall(ServiceUploadDocument body, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        ServiceUploadDocument localVarPostBody = body;
        String localVarPath = "/service/v1/documents".equals("/uploads/2020-11-01/uploadDestinations/{resource}") ? "/service/v1/documents" : "/service/v1/documents";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, progressRequestListener);
    }

    private Call createServiceDocumentUploadDestinationValidateBeforeCall(ServiceUploadDocument body, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling createServiceDocumentUploadDestination(Async)");
        }
        return this.createServiceDocumentUploadDestinationCall(body, progressRequestListener);
    }

    public CreateServiceDocumentUploadDestination createServiceDocumentUploadDestination(ServiceUploadDocument body, String restrictedDataToken) throws ApiException, LWAException {
        ApiResponse<CreateServiceDocumentUploadDestination> resp = this.createServiceDocumentUploadDestinationWithHttpInfo(body, restrictedDataToken);
        return resp.getData();
    }

    public CreateServiceDocumentUploadDestination createServiceDocumentUploadDestination(ServiceUploadDocument body) throws ApiException, LWAException {
        ApiResponse<CreateServiceDocumentUploadDestination> resp = this.createServiceDocumentUploadDestinationWithHttpInfo(body, null);
        return resp.getData();
    }

    public ApiResponse<CreateServiceDocumentUploadDestination> createServiceDocumentUploadDestinationWithHttpInfo(ServiceUploadDocument body, String restrictedDataToken) throws ApiException, LWAException {
        Call call = this.createServiceDocumentUploadDestinationValidateBeforeCall(body, null);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "ServiceApi-createServiceDocumentUploadDestination");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.createServiceDocumentUploadDestinationBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<CreateServiceDocumentUploadDestination>(){}.getType();
            return this.apiClient.execute(call, localVarReturnType);
        }
        throw new ApiException.RateLimitExceeded("createServiceDocumentUploadDestination operation exceeds rate limit");
    }

    public ApiResponse<CreateServiceDocumentUploadDestination> createServiceDocumentUploadDestinationWithHttpInfo(ServiceUploadDocument body) throws ApiException, LWAException {
        return this.createServiceDocumentUploadDestinationWithHttpInfo(body, null);
    }

    public Call createServiceDocumentUploadDestinationAsync(ServiceUploadDocument body, ApiCallback<CreateServiceDocumentUploadDestination> callback) throws ApiException, LWAException {
        return this.createServiceDocumentUploadDestinationAsync(body, callback, null);
    }

    public Call createServiceDocumentUploadDestinationAsync(ServiceUploadDocument body, ApiCallback<CreateServiceDocumentUploadDestination> callback, String restrictedDataToken) throws ApiException, LWAException {
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressRequestListener = callback::onUploadProgress;
        }
        Call call = this.createServiceDocumentUploadDestinationValidateBeforeCall(body, progressRequestListener);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "ServiceApi-createServiceDocumentUploadDestination");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.createServiceDocumentUploadDestinationBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<CreateServiceDocumentUploadDestination>(){}.getType();
            this.apiClient.executeAsync(call, localVarReturnType, callback);
            return call;
        }
        throw new ApiException.RateLimitExceeded("createServiceDocumentUploadDestination operation exceeds rate limit");
    }

    private Call getAppointmentSlotsCall(String asin, String storeId, List<String> marketplaceIds, String startTime, String endTime, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        Object localVarPostBody = null;
        String localVarPath = "/service/v1/appointmentSlots".equals("/uploads/2020-11-01/uploadDestinations/{resource}") ? "/service/v1/appointmentSlots" : "/service/v1/appointmentSlots";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (asin != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("asin", asin));
        }
        if (storeId != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("storeId", storeId));
        }
        if (marketplaceIds != null) {
            localVarCollectionQueryParams.addAll(this.apiClient.parameterToPairs("csv", "marketplaceIds", marketplaceIds));
        }
        if (startTime != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("startTime", startTime));
        }
        if (endTime != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("endTime", endTime));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, progressRequestListener);
    }

    private Call getAppointmentSlotsValidateBeforeCall(String asin, String storeId, List<String> marketplaceIds, String startTime, String endTime, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        if (asin == null) {
            throw new ApiException("Missing the required parameter 'asin' when calling getAppointmentSlots(Async)");
        }
        if (storeId == null) {
            throw new ApiException("Missing the required parameter 'storeId' when calling getAppointmentSlots(Async)");
        }
        if (marketplaceIds == null) {
            throw new ApiException("Missing the required parameter 'marketplaceIds' when calling getAppointmentSlots(Async)");
        }
        return this.getAppointmentSlotsCall(asin, storeId, marketplaceIds, startTime, endTime, progressRequestListener);
    }

    public GetAppointmentSlotsResponse getAppointmentSlots(String asin, String storeId, List<String> marketplaceIds, String startTime, String endTime, String restrictedDataToken) throws ApiException, LWAException {
        ApiResponse<GetAppointmentSlotsResponse> resp = this.getAppointmentSlotsWithHttpInfo(asin, storeId, marketplaceIds, startTime, endTime, restrictedDataToken);
        return resp.getData();
    }

    public GetAppointmentSlotsResponse getAppointmentSlots(String asin, String storeId, List<String> marketplaceIds, String startTime, String endTime) throws ApiException, LWAException {
        ApiResponse<GetAppointmentSlotsResponse> resp = this.getAppointmentSlotsWithHttpInfo(asin, storeId, marketplaceIds, startTime, endTime, null);
        return resp.getData();
    }

    public ApiResponse<GetAppointmentSlotsResponse> getAppointmentSlotsWithHttpInfo(String asin, String storeId, List<String> marketplaceIds, String startTime, String endTime, String restrictedDataToken) throws ApiException, LWAException {
        Call call = this.getAppointmentSlotsValidateBeforeCall(asin, storeId, marketplaceIds, startTime, endTime, null);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "ServiceApi-getAppointmentSlots");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.getAppointmentSlotsBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<GetAppointmentSlotsResponse>(){}.getType();
            return this.apiClient.execute(call, localVarReturnType);
        }
        throw new ApiException.RateLimitExceeded("getAppointmentSlots operation exceeds rate limit");
    }

    public ApiResponse<GetAppointmentSlotsResponse> getAppointmentSlotsWithHttpInfo(String asin, String storeId, List<String> marketplaceIds, String startTime, String endTime) throws ApiException, LWAException {
        return this.getAppointmentSlotsWithHttpInfo(asin, storeId, marketplaceIds, startTime, endTime, null);
    }

    public Call getAppointmentSlotsAsync(String asin, String storeId, List<String> marketplaceIds, String startTime, String endTime, ApiCallback<GetAppointmentSlotsResponse> callback) throws ApiException, LWAException {
        return this.getAppointmentSlotsAsync(asin, storeId, marketplaceIds, startTime, endTime, callback, null);
    }

    public Call getAppointmentSlotsAsync(String asin, String storeId, List<String> marketplaceIds, String startTime, String endTime, ApiCallback<GetAppointmentSlotsResponse> callback, String restrictedDataToken) throws ApiException, LWAException {
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressRequestListener = callback::onUploadProgress;
        }
        Call call = this.getAppointmentSlotsValidateBeforeCall(asin, storeId, marketplaceIds, startTime, endTime, progressRequestListener);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "ServiceApi-getAppointmentSlots");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.getAppointmentSlotsBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<GetAppointmentSlotsResponse>(){}.getType();
            this.apiClient.executeAsync(call, localVarReturnType, callback);
            return call;
        }
        throw new ApiException.RateLimitExceeded("getAppointmentSlots operation exceeds rate limit");
    }

    private Call getAppointmmentSlotsByJobIdCall(String serviceJobId, List<String> marketplaceIds, String startTime, String endTime, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        Object localVarPostBody = null;
        String localVarPath = "/service/v1/serviceJobs/{serviceJobId}/appointmentSlots".equals("/uploads/2020-11-01/uploadDestinations/{resource}") ? "/service/v1/serviceJobs/{serviceJobId}/appointmentSlots".replaceAll("\\{serviceJobId\\}", serviceJobId.toString()) : "/service/v1/serviceJobs/{serviceJobId}/appointmentSlots".replaceAll("\\{serviceJobId\\}", this.apiClient.escapeString(serviceJobId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (marketplaceIds != null) {
            localVarCollectionQueryParams.addAll(this.apiClient.parameterToPairs("csv", "marketplaceIds", marketplaceIds));
        }
        if (startTime != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("startTime", startTime));
        }
        if (endTime != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("endTime", endTime));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, progressRequestListener);
    }

    private Call getAppointmmentSlotsByJobIdValidateBeforeCall(String serviceJobId, List<String> marketplaceIds, String startTime, String endTime, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        if (serviceJobId == null) {
            throw new ApiException("Missing the required parameter 'serviceJobId' when calling getAppointmmentSlotsByJobId(Async)");
        }
        if (marketplaceIds == null) {
            throw new ApiException("Missing the required parameter 'marketplaceIds' when calling getAppointmmentSlotsByJobId(Async)");
        }
        return this.getAppointmmentSlotsByJobIdCall(serviceJobId, marketplaceIds, startTime, endTime, progressRequestListener);
    }

    public GetAppointmentSlotsResponse getAppointmmentSlotsByJobId(String serviceJobId, List<String> marketplaceIds, String startTime, String endTime, String restrictedDataToken) throws ApiException, LWAException {
        ApiResponse<GetAppointmentSlotsResponse> resp = this.getAppointmmentSlotsByJobIdWithHttpInfo(serviceJobId, marketplaceIds, startTime, endTime, restrictedDataToken);
        return resp.getData();
    }

    public GetAppointmentSlotsResponse getAppointmmentSlotsByJobId(String serviceJobId, List<String> marketplaceIds, String startTime, String endTime) throws ApiException, LWAException {
        ApiResponse<GetAppointmentSlotsResponse> resp = this.getAppointmmentSlotsByJobIdWithHttpInfo(serviceJobId, marketplaceIds, startTime, endTime, null);
        return resp.getData();
    }

    public ApiResponse<GetAppointmentSlotsResponse> getAppointmmentSlotsByJobIdWithHttpInfo(String serviceJobId, List<String> marketplaceIds, String startTime, String endTime, String restrictedDataToken) throws ApiException, LWAException {
        Call call = this.getAppointmmentSlotsByJobIdValidateBeforeCall(serviceJobId, marketplaceIds, startTime, endTime, null);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "ServiceApi-getAppointmmentSlotsByJobId");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.getAppointmmentSlotsByJobIdBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<GetAppointmentSlotsResponse>(){}.getType();
            return this.apiClient.execute(call, localVarReturnType);
        }
        throw new ApiException.RateLimitExceeded("getAppointmmentSlotsByJobId operation exceeds rate limit");
    }

    public ApiResponse<GetAppointmentSlotsResponse> getAppointmmentSlotsByJobIdWithHttpInfo(String serviceJobId, List<String> marketplaceIds, String startTime, String endTime) throws ApiException, LWAException {
        return this.getAppointmmentSlotsByJobIdWithHttpInfo(serviceJobId, marketplaceIds, startTime, endTime, null);
    }

    public Call getAppointmmentSlotsByJobIdAsync(String serviceJobId, List<String> marketplaceIds, String startTime, String endTime, ApiCallback<GetAppointmentSlotsResponse> callback) throws ApiException, LWAException {
        return this.getAppointmmentSlotsByJobIdAsync(serviceJobId, marketplaceIds, startTime, endTime, callback, null);
    }

    public Call getAppointmmentSlotsByJobIdAsync(String serviceJobId, List<String> marketplaceIds, String startTime, String endTime, ApiCallback<GetAppointmentSlotsResponse> callback, String restrictedDataToken) throws ApiException, LWAException {
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressRequestListener = callback::onUploadProgress;
        }
        Call call = this.getAppointmmentSlotsByJobIdValidateBeforeCall(serviceJobId, marketplaceIds, startTime, endTime, progressRequestListener);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "ServiceApi-getAppointmmentSlotsByJobId");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.getAppointmmentSlotsByJobIdBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<GetAppointmentSlotsResponse>(){}.getType();
            this.apiClient.executeAsync(call, localVarReturnType, callback);
            return call;
        }
        throw new ApiException.RateLimitExceeded("getAppointmmentSlotsByJobId operation exceeds rate limit");
    }

    private Call getFixedSlotCapacityCall(FixedSlotCapacityQuery body, String resourceId, List<String> marketplaceIds, String nextPageToken, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        FixedSlotCapacityQuery localVarPostBody = body;
        String localVarPath = "/service/v1/serviceResources/{resourceId}/capacity/fixed".equals("/uploads/2020-11-01/uploadDestinations/{resource}") ? "/service/v1/serviceResources/{resourceId}/capacity/fixed".replaceAll("\\{resourceId\\}", resourceId.toString()) : "/service/v1/serviceResources/{resourceId}/capacity/fixed".replaceAll("\\{resourceId\\}", this.apiClient.escapeString(resourceId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (marketplaceIds != null) {
            localVarCollectionQueryParams.addAll(this.apiClient.parameterToPairs("csv", "marketplaceIds", marketplaceIds));
        }
        if (nextPageToken != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("nextPageToken", nextPageToken));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, progressRequestListener);
    }

    private Call getFixedSlotCapacityValidateBeforeCall(FixedSlotCapacityQuery body, String resourceId, List<String> marketplaceIds, String nextPageToken, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling getFixedSlotCapacity(Async)");
        }
        if (resourceId == null) {
            throw new ApiException("Missing the required parameter 'resourceId' when calling getFixedSlotCapacity(Async)");
        }
        if (marketplaceIds == null) {
            throw new ApiException("Missing the required parameter 'marketplaceIds' when calling getFixedSlotCapacity(Async)");
        }
        return this.getFixedSlotCapacityCall(body, resourceId, marketplaceIds, nextPageToken, progressRequestListener);
    }

    public FixedSlotCapacity getFixedSlotCapacity(FixedSlotCapacityQuery body, String resourceId, List<String> marketplaceIds, String nextPageToken, String restrictedDataToken) throws ApiException, LWAException {
        ApiResponse<FixedSlotCapacity> resp = this.getFixedSlotCapacityWithHttpInfo(body, resourceId, marketplaceIds, nextPageToken, restrictedDataToken);
        return resp.getData();
    }

    public FixedSlotCapacity getFixedSlotCapacity(FixedSlotCapacityQuery body, String resourceId, List<String> marketplaceIds, String nextPageToken) throws ApiException, LWAException {
        ApiResponse<FixedSlotCapacity> resp = this.getFixedSlotCapacityWithHttpInfo(body, resourceId, marketplaceIds, nextPageToken, null);
        return resp.getData();
    }

    public ApiResponse<FixedSlotCapacity> getFixedSlotCapacityWithHttpInfo(FixedSlotCapacityQuery body, String resourceId, List<String> marketplaceIds, String nextPageToken, String restrictedDataToken) throws ApiException, LWAException {
        Call call = this.getFixedSlotCapacityValidateBeforeCall(body, resourceId, marketplaceIds, nextPageToken, null);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "ServiceApi-getFixedSlotCapacity");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.getFixedSlotCapacityBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<FixedSlotCapacity>(){}.getType();
            return this.apiClient.execute(call, localVarReturnType);
        }
        throw new ApiException.RateLimitExceeded("getFixedSlotCapacity operation exceeds rate limit");
    }

    public ApiResponse<FixedSlotCapacity> getFixedSlotCapacityWithHttpInfo(FixedSlotCapacityQuery body, String resourceId, List<String> marketplaceIds, String nextPageToken) throws ApiException, LWAException {
        return this.getFixedSlotCapacityWithHttpInfo(body, resourceId, marketplaceIds, nextPageToken, null);
    }

    public Call getFixedSlotCapacityAsync(FixedSlotCapacityQuery body, String resourceId, List<String> marketplaceIds, String nextPageToken, ApiCallback<FixedSlotCapacity> callback) throws ApiException, LWAException {
        return this.getFixedSlotCapacityAsync(body, resourceId, marketplaceIds, nextPageToken, callback, null);
    }

    public Call getFixedSlotCapacityAsync(FixedSlotCapacityQuery body, String resourceId, List<String> marketplaceIds, String nextPageToken, ApiCallback<FixedSlotCapacity> callback, String restrictedDataToken) throws ApiException, LWAException {
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressRequestListener = callback::onUploadProgress;
        }
        Call call = this.getFixedSlotCapacityValidateBeforeCall(body, resourceId, marketplaceIds, nextPageToken, progressRequestListener);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "ServiceApi-getFixedSlotCapacity");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.getFixedSlotCapacityBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<FixedSlotCapacity>(){}.getType();
            this.apiClient.executeAsync(call, localVarReturnType, callback);
            return call;
        }
        throw new ApiException.RateLimitExceeded("getFixedSlotCapacity operation exceeds rate limit");
    }

    private Call getRangeSlotCapacityCall(RangeSlotCapacityQuery body, String resourceId, List<String> marketplaceIds, String nextPageToken, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        RangeSlotCapacityQuery localVarPostBody = body;
        String localVarPath = "/service/v1/serviceResources/{resourceId}/capacity/range".equals("/uploads/2020-11-01/uploadDestinations/{resource}") ? "/service/v1/serviceResources/{resourceId}/capacity/range".replaceAll("\\{resourceId\\}", resourceId.toString()) : "/service/v1/serviceResources/{resourceId}/capacity/range".replaceAll("\\{resourceId\\}", this.apiClient.escapeString(resourceId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (marketplaceIds != null) {
            localVarCollectionQueryParams.addAll(this.apiClient.parameterToPairs("csv", "marketplaceIds", marketplaceIds));
        }
        if (nextPageToken != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("nextPageToken", nextPageToken));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, progressRequestListener);
    }

    private Call getRangeSlotCapacityValidateBeforeCall(RangeSlotCapacityQuery body, String resourceId, List<String> marketplaceIds, String nextPageToken, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling getRangeSlotCapacity(Async)");
        }
        if (resourceId == null) {
            throw new ApiException("Missing the required parameter 'resourceId' when calling getRangeSlotCapacity(Async)");
        }
        if (marketplaceIds == null) {
            throw new ApiException("Missing the required parameter 'marketplaceIds' when calling getRangeSlotCapacity(Async)");
        }
        return this.getRangeSlotCapacityCall(body, resourceId, marketplaceIds, nextPageToken, progressRequestListener);
    }

    public RangeSlotCapacity getRangeSlotCapacity(RangeSlotCapacityQuery body, String resourceId, List<String> marketplaceIds, String nextPageToken, String restrictedDataToken) throws ApiException, LWAException {
        ApiResponse<RangeSlotCapacity> resp = this.getRangeSlotCapacityWithHttpInfo(body, resourceId, marketplaceIds, nextPageToken, restrictedDataToken);
        return resp.getData();
    }

    public RangeSlotCapacity getRangeSlotCapacity(RangeSlotCapacityQuery body, String resourceId, List<String> marketplaceIds, String nextPageToken) throws ApiException, LWAException {
        ApiResponse<RangeSlotCapacity> resp = this.getRangeSlotCapacityWithHttpInfo(body, resourceId, marketplaceIds, nextPageToken, null);
        return resp.getData();
    }

    public ApiResponse<RangeSlotCapacity> getRangeSlotCapacityWithHttpInfo(RangeSlotCapacityQuery body, String resourceId, List<String> marketplaceIds, String nextPageToken, String restrictedDataToken) throws ApiException, LWAException {
        Call call = this.getRangeSlotCapacityValidateBeforeCall(body, resourceId, marketplaceIds, nextPageToken, null);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "ServiceApi-getRangeSlotCapacity");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.getRangeSlotCapacityBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<RangeSlotCapacity>(){}.getType();
            return this.apiClient.execute(call, localVarReturnType);
        }
        throw new ApiException.RateLimitExceeded("getRangeSlotCapacity operation exceeds rate limit");
    }

    public ApiResponse<RangeSlotCapacity> getRangeSlotCapacityWithHttpInfo(RangeSlotCapacityQuery body, String resourceId, List<String> marketplaceIds, String nextPageToken) throws ApiException, LWAException {
        return this.getRangeSlotCapacityWithHttpInfo(body, resourceId, marketplaceIds, nextPageToken, null);
    }

    public Call getRangeSlotCapacityAsync(RangeSlotCapacityQuery body, String resourceId, List<String> marketplaceIds, String nextPageToken, ApiCallback<RangeSlotCapacity> callback) throws ApiException, LWAException {
        return this.getRangeSlotCapacityAsync(body, resourceId, marketplaceIds, nextPageToken, callback, null);
    }

    public Call getRangeSlotCapacityAsync(RangeSlotCapacityQuery body, String resourceId, List<String> marketplaceIds, String nextPageToken, ApiCallback<RangeSlotCapacity> callback, String restrictedDataToken) throws ApiException, LWAException {
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressRequestListener = callback::onUploadProgress;
        }
        Call call = this.getRangeSlotCapacityValidateBeforeCall(body, resourceId, marketplaceIds, nextPageToken, progressRequestListener);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "ServiceApi-getRangeSlotCapacity");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.getRangeSlotCapacityBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<RangeSlotCapacity>(){}.getType();
            this.apiClient.executeAsync(call, localVarReturnType, callback);
            return call;
        }
        throw new ApiException.RateLimitExceeded("getRangeSlotCapacity operation exceeds rate limit");
    }

    private Call getServiceJobByServiceJobIdCall(String serviceJobId, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        Object localVarPostBody = null;
        String localVarPath = "/service/v1/serviceJobs/{serviceJobId}".equals("/uploads/2020-11-01/uploadDestinations/{resource}") ? "/service/v1/serviceJobs/{serviceJobId}".replaceAll("\\{serviceJobId\\}", serviceJobId.toString()) : "/service/v1/serviceJobs/{serviceJobId}".replaceAll("\\{serviceJobId\\}", this.apiClient.escapeString(serviceJobId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, progressRequestListener);
    }

    private Call getServiceJobByServiceJobIdValidateBeforeCall(String serviceJobId, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        if (serviceJobId == null) {
            throw new ApiException("Missing the required parameter 'serviceJobId' when calling getServiceJobByServiceJobId(Async)");
        }
        return this.getServiceJobByServiceJobIdCall(serviceJobId, progressRequestListener);
    }

    public GetServiceJobByServiceJobIdResponse getServiceJobByServiceJobId(String serviceJobId, String restrictedDataToken) throws ApiException, LWAException {
        ApiResponse<GetServiceJobByServiceJobIdResponse> resp = this.getServiceJobByServiceJobIdWithHttpInfo(serviceJobId, restrictedDataToken);
        return resp.getData();
    }

    public GetServiceJobByServiceJobIdResponse getServiceJobByServiceJobId(String serviceJobId) throws ApiException, LWAException {
        ApiResponse<GetServiceJobByServiceJobIdResponse> resp = this.getServiceJobByServiceJobIdWithHttpInfo(serviceJobId, null);
        return resp.getData();
    }

    public ApiResponse<GetServiceJobByServiceJobIdResponse> getServiceJobByServiceJobIdWithHttpInfo(String serviceJobId, String restrictedDataToken) throws ApiException, LWAException {
        Call call = this.getServiceJobByServiceJobIdValidateBeforeCall(serviceJobId, null);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "ServiceApi-getServiceJobByServiceJobId");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.getServiceJobByServiceJobIdBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<GetServiceJobByServiceJobIdResponse>(){}.getType();
            return this.apiClient.execute(call, localVarReturnType);
        }
        throw new ApiException.RateLimitExceeded("getServiceJobByServiceJobId operation exceeds rate limit");
    }

    public ApiResponse<GetServiceJobByServiceJobIdResponse> getServiceJobByServiceJobIdWithHttpInfo(String serviceJobId) throws ApiException, LWAException {
        return this.getServiceJobByServiceJobIdWithHttpInfo(serviceJobId, null);
    }

    public Call getServiceJobByServiceJobIdAsync(String serviceJobId, ApiCallback<GetServiceJobByServiceJobIdResponse> callback) throws ApiException, LWAException {
        return this.getServiceJobByServiceJobIdAsync(serviceJobId, callback, null);
    }

    public Call getServiceJobByServiceJobIdAsync(String serviceJobId, ApiCallback<GetServiceJobByServiceJobIdResponse> callback, String restrictedDataToken) throws ApiException, LWAException {
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressRequestListener = callback::onUploadProgress;
        }
        Call call = this.getServiceJobByServiceJobIdValidateBeforeCall(serviceJobId, progressRequestListener);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "ServiceApi-getServiceJobByServiceJobId");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.getServiceJobByServiceJobIdBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<GetServiceJobByServiceJobIdResponse>(){}.getType();
            this.apiClient.executeAsync(call, localVarReturnType, callback);
            return call;
        }
        throw new ApiException.RateLimitExceeded("getServiceJobByServiceJobId operation exceeds rate limit");
    }

    private Call getServiceJobsCall(List<String> marketplaceIds, List<String> serviceOrderIds, List<String> serviceJobStatus, String pageToken, Integer pageSize, String sortField, String sortOrder, String createdAfter, String createdBefore, String lastUpdatedAfter, String lastUpdatedBefore, String scheduleStartDate, String scheduleEndDate, List<String> asins, List<String> requiredSkills, List<String> storeIds, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        Object localVarPostBody = null;
        String localVarPath = "/service/v1/serviceJobs".equals("/uploads/2020-11-01/uploadDestinations/{resource}") ? "/service/v1/serviceJobs" : "/service/v1/serviceJobs";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (serviceOrderIds != null) {
            localVarCollectionQueryParams.addAll(this.apiClient.parameterToPairs("csv", "serviceOrderIds", serviceOrderIds));
        }
        if (serviceJobStatus != null) {
            localVarCollectionQueryParams.addAll(this.apiClient.parameterToPairs("csv", "serviceJobStatus", serviceJobStatus));
        }
        if (pageToken != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("pageToken", pageToken));
        }
        if (pageSize != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("pageSize", pageSize));
        }
        if (sortField != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("sortField", sortField));
        }
        if (sortOrder != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("sortOrder", sortOrder));
        }
        if (createdAfter != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("createdAfter", createdAfter));
        }
        if (createdBefore != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("createdBefore", createdBefore));
        }
        if (lastUpdatedAfter != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("lastUpdatedAfter", lastUpdatedAfter));
        }
        if (lastUpdatedBefore != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("lastUpdatedBefore", lastUpdatedBefore));
        }
        if (scheduleStartDate != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("scheduleStartDate", scheduleStartDate));
        }
        if (scheduleEndDate != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("scheduleEndDate", scheduleEndDate));
        }
        if (marketplaceIds != null) {
            localVarCollectionQueryParams.addAll(this.apiClient.parameterToPairs("csv", "marketplaceIds", marketplaceIds));
        }
        if (asins != null) {
            localVarCollectionQueryParams.addAll(this.apiClient.parameterToPairs("csv", "asins", asins));
        }
        if (requiredSkills != null) {
            localVarCollectionQueryParams.addAll(this.apiClient.parameterToPairs("csv", "requiredSkills", requiredSkills));
        }
        if (storeIds != null) {
            localVarCollectionQueryParams.addAll(this.apiClient.parameterToPairs("csv", "storeIds", storeIds));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, progressRequestListener);
    }

    private Call getServiceJobsValidateBeforeCall(List<String> marketplaceIds, List<String> serviceOrderIds, List<String> serviceJobStatus, String pageToken, Integer pageSize, String sortField, String sortOrder, String createdAfter, String createdBefore, String lastUpdatedAfter, String lastUpdatedBefore, String scheduleStartDate, String scheduleEndDate, List<String> asins, List<String> requiredSkills, List<String> storeIds, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        if (marketplaceIds == null) {
            throw new ApiException("Missing the required parameter 'marketplaceIds' when calling getServiceJobs(Async)");
        }
        return this.getServiceJobsCall(marketplaceIds, serviceOrderIds, serviceJobStatus, pageToken, pageSize, sortField, sortOrder, createdAfter, createdBefore, lastUpdatedAfter, lastUpdatedBefore, scheduleStartDate, scheduleEndDate, asins, requiredSkills, storeIds, progressRequestListener);
    }

    public GetServiceJobsResponse getServiceJobs(List<String> marketplaceIds, List<String> serviceOrderIds, List<String> serviceJobStatus, String pageToken, Integer pageSize, String sortField, String sortOrder, String createdAfter, String createdBefore, String lastUpdatedAfter, String lastUpdatedBefore, String scheduleStartDate, String scheduleEndDate, List<String> asins, List<String> requiredSkills, List<String> storeIds, String restrictedDataToken) throws ApiException, LWAException {
        ApiResponse<GetServiceJobsResponse> resp = this.getServiceJobsWithHttpInfo(marketplaceIds, serviceOrderIds, serviceJobStatus, pageToken, pageSize, sortField, sortOrder, createdAfter, createdBefore, lastUpdatedAfter, lastUpdatedBefore, scheduleStartDate, scheduleEndDate, asins, requiredSkills, storeIds, restrictedDataToken);
        return resp.getData();
    }

    public GetServiceJobsResponse getServiceJobs(List<String> marketplaceIds, List<String> serviceOrderIds, List<String> serviceJobStatus, String pageToken, Integer pageSize, String sortField, String sortOrder, String createdAfter, String createdBefore, String lastUpdatedAfter, String lastUpdatedBefore, String scheduleStartDate, String scheduleEndDate, List<String> asins, List<String> requiredSkills, List<String> storeIds) throws ApiException, LWAException {
        ApiResponse<GetServiceJobsResponse> resp = this.getServiceJobsWithHttpInfo(marketplaceIds, serviceOrderIds, serviceJobStatus, pageToken, pageSize, sortField, sortOrder, createdAfter, createdBefore, lastUpdatedAfter, lastUpdatedBefore, scheduleStartDate, scheduleEndDate, asins, requiredSkills, storeIds, null);
        return resp.getData();
    }

    public ApiResponse<GetServiceJobsResponse> getServiceJobsWithHttpInfo(List<String> marketplaceIds, List<String> serviceOrderIds, List<String> serviceJobStatus, String pageToken, Integer pageSize, String sortField, String sortOrder, String createdAfter, String createdBefore, String lastUpdatedAfter, String lastUpdatedBefore, String scheduleStartDate, String scheduleEndDate, List<String> asins, List<String> requiredSkills, List<String> storeIds, String restrictedDataToken) throws ApiException, LWAException {
        Call call = this.getServiceJobsValidateBeforeCall(marketplaceIds, serviceOrderIds, serviceJobStatus, pageToken, pageSize, sortField, sortOrder, createdAfter, createdBefore, lastUpdatedAfter, lastUpdatedBefore, scheduleStartDate, scheduleEndDate, asins, requiredSkills, storeIds, null);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "ServiceApi-getServiceJobs");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.getServiceJobsBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<GetServiceJobsResponse>(){}.getType();
            return this.apiClient.execute(call, localVarReturnType);
        }
        throw new ApiException.RateLimitExceeded("getServiceJobs operation exceeds rate limit");
    }

    public ApiResponse<GetServiceJobsResponse> getServiceJobsWithHttpInfo(List<String> marketplaceIds, List<String> serviceOrderIds, List<String> serviceJobStatus, String pageToken, Integer pageSize, String sortField, String sortOrder, String createdAfter, String createdBefore, String lastUpdatedAfter, String lastUpdatedBefore, String scheduleStartDate, String scheduleEndDate, List<String> asins, List<String> requiredSkills, List<String> storeIds) throws ApiException, LWAException {
        return this.getServiceJobsWithHttpInfo(marketplaceIds, serviceOrderIds, serviceJobStatus, pageToken, pageSize, sortField, sortOrder, createdAfter, createdBefore, lastUpdatedAfter, lastUpdatedBefore, scheduleStartDate, scheduleEndDate, asins, requiredSkills, storeIds, null);
    }

    public Call getServiceJobsAsync(List<String> marketplaceIds, List<String> serviceOrderIds, List<String> serviceJobStatus, String pageToken, Integer pageSize, String sortField, String sortOrder, String createdAfter, String createdBefore, String lastUpdatedAfter, String lastUpdatedBefore, String scheduleStartDate, String scheduleEndDate, List<String> asins, List<String> requiredSkills, List<String> storeIds, ApiCallback<GetServiceJobsResponse> callback) throws ApiException, LWAException {
        return this.getServiceJobsAsync(marketplaceIds, serviceOrderIds, serviceJobStatus, pageToken, pageSize, sortField, sortOrder, createdAfter, createdBefore, lastUpdatedAfter, lastUpdatedBefore, scheduleStartDate, scheduleEndDate, asins, requiredSkills, storeIds, callback, null);
    }

    public Call getServiceJobsAsync(List<String> marketplaceIds, List<String> serviceOrderIds, List<String> serviceJobStatus, String pageToken, Integer pageSize, String sortField, String sortOrder, String createdAfter, String createdBefore, String lastUpdatedAfter, String lastUpdatedBefore, String scheduleStartDate, String scheduleEndDate, List<String> asins, List<String> requiredSkills, List<String> storeIds, ApiCallback<GetServiceJobsResponse> callback, String restrictedDataToken) throws ApiException, LWAException {
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressRequestListener = callback::onUploadProgress;
        }
        Call call = this.getServiceJobsValidateBeforeCall(marketplaceIds, serviceOrderIds, serviceJobStatus, pageToken, pageSize, sortField, sortOrder, createdAfter, createdBefore, lastUpdatedAfter, lastUpdatedBefore, scheduleStartDate, scheduleEndDate, asins, requiredSkills, storeIds, progressRequestListener);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "ServiceApi-getServiceJobs");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.getServiceJobsBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<GetServiceJobsResponse>(){}.getType();
            this.apiClient.executeAsync(call, localVarReturnType, callback);
            return call;
        }
        throw new ApiException.RateLimitExceeded("getServiceJobs operation exceeds rate limit");
    }

    private Call rescheduleAppointmentForServiceJobByServiceJobIdCall(RescheduleAppointmentRequest body, String serviceJobId, String appointmentId, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        RescheduleAppointmentRequest localVarPostBody = body;
        String localVarPath = "/service/v1/serviceJobs/{serviceJobId}/appointments/{appointmentId}".equals("/uploads/2020-11-01/uploadDestinations/{resource}") ? "/service/v1/serviceJobs/{serviceJobId}/appointments/{appointmentId}".replaceAll("\\{serviceJobId\\}", serviceJobId.toString()).replaceAll("\\{appointmentId\\}", appointmentId.toString()) : "/service/v1/serviceJobs/{serviceJobId}/appointments/{appointmentId}".replaceAll("\\{serviceJobId\\}", this.apiClient.escapeString(serviceJobId.toString())).replaceAll("\\{appointmentId\\}", this.apiClient.escapeString(appointmentId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, progressRequestListener);
    }

    private Call rescheduleAppointmentForServiceJobByServiceJobIdValidateBeforeCall(RescheduleAppointmentRequest body, String serviceJobId, String appointmentId, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling rescheduleAppointmentForServiceJobByServiceJobId(Async)");
        }
        if (serviceJobId == null) {
            throw new ApiException("Missing the required parameter 'serviceJobId' when calling rescheduleAppointmentForServiceJobByServiceJobId(Async)");
        }
        if (appointmentId == null) {
            throw new ApiException("Missing the required parameter 'appointmentId' when calling rescheduleAppointmentForServiceJobByServiceJobId(Async)");
        }
        return this.rescheduleAppointmentForServiceJobByServiceJobIdCall(body, serviceJobId, appointmentId, progressRequestListener);
    }

    public SetAppointmentResponse rescheduleAppointmentForServiceJobByServiceJobId(RescheduleAppointmentRequest body, String serviceJobId, String appointmentId, String restrictedDataToken) throws ApiException, LWAException {
        ApiResponse<SetAppointmentResponse> resp = this.rescheduleAppointmentForServiceJobByServiceJobIdWithHttpInfo(body, serviceJobId, appointmentId, restrictedDataToken);
        return resp.getData();
    }

    public SetAppointmentResponse rescheduleAppointmentForServiceJobByServiceJobId(RescheduleAppointmentRequest body, String serviceJobId, String appointmentId) throws ApiException, LWAException {
        ApiResponse<SetAppointmentResponse> resp = this.rescheduleAppointmentForServiceJobByServiceJobIdWithHttpInfo(body, serviceJobId, appointmentId, null);
        return resp.getData();
    }

    public ApiResponse<SetAppointmentResponse> rescheduleAppointmentForServiceJobByServiceJobIdWithHttpInfo(RescheduleAppointmentRequest body, String serviceJobId, String appointmentId, String restrictedDataToken) throws ApiException, LWAException {
        Call call = this.rescheduleAppointmentForServiceJobByServiceJobIdValidateBeforeCall(body, serviceJobId, appointmentId, null);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "ServiceApi-rescheduleAppointmentForServiceJobByServiceJobId");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.rescheduleAppointmentForServiceJobByServiceJobIdBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<SetAppointmentResponse>(){}.getType();
            return this.apiClient.execute(call, localVarReturnType);
        }
        throw new ApiException.RateLimitExceeded("rescheduleAppointmentForServiceJobByServiceJobId operation exceeds rate limit");
    }

    public ApiResponse<SetAppointmentResponse> rescheduleAppointmentForServiceJobByServiceJobIdWithHttpInfo(RescheduleAppointmentRequest body, String serviceJobId, String appointmentId) throws ApiException, LWAException {
        return this.rescheduleAppointmentForServiceJobByServiceJobIdWithHttpInfo(body, serviceJobId, appointmentId, null);
    }

    public Call rescheduleAppointmentForServiceJobByServiceJobIdAsync(RescheduleAppointmentRequest body, String serviceJobId, String appointmentId, ApiCallback<SetAppointmentResponse> callback) throws ApiException, LWAException {
        return this.rescheduleAppointmentForServiceJobByServiceJobIdAsync(body, serviceJobId, appointmentId, callback, null);
    }

    public Call rescheduleAppointmentForServiceJobByServiceJobIdAsync(RescheduleAppointmentRequest body, String serviceJobId, String appointmentId, ApiCallback<SetAppointmentResponse> callback, String restrictedDataToken) throws ApiException, LWAException {
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressRequestListener = callback::onUploadProgress;
        }
        Call call = this.rescheduleAppointmentForServiceJobByServiceJobIdValidateBeforeCall(body, serviceJobId, appointmentId, progressRequestListener);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "ServiceApi-rescheduleAppointmentForServiceJobByServiceJobId");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.rescheduleAppointmentForServiceJobByServiceJobIdBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<SetAppointmentResponse>(){}.getType();
            this.apiClient.executeAsync(call, localVarReturnType, callback);
            return call;
        }
        throw new ApiException.RateLimitExceeded("rescheduleAppointmentForServiceJobByServiceJobId operation exceeds rate limit");
    }

    private Call setAppointmentFulfillmentDataCall(SetAppointmentFulfillmentDataRequest body, String serviceJobId, String appointmentId, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        SetAppointmentFulfillmentDataRequest localVarPostBody = body;
        String localVarPath = "/service/v1/serviceJobs/{serviceJobId}/appointments/{appointmentId}/fulfillment".equals("/uploads/2020-11-01/uploadDestinations/{resource}") ? "/service/v1/serviceJobs/{serviceJobId}/appointments/{appointmentId}/fulfillment".replaceAll("\\{serviceJobId\\}", serviceJobId.toString()).replaceAll("\\{appointmentId\\}", appointmentId.toString()) : "/service/v1/serviceJobs/{serviceJobId}/appointments/{appointmentId}/fulfillment".replaceAll("\\{serviceJobId\\}", this.apiClient.escapeString(serviceJobId.toString())).replaceAll("\\{appointmentId\\}", this.apiClient.escapeString(appointmentId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        return this.apiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, progressRequestListener);
    }

    private Call setAppointmentFulfillmentDataValidateBeforeCall(SetAppointmentFulfillmentDataRequest body, String serviceJobId, String appointmentId, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling setAppointmentFulfillmentData(Async)");
        }
        if (serviceJobId == null) {
            throw new ApiException("Missing the required parameter 'serviceJobId' when calling setAppointmentFulfillmentData(Async)");
        }
        if (appointmentId == null) {
            throw new ApiException("Missing the required parameter 'appointmentId' when calling setAppointmentFulfillmentData(Async)");
        }
        return this.setAppointmentFulfillmentDataCall(body, serviceJobId, appointmentId, progressRequestListener);
    }

    public String setAppointmentFulfillmentData(SetAppointmentFulfillmentDataRequest body, String serviceJobId, String appointmentId, String restrictedDataToken) throws ApiException, LWAException {
        ApiResponse<String> resp = this.setAppointmentFulfillmentDataWithHttpInfo(body, serviceJobId, appointmentId, restrictedDataToken);
        return resp.getData();
    }

    public String setAppointmentFulfillmentData(SetAppointmentFulfillmentDataRequest body, String serviceJobId, String appointmentId) throws ApiException, LWAException {
        ApiResponse<String> resp = this.setAppointmentFulfillmentDataWithHttpInfo(body, serviceJobId, appointmentId, null);
        return resp.getData();
    }

    public ApiResponse<String> setAppointmentFulfillmentDataWithHttpInfo(SetAppointmentFulfillmentDataRequest body, String serviceJobId, String appointmentId, String restrictedDataToken) throws ApiException, LWAException {
        Call call = this.setAppointmentFulfillmentDataValidateBeforeCall(body, serviceJobId, appointmentId, null);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "ServiceApi-setAppointmentFulfillmentData");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.setAppointmentFulfillmentDataBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<String>(){}.getType();
            return this.apiClient.execute(call, localVarReturnType);
        }
        throw new ApiException.RateLimitExceeded("setAppointmentFulfillmentData operation exceeds rate limit");
    }

    public ApiResponse<String> setAppointmentFulfillmentDataWithHttpInfo(SetAppointmentFulfillmentDataRequest body, String serviceJobId, String appointmentId) throws ApiException, LWAException {
        return this.setAppointmentFulfillmentDataWithHttpInfo(body, serviceJobId, appointmentId, null);
    }

    public Call setAppointmentFulfillmentDataAsync(SetAppointmentFulfillmentDataRequest body, String serviceJobId, String appointmentId, ApiCallback<String> callback) throws ApiException, LWAException {
        return this.setAppointmentFulfillmentDataAsync(body, serviceJobId, appointmentId, callback, null);
    }

    public Call setAppointmentFulfillmentDataAsync(SetAppointmentFulfillmentDataRequest body, String serviceJobId, String appointmentId, ApiCallback<String> callback, String restrictedDataToken) throws ApiException, LWAException {
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressRequestListener = callback::onUploadProgress;
        }
        Call call = this.setAppointmentFulfillmentDataValidateBeforeCall(body, serviceJobId, appointmentId, progressRequestListener);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "ServiceApi-setAppointmentFulfillmentData");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.setAppointmentFulfillmentDataBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<String>(){}.getType();
            this.apiClient.executeAsync(call, localVarReturnType, callback);
            return call;
        }
        throw new ApiException.RateLimitExceeded("setAppointmentFulfillmentData operation exceeds rate limit");
    }

    private Call updateReservationCall(UpdateReservationRequest body, String reservationId, List<String> marketplaceIds, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        UpdateReservationRequest localVarPostBody = body;
        String localVarPath = "/service/v1/reservation/{reservationId}".equals("/uploads/2020-11-01/uploadDestinations/{resource}") ? "/service/v1/reservation/{reservationId}".replaceAll("\\{reservationId\\}", reservationId.toString()) : "/service/v1/reservation/{reservationId}".replaceAll("\\{reservationId\\}", this.apiClient.escapeString(reservationId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (marketplaceIds != null) {
            localVarCollectionQueryParams.addAll(this.apiClient.parameterToPairs("csv", "marketplaceIds", marketplaceIds));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        return this.apiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, progressRequestListener);
    }

    private Call updateReservationValidateBeforeCall(UpdateReservationRequest body, String reservationId, List<String> marketplaceIds, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling updateReservation(Async)");
        }
        if (reservationId == null) {
            throw new ApiException("Missing the required parameter 'reservationId' when calling updateReservation(Async)");
        }
        if (marketplaceIds == null) {
            throw new ApiException("Missing the required parameter 'marketplaceIds' when calling updateReservation(Async)");
        }
        return this.updateReservationCall(body, reservationId, marketplaceIds, progressRequestListener);
    }

    public UpdateReservationResponse updateReservation(UpdateReservationRequest body, String reservationId, List<String> marketplaceIds, String restrictedDataToken) throws ApiException, LWAException {
        ApiResponse<UpdateReservationResponse> resp = this.updateReservationWithHttpInfo(body, reservationId, marketplaceIds, restrictedDataToken);
        return resp.getData();
    }

    public UpdateReservationResponse updateReservation(UpdateReservationRequest body, String reservationId, List<String> marketplaceIds) throws ApiException, LWAException {
        ApiResponse<UpdateReservationResponse> resp = this.updateReservationWithHttpInfo(body, reservationId, marketplaceIds, null);
        return resp.getData();
    }

    public ApiResponse<UpdateReservationResponse> updateReservationWithHttpInfo(UpdateReservationRequest body, String reservationId, List<String> marketplaceIds, String restrictedDataToken) throws ApiException, LWAException {
        Call call = this.updateReservationValidateBeforeCall(body, reservationId, marketplaceIds, null);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "ServiceApi-updateReservation");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.updateReservationBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<UpdateReservationResponse>(){}.getType();
            return this.apiClient.execute(call, localVarReturnType);
        }
        throw new ApiException.RateLimitExceeded("updateReservation operation exceeds rate limit");
    }

    public ApiResponse<UpdateReservationResponse> updateReservationWithHttpInfo(UpdateReservationRequest body, String reservationId, List<String> marketplaceIds) throws ApiException, LWAException {
        return this.updateReservationWithHttpInfo(body, reservationId, marketplaceIds, null);
    }

    public Call updateReservationAsync(UpdateReservationRequest body, String reservationId, List<String> marketplaceIds, ApiCallback<UpdateReservationResponse> callback) throws ApiException, LWAException {
        return this.updateReservationAsync(body, reservationId, marketplaceIds, callback, null);
    }

    public Call updateReservationAsync(UpdateReservationRequest body, String reservationId, List<String> marketplaceIds, ApiCallback<UpdateReservationResponse> callback, String restrictedDataToken) throws ApiException, LWAException {
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressRequestListener = callback::onUploadProgress;
        }
        Call call = this.updateReservationValidateBeforeCall(body, reservationId, marketplaceIds, progressRequestListener);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "ServiceApi-updateReservation");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.updateReservationBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<UpdateReservationResponse>(){}.getType();
            this.apiClient.executeAsync(call, localVarReturnType, callback);
            return call;
        }
        throw new ApiException.RateLimitExceeded("updateReservation operation exceeds rate limit");
    }

    private Call updateScheduleCall(UpdateScheduleRequest body, String resourceId, List<String> marketplaceIds, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        UpdateScheduleRequest localVarPostBody = body;
        String localVarPath = "/service/v1/serviceResources/{resourceId}/schedules".equals("/uploads/2020-11-01/uploadDestinations/{resource}") ? "/service/v1/serviceResources/{resourceId}/schedules".replaceAll("\\{resourceId\\}", resourceId.toString()) : "/service/v1/serviceResources/{resourceId}/schedules".replaceAll("\\{resourceId\\}", this.apiClient.escapeString(resourceId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (marketplaceIds != null) {
            localVarCollectionQueryParams.addAll(this.apiClient.parameterToPairs("csv", "marketplaceIds", marketplaceIds));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        return this.apiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, progressRequestListener);
    }

    private Call updateScheduleValidateBeforeCall(UpdateScheduleRequest body, String resourceId, List<String> marketplaceIds, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling updateSchedule(Async)");
        }
        if (resourceId == null) {
            throw new ApiException("Missing the required parameter 'resourceId' when calling updateSchedule(Async)");
        }
        if (marketplaceIds == null) {
            throw new ApiException("Missing the required parameter 'marketplaceIds' when calling updateSchedule(Async)");
        }
        return this.updateScheduleCall(body, resourceId, marketplaceIds, progressRequestListener);
    }

    public UpdateScheduleResponse updateSchedule(UpdateScheduleRequest body, String resourceId, List<String> marketplaceIds, String restrictedDataToken) throws ApiException, LWAException {
        ApiResponse<UpdateScheduleResponse> resp = this.updateScheduleWithHttpInfo(body, resourceId, marketplaceIds, restrictedDataToken);
        return resp.getData();
    }

    public UpdateScheduleResponse updateSchedule(UpdateScheduleRequest body, String resourceId, List<String> marketplaceIds) throws ApiException, LWAException {
        ApiResponse<UpdateScheduleResponse> resp = this.updateScheduleWithHttpInfo(body, resourceId, marketplaceIds, null);
        return resp.getData();
    }

    public ApiResponse<UpdateScheduleResponse> updateScheduleWithHttpInfo(UpdateScheduleRequest body, String resourceId, List<String> marketplaceIds, String restrictedDataToken) throws ApiException, LWAException {
        Call call = this.updateScheduleValidateBeforeCall(body, resourceId, marketplaceIds, null);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "ServiceApi-updateSchedule");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.updateScheduleBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<UpdateScheduleResponse>(){}.getType();
            return this.apiClient.execute(call, localVarReturnType);
        }
        throw new ApiException.RateLimitExceeded("updateSchedule operation exceeds rate limit");
    }

    public ApiResponse<UpdateScheduleResponse> updateScheduleWithHttpInfo(UpdateScheduleRequest body, String resourceId, List<String> marketplaceIds) throws ApiException, LWAException {
        return this.updateScheduleWithHttpInfo(body, resourceId, marketplaceIds, null);
    }

    public Call updateScheduleAsync(UpdateScheduleRequest body, String resourceId, List<String> marketplaceIds, ApiCallback<UpdateScheduleResponse> callback) throws ApiException, LWAException {
        return this.updateScheduleAsync(body, resourceId, marketplaceIds, callback, null);
    }

    public Call updateScheduleAsync(UpdateScheduleRequest body, String resourceId, List<String> marketplaceIds, ApiCallback<UpdateScheduleResponse> callback, String restrictedDataToken) throws ApiException, LWAException {
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressRequestListener = callback::onUploadProgress;
        }
        Call call = this.updateScheduleValidateBeforeCall(body, resourceId, marketplaceIds, progressRequestListener);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "ServiceApi-updateSchedule");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.updateScheduleBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<UpdateScheduleResponse>(){}.getType();
            this.apiClient.executeAsync(call, localVarReturnType, callback);
            return call;
        }
        throw new ApiException.RateLimitExceeded("updateSchedule operation exceeds rate limit");
    }

    public static class Builder {
        private LWAAuthorizationCredentials lwaAuthorizationCredentials;
        private String endpoint;
        private LWAAccessTokenCache lwaAccessTokenCache;
        private Boolean disableAccessTokenCache = false;
        private Boolean disableRateLimiting = false;

        public Builder lwaAuthorizationCredentials(LWAAuthorizationCredentials lwaAuthorizationCredentials) {
            this.lwaAuthorizationCredentials = lwaAuthorizationCredentials;
            return this;
        }

        public Builder endpoint(String endpoint) {
            this.endpoint = endpoint;
            return this;
        }

        public Builder lwaAccessTokenCache(LWAAccessTokenCache lwaAccessTokenCache) {
            this.lwaAccessTokenCache = lwaAccessTokenCache;
            return this;
        }

        public Builder disableAccessTokenCache() {
            this.disableAccessTokenCache = true;
            return this;
        }

        public Builder disableRateLimiting() {
            this.disableRateLimiting = true;
            return this;
        }

        public ServiceApi build() {
            if (this.lwaAuthorizationCredentials == null) {
                throw new RuntimeException("LWAAuthorizationCredentials not set");
            }
            if (StringUtil.isEmpty(this.endpoint)) {
                throw new RuntimeException("Endpoint not set");
            }
            LWAAuthorizationSigner lwaAuthorizationSigner = null;
            if (this.disableAccessTokenCache.booleanValue()) {
                lwaAuthorizationSigner = new LWAAuthorizationSigner(this.lwaAuthorizationCredentials);
            } else {
                if (this.lwaAccessTokenCache == null) {
                    this.lwaAccessTokenCache = new LWAAccessTokenCacheImpl();
                }
                lwaAuthorizationSigner = new LWAAuthorizationSigner(this.lwaAuthorizationCredentials, this.lwaAccessTokenCache);
            }
            return new ServiceApi(new ApiClient().setLWAAuthorizationSigner(lwaAuthorizationSigner).setBasePath(this.endpoint), this.disableRateLimiting);
        }
    }
}

