/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.api.sellerwallet.v2024_03_01;

import com.amazon.SellingPartnerAPIAA.LWAAccessTokenCache;
import com.amazon.SellingPartnerAPIAA.LWAAccessTokenCacheImpl;
import com.amazon.SellingPartnerAPIAA.LWAAuthorizationCredentials;
import com.amazon.SellingPartnerAPIAA.LWAAuthorizationSigner;
import com.amazon.SellingPartnerAPIAA.LWAException;
import com.amazon.SellingPartnerAPIAA.RestrictedDataTokenSigner;
import com.google.gson.reflect.TypeToken;
import io.github.bucket4j.Bucket;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import okhttp3.Call;
import okhttp3.Request;
import software.amazon.spapi.ApiCallback;
import software.amazon.spapi.ApiClient;
import software.amazon.spapi.ApiException;
import software.amazon.spapi.ApiResponse;
import software.amazon.spapi.Configuration;
import software.amazon.spapi.Pair;
import software.amazon.spapi.ProgressRequestBody;
import software.amazon.spapi.StringUtil;
import software.amazon.spapi.models.sellerwallet.v2024_03_01.TransferRatePreview;

public class TransferPreviewApi {
    private ApiClient apiClient;
    private Boolean disableRateLimiting;
    private final Configuration config = Configuration.get();
    public final Bucket getTransferPreviewBucket = Bucket.builder().addLimit(this.config.getLimit("TransferPreviewApi-getTransferPreview")).build();

    public TransferPreviewApi(ApiClient apiClient, Boolean disableRateLimiting) {
        this.apiClient = apiClient;
        this.disableRateLimiting = disableRateLimiting;
    }

    private Call getTransferPreviewCall(String sourceCountryCode, String sourceCurrencyCode, String destinationCountryCode, String destinationCurrencyCode, BigDecimal baseAmount, String marketplaceId, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        Object localVarPostBody = null;
        String localVarPath = "/finances/transfers/wallet/2024-03-01/transferPreview".equals("/uploads/2020-11-01/uploadDestinations/{resource}") ? "/finances/transfers/wallet/2024-03-01/transferPreview" : "/finances/transfers/wallet/2024-03-01/transferPreview";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (sourceCountryCode != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("sourceCountryCode", sourceCountryCode));
        }
        if (sourceCurrencyCode != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("sourceCurrencyCode", sourceCurrencyCode));
        }
        if (destinationCountryCode != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("destinationCountryCode", destinationCountryCode));
        }
        if (destinationCurrencyCode != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("destinationCurrencyCode", destinationCurrencyCode));
        }
        if (baseAmount != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("baseAmount", baseAmount));
        }
        if (marketplaceId != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("marketplaceId", marketplaceId));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, progressRequestListener);
    }

    private Call getTransferPreviewValidateBeforeCall(String sourceCountryCode, String sourceCurrencyCode, String destinationCountryCode, String destinationCurrencyCode, BigDecimal baseAmount, String marketplaceId, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        if (sourceCountryCode == null) {
            throw new ApiException("Missing the required parameter 'sourceCountryCode' when calling getTransferPreview(Async)");
        }
        if (sourceCurrencyCode == null) {
            throw new ApiException("Missing the required parameter 'sourceCurrencyCode' when calling getTransferPreview(Async)");
        }
        if (destinationCountryCode == null) {
            throw new ApiException("Missing the required parameter 'destinationCountryCode' when calling getTransferPreview(Async)");
        }
        if (destinationCurrencyCode == null) {
            throw new ApiException("Missing the required parameter 'destinationCurrencyCode' when calling getTransferPreview(Async)");
        }
        if (baseAmount == null) {
            throw new ApiException("Missing the required parameter 'baseAmount' when calling getTransferPreview(Async)");
        }
        if (marketplaceId == null) {
            throw new ApiException("Missing the required parameter 'marketplaceId' when calling getTransferPreview(Async)");
        }
        return this.getTransferPreviewCall(sourceCountryCode, sourceCurrencyCode, destinationCountryCode, destinationCurrencyCode, baseAmount, marketplaceId, progressRequestListener);
    }

    public TransferRatePreview getTransferPreview(String sourceCountryCode, String sourceCurrencyCode, String destinationCountryCode, String destinationCurrencyCode, BigDecimal baseAmount, String marketplaceId, String restrictedDataToken) throws ApiException, LWAException {
        ApiResponse<TransferRatePreview> resp = this.getTransferPreviewWithHttpInfo(sourceCountryCode, sourceCurrencyCode, destinationCountryCode, destinationCurrencyCode, baseAmount, marketplaceId, restrictedDataToken);
        return resp.getData();
    }

    public TransferRatePreview getTransferPreview(String sourceCountryCode, String sourceCurrencyCode, String destinationCountryCode, String destinationCurrencyCode, BigDecimal baseAmount, String marketplaceId) throws ApiException, LWAException {
        ApiResponse<TransferRatePreview> resp = this.getTransferPreviewWithHttpInfo(sourceCountryCode, sourceCurrencyCode, destinationCountryCode, destinationCurrencyCode, baseAmount, marketplaceId, null);
        return resp.getData();
    }

    public ApiResponse<TransferRatePreview> getTransferPreviewWithHttpInfo(String sourceCountryCode, String sourceCurrencyCode, String destinationCountryCode, String destinationCurrencyCode, BigDecimal baseAmount, String marketplaceId, String restrictedDataToken) throws ApiException, LWAException {
        Call call = this.getTransferPreviewValidateBeforeCall(sourceCountryCode, sourceCurrencyCode, destinationCountryCode, destinationCurrencyCode, baseAmount, marketplaceId, null);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "TransferPreviewApi-getTransferPreview");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.getTransferPreviewBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<TransferRatePreview>(){}.getType();
            return this.apiClient.execute(call, localVarReturnType);
        }
        throw new ApiException.RateLimitExceeded("getTransferPreview operation exceeds rate limit");
    }

    public ApiResponse<TransferRatePreview> getTransferPreviewWithHttpInfo(String sourceCountryCode, String sourceCurrencyCode, String destinationCountryCode, String destinationCurrencyCode, BigDecimal baseAmount, String marketplaceId) throws ApiException, LWAException {
        return this.getTransferPreviewWithHttpInfo(sourceCountryCode, sourceCurrencyCode, destinationCountryCode, destinationCurrencyCode, baseAmount, marketplaceId, null);
    }

    public Call getTransferPreviewAsync(String sourceCountryCode, String sourceCurrencyCode, String destinationCountryCode, String destinationCurrencyCode, BigDecimal baseAmount, String marketplaceId, ApiCallback<TransferRatePreview> callback) throws ApiException, LWAException {
        return this.getTransferPreviewAsync(sourceCountryCode, sourceCurrencyCode, destinationCountryCode, destinationCurrencyCode, baseAmount, marketplaceId, callback, null);
    }

    public Call getTransferPreviewAsync(String sourceCountryCode, String sourceCurrencyCode, String destinationCountryCode, String destinationCurrencyCode, BigDecimal baseAmount, String marketplaceId, ApiCallback<TransferRatePreview> callback, String restrictedDataToken) throws ApiException, LWAException {
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressRequestListener = callback::onUploadProgress;
        }
        Call call = this.getTransferPreviewValidateBeforeCall(sourceCountryCode, sourceCurrencyCode, destinationCountryCode, destinationCurrencyCode, baseAmount, marketplaceId, progressRequestListener);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "TransferPreviewApi-getTransferPreview");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.getTransferPreviewBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<TransferRatePreview>(){}.getType();
            this.apiClient.executeAsync(call, localVarReturnType, callback);
            return call;
        }
        throw new ApiException.RateLimitExceeded("getTransferPreview operation exceeds rate limit");
    }

    public static class Builder {
        private LWAAuthorizationCredentials lwaAuthorizationCredentials;
        private String endpoint;
        private LWAAccessTokenCache lwaAccessTokenCache;
        private Boolean disableAccessTokenCache = false;
        private Boolean disableRateLimiting = false;

        public Builder lwaAuthorizationCredentials(LWAAuthorizationCredentials lwaAuthorizationCredentials) {
            this.lwaAuthorizationCredentials = lwaAuthorizationCredentials;
            return this;
        }

        public Builder endpoint(String endpoint) {
            this.endpoint = endpoint;
            return this;
        }

        public Builder lwaAccessTokenCache(LWAAccessTokenCache lwaAccessTokenCache) {
            this.lwaAccessTokenCache = lwaAccessTokenCache;
            return this;
        }

        public Builder disableAccessTokenCache() {
            this.disableAccessTokenCache = true;
            return this;
        }

        public Builder disableRateLimiting() {
            this.disableRateLimiting = true;
            return this;
        }

        public TransferPreviewApi build() {
            if (this.lwaAuthorizationCredentials == null) {
                throw new RuntimeException("LWAAuthorizationCredentials not set");
            }
            if (StringUtil.isEmpty(this.endpoint)) {
                throw new RuntimeException("Endpoint not set");
            }
            LWAAuthorizationSigner lwaAuthorizationSigner = null;
            if (this.disableAccessTokenCache.booleanValue()) {
                lwaAuthorizationSigner = new LWAAuthorizationSigner(this.lwaAuthorizationCredentials);
            } else {
                if (this.lwaAccessTokenCache == null) {
                    this.lwaAccessTokenCache = new LWAAccessTokenCacheImpl();
                }
                lwaAuthorizationSigner = new LWAAuthorizationSigner(this.lwaAuthorizationCredentials, this.lwaAccessTokenCache);
            }
            return new TransferPreviewApi(new ApiClient().setLWAAuthorizationSigner(lwaAuthorizationSigner).setBasePath(this.endpoint), this.disableRateLimiting);
        }
    }
}

