/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.api.sellerwallet.v2024_03_01;

import com.amazon.SellingPartnerAPIAA.LWAAccessTokenCache;
import com.amazon.SellingPartnerAPIAA.LWAAccessTokenCacheImpl;
import com.amazon.SellingPartnerAPIAA.LWAAuthorizationCredentials;
import com.amazon.SellingPartnerAPIAA.LWAAuthorizationSigner;
import com.amazon.SellingPartnerAPIAA.LWAException;
import com.amazon.SellingPartnerAPIAA.RestrictedDataTokenSigner;
import com.google.gson.reflect.TypeToken;
import io.github.bucket4j.Bucket;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import okhttp3.Call;
import okhttp3.Request;
import software.amazon.spapi.ApiCallback;
import software.amazon.spapi.ApiClient;
import software.amazon.spapi.ApiException;
import software.amazon.spapi.ApiResponse;
import software.amazon.spapi.Configuration;
import software.amazon.spapi.Pair;
import software.amazon.spapi.ProgressRequestBody;
import software.amazon.spapi.StringUtil;
import software.amazon.spapi.models.sellerwallet.v2024_03_01.CreateTransactionResponse;
import software.amazon.spapi.models.sellerwallet.v2024_03_01.Transaction;
import software.amazon.spapi.models.sellerwallet.v2024_03_01.TransactionInitiationRequest;
import software.amazon.spapi.models.sellerwallet.v2024_03_01.TransactionListing;

public class TransactionsApi {
    private ApiClient apiClient;
    private Boolean disableRateLimiting;
    private final Configuration config = Configuration.get();
    public final Bucket createTransactionBucket = Bucket.builder().addLimit(this.config.getLimit("TransactionsApi-createTransaction")).build();
    public final Bucket getTransactionBucket = Bucket.builder().addLimit(this.config.getLimit("TransactionsApi-getTransaction")).build();
    public final Bucket listAccountTransactionsBucket = Bucket.builder().addLimit(this.config.getLimit("TransactionsApi-listAccountTransactions")).build();

    public TransactionsApi(ApiClient apiClient, Boolean disableRateLimiting) {
        this.apiClient = apiClient;
        this.disableRateLimiting = disableRateLimiting;
    }

    private Call createTransactionCall(TransactionInitiationRequest body, String destAccountDigitalSignature, String amountDigitalSignature, String marketplaceId, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        TransactionInitiationRequest localVarPostBody = body;
        String localVarPath = "/finances/transfers/wallet/2024-03-01/transactions".equals("/uploads/2020-11-01/uploadDestinations/{resource}") ? "/finances/transfers/wallet/2024-03-01/transactions" : "/finances/transfers/wallet/2024-03-01/transactions";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (marketplaceId != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("marketplaceId", marketplaceId));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (destAccountDigitalSignature != null) {
            localVarHeaderParams.put("destAccountDigitalSignature", this.apiClient.parameterToString(destAccountDigitalSignature));
        }
        if (amountDigitalSignature != null) {
            localVarHeaderParams.put("amountDigitalSignature", this.apiClient.parameterToString(amountDigitalSignature));
        }
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, progressRequestListener);
    }

    private Call createTransactionValidateBeforeCall(TransactionInitiationRequest body, String destAccountDigitalSignature, String amountDigitalSignature, String marketplaceId, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling createTransaction(Async)");
        }
        if (destAccountDigitalSignature == null) {
            throw new ApiException("Missing the required parameter 'destAccountDigitalSignature' when calling createTransaction(Async)");
        }
        if (amountDigitalSignature == null) {
            throw new ApiException("Missing the required parameter 'amountDigitalSignature' when calling createTransaction(Async)");
        }
        if (marketplaceId == null) {
            throw new ApiException("Missing the required parameter 'marketplaceId' when calling createTransaction(Async)");
        }
        return this.createTransactionCall(body, destAccountDigitalSignature, amountDigitalSignature, marketplaceId, progressRequestListener);
    }

    public CreateTransactionResponse createTransaction(TransactionInitiationRequest body, String destAccountDigitalSignature, String amountDigitalSignature, String marketplaceId, String restrictedDataToken) throws ApiException, LWAException {
        ApiResponse<CreateTransactionResponse> resp = this.createTransactionWithHttpInfo(body, destAccountDigitalSignature, amountDigitalSignature, marketplaceId, restrictedDataToken);
        return resp.getData();
    }

    public CreateTransactionResponse createTransaction(TransactionInitiationRequest body, String destAccountDigitalSignature, String amountDigitalSignature, String marketplaceId) throws ApiException, LWAException {
        ApiResponse<CreateTransactionResponse> resp = this.createTransactionWithHttpInfo(body, destAccountDigitalSignature, amountDigitalSignature, marketplaceId, null);
        return resp.getData();
    }

    public ApiResponse<CreateTransactionResponse> createTransactionWithHttpInfo(TransactionInitiationRequest body, String destAccountDigitalSignature, String amountDigitalSignature, String marketplaceId, String restrictedDataToken) throws ApiException, LWAException {
        Call call = this.createTransactionValidateBeforeCall(body, destAccountDigitalSignature, amountDigitalSignature, marketplaceId, null);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "TransactionsApi-createTransaction");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.createTransactionBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<CreateTransactionResponse>(){}.getType();
            return this.apiClient.execute(call, localVarReturnType);
        }
        throw new ApiException.RateLimitExceeded("createTransaction operation exceeds rate limit");
    }

    public ApiResponse<CreateTransactionResponse> createTransactionWithHttpInfo(TransactionInitiationRequest body, String destAccountDigitalSignature, String amountDigitalSignature, String marketplaceId) throws ApiException, LWAException {
        return this.createTransactionWithHttpInfo(body, destAccountDigitalSignature, amountDigitalSignature, marketplaceId, null);
    }

    public Call createTransactionAsync(TransactionInitiationRequest body, String destAccountDigitalSignature, String amountDigitalSignature, String marketplaceId, ApiCallback<CreateTransactionResponse> callback) throws ApiException, LWAException {
        return this.createTransactionAsync(body, destAccountDigitalSignature, amountDigitalSignature, marketplaceId, callback, null);
    }

    public Call createTransactionAsync(TransactionInitiationRequest body, String destAccountDigitalSignature, String amountDigitalSignature, String marketplaceId, ApiCallback<CreateTransactionResponse> callback, String restrictedDataToken) throws ApiException, LWAException {
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressRequestListener = callback::onUploadProgress;
        }
        Call call = this.createTransactionValidateBeforeCall(body, destAccountDigitalSignature, amountDigitalSignature, marketplaceId, progressRequestListener);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "TransactionsApi-createTransaction");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.createTransactionBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<CreateTransactionResponse>(){}.getType();
            this.apiClient.executeAsync(call, localVarReturnType, callback);
            return call;
        }
        throw new ApiException.RateLimitExceeded("createTransaction operation exceeds rate limit");
    }

    private Call getTransactionCall(String transactionId, String marketplaceId, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        Object localVarPostBody = null;
        String localVarPath = "/finances/transfers/wallet/2024-03-01/transactions/{transactionId}".equals("/uploads/2020-11-01/uploadDestinations/{resource}") ? "/finances/transfers/wallet/2024-03-01/transactions/{transactionId}".replaceAll("\\{transactionId\\}", transactionId.toString()) : "/finances/transfers/wallet/2024-03-01/transactions/{transactionId}".replaceAll("\\{transactionId\\}", this.apiClient.escapeString(transactionId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (marketplaceId != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("marketplaceId", marketplaceId));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, progressRequestListener);
    }

    private Call getTransactionValidateBeforeCall(String transactionId, String marketplaceId, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        if (transactionId == null) {
            throw new ApiException("Missing the required parameter 'transactionId' when calling getTransaction(Async)");
        }
        if (marketplaceId == null) {
            throw new ApiException("Missing the required parameter 'marketplaceId' when calling getTransaction(Async)");
        }
        return this.getTransactionCall(transactionId, marketplaceId, progressRequestListener);
    }

    public Transaction getTransaction(String transactionId, String marketplaceId, String restrictedDataToken) throws ApiException, LWAException {
        ApiResponse<Transaction> resp = this.getTransactionWithHttpInfo(transactionId, marketplaceId, restrictedDataToken);
        return resp.getData();
    }

    public Transaction getTransaction(String transactionId, String marketplaceId) throws ApiException, LWAException {
        ApiResponse<Transaction> resp = this.getTransactionWithHttpInfo(transactionId, marketplaceId, null);
        return resp.getData();
    }

    public ApiResponse<Transaction> getTransactionWithHttpInfo(String transactionId, String marketplaceId, String restrictedDataToken) throws ApiException, LWAException {
        Call call = this.getTransactionValidateBeforeCall(transactionId, marketplaceId, null);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "TransactionsApi-getTransaction");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.getTransactionBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<Transaction>(){}.getType();
            return this.apiClient.execute(call, localVarReturnType);
        }
        throw new ApiException.RateLimitExceeded("getTransaction operation exceeds rate limit");
    }

    public ApiResponse<Transaction> getTransactionWithHttpInfo(String transactionId, String marketplaceId) throws ApiException, LWAException {
        return this.getTransactionWithHttpInfo(transactionId, marketplaceId, null);
    }

    public Call getTransactionAsync(String transactionId, String marketplaceId, ApiCallback<Transaction> callback) throws ApiException, LWAException {
        return this.getTransactionAsync(transactionId, marketplaceId, callback, null);
    }

    public Call getTransactionAsync(String transactionId, String marketplaceId, ApiCallback<Transaction> callback, String restrictedDataToken) throws ApiException, LWAException {
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressRequestListener = callback::onUploadProgress;
        }
        Call call = this.getTransactionValidateBeforeCall(transactionId, marketplaceId, progressRequestListener);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "TransactionsApi-getTransaction");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.getTransactionBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<Transaction>(){}.getType();
            this.apiClient.executeAsync(call, localVarReturnType, callback);
            return call;
        }
        throw new ApiException.RateLimitExceeded("getTransaction operation exceeds rate limit");
    }

    private Call listAccountTransactionsCall(String accountId, String marketplaceId, String nextPageToken, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        Object localVarPostBody = null;
        String localVarPath = "/finances/transfers/wallet/2024-03-01/transactions".equals("/uploads/2020-11-01/uploadDestinations/{resource}") ? "/finances/transfers/wallet/2024-03-01/transactions" : "/finances/transfers/wallet/2024-03-01/transactions";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (accountId != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("accountId", accountId));
        }
        if (nextPageToken != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("nextPageToken", nextPageToken));
        }
        if (marketplaceId != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("marketplaceId", marketplaceId));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, progressRequestListener);
    }

    private Call listAccountTransactionsValidateBeforeCall(String accountId, String marketplaceId, String nextPageToken, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        if (accountId == null) {
            throw new ApiException("Missing the required parameter 'accountId' when calling listAccountTransactions(Async)");
        }
        if (marketplaceId == null) {
            throw new ApiException("Missing the required parameter 'marketplaceId' when calling listAccountTransactions(Async)");
        }
        return this.listAccountTransactionsCall(accountId, marketplaceId, nextPageToken, progressRequestListener);
    }

    public TransactionListing listAccountTransactions(String accountId, String marketplaceId, String nextPageToken, String restrictedDataToken) throws ApiException, LWAException {
        ApiResponse<TransactionListing> resp = this.listAccountTransactionsWithHttpInfo(accountId, marketplaceId, nextPageToken, restrictedDataToken);
        return resp.getData();
    }

    public TransactionListing listAccountTransactions(String accountId, String marketplaceId, String nextPageToken) throws ApiException, LWAException {
        ApiResponse<TransactionListing> resp = this.listAccountTransactionsWithHttpInfo(accountId, marketplaceId, nextPageToken, null);
        return resp.getData();
    }

    public ApiResponse<TransactionListing> listAccountTransactionsWithHttpInfo(String accountId, String marketplaceId, String nextPageToken, String restrictedDataToken) throws ApiException, LWAException {
        Call call = this.listAccountTransactionsValidateBeforeCall(accountId, marketplaceId, nextPageToken, null);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "TransactionsApi-listAccountTransactions");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.listAccountTransactionsBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<TransactionListing>(){}.getType();
            return this.apiClient.execute(call, localVarReturnType);
        }
        throw new ApiException.RateLimitExceeded("listAccountTransactions operation exceeds rate limit");
    }

    public ApiResponse<TransactionListing> listAccountTransactionsWithHttpInfo(String accountId, String marketplaceId, String nextPageToken) throws ApiException, LWAException {
        return this.listAccountTransactionsWithHttpInfo(accountId, marketplaceId, nextPageToken, null);
    }

    public Call listAccountTransactionsAsync(String accountId, String marketplaceId, String nextPageToken, ApiCallback<TransactionListing> callback) throws ApiException, LWAException {
        return this.listAccountTransactionsAsync(accountId, marketplaceId, nextPageToken, callback, null);
    }

    public Call listAccountTransactionsAsync(String accountId, String marketplaceId, String nextPageToken, ApiCallback<TransactionListing> callback, String restrictedDataToken) throws ApiException, LWAException {
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressRequestListener = callback::onUploadProgress;
        }
        Call call = this.listAccountTransactionsValidateBeforeCall(accountId, marketplaceId, nextPageToken, progressRequestListener);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "TransactionsApi-listAccountTransactions");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.listAccountTransactionsBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<TransactionListing>(){}.getType();
            this.apiClient.executeAsync(call, localVarReturnType, callback);
            return call;
        }
        throw new ApiException.RateLimitExceeded("listAccountTransactions operation exceeds rate limit");
    }

    public static class Builder {
        private LWAAuthorizationCredentials lwaAuthorizationCredentials;
        private String endpoint;
        private LWAAccessTokenCache lwaAccessTokenCache;
        private Boolean disableAccessTokenCache = false;
        private Boolean disableRateLimiting = false;

        public Builder lwaAuthorizationCredentials(LWAAuthorizationCredentials lwaAuthorizationCredentials) {
            this.lwaAuthorizationCredentials = lwaAuthorizationCredentials;
            return this;
        }

        public Builder endpoint(String endpoint) {
            this.endpoint = endpoint;
            return this;
        }

        public Builder lwaAccessTokenCache(LWAAccessTokenCache lwaAccessTokenCache) {
            this.lwaAccessTokenCache = lwaAccessTokenCache;
            return this;
        }

        public Builder disableAccessTokenCache() {
            this.disableAccessTokenCache = true;
            return this;
        }

        public Builder disableRateLimiting() {
            this.disableRateLimiting = true;
            return this;
        }

        public TransactionsApi build() {
            if (this.lwaAuthorizationCredentials == null) {
                throw new RuntimeException("LWAAuthorizationCredentials not set");
            }
            if (StringUtil.isEmpty(this.endpoint)) {
                throw new RuntimeException("Endpoint not set");
            }
            LWAAuthorizationSigner lwaAuthorizationSigner = null;
            if (this.disableAccessTokenCache.booleanValue()) {
                lwaAuthorizationSigner = new LWAAuthorizationSigner(this.lwaAuthorizationCredentials);
            } else {
                if (this.lwaAccessTokenCache == null) {
                    this.lwaAccessTokenCache = new LWAAccessTokenCacheImpl();
                }
                lwaAuthorizationSigner = new LWAAuthorizationSigner(this.lwaAuthorizationCredentials, this.lwaAccessTokenCache);
            }
            return new TransactionsApi(new ApiClient().setLWAAuthorizationSigner(lwaAuthorizationSigner).setBasePath(this.endpoint), this.disableRateLimiting);
        }
    }
}

