/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.api.sellerwallet.v2024_03_01;

import com.amazon.SellingPartnerAPIAA.LWAAccessTokenCache;
import com.amazon.SellingPartnerAPIAA.LWAAccessTokenCacheImpl;
import com.amazon.SellingPartnerAPIAA.LWAAuthorizationCredentials;
import com.amazon.SellingPartnerAPIAA.LWAAuthorizationSigner;
import com.amazon.SellingPartnerAPIAA.LWAException;
import com.amazon.SellingPartnerAPIAA.RestrictedDataTokenSigner;
import com.google.gson.reflect.TypeToken;
import io.github.bucket4j.Bucket;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import okhttp3.Call;
import okhttp3.Request;
import software.amazon.spapi.ApiCallback;
import software.amazon.spapi.ApiClient;
import software.amazon.spapi.ApiException;
import software.amazon.spapi.ApiResponse;
import software.amazon.spapi.Configuration;
import software.amazon.spapi.Pair;
import software.amazon.spapi.ProgressRequestBody;
import software.amazon.spapi.StringUtil;
import software.amazon.spapi.models.sellerwallet.v2024_03_01.BalanceListing;
import software.amazon.spapi.models.sellerwallet.v2024_03_01.BankAccount;
import software.amazon.spapi.models.sellerwallet.v2024_03_01.BankAccountListing;

public class AccountsApi {
    private ApiClient apiClient;
    private Boolean disableRateLimiting;
    private final Configuration config = Configuration.get();
    public final Bucket getAccountBucket = Bucket.builder().addLimit(this.config.getLimit("AccountsApi-getAccount")).build();
    public final Bucket listAccountBalancesBucket = Bucket.builder().addLimit(this.config.getLimit("AccountsApi-listAccountBalances")).build();
    public final Bucket listAccountsBucket = Bucket.builder().addLimit(this.config.getLimit("AccountsApi-listAccounts")).build();

    public AccountsApi(ApiClient apiClient, Boolean disableRateLimiting) {
        this.apiClient = apiClient;
        this.disableRateLimiting = disableRateLimiting;
    }

    private Call getAccountCall(String accountId, String marketplaceId, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        Object localVarPostBody = null;
        String localVarPath = "/finances/transfers/wallet/2024-03-01/accounts/{accountId}".equals("/uploads/2020-11-01/uploadDestinations/{resource}") ? "/finances/transfers/wallet/2024-03-01/accounts/{accountId}".replaceAll("\\{accountId\\}", accountId.toString()) : "/finances/transfers/wallet/2024-03-01/accounts/{accountId}".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (marketplaceId != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("marketplaceId", marketplaceId));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, progressRequestListener);
    }

    private Call getAccountValidateBeforeCall(String accountId, String marketplaceId, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        if (accountId == null) {
            throw new ApiException("Missing the required parameter 'accountId' when calling getAccount(Async)");
        }
        if (marketplaceId == null) {
            throw new ApiException("Missing the required parameter 'marketplaceId' when calling getAccount(Async)");
        }
        return this.getAccountCall(accountId, marketplaceId, progressRequestListener);
    }

    public BankAccount getAccount(String accountId, String marketplaceId, String restrictedDataToken) throws ApiException, LWAException {
        ApiResponse<BankAccount> resp = this.getAccountWithHttpInfo(accountId, marketplaceId, restrictedDataToken);
        return resp.getData();
    }

    public BankAccount getAccount(String accountId, String marketplaceId) throws ApiException, LWAException {
        ApiResponse<BankAccount> resp = this.getAccountWithHttpInfo(accountId, marketplaceId, null);
        return resp.getData();
    }

    public ApiResponse<BankAccount> getAccountWithHttpInfo(String accountId, String marketplaceId, String restrictedDataToken) throws ApiException, LWAException {
        Call call = this.getAccountValidateBeforeCall(accountId, marketplaceId, null);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "AccountsApi-getAccount");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.getAccountBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<BankAccount>(){}.getType();
            return this.apiClient.execute(call, localVarReturnType);
        }
        throw new ApiException.RateLimitExceeded("getAccount operation exceeds rate limit");
    }

    public ApiResponse<BankAccount> getAccountWithHttpInfo(String accountId, String marketplaceId) throws ApiException, LWAException {
        return this.getAccountWithHttpInfo(accountId, marketplaceId, null);
    }

    public Call getAccountAsync(String accountId, String marketplaceId, ApiCallback<BankAccount> callback) throws ApiException, LWAException {
        return this.getAccountAsync(accountId, marketplaceId, callback, null);
    }

    public Call getAccountAsync(String accountId, String marketplaceId, ApiCallback<BankAccount> callback, String restrictedDataToken) throws ApiException, LWAException {
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressRequestListener = callback::onUploadProgress;
        }
        Call call = this.getAccountValidateBeforeCall(accountId, marketplaceId, progressRequestListener);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "AccountsApi-getAccount");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.getAccountBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<BankAccount>(){}.getType();
            this.apiClient.executeAsync(call, localVarReturnType, callback);
            return call;
        }
        throw new ApiException.RateLimitExceeded("getAccount operation exceeds rate limit");
    }

    private Call listAccountBalancesCall(String accountId, String marketplaceId, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        Object localVarPostBody = null;
        String localVarPath = "/finances/transfers/wallet/2024-03-01/accounts/{accountId}/balance".equals("/uploads/2020-11-01/uploadDestinations/{resource}") ? "/finances/transfers/wallet/2024-03-01/accounts/{accountId}/balance".replaceAll("\\{accountId\\}", accountId.toString()) : "/finances/transfers/wallet/2024-03-01/accounts/{accountId}/balance".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (marketplaceId != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("marketplaceId", marketplaceId));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, progressRequestListener);
    }

    private Call listAccountBalancesValidateBeforeCall(String accountId, String marketplaceId, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        if (accountId == null) {
            throw new ApiException("Missing the required parameter 'accountId' when calling listAccountBalances(Async)");
        }
        if (marketplaceId == null) {
            throw new ApiException("Missing the required parameter 'marketplaceId' when calling listAccountBalances(Async)");
        }
        return this.listAccountBalancesCall(accountId, marketplaceId, progressRequestListener);
    }

    public BalanceListing listAccountBalances(String accountId, String marketplaceId, String restrictedDataToken) throws ApiException, LWAException {
        ApiResponse<BalanceListing> resp = this.listAccountBalancesWithHttpInfo(accountId, marketplaceId, restrictedDataToken);
        return resp.getData();
    }

    public BalanceListing listAccountBalances(String accountId, String marketplaceId) throws ApiException, LWAException {
        ApiResponse<BalanceListing> resp = this.listAccountBalancesWithHttpInfo(accountId, marketplaceId, null);
        return resp.getData();
    }

    public ApiResponse<BalanceListing> listAccountBalancesWithHttpInfo(String accountId, String marketplaceId, String restrictedDataToken) throws ApiException, LWAException {
        Call call = this.listAccountBalancesValidateBeforeCall(accountId, marketplaceId, null);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "AccountsApi-listAccountBalances");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.listAccountBalancesBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<BalanceListing>(){}.getType();
            return this.apiClient.execute(call, localVarReturnType);
        }
        throw new ApiException.RateLimitExceeded("listAccountBalances operation exceeds rate limit");
    }

    public ApiResponse<BalanceListing> listAccountBalancesWithHttpInfo(String accountId, String marketplaceId) throws ApiException, LWAException {
        return this.listAccountBalancesWithHttpInfo(accountId, marketplaceId, null);
    }

    public Call listAccountBalancesAsync(String accountId, String marketplaceId, ApiCallback<BalanceListing> callback) throws ApiException, LWAException {
        return this.listAccountBalancesAsync(accountId, marketplaceId, callback, null);
    }

    public Call listAccountBalancesAsync(String accountId, String marketplaceId, ApiCallback<BalanceListing> callback, String restrictedDataToken) throws ApiException, LWAException {
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressRequestListener = callback::onUploadProgress;
        }
        Call call = this.listAccountBalancesValidateBeforeCall(accountId, marketplaceId, progressRequestListener);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "AccountsApi-listAccountBalances");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.listAccountBalancesBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<BalanceListing>(){}.getType();
            this.apiClient.executeAsync(call, localVarReturnType, callback);
            return call;
        }
        throw new ApiException.RateLimitExceeded("listAccountBalances operation exceeds rate limit");
    }

    private Call listAccountsCall(String marketplaceId, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        Object localVarPostBody = null;
        String localVarPath = "/finances/transfers/wallet/2024-03-01/accounts".equals("/uploads/2020-11-01/uploadDestinations/{resource}") ? "/finances/transfers/wallet/2024-03-01/accounts" : "/finances/transfers/wallet/2024-03-01/accounts";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (marketplaceId != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("marketplaceId", marketplaceId));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, progressRequestListener);
    }

    private Call listAccountsValidateBeforeCall(String marketplaceId, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        if (marketplaceId == null) {
            throw new ApiException("Missing the required parameter 'marketplaceId' when calling listAccounts(Async)");
        }
        return this.listAccountsCall(marketplaceId, progressRequestListener);
    }

    public BankAccountListing listAccounts(String marketplaceId, String restrictedDataToken) throws ApiException, LWAException {
        ApiResponse<BankAccountListing> resp = this.listAccountsWithHttpInfo(marketplaceId, restrictedDataToken);
        return resp.getData();
    }

    public BankAccountListing listAccounts(String marketplaceId) throws ApiException, LWAException {
        ApiResponse<BankAccountListing> resp = this.listAccountsWithHttpInfo(marketplaceId, null);
        return resp.getData();
    }

    public ApiResponse<BankAccountListing> listAccountsWithHttpInfo(String marketplaceId, String restrictedDataToken) throws ApiException, LWAException {
        Call call = this.listAccountsValidateBeforeCall(marketplaceId, null);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "AccountsApi-listAccounts");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.listAccountsBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<BankAccountListing>(){}.getType();
            return this.apiClient.execute(call, localVarReturnType);
        }
        throw new ApiException.RateLimitExceeded("listAccounts operation exceeds rate limit");
    }

    public ApiResponse<BankAccountListing> listAccountsWithHttpInfo(String marketplaceId) throws ApiException, LWAException {
        return this.listAccountsWithHttpInfo(marketplaceId, null);
    }

    public Call listAccountsAsync(String marketplaceId, ApiCallback<BankAccountListing> callback) throws ApiException, LWAException {
        return this.listAccountsAsync(marketplaceId, callback, null);
    }

    public Call listAccountsAsync(String marketplaceId, ApiCallback<BankAccountListing> callback, String restrictedDataToken) throws ApiException, LWAException {
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressRequestListener = callback::onUploadProgress;
        }
        Call call = this.listAccountsValidateBeforeCall(marketplaceId, progressRequestListener);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "AccountsApi-listAccounts");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.listAccountsBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<BankAccountListing>(){}.getType();
            this.apiClient.executeAsync(call, localVarReturnType, callback);
            return call;
        }
        throw new ApiException.RateLimitExceeded("listAccounts operation exceeds rate limit");
    }

    public static class Builder {
        private LWAAuthorizationCredentials lwaAuthorizationCredentials;
        private String endpoint;
        private LWAAccessTokenCache lwaAccessTokenCache;
        private Boolean disableAccessTokenCache = false;
        private Boolean disableRateLimiting = false;

        public Builder lwaAuthorizationCredentials(LWAAuthorizationCredentials lwaAuthorizationCredentials) {
            this.lwaAuthorizationCredentials = lwaAuthorizationCredentials;
            return this;
        }

        public Builder endpoint(String endpoint) {
            this.endpoint = endpoint;
            return this;
        }

        public Builder lwaAccessTokenCache(LWAAccessTokenCache lwaAccessTokenCache) {
            this.lwaAccessTokenCache = lwaAccessTokenCache;
            return this;
        }

        public Builder disableAccessTokenCache() {
            this.disableAccessTokenCache = true;
            return this;
        }

        public Builder disableRateLimiting() {
            this.disableRateLimiting = true;
            return this;
        }

        public AccountsApi build() {
            if (this.lwaAuthorizationCredentials == null) {
                throw new RuntimeException("LWAAuthorizationCredentials not set");
            }
            if (StringUtil.isEmpty(this.endpoint)) {
                throw new RuntimeException("Endpoint not set");
            }
            LWAAuthorizationSigner lwaAuthorizationSigner = null;
            if (this.disableAccessTokenCache.booleanValue()) {
                lwaAuthorizationSigner = new LWAAuthorizationSigner(this.lwaAuthorizationCredentials);
            } else {
                if (this.lwaAccessTokenCache == null) {
                    this.lwaAccessTokenCache = new LWAAccessTokenCacheImpl();
                }
                lwaAuthorizationSigner = new LWAAuthorizationSigner(this.lwaAuthorizationCredentials, this.lwaAccessTokenCache);
            }
            return new AccountsApi(new ApiClient().setLWAAuthorizationSigner(lwaAuthorizationSigner).setBasePath(this.endpoint), this.disableRateLimiting);
        }
    }
}

