/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.api.sales.v1;

import com.amazon.SellingPartnerAPIAA.LWAAccessTokenCache;
import com.amazon.SellingPartnerAPIAA.LWAAccessTokenCacheImpl;
import com.amazon.SellingPartnerAPIAA.LWAAuthorizationCredentials;
import com.amazon.SellingPartnerAPIAA.LWAAuthorizationSigner;
import com.amazon.SellingPartnerAPIAA.LWAException;
import com.amazon.SellingPartnerAPIAA.RestrictedDataTokenSigner;
import com.google.gson.reflect.TypeToken;
import io.github.bucket4j.Bucket;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import okhttp3.Call;
import okhttp3.Request;
import software.amazon.spapi.ApiCallback;
import software.amazon.spapi.ApiClient;
import software.amazon.spapi.ApiException;
import software.amazon.spapi.ApiResponse;
import software.amazon.spapi.Configuration;
import software.amazon.spapi.Pair;
import software.amazon.spapi.ProgressRequestBody;
import software.amazon.spapi.StringUtil;
import software.amazon.spapi.models.sales.v1.GetOrderMetricsResponse;

public class SalesApi {
    private ApiClient apiClient;
    private Boolean disableRateLimiting;
    private final Configuration config = Configuration.get();
    public final Bucket getOrderMetricsBucket = Bucket.builder().addLimit(this.config.getLimit("SalesApi-getOrderMetrics")).build();

    public SalesApi(ApiClient apiClient, Boolean disableRateLimiting) {
        this.apiClient = apiClient;
        this.disableRateLimiting = disableRateLimiting;
    }

    private Call getOrderMetricsCall(List<String> marketplaceIds, String interval, String granularity, String granularityTimeZone, String buyerType, String fulfillmentNetwork, String firstDayOfWeek, String asin, String sku, String amazonProgram, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        Object localVarPostBody = null;
        String localVarPath = "/sales/v1/orderMetrics".equals("/uploads/2020-11-01/uploadDestinations/{resource}") ? "/sales/v1/orderMetrics" : "/sales/v1/orderMetrics";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (marketplaceIds != null) {
            localVarCollectionQueryParams.addAll(this.apiClient.parameterToPairs("csv", "marketplaceIds", marketplaceIds));
        }
        if (interval != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("interval", interval));
        }
        if (granularityTimeZone != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("granularityTimeZone", granularityTimeZone));
        }
        if (granularity != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("granularity", granularity));
        }
        if (buyerType != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("buyerType", buyerType));
        }
        if (fulfillmentNetwork != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("fulfillmentNetwork", fulfillmentNetwork));
        }
        if (firstDayOfWeek != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("firstDayOfWeek", firstDayOfWeek));
        }
        if (asin != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("asin", asin));
        }
        if (sku != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("sku", sku));
        }
        if (amazonProgram != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("amazonProgram", amazonProgram));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "payload"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, progressRequestListener);
    }

    private Call getOrderMetricsValidateBeforeCall(List<String> marketplaceIds, String interval, String granularity, String granularityTimeZone, String buyerType, String fulfillmentNetwork, String firstDayOfWeek, String asin, String sku, String amazonProgram, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        if (marketplaceIds == null) {
            throw new ApiException("Missing the required parameter 'marketplaceIds' when calling getOrderMetrics(Async)");
        }
        if (interval == null) {
            throw new ApiException("Missing the required parameter 'interval' when calling getOrderMetrics(Async)");
        }
        if (granularity == null) {
            throw new ApiException("Missing the required parameter 'granularity' when calling getOrderMetrics(Async)");
        }
        return this.getOrderMetricsCall(marketplaceIds, interval, granularity, granularityTimeZone, buyerType, fulfillmentNetwork, firstDayOfWeek, asin, sku, amazonProgram, progressRequestListener);
    }

    public GetOrderMetricsResponse getOrderMetrics(List<String> marketplaceIds, String interval, String granularity, String granularityTimeZone, String buyerType, String fulfillmentNetwork, String firstDayOfWeek, String asin, String sku, String amazonProgram, String restrictedDataToken) throws ApiException, LWAException {
        ApiResponse<GetOrderMetricsResponse> resp = this.getOrderMetricsWithHttpInfo(marketplaceIds, interval, granularity, granularityTimeZone, buyerType, fulfillmentNetwork, firstDayOfWeek, asin, sku, amazonProgram, restrictedDataToken);
        return resp.getData();
    }

    public GetOrderMetricsResponse getOrderMetrics(List<String> marketplaceIds, String interval, String granularity, String granularityTimeZone, String buyerType, String fulfillmentNetwork, String firstDayOfWeek, String asin, String sku, String amazonProgram) throws ApiException, LWAException {
        ApiResponse<GetOrderMetricsResponse> resp = this.getOrderMetricsWithHttpInfo(marketplaceIds, interval, granularity, granularityTimeZone, buyerType, fulfillmentNetwork, firstDayOfWeek, asin, sku, amazonProgram, null);
        return resp.getData();
    }

    public ApiResponse<GetOrderMetricsResponse> getOrderMetricsWithHttpInfo(List<String> marketplaceIds, String interval, String granularity, String granularityTimeZone, String buyerType, String fulfillmentNetwork, String firstDayOfWeek, String asin, String sku, String amazonProgram, String restrictedDataToken) throws ApiException, LWAException {
        Call call = this.getOrderMetricsValidateBeforeCall(marketplaceIds, interval, granularity, granularityTimeZone, buyerType, fulfillmentNetwork, firstDayOfWeek, asin, sku, amazonProgram, null);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "SalesApi-getOrderMetrics");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.getOrderMetricsBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<GetOrderMetricsResponse>(){}.getType();
            return this.apiClient.execute(call, localVarReturnType);
        }
        throw new ApiException.RateLimitExceeded("getOrderMetrics operation exceeds rate limit");
    }

    public ApiResponse<GetOrderMetricsResponse> getOrderMetricsWithHttpInfo(List<String> marketplaceIds, String interval, String granularity, String granularityTimeZone, String buyerType, String fulfillmentNetwork, String firstDayOfWeek, String asin, String sku, String amazonProgram) throws ApiException, LWAException {
        return this.getOrderMetricsWithHttpInfo(marketplaceIds, interval, granularity, granularityTimeZone, buyerType, fulfillmentNetwork, firstDayOfWeek, asin, sku, amazonProgram, null);
    }

    public Call getOrderMetricsAsync(List<String> marketplaceIds, String interval, String granularity, String granularityTimeZone, String buyerType, String fulfillmentNetwork, String firstDayOfWeek, String asin, String sku, String amazonProgram, ApiCallback<GetOrderMetricsResponse> callback) throws ApiException, LWAException {
        return this.getOrderMetricsAsync(marketplaceIds, interval, granularity, granularityTimeZone, buyerType, fulfillmentNetwork, firstDayOfWeek, asin, sku, amazonProgram, callback, null);
    }

    public Call getOrderMetricsAsync(List<String> marketplaceIds, String interval, String granularity, String granularityTimeZone, String buyerType, String fulfillmentNetwork, String firstDayOfWeek, String asin, String sku, String amazonProgram, ApiCallback<GetOrderMetricsResponse> callback, String restrictedDataToken) throws ApiException, LWAException {
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressRequestListener = callback::onUploadProgress;
        }
        Call call = this.getOrderMetricsValidateBeforeCall(marketplaceIds, interval, granularity, granularityTimeZone, buyerType, fulfillmentNetwork, firstDayOfWeek, asin, sku, amazonProgram, progressRequestListener);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "SalesApi-getOrderMetrics");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.getOrderMetricsBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<GetOrderMetricsResponse>(){}.getType();
            this.apiClient.executeAsync(call, localVarReturnType, callback);
            return call;
        }
        throw new ApiException.RateLimitExceeded("getOrderMetrics operation exceeds rate limit");
    }

    public static class Builder {
        private LWAAuthorizationCredentials lwaAuthorizationCredentials;
        private String endpoint;
        private LWAAccessTokenCache lwaAccessTokenCache;
        private Boolean disableAccessTokenCache = false;
        private Boolean disableRateLimiting = false;

        public Builder lwaAuthorizationCredentials(LWAAuthorizationCredentials lwaAuthorizationCredentials) {
            this.lwaAuthorizationCredentials = lwaAuthorizationCredentials;
            return this;
        }

        public Builder endpoint(String endpoint) {
            this.endpoint = endpoint;
            return this;
        }

        public Builder lwaAccessTokenCache(LWAAccessTokenCache lwaAccessTokenCache) {
            this.lwaAccessTokenCache = lwaAccessTokenCache;
            return this;
        }

        public Builder disableAccessTokenCache() {
            this.disableAccessTokenCache = true;
            return this;
        }

        public Builder disableRateLimiting() {
            this.disableRateLimiting = true;
            return this;
        }

        public SalesApi build() {
            if (this.lwaAuthorizationCredentials == null) {
                throw new RuntimeException("LWAAuthorizationCredentials not set");
            }
            if (StringUtil.isEmpty(this.endpoint)) {
                throw new RuntimeException("Endpoint not set");
            }
            LWAAuthorizationSigner lwaAuthorizationSigner = null;
            if (this.disableAccessTokenCache.booleanValue()) {
                lwaAuthorizationSigner = new LWAAuthorizationSigner(this.lwaAuthorizationCredentials);
            } else {
                if (this.lwaAccessTokenCache == null) {
                    this.lwaAccessTokenCache = new LWAAccessTokenCacheImpl();
                }
                lwaAuthorizationSigner = new LWAAuthorizationSigner(this.lwaAuthorizationCredentials, this.lwaAccessTokenCache);
            }
            return new SalesApi(new ApiClient().setLWAAuthorizationSigner(lwaAuthorizationSigner).setBasePath(this.endpoint), this.disableRateLimiting);
        }
    }
}

