/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.api.reports.v2021_06_30;

import com.amazon.SellingPartnerAPIAA.LWAAccessTokenCache;
import com.amazon.SellingPartnerAPIAA.LWAAccessTokenCacheImpl;
import com.amazon.SellingPartnerAPIAA.LWAAuthorizationCredentials;
import com.amazon.SellingPartnerAPIAA.LWAAuthorizationSigner;
import com.amazon.SellingPartnerAPIAA.LWAException;
import com.amazon.SellingPartnerAPIAA.RestrictedDataTokenSigner;
import com.google.gson.reflect.TypeToken;
import io.github.bucket4j.Bucket;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import okhttp3.Call;
import okhttp3.Request;
import org.threeten.bp.OffsetDateTime;
import software.amazon.spapi.ApiCallback;
import software.amazon.spapi.ApiClient;
import software.amazon.spapi.ApiException;
import software.amazon.spapi.ApiResponse;
import software.amazon.spapi.Configuration;
import software.amazon.spapi.Pair;
import software.amazon.spapi.ProgressRequestBody;
import software.amazon.spapi.StringUtil;
import software.amazon.spapi.models.reports.v2021_06_30.CreateReportResponse;
import software.amazon.spapi.models.reports.v2021_06_30.CreateReportScheduleResponse;
import software.amazon.spapi.models.reports.v2021_06_30.CreateReportScheduleSpecification;
import software.amazon.spapi.models.reports.v2021_06_30.CreateReportSpecification;
import software.amazon.spapi.models.reports.v2021_06_30.GetReportsResponse;
import software.amazon.spapi.models.reports.v2021_06_30.Report;
import software.amazon.spapi.models.reports.v2021_06_30.ReportDocument;
import software.amazon.spapi.models.reports.v2021_06_30.ReportSchedule;
import software.amazon.spapi.models.reports.v2021_06_30.ReportScheduleList;

public class ReportsApi {
    private ApiClient apiClient;
    private Boolean disableRateLimiting;
    private final Configuration config = Configuration.get();
    public final Bucket cancelReportBucket = Bucket.builder().addLimit(this.config.getLimit("ReportsApi-cancelReport")).build();
    public final Bucket cancelReportScheduleBucket = Bucket.builder().addLimit(this.config.getLimit("ReportsApi-cancelReportSchedule")).build();
    public final Bucket createReportBucket = Bucket.builder().addLimit(this.config.getLimit("ReportsApi-createReport")).build();
    public final Bucket createReportScheduleBucket = Bucket.builder().addLimit(this.config.getLimit("ReportsApi-createReportSchedule")).build();
    public final Bucket getReportBucket = Bucket.builder().addLimit(this.config.getLimit("ReportsApi-getReport")).build();
    public final Bucket getReportDocumentBucket = Bucket.builder().addLimit(this.config.getLimit("ReportsApi-getReportDocument")).build();
    public final Bucket getReportScheduleBucket = Bucket.builder().addLimit(this.config.getLimit("ReportsApi-getReportSchedule")).build();
    public final Bucket getReportSchedulesBucket = Bucket.builder().addLimit(this.config.getLimit("ReportsApi-getReportSchedules")).build();
    public final Bucket getReportsBucket = Bucket.builder().addLimit(this.config.getLimit("ReportsApi-getReports")).build();

    public ReportsApi(ApiClient apiClient, Boolean disableRateLimiting) {
        this.apiClient = apiClient;
        this.disableRateLimiting = disableRateLimiting;
    }

    private Call cancelReportCall(String reportId, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        Object localVarPostBody = null;
        String localVarPath = "/reports/2021-06-30/reports/{reportId}".equals("/uploads/2020-11-01/uploadDestinations/{resource}") ? "/reports/2021-06-30/reports/{reportId}".replaceAll("\\{reportId\\}", reportId.toString()) : "/reports/2021-06-30/reports/{reportId}".replaceAll("\\{reportId\\}", this.apiClient.escapeString(reportId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        return this.apiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, progressRequestListener);
    }

    private Call cancelReportValidateBeforeCall(String reportId, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        if (reportId == null) {
            throw new ApiException("Missing the required parameter 'reportId' when calling cancelReport(Async)");
        }
        return this.cancelReportCall(reportId, progressRequestListener);
    }

    public void cancelReport(String reportId, String restrictedDataToken) throws ApiException, LWAException {
        this.cancelReportWithHttpInfo(reportId, restrictedDataToken);
    }

    public void cancelReport(String reportId) throws ApiException, LWAException {
        this.cancelReportWithHttpInfo(reportId, null);
    }

    public ApiResponse<Void> cancelReportWithHttpInfo(String reportId, String restrictedDataToken) throws ApiException, LWAException {
        Call call = this.cancelReportValidateBeforeCall(reportId, null);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "ReportsApi-cancelReport");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.cancelReportBucket.tryConsume(1L)) {
            return this.apiClient.execute(call);
        }
        throw new ApiException.RateLimitExceeded("cancelReport operation exceeds rate limit");
    }

    public ApiResponse<Void> cancelReportWithHttpInfo(String reportId) throws ApiException, LWAException {
        return this.cancelReportWithHttpInfo(reportId, null);
    }

    public Call cancelReportAsync(String reportId, ApiCallback<Void> callback) throws ApiException, LWAException {
        return this.cancelReportAsync(reportId, callback, null);
    }

    public Call cancelReportAsync(String reportId, ApiCallback<Void> callback, String restrictedDataToken) throws ApiException, LWAException {
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressRequestListener = callback::onUploadProgress;
        }
        Call call = this.cancelReportValidateBeforeCall(reportId, progressRequestListener);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "ReportsApi-cancelReport");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.cancelReportBucket.tryConsume(1L)) {
            this.apiClient.executeAsync(call, callback);
            return call;
        }
        throw new ApiException.RateLimitExceeded("cancelReport operation exceeds rate limit");
    }

    private Call cancelReportScheduleCall(String reportScheduleId, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        Object localVarPostBody = null;
        String localVarPath = "/reports/2021-06-30/schedules/{reportScheduleId}".equals("/uploads/2020-11-01/uploadDestinations/{resource}") ? "/reports/2021-06-30/schedules/{reportScheduleId}".replaceAll("\\{reportScheduleId\\}", reportScheduleId.toString()) : "/reports/2021-06-30/schedules/{reportScheduleId}".replaceAll("\\{reportScheduleId\\}", this.apiClient.escapeString(reportScheduleId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        return this.apiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, progressRequestListener);
    }

    private Call cancelReportScheduleValidateBeforeCall(String reportScheduleId, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        if (reportScheduleId == null) {
            throw new ApiException("Missing the required parameter 'reportScheduleId' when calling cancelReportSchedule(Async)");
        }
        return this.cancelReportScheduleCall(reportScheduleId, progressRequestListener);
    }

    public void cancelReportSchedule(String reportScheduleId, String restrictedDataToken) throws ApiException, LWAException {
        this.cancelReportScheduleWithHttpInfo(reportScheduleId, restrictedDataToken);
    }

    public void cancelReportSchedule(String reportScheduleId) throws ApiException, LWAException {
        this.cancelReportScheduleWithHttpInfo(reportScheduleId, null);
    }

    public ApiResponse<Void> cancelReportScheduleWithHttpInfo(String reportScheduleId, String restrictedDataToken) throws ApiException, LWAException {
        Call call = this.cancelReportScheduleValidateBeforeCall(reportScheduleId, null);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "ReportsApi-cancelReportSchedule");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.cancelReportScheduleBucket.tryConsume(1L)) {
            return this.apiClient.execute(call);
        }
        throw new ApiException.RateLimitExceeded("cancelReportSchedule operation exceeds rate limit");
    }

    public ApiResponse<Void> cancelReportScheduleWithHttpInfo(String reportScheduleId) throws ApiException, LWAException {
        return this.cancelReportScheduleWithHttpInfo(reportScheduleId, null);
    }

    public Call cancelReportScheduleAsync(String reportScheduleId, ApiCallback<Void> callback) throws ApiException, LWAException {
        return this.cancelReportScheduleAsync(reportScheduleId, callback, null);
    }

    public Call cancelReportScheduleAsync(String reportScheduleId, ApiCallback<Void> callback, String restrictedDataToken) throws ApiException, LWAException {
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressRequestListener = callback::onUploadProgress;
        }
        Call call = this.cancelReportScheduleValidateBeforeCall(reportScheduleId, progressRequestListener);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "ReportsApi-cancelReportSchedule");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.cancelReportScheduleBucket.tryConsume(1L)) {
            this.apiClient.executeAsync(call, callback);
            return call;
        }
        throw new ApiException.RateLimitExceeded("cancelReportSchedule operation exceeds rate limit");
    }

    private Call createReportCall(CreateReportSpecification body, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        CreateReportSpecification localVarPostBody = body;
        String localVarPath = "/reports/2021-06-30/reports".equals("/uploads/2020-11-01/uploadDestinations/{resource}") ? "/reports/2021-06-30/reports" : "/reports/2021-06-30/reports";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, progressRequestListener);
    }

    private Call createReportValidateBeforeCall(CreateReportSpecification body, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling createReport(Async)");
        }
        return this.createReportCall(body, progressRequestListener);
    }

    public CreateReportResponse createReport(CreateReportSpecification body, String restrictedDataToken) throws ApiException, LWAException {
        ApiResponse<CreateReportResponse> resp = this.createReportWithHttpInfo(body, restrictedDataToken);
        return resp.getData();
    }

    public CreateReportResponse createReport(CreateReportSpecification body) throws ApiException, LWAException {
        ApiResponse<CreateReportResponse> resp = this.createReportWithHttpInfo(body, null);
        return resp.getData();
    }

    public ApiResponse<CreateReportResponse> createReportWithHttpInfo(CreateReportSpecification body, String restrictedDataToken) throws ApiException, LWAException {
        Call call = this.createReportValidateBeforeCall(body, null);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "ReportsApi-createReport");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.createReportBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<CreateReportResponse>(){}.getType();
            return this.apiClient.execute(call, localVarReturnType);
        }
        throw new ApiException.RateLimitExceeded("createReport operation exceeds rate limit");
    }

    public ApiResponse<CreateReportResponse> createReportWithHttpInfo(CreateReportSpecification body) throws ApiException, LWAException {
        return this.createReportWithHttpInfo(body, null);
    }

    public Call createReportAsync(CreateReportSpecification body, ApiCallback<CreateReportResponse> callback) throws ApiException, LWAException {
        return this.createReportAsync(body, callback, null);
    }

    public Call createReportAsync(CreateReportSpecification body, ApiCallback<CreateReportResponse> callback, String restrictedDataToken) throws ApiException, LWAException {
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressRequestListener = callback::onUploadProgress;
        }
        Call call = this.createReportValidateBeforeCall(body, progressRequestListener);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "ReportsApi-createReport");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.createReportBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<CreateReportResponse>(){}.getType();
            this.apiClient.executeAsync(call, localVarReturnType, callback);
            return call;
        }
        throw new ApiException.RateLimitExceeded("createReport operation exceeds rate limit");
    }

    private Call createReportScheduleCall(CreateReportScheduleSpecification body, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        CreateReportScheduleSpecification localVarPostBody = body;
        String localVarPath = "/reports/2021-06-30/schedules".equals("/uploads/2020-11-01/uploadDestinations/{resource}") ? "/reports/2021-06-30/schedules" : "/reports/2021-06-30/schedules";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, progressRequestListener);
    }

    private Call createReportScheduleValidateBeforeCall(CreateReportScheduleSpecification body, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling createReportSchedule(Async)");
        }
        return this.createReportScheduleCall(body, progressRequestListener);
    }

    public CreateReportScheduleResponse createReportSchedule(CreateReportScheduleSpecification body, String restrictedDataToken) throws ApiException, LWAException {
        ApiResponse<CreateReportScheduleResponse> resp = this.createReportScheduleWithHttpInfo(body, restrictedDataToken);
        return resp.getData();
    }

    public CreateReportScheduleResponse createReportSchedule(CreateReportScheduleSpecification body) throws ApiException, LWAException {
        ApiResponse<CreateReportScheduleResponse> resp = this.createReportScheduleWithHttpInfo(body, null);
        return resp.getData();
    }

    public ApiResponse<CreateReportScheduleResponse> createReportScheduleWithHttpInfo(CreateReportScheduleSpecification body, String restrictedDataToken) throws ApiException, LWAException {
        Call call = this.createReportScheduleValidateBeforeCall(body, null);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "ReportsApi-createReportSchedule");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.createReportScheduleBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<CreateReportScheduleResponse>(){}.getType();
            return this.apiClient.execute(call, localVarReturnType);
        }
        throw new ApiException.RateLimitExceeded("createReportSchedule operation exceeds rate limit");
    }

    public ApiResponse<CreateReportScheduleResponse> createReportScheduleWithHttpInfo(CreateReportScheduleSpecification body) throws ApiException, LWAException {
        return this.createReportScheduleWithHttpInfo(body, null);
    }

    public Call createReportScheduleAsync(CreateReportScheduleSpecification body, ApiCallback<CreateReportScheduleResponse> callback) throws ApiException, LWAException {
        return this.createReportScheduleAsync(body, callback, null);
    }

    public Call createReportScheduleAsync(CreateReportScheduleSpecification body, ApiCallback<CreateReportScheduleResponse> callback, String restrictedDataToken) throws ApiException, LWAException {
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressRequestListener = callback::onUploadProgress;
        }
        Call call = this.createReportScheduleValidateBeforeCall(body, progressRequestListener);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "ReportsApi-createReportSchedule");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.createReportScheduleBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<CreateReportScheduleResponse>(){}.getType();
            this.apiClient.executeAsync(call, localVarReturnType, callback);
            return call;
        }
        throw new ApiException.RateLimitExceeded("createReportSchedule operation exceeds rate limit");
    }

    private Call getReportCall(String reportId, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        Object localVarPostBody = null;
        String localVarPath = "/reports/2021-06-30/reports/{reportId}".equals("/uploads/2020-11-01/uploadDestinations/{resource}") ? "/reports/2021-06-30/reports/{reportId}".replaceAll("\\{reportId\\}", reportId.toString()) : "/reports/2021-06-30/reports/{reportId}".replaceAll("\\{reportId\\}", this.apiClient.escapeString(reportId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, progressRequestListener);
    }

    private Call getReportValidateBeforeCall(String reportId, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        if (reportId == null) {
            throw new ApiException("Missing the required parameter 'reportId' when calling getReport(Async)");
        }
        return this.getReportCall(reportId, progressRequestListener);
    }

    public Report getReport(String reportId, String restrictedDataToken) throws ApiException, LWAException {
        ApiResponse<Report> resp = this.getReportWithHttpInfo(reportId, restrictedDataToken);
        return resp.getData();
    }

    public Report getReport(String reportId) throws ApiException, LWAException {
        ApiResponse<Report> resp = this.getReportWithHttpInfo(reportId, null);
        return resp.getData();
    }

    public ApiResponse<Report> getReportWithHttpInfo(String reportId, String restrictedDataToken) throws ApiException, LWAException {
        Call call = this.getReportValidateBeforeCall(reportId, null);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "ReportsApi-getReport");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.getReportBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<Report>(){}.getType();
            return this.apiClient.execute(call, localVarReturnType);
        }
        throw new ApiException.RateLimitExceeded("getReport operation exceeds rate limit");
    }

    public ApiResponse<Report> getReportWithHttpInfo(String reportId) throws ApiException, LWAException {
        return this.getReportWithHttpInfo(reportId, null);
    }

    public Call getReportAsync(String reportId, ApiCallback<Report> callback) throws ApiException, LWAException {
        return this.getReportAsync(reportId, callback, null);
    }

    public Call getReportAsync(String reportId, ApiCallback<Report> callback, String restrictedDataToken) throws ApiException, LWAException {
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressRequestListener = callback::onUploadProgress;
        }
        Call call = this.getReportValidateBeforeCall(reportId, progressRequestListener);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "ReportsApi-getReport");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.getReportBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<Report>(){}.getType();
            this.apiClient.executeAsync(call, localVarReturnType, callback);
            return call;
        }
        throw new ApiException.RateLimitExceeded("getReport operation exceeds rate limit");
    }

    private Call getReportDocumentCall(String reportDocumentId, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        Object localVarPostBody = null;
        String localVarPath = "/reports/2021-06-30/documents/{reportDocumentId}".equals("/uploads/2020-11-01/uploadDestinations/{resource}") ? "/reports/2021-06-30/documents/{reportDocumentId}".replaceAll("\\{reportDocumentId\\}", reportDocumentId.toString()) : "/reports/2021-06-30/documents/{reportDocumentId}".replaceAll("\\{reportDocumentId\\}", this.apiClient.escapeString(reportDocumentId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, progressRequestListener);
    }

    private Call getReportDocumentValidateBeforeCall(String reportDocumentId, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        if (reportDocumentId == null) {
            throw new ApiException("Missing the required parameter 'reportDocumentId' when calling getReportDocument(Async)");
        }
        return this.getReportDocumentCall(reportDocumentId, progressRequestListener);
    }

    public ReportDocument getReportDocument(String reportDocumentId, String restrictedDataToken) throws ApiException, LWAException {
        ApiResponse<ReportDocument> resp = this.getReportDocumentWithHttpInfo(reportDocumentId, restrictedDataToken);
        return resp.getData();
    }

    public ReportDocument getReportDocument(String reportDocumentId) throws ApiException, LWAException {
        ApiResponse<ReportDocument> resp = this.getReportDocumentWithHttpInfo(reportDocumentId, null);
        return resp.getData();
    }

    public ApiResponse<ReportDocument> getReportDocumentWithHttpInfo(String reportDocumentId, String restrictedDataToken) throws ApiException, LWAException {
        Call call = this.getReportDocumentValidateBeforeCall(reportDocumentId, null);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "ReportsApi-getReportDocument");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.getReportDocumentBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<ReportDocument>(){}.getType();
            return this.apiClient.execute(call, localVarReturnType);
        }
        throw new ApiException.RateLimitExceeded("getReportDocument operation exceeds rate limit");
    }

    public ApiResponse<ReportDocument> getReportDocumentWithHttpInfo(String reportDocumentId) throws ApiException, LWAException {
        return this.getReportDocumentWithHttpInfo(reportDocumentId, null);
    }

    public Call getReportDocumentAsync(String reportDocumentId, ApiCallback<ReportDocument> callback) throws ApiException, LWAException {
        return this.getReportDocumentAsync(reportDocumentId, callback, null);
    }

    public Call getReportDocumentAsync(String reportDocumentId, ApiCallback<ReportDocument> callback, String restrictedDataToken) throws ApiException, LWAException {
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressRequestListener = callback::onUploadProgress;
        }
        Call call = this.getReportDocumentValidateBeforeCall(reportDocumentId, progressRequestListener);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "ReportsApi-getReportDocument");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.getReportDocumentBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<ReportDocument>(){}.getType();
            this.apiClient.executeAsync(call, localVarReturnType, callback);
            return call;
        }
        throw new ApiException.RateLimitExceeded("getReportDocument operation exceeds rate limit");
    }

    private Call getReportScheduleCall(String reportScheduleId, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        Object localVarPostBody = null;
        String localVarPath = "/reports/2021-06-30/schedules/{reportScheduleId}".equals("/uploads/2020-11-01/uploadDestinations/{resource}") ? "/reports/2021-06-30/schedules/{reportScheduleId}".replaceAll("\\{reportScheduleId\\}", reportScheduleId.toString()) : "/reports/2021-06-30/schedules/{reportScheduleId}".replaceAll("\\{reportScheduleId\\}", this.apiClient.escapeString(reportScheduleId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, progressRequestListener);
    }

    private Call getReportScheduleValidateBeforeCall(String reportScheduleId, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        if (reportScheduleId == null) {
            throw new ApiException("Missing the required parameter 'reportScheduleId' when calling getReportSchedule(Async)");
        }
        return this.getReportScheduleCall(reportScheduleId, progressRequestListener);
    }

    public ReportSchedule getReportSchedule(String reportScheduleId, String restrictedDataToken) throws ApiException, LWAException {
        ApiResponse<ReportSchedule> resp = this.getReportScheduleWithHttpInfo(reportScheduleId, restrictedDataToken);
        return resp.getData();
    }

    public ReportSchedule getReportSchedule(String reportScheduleId) throws ApiException, LWAException {
        ApiResponse<ReportSchedule> resp = this.getReportScheduleWithHttpInfo(reportScheduleId, null);
        return resp.getData();
    }

    public ApiResponse<ReportSchedule> getReportScheduleWithHttpInfo(String reportScheduleId, String restrictedDataToken) throws ApiException, LWAException {
        Call call = this.getReportScheduleValidateBeforeCall(reportScheduleId, null);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "ReportsApi-getReportSchedule");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.getReportScheduleBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<ReportSchedule>(){}.getType();
            return this.apiClient.execute(call, localVarReturnType);
        }
        throw new ApiException.RateLimitExceeded("getReportSchedule operation exceeds rate limit");
    }

    public ApiResponse<ReportSchedule> getReportScheduleWithHttpInfo(String reportScheduleId) throws ApiException, LWAException {
        return this.getReportScheduleWithHttpInfo(reportScheduleId, null);
    }

    public Call getReportScheduleAsync(String reportScheduleId, ApiCallback<ReportSchedule> callback) throws ApiException, LWAException {
        return this.getReportScheduleAsync(reportScheduleId, callback, null);
    }

    public Call getReportScheduleAsync(String reportScheduleId, ApiCallback<ReportSchedule> callback, String restrictedDataToken) throws ApiException, LWAException {
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressRequestListener = callback::onUploadProgress;
        }
        Call call = this.getReportScheduleValidateBeforeCall(reportScheduleId, progressRequestListener);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "ReportsApi-getReportSchedule");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.getReportScheduleBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<ReportSchedule>(){}.getType();
            this.apiClient.executeAsync(call, localVarReturnType, callback);
            return call;
        }
        throw new ApiException.RateLimitExceeded("getReportSchedule operation exceeds rate limit");
    }

    private Call getReportSchedulesCall(List<String> reportTypes, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        Object localVarPostBody = null;
        String localVarPath = "/reports/2021-06-30/schedules".equals("/uploads/2020-11-01/uploadDestinations/{resource}") ? "/reports/2021-06-30/schedules" : "/reports/2021-06-30/schedules";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (reportTypes != null) {
            localVarCollectionQueryParams.addAll(this.apiClient.parameterToPairs("csv", "reportTypes", reportTypes));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, progressRequestListener);
    }

    private Call getReportSchedulesValidateBeforeCall(List<String> reportTypes, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        if (reportTypes == null) {
            throw new ApiException("Missing the required parameter 'reportTypes' when calling getReportSchedules(Async)");
        }
        return this.getReportSchedulesCall(reportTypes, progressRequestListener);
    }

    public ReportScheduleList getReportSchedules(List<String> reportTypes, String restrictedDataToken) throws ApiException, LWAException {
        ApiResponse<ReportScheduleList> resp = this.getReportSchedulesWithHttpInfo(reportTypes, restrictedDataToken);
        return resp.getData();
    }

    public ReportScheduleList getReportSchedules(List<String> reportTypes) throws ApiException, LWAException {
        ApiResponse<ReportScheduleList> resp = this.getReportSchedulesWithHttpInfo(reportTypes, null);
        return resp.getData();
    }

    public ApiResponse<ReportScheduleList> getReportSchedulesWithHttpInfo(List<String> reportTypes, String restrictedDataToken) throws ApiException, LWAException {
        Call call = this.getReportSchedulesValidateBeforeCall(reportTypes, null);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "ReportsApi-getReportSchedules");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.getReportSchedulesBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<ReportScheduleList>(){}.getType();
            return this.apiClient.execute(call, localVarReturnType);
        }
        throw new ApiException.RateLimitExceeded("getReportSchedules operation exceeds rate limit");
    }

    public ApiResponse<ReportScheduleList> getReportSchedulesWithHttpInfo(List<String> reportTypes) throws ApiException, LWAException {
        return this.getReportSchedulesWithHttpInfo(reportTypes, null);
    }

    public Call getReportSchedulesAsync(List<String> reportTypes, ApiCallback<ReportScheduleList> callback) throws ApiException, LWAException {
        return this.getReportSchedulesAsync(reportTypes, callback, null);
    }

    public Call getReportSchedulesAsync(List<String> reportTypes, ApiCallback<ReportScheduleList> callback, String restrictedDataToken) throws ApiException, LWAException {
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressRequestListener = callback::onUploadProgress;
        }
        Call call = this.getReportSchedulesValidateBeforeCall(reportTypes, progressRequestListener);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "ReportsApi-getReportSchedules");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.getReportSchedulesBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<ReportScheduleList>(){}.getType();
            this.apiClient.executeAsync(call, localVarReturnType, callback);
            return call;
        }
        throw new ApiException.RateLimitExceeded("getReportSchedules operation exceeds rate limit");
    }

    private Call getReportsCall(List<String> reportTypes, List<String> processingStatuses, List<String> marketplaceIds, Integer pageSize, OffsetDateTime createdSince, OffsetDateTime createdUntil, String nextToken, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        Object localVarPostBody = null;
        String localVarPath = "/reports/2021-06-30/reports".equals("/uploads/2020-11-01/uploadDestinations/{resource}") ? "/reports/2021-06-30/reports" : "/reports/2021-06-30/reports";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (reportTypes != null) {
            localVarCollectionQueryParams.addAll(this.apiClient.parameterToPairs("csv", "reportTypes", reportTypes));
        }
        if (processingStatuses != null) {
            localVarCollectionQueryParams.addAll(this.apiClient.parameterToPairs("csv", "processingStatuses", processingStatuses));
        }
        if (marketplaceIds != null) {
            localVarCollectionQueryParams.addAll(this.apiClient.parameterToPairs("csv", "marketplaceIds", marketplaceIds));
        }
        if (pageSize != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("pageSize", pageSize));
        }
        if (createdSince != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("createdSince", createdSince));
        }
        if (createdUntil != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("createdUntil", createdUntil));
        }
        if (nextToken != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("nextToken", nextToken));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, progressRequestListener);
    }

    private Call getReportsValidateBeforeCall(List<String> reportTypes, List<String> processingStatuses, List<String> marketplaceIds, Integer pageSize, OffsetDateTime createdSince, OffsetDateTime createdUntil, String nextToken, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        return this.getReportsCall(reportTypes, processingStatuses, marketplaceIds, pageSize, createdSince, createdUntil, nextToken, progressRequestListener);
    }

    public GetReportsResponse getReports(List<String> reportTypes, List<String> processingStatuses, List<String> marketplaceIds, Integer pageSize, OffsetDateTime createdSince, OffsetDateTime createdUntil, String nextToken, String restrictedDataToken) throws ApiException, LWAException {
        ApiResponse<GetReportsResponse> resp = this.getReportsWithHttpInfo(reportTypes, processingStatuses, marketplaceIds, pageSize, createdSince, createdUntil, nextToken, restrictedDataToken);
        return resp.getData();
    }

    public GetReportsResponse getReports(List<String> reportTypes, List<String> processingStatuses, List<String> marketplaceIds, Integer pageSize, OffsetDateTime createdSince, OffsetDateTime createdUntil, String nextToken) throws ApiException, LWAException {
        ApiResponse<GetReportsResponse> resp = this.getReportsWithHttpInfo(reportTypes, processingStatuses, marketplaceIds, pageSize, createdSince, createdUntil, nextToken, null);
        return resp.getData();
    }

    public ApiResponse<GetReportsResponse> getReportsWithHttpInfo(List<String> reportTypes, List<String> processingStatuses, List<String> marketplaceIds, Integer pageSize, OffsetDateTime createdSince, OffsetDateTime createdUntil, String nextToken, String restrictedDataToken) throws ApiException, LWAException {
        Call call = this.getReportsValidateBeforeCall(reportTypes, processingStatuses, marketplaceIds, pageSize, createdSince, createdUntil, nextToken, null);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "ReportsApi-getReports");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.getReportsBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<GetReportsResponse>(){}.getType();
            return this.apiClient.execute(call, localVarReturnType);
        }
        throw new ApiException.RateLimitExceeded("getReports operation exceeds rate limit");
    }

    public ApiResponse<GetReportsResponse> getReportsWithHttpInfo(List<String> reportTypes, List<String> processingStatuses, List<String> marketplaceIds, Integer pageSize, OffsetDateTime createdSince, OffsetDateTime createdUntil, String nextToken) throws ApiException, LWAException {
        return this.getReportsWithHttpInfo(reportTypes, processingStatuses, marketplaceIds, pageSize, createdSince, createdUntil, nextToken, null);
    }

    public Call getReportsAsync(List<String> reportTypes, List<String> processingStatuses, List<String> marketplaceIds, Integer pageSize, OffsetDateTime createdSince, OffsetDateTime createdUntil, String nextToken, ApiCallback<GetReportsResponse> callback) throws ApiException, LWAException {
        return this.getReportsAsync(reportTypes, processingStatuses, marketplaceIds, pageSize, createdSince, createdUntil, nextToken, callback, null);
    }

    public Call getReportsAsync(List<String> reportTypes, List<String> processingStatuses, List<String> marketplaceIds, Integer pageSize, OffsetDateTime createdSince, OffsetDateTime createdUntil, String nextToken, ApiCallback<GetReportsResponse> callback, String restrictedDataToken) throws ApiException, LWAException {
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressRequestListener = callback::onUploadProgress;
        }
        Call call = this.getReportsValidateBeforeCall(reportTypes, processingStatuses, marketplaceIds, pageSize, createdSince, createdUntil, nextToken, progressRequestListener);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "ReportsApi-getReports");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.getReportsBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<GetReportsResponse>(){}.getType();
            this.apiClient.executeAsync(call, localVarReturnType, callback);
            return call;
        }
        throw new ApiException.RateLimitExceeded("getReports operation exceeds rate limit");
    }

    public static class Builder {
        private LWAAuthorizationCredentials lwaAuthorizationCredentials;
        private String endpoint;
        private LWAAccessTokenCache lwaAccessTokenCache;
        private Boolean disableAccessTokenCache = false;
        private Boolean disableRateLimiting = false;

        public Builder lwaAuthorizationCredentials(LWAAuthorizationCredentials lwaAuthorizationCredentials) {
            this.lwaAuthorizationCredentials = lwaAuthorizationCredentials;
            return this;
        }

        public Builder endpoint(String endpoint) {
            this.endpoint = endpoint;
            return this;
        }

        public Builder lwaAccessTokenCache(LWAAccessTokenCache lwaAccessTokenCache) {
            this.lwaAccessTokenCache = lwaAccessTokenCache;
            return this;
        }

        public Builder disableAccessTokenCache() {
            this.disableAccessTokenCache = true;
            return this;
        }

        public Builder disableRateLimiting() {
            this.disableRateLimiting = true;
            return this;
        }

        public ReportsApi build() {
            if (this.lwaAuthorizationCredentials == null) {
                throw new RuntimeException("LWAAuthorizationCredentials not set");
            }
            if (StringUtil.isEmpty(this.endpoint)) {
                throw new RuntimeException("Endpoint not set");
            }
            LWAAuthorizationSigner lwaAuthorizationSigner = null;
            if (this.disableAccessTokenCache.booleanValue()) {
                lwaAuthorizationSigner = new LWAAuthorizationSigner(this.lwaAuthorizationCredentials);
            } else {
                if (this.lwaAccessTokenCache == null) {
                    this.lwaAccessTokenCache = new LWAAccessTokenCacheImpl();
                }
                lwaAuthorizationSigner = new LWAAuthorizationSigner(this.lwaAuthorizationCredentials, this.lwaAccessTokenCache);
            }
            return new ReportsApi(new ApiClient().setLWAAuthorizationSigner(lwaAuthorizationSigner).setBasePath(this.endpoint), this.disableRateLimiting);
        }
    }
}

