/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.api.replenishment.v2022_11_07;

import com.amazon.SellingPartnerAPIAA.LWAAccessTokenCache;
import com.amazon.SellingPartnerAPIAA.LWAAccessTokenCacheImpl;
import com.amazon.SellingPartnerAPIAA.LWAAuthorizationCredentials;
import com.amazon.SellingPartnerAPIAA.LWAAuthorizationSigner;
import com.amazon.SellingPartnerAPIAA.LWAException;
import com.amazon.SellingPartnerAPIAA.RestrictedDataTokenSigner;
import com.google.gson.reflect.TypeToken;
import io.github.bucket4j.Bucket;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import okhttp3.Call;
import okhttp3.Request;
import software.amazon.spapi.ApiCallback;
import software.amazon.spapi.ApiClient;
import software.amazon.spapi.ApiException;
import software.amazon.spapi.ApiResponse;
import software.amazon.spapi.Configuration;
import software.amazon.spapi.Pair;
import software.amazon.spapi.ProgressRequestBody;
import software.amazon.spapi.StringUtil;
import software.amazon.spapi.models.replenishment.v2022_11_07.GetSellingPartnerMetricsRequest;
import software.amazon.spapi.models.replenishment.v2022_11_07.GetSellingPartnerMetricsResponse;

public class SellingpartnersApi {
    private ApiClient apiClient;
    private Boolean disableRateLimiting;
    private final Configuration config = Configuration.get();
    public final Bucket getSellingPartnerMetricsBucket = Bucket.builder().addLimit(this.config.getLimit("SellingpartnersApi-getSellingPartnerMetrics")).build();

    public SellingpartnersApi(ApiClient apiClient, Boolean disableRateLimiting) {
        this.apiClient = apiClient;
        this.disableRateLimiting = disableRateLimiting;
    }

    private Call getSellingPartnerMetricsCall(GetSellingPartnerMetricsRequest body, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        GetSellingPartnerMetricsRequest localVarPostBody = body;
        String localVarPath = "/replenishment/2022-11-07/sellingPartners/metrics/search".equals("/uploads/2020-11-01/uploadDestinations/{resource}") ? "/replenishment/2022-11-07/sellingPartners/metrics/search" : "/replenishment/2022-11-07/sellingPartners/metrics/search";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, progressRequestListener);
    }

    private Call getSellingPartnerMetricsValidateBeforeCall(GetSellingPartnerMetricsRequest body, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        return this.getSellingPartnerMetricsCall(body, progressRequestListener);
    }

    public GetSellingPartnerMetricsResponse getSellingPartnerMetrics(GetSellingPartnerMetricsRequest body, String restrictedDataToken) throws ApiException, LWAException {
        ApiResponse<GetSellingPartnerMetricsResponse> resp = this.getSellingPartnerMetricsWithHttpInfo(body, restrictedDataToken);
        return resp.getData();
    }

    public GetSellingPartnerMetricsResponse getSellingPartnerMetrics(GetSellingPartnerMetricsRequest body) throws ApiException, LWAException {
        ApiResponse<GetSellingPartnerMetricsResponse> resp = this.getSellingPartnerMetricsWithHttpInfo(body, null);
        return resp.getData();
    }

    public ApiResponse<GetSellingPartnerMetricsResponse> getSellingPartnerMetricsWithHttpInfo(GetSellingPartnerMetricsRequest body, String restrictedDataToken) throws ApiException, LWAException {
        Call call = this.getSellingPartnerMetricsValidateBeforeCall(body, null);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "SellingpartnersApi-getSellingPartnerMetrics");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.getSellingPartnerMetricsBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<GetSellingPartnerMetricsResponse>(){}.getType();
            return this.apiClient.execute(call, localVarReturnType);
        }
        throw new ApiException.RateLimitExceeded("getSellingPartnerMetrics operation exceeds rate limit");
    }

    public ApiResponse<GetSellingPartnerMetricsResponse> getSellingPartnerMetricsWithHttpInfo(GetSellingPartnerMetricsRequest body) throws ApiException, LWAException {
        return this.getSellingPartnerMetricsWithHttpInfo(body, null);
    }

    public Call getSellingPartnerMetricsAsync(GetSellingPartnerMetricsRequest body, ApiCallback<GetSellingPartnerMetricsResponse> callback) throws ApiException, LWAException {
        return this.getSellingPartnerMetricsAsync(body, callback, null);
    }

    public Call getSellingPartnerMetricsAsync(GetSellingPartnerMetricsRequest body, ApiCallback<GetSellingPartnerMetricsResponse> callback, String restrictedDataToken) throws ApiException, LWAException {
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressRequestListener = callback::onUploadProgress;
        }
        Call call = this.getSellingPartnerMetricsValidateBeforeCall(body, progressRequestListener);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "SellingpartnersApi-getSellingPartnerMetrics");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.getSellingPartnerMetricsBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<GetSellingPartnerMetricsResponse>(){}.getType();
            this.apiClient.executeAsync(call, localVarReturnType, callback);
            return call;
        }
        throw new ApiException.RateLimitExceeded("getSellingPartnerMetrics operation exceeds rate limit");
    }

    public static class Builder {
        private LWAAuthorizationCredentials lwaAuthorizationCredentials;
        private String endpoint;
        private LWAAccessTokenCache lwaAccessTokenCache;
        private Boolean disableAccessTokenCache = false;
        private Boolean disableRateLimiting = false;

        public Builder lwaAuthorizationCredentials(LWAAuthorizationCredentials lwaAuthorizationCredentials) {
            this.lwaAuthorizationCredentials = lwaAuthorizationCredentials;
            return this;
        }

        public Builder endpoint(String endpoint) {
            this.endpoint = endpoint;
            return this;
        }

        public Builder lwaAccessTokenCache(LWAAccessTokenCache lwaAccessTokenCache) {
            this.lwaAccessTokenCache = lwaAccessTokenCache;
            return this;
        }

        public Builder disableAccessTokenCache() {
            this.disableAccessTokenCache = true;
            return this;
        }

        public Builder disableRateLimiting() {
            this.disableRateLimiting = true;
            return this;
        }

        public SellingpartnersApi build() {
            if (this.lwaAuthorizationCredentials == null) {
                throw new RuntimeException("LWAAuthorizationCredentials not set");
            }
            if (StringUtil.isEmpty(this.endpoint)) {
                throw new RuntimeException("Endpoint not set");
            }
            LWAAuthorizationSigner lwaAuthorizationSigner = null;
            if (this.disableAccessTokenCache.booleanValue()) {
                lwaAuthorizationSigner = new LWAAuthorizationSigner(this.lwaAuthorizationCredentials);
            } else {
                if (this.lwaAccessTokenCache == null) {
                    this.lwaAccessTokenCache = new LWAAccessTokenCacheImpl();
                }
                lwaAuthorizationSigner = new LWAAuthorizationSigner(this.lwaAuthorizationCredentials, this.lwaAccessTokenCache);
            }
            return new SellingpartnersApi(new ApiClient().setLWAAuthorizationSigner(lwaAuthorizationSigner).setBasePath(this.endpoint), this.disableRateLimiting);
        }
    }
}

