/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.api.replenishment.v2022_11_07;

import com.amazon.SellingPartnerAPIAA.LWAAccessTokenCache;
import com.amazon.SellingPartnerAPIAA.LWAAccessTokenCacheImpl;
import com.amazon.SellingPartnerAPIAA.LWAAuthorizationCredentials;
import com.amazon.SellingPartnerAPIAA.LWAAuthorizationSigner;
import com.amazon.SellingPartnerAPIAA.LWAException;
import com.amazon.SellingPartnerAPIAA.RestrictedDataTokenSigner;
import com.google.gson.reflect.TypeToken;
import io.github.bucket4j.Bucket;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import okhttp3.Call;
import okhttp3.Request;
import software.amazon.spapi.ApiCallback;
import software.amazon.spapi.ApiClient;
import software.amazon.spapi.ApiException;
import software.amazon.spapi.ApiResponse;
import software.amazon.spapi.Configuration;
import software.amazon.spapi.Pair;
import software.amazon.spapi.ProgressRequestBody;
import software.amazon.spapi.StringUtil;
import software.amazon.spapi.models.replenishment.v2022_11_07.ListOfferMetricsRequest;
import software.amazon.spapi.models.replenishment.v2022_11_07.ListOfferMetricsResponse;
import software.amazon.spapi.models.replenishment.v2022_11_07.ListOffersRequest;
import software.amazon.spapi.models.replenishment.v2022_11_07.ListOffersResponse;

public class OffersApi {
    private ApiClient apiClient;
    private Boolean disableRateLimiting;
    private final Configuration config = Configuration.get();
    public final Bucket listOfferMetricsBucket = Bucket.builder().addLimit(this.config.getLimit("OffersApi-listOfferMetrics")).build();
    public final Bucket listOffersBucket = Bucket.builder().addLimit(this.config.getLimit("OffersApi-listOffers")).build();

    public OffersApi(ApiClient apiClient, Boolean disableRateLimiting) {
        this.apiClient = apiClient;
        this.disableRateLimiting = disableRateLimiting;
    }

    private Call listOfferMetricsCall(ListOfferMetricsRequest body, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        ListOfferMetricsRequest localVarPostBody = body;
        String localVarPath = "/replenishment/2022-11-07/offers/metrics/search".equals("/uploads/2020-11-01/uploadDestinations/{resource}") ? "/replenishment/2022-11-07/offers/metrics/search" : "/replenishment/2022-11-07/offers/metrics/search";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, progressRequestListener);
    }

    private Call listOfferMetricsValidateBeforeCall(ListOfferMetricsRequest body, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        return this.listOfferMetricsCall(body, progressRequestListener);
    }

    public ListOfferMetricsResponse listOfferMetrics(ListOfferMetricsRequest body, String restrictedDataToken) throws ApiException, LWAException {
        ApiResponse<ListOfferMetricsResponse> resp = this.listOfferMetricsWithHttpInfo(body, restrictedDataToken);
        return resp.getData();
    }

    public ListOfferMetricsResponse listOfferMetrics(ListOfferMetricsRequest body) throws ApiException, LWAException {
        ApiResponse<ListOfferMetricsResponse> resp = this.listOfferMetricsWithHttpInfo(body, null);
        return resp.getData();
    }

    public ApiResponse<ListOfferMetricsResponse> listOfferMetricsWithHttpInfo(ListOfferMetricsRequest body, String restrictedDataToken) throws ApiException, LWAException {
        Call call = this.listOfferMetricsValidateBeforeCall(body, null);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "OffersApi-listOfferMetrics");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.listOfferMetricsBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<ListOfferMetricsResponse>(){}.getType();
            return this.apiClient.execute(call, localVarReturnType);
        }
        throw new ApiException.RateLimitExceeded("listOfferMetrics operation exceeds rate limit");
    }

    public ApiResponse<ListOfferMetricsResponse> listOfferMetricsWithHttpInfo(ListOfferMetricsRequest body) throws ApiException, LWAException {
        return this.listOfferMetricsWithHttpInfo(body, null);
    }

    public Call listOfferMetricsAsync(ListOfferMetricsRequest body, ApiCallback<ListOfferMetricsResponse> callback) throws ApiException, LWAException {
        return this.listOfferMetricsAsync(body, callback, null);
    }

    public Call listOfferMetricsAsync(ListOfferMetricsRequest body, ApiCallback<ListOfferMetricsResponse> callback, String restrictedDataToken) throws ApiException, LWAException {
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressRequestListener = callback::onUploadProgress;
        }
        Call call = this.listOfferMetricsValidateBeforeCall(body, progressRequestListener);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "OffersApi-listOfferMetrics");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.listOfferMetricsBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<ListOfferMetricsResponse>(){}.getType();
            this.apiClient.executeAsync(call, localVarReturnType, callback);
            return call;
        }
        throw new ApiException.RateLimitExceeded("listOfferMetrics operation exceeds rate limit");
    }

    private Call listOffersCall(ListOffersRequest body, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        ListOffersRequest localVarPostBody = body;
        String localVarPath = "/replenishment/2022-11-07/offers/search".equals("/uploads/2020-11-01/uploadDestinations/{resource}") ? "/replenishment/2022-11-07/offers/search" : "/replenishment/2022-11-07/offers/search";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, progressRequestListener);
    }

    private Call listOffersValidateBeforeCall(ListOffersRequest body, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        return this.listOffersCall(body, progressRequestListener);
    }

    public ListOffersResponse listOffers(ListOffersRequest body, String restrictedDataToken) throws ApiException, LWAException {
        ApiResponse<ListOffersResponse> resp = this.listOffersWithHttpInfo(body, restrictedDataToken);
        return resp.getData();
    }

    public ListOffersResponse listOffers(ListOffersRequest body) throws ApiException, LWAException {
        ApiResponse<ListOffersResponse> resp = this.listOffersWithHttpInfo(body, null);
        return resp.getData();
    }

    public ApiResponse<ListOffersResponse> listOffersWithHttpInfo(ListOffersRequest body, String restrictedDataToken) throws ApiException, LWAException {
        Call call = this.listOffersValidateBeforeCall(body, null);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "OffersApi-listOffers");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.listOffersBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<ListOffersResponse>(){}.getType();
            return this.apiClient.execute(call, localVarReturnType);
        }
        throw new ApiException.RateLimitExceeded("listOffers operation exceeds rate limit");
    }

    public ApiResponse<ListOffersResponse> listOffersWithHttpInfo(ListOffersRequest body) throws ApiException, LWAException {
        return this.listOffersWithHttpInfo(body, null);
    }

    public Call listOffersAsync(ListOffersRequest body, ApiCallback<ListOffersResponse> callback) throws ApiException, LWAException {
        return this.listOffersAsync(body, callback, null);
    }

    public Call listOffersAsync(ListOffersRequest body, ApiCallback<ListOffersResponse> callback, String restrictedDataToken) throws ApiException, LWAException {
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressRequestListener = callback::onUploadProgress;
        }
        Call call = this.listOffersValidateBeforeCall(body, progressRequestListener);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "OffersApi-listOffers");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.listOffersBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<ListOffersResponse>(){}.getType();
            this.apiClient.executeAsync(call, localVarReturnType, callback);
            return call;
        }
        throw new ApiException.RateLimitExceeded("listOffers operation exceeds rate limit");
    }

    public static class Builder {
        private LWAAuthorizationCredentials lwaAuthorizationCredentials;
        private String endpoint;
        private LWAAccessTokenCache lwaAccessTokenCache;
        private Boolean disableAccessTokenCache = false;
        private Boolean disableRateLimiting = false;

        public Builder lwaAuthorizationCredentials(LWAAuthorizationCredentials lwaAuthorizationCredentials) {
            this.lwaAuthorizationCredentials = lwaAuthorizationCredentials;
            return this;
        }

        public Builder endpoint(String endpoint) {
            this.endpoint = endpoint;
            return this;
        }

        public Builder lwaAccessTokenCache(LWAAccessTokenCache lwaAccessTokenCache) {
            this.lwaAccessTokenCache = lwaAccessTokenCache;
            return this;
        }

        public Builder disableAccessTokenCache() {
            this.disableAccessTokenCache = true;
            return this;
        }

        public Builder disableRateLimiting() {
            this.disableRateLimiting = true;
            return this;
        }

        public OffersApi build() {
            if (this.lwaAuthorizationCredentials == null) {
                throw new RuntimeException("LWAAuthorizationCredentials not set");
            }
            if (StringUtil.isEmpty(this.endpoint)) {
                throw new RuntimeException("Endpoint not set");
            }
            LWAAuthorizationSigner lwaAuthorizationSigner = null;
            if (this.disableAccessTokenCache.booleanValue()) {
                lwaAuthorizationSigner = new LWAAuthorizationSigner(this.lwaAuthorizationCredentials);
            } else {
                if (this.lwaAccessTokenCache == null) {
                    this.lwaAccessTokenCache = new LWAAccessTokenCacheImpl();
                }
                lwaAuthorizationSigner = new LWAAuthorizationSigner(this.lwaAuthorizationCredentials, this.lwaAccessTokenCache);
            }
            return new OffersApi(new ApiClient().setLWAAuthorizationSigner(lwaAuthorizationSigner).setBasePath(this.endpoint), this.disableRateLimiting);
        }
    }
}

