/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.api.orders.v0;

import com.amazon.SellingPartnerAPIAA.LWAAccessTokenCache;
import com.amazon.SellingPartnerAPIAA.LWAAccessTokenCacheImpl;
import com.amazon.SellingPartnerAPIAA.LWAAuthorizationCredentials;
import com.amazon.SellingPartnerAPIAA.LWAAuthorizationSigner;
import com.amazon.SellingPartnerAPIAA.LWAException;
import com.amazon.SellingPartnerAPIAA.RestrictedDataTokenSigner;
import io.github.bucket4j.Bucket;
import java.util.ArrayList;
import java.util.HashMap;
import okhttp3.Call;
import okhttp3.Request;
import software.amazon.spapi.ApiCallback;
import software.amazon.spapi.ApiClient;
import software.amazon.spapi.ApiException;
import software.amazon.spapi.ApiResponse;
import software.amazon.spapi.Configuration;
import software.amazon.spapi.Pair;
import software.amazon.spapi.ProgressRequestBody;
import software.amazon.spapi.StringUtil;
import software.amazon.spapi.models.orders.v0.UpdateShipmentStatusRequest;

public class ShipmentApi {
    private ApiClient apiClient;
    private Boolean disableRateLimiting;
    private final Configuration config = Configuration.get();
    public final Bucket updateShipmentStatusBucket = Bucket.builder().addLimit(this.config.getLimit("ShipmentApi-updateShipmentStatus")).build();

    public ShipmentApi(ApiClient apiClient, Boolean disableRateLimiting) {
        this.apiClient = apiClient;
        this.disableRateLimiting = disableRateLimiting;
    }

    private Call updateShipmentStatusCall(UpdateShipmentStatusRequest body, String orderId, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        UpdateShipmentStatusRequest localVarPostBody = body;
        String localVarPath = "/orders/v0/orders/{orderId}/shipment".equals("/uploads/2020-11-01/uploadDestinations/{resource}") ? "/orders/v0/orders/{orderId}/shipment".replaceAll("\\{orderId\\}", orderId.toString()) : "/orders/v0/orders/{orderId}/shipment".replaceAll("\\{orderId\\}", this.apiClient.escapeString(orderId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, progressRequestListener);
    }

    private Call updateShipmentStatusValidateBeforeCall(UpdateShipmentStatusRequest body, String orderId, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling updateShipmentStatus(Async)");
        }
        if (orderId == null) {
            throw new ApiException("Missing the required parameter 'orderId' when calling updateShipmentStatus(Async)");
        }
        return this.updateShipmentStatusCall(body, orderId, progressRequestListener);
    }

    public void updateShipmentStatus(UpdateShipmentStatusRequest body, String orderId, String restrictedDataToken) throws ApiException, LWAException {
        this.updateShipmentStatusWithHttpInfo(body, orderId, restrictedDataToken);
    }

    public void updateShipmentStatus(UpdateShipmentStatusRequest body, String orderId) throws ApiException, LWAException {
        this.updateShipmentStatusWithHttpInfo(body, orderId, null);
    }

    public ApiResponse<Void> updateShipmentStatusWithHttpInfo(UpdateShipmentStatusRequest body, String orderId, String restrictedDataToken) throws ApiException, LWAException {
        Call call = this.updateShipmentStatusValidateBeforeCall(body, orderId, null);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "ShipmentApi-updateShipmentStatus");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.updateShipmentStatusBucket.tryConsume(1L)) {
            return this.apiClient.execute(call);
        }
        throw new ApiException.RateLimitExceeded("updateShipmentStatus operation exceeds rate limit");
    }

    public ApiResponse<Void> updateShipmentStatusWithHttpInfo(UpdateShipmentStatusRequest body, String orderId) throws ApiException, LWAException {
        return this.updateShipmentStatusWithHttpInfo(body, orderId, null);
    }

    public Call updateShipmentStatusAsync(UpdateShipmentStatusRequest body, String orderId, ApiCallback<Void> callback) throws ApiException, LWAException {
        return this.updateShipmentStatusAsync(body, orderId, callback, null);
    }

    public Call updateShipmentStatusAsync(UpdateShipmentStatusRequest body, String orderId, ApiCallback<Void> callback, String restrictedDataToken) throws ApiException, LWAException {
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressRequestListener = callback::onUploadProgress;
        }
        Call call = this.updateShipmentStatusValidateBeforeCall(body, orderId, progressRequestListener);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "ShipmentApi-updateShipmentStatus");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.updateShipmentStatusBucket.tryConsume(1L)) {
            this.apiClient.executeAsync(call, callback);
            return call;
        }
        throw new ApiException.RateLimitExceeded("updateShipmentStatus operation exceeds rate limit");
    }

    public static class Builder {
        private LWAAuthorizationCredentials lwaAuthorizationCredentials;
        private String endpoint;
        private LWAAccessTokenCache lwaAccessTokenCache;
        private Boolean disableAccessTokenCache = false;
        private Boolean disableRateLimiting = false;

        public Builder lwaAuthorizationCredentials(LWAAuthorizationCredentials lwaAuthorizationCredentials) {
            this.lwaAuthorizationCredentials = lwaAuthorizationCredentials;
            return this;
        }

        public Builder endpoint(String endpoint) {
            this.endpoint = endpoint;
            return this;
        }

        public Builder lwaAccessTokenCache(LWAAccessTokenCache lwaAccessTokenCache) {
            this.lwaAccessTokenCache = lwaAccessTokenCache;
            return this;
        }

        public Builder disableAccessTokenCache() {
            this.disableAccessTokenCache = true;
            return this;
        }

        public Builder disableRateLimiting() {
            this.disableRateLimiting = true;
            return this;
        }

        public ShipmentApi build() {
            if (this.lwaAuthorizationCredentials == null) {
                throw new RuntimeException("LWAAuthorizationCredentials not set");
            }
            if (StringUtil.isEmpty(this.endpoint)) {
                throw new RuntimeException("Endpoint not set");
            }
            LWAAuthorizationSigner lwaAuthorizationSigner = null;
            if (this.disableAccessTokenCache.booleanValue()) {
                lwaAuthorizationSigner = new LWAAuthorizationSigner(this.lwaAuthorizationCredentials);
            } else {
                if (this.lwaAccessTokenCache == null) {
                    this.lwaAccessTokenCache = new LWAAccessTokenCacheImpl();
                }
                lwaAuthorizationSigner = new LWAAuthorizationSigner(this.lwaAuthorizationCredentials, this.lwaAccessTokenCache);
            }
            return new ShipmentApi(new ApiClient().setLWAAuthorizationSigner(lwaAuthorizationSigner).setBasePath(this.endpoint), this.disableRateLimiting);
        }
    }
}

