/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.api.orders.v0;

import com.amazon.SellingPartnerAPIAA.LWAAccessTokenCache;
import com.amazon.SellingPartnerAPIAA.LWAAccessTokenCacheImpl;
import com.amazon.SellingPartnerAPIAA.LWAAuthorizationCredentials;
import com.amazon.SellingPartnerAPIAA.LWAAuthorizationSigner;
import com.amazon.SellingPartnerAPIAA.LWAException;
import com.amazon.SellingPartnerAPIAA.RestrictedDataTokenSigner;
import com.google.gson.reflect.TypeToken;
import io.github.bucket4j.Bucket;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import okhttp3.Call;
import okhttp3.Request;
import software.amazon.spapi.ApiCallback;
import software.amazon.spapi.ApiClient;
import software.amazon.spapi.ApiException;
import software.amazon.spapi.ApiResponse;
import software.amazon.spapi.Configuration;
import software.amazon.spapi.Pair;
import software.amazon.spapi.ProgressRequestBody;
import software.amazon.spapi.StringUtil;
import software.amazon.spapi.models.orders.v0.ConfirmShipmentRequest;
import software.amazon.spapi.models.orders.v0.GetOrderAddressResponse;
import software.amazon.spapi.models.orders.v0.GetOrderBuyerInfoResponse;
import software.amazon.spapi.models.orders.v0.GetOrderItemsBuyerInfoResponse;
import software.amazon.spapi.models.orders.v0.GetOrderItemsResponse;
import software.amazon.spapi.models.orders.v0.GetOrderRegulatedInfoResponse;
import software.amazon.spapi.models.orders.v0.GetOrderResponse;
import software.amazon.spapi.models.orders.v0.GetOrdersResponse;
import software.amazon.spapi.models.orders.v0.UpdateVerificationStatusRequest;

public class OrdersV0Api {
    private ApiClient apiClient;
    private Boolean disableRateLimiting;
    private final Configuration config = Configuration.get();
    public final Bucket confirmShipmentBucket = Bucket.builder().addLimit(this.config.getLimit("OrdersV0Api-confirmShipment")).build();
    public final Bucket getOrderBucket = Bucket.builder().addLimit(this.config.getLimit("OrdersV0Api-getOrder")).build();
    public final Bucket getOrderAddressBucket = Bucket.builder().addLimit(this.config.getLimit("OrdersV0Api-getOrderAddress")).build();
    public final Bucket getOrderBuyerInfoBucket = Bucket.builder().addLimit(this.config.getLimit("OrdersV0Api-getOrderBuyerInfo")).build();
    public final Bucket getOrderItemsBucket = Bucket.builder().addLimit(this.config.getLimit("OrdersV0Api-getOrderItems")).build();
    public final Bucket getOrderItemsBuyerInfoBucket = Bucket.builder().addLimit(this.config.getLimit("OrdersV0Api-getOrderItemsBuyerInfo")).build();
    public final Bucket getOrderRegulatedInfoBucket = Bucket.builder().addLimit(this.config.getLimit("OrdersV0Api-getOrderRegulatedInfo")).build();
    public final Bucket getOrdersBucket = Bucket.builder().addLimit(this.config.getLimit("OrdersV0Api-getOrders")).build();
    public final Bucket updateVerificationStatusBucket = Bucket.builder().addLimit(this.config.getLimit("OrdersV0Api-updateVerificationStatus")).build();

    public OrdersV0Api(ApiClient apiClient, Boolean disableRateLimiting) {
        this.apiClient = apiClient;
        this.disableRateLimiting = disableRateLimiting;
    }

    private Call confirmShipmentCall(ConfirmShipmentRequest body, String orderId, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        ConfirmShipmentRequest localVarPostBody = body;
        String localVarPath = "/orders/v0/orders/{orderId}/shipmentConfirmation".equals("/uploads/2020-11-01/uploadDestinations/{resource}") ? "/orders/v0/orders/{orderId}/shipmentConfirmation".replaceAll("\\{orderId\\}", orderId.toString()) : "/orders/v0/orders/{orderId}/shipmentConfirmation".replaceAll("\\{orderId\\}", this.apiClient.escapeString(orderId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, progressRequestListener);
    }

    private Call confirmShipmentValidateBeforeCall(ConfirmShipmentRequest body, String orderId, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling confirmShipment(Async)");
        }
        if (orderId == null) {
            throw new ApiException("Missing the required parameter 'orderId' when calling confirmShipment(Async)");
        }
        return this.confirmShipmentCall(body, orderId, progressRequestListener);
    }

    public void confirmShipment(ConfirmShipmentRequest body, String orderId, String restrictedDataToken) throws ApiException, LWAException {
        this.confirmShipmentWithHttpInfo(body, orderId, restrictedDataToken);
    }

    public void confirmShipment(ConfirmShipmentRequest body, String orderId) throws ApiException, LWAException {
        this.confirmShipmentWithHttpInfo(body, orderId, null);
    }

    public ApiResponse<Void> confirmShipmentWithHttpInfo(ConfirmShipmentRequest body, String orderId, String restrictedDataToken) throws ApiException, LWAException {
        Call call = this.confirmShipmentValidateBeforeCall(body, orderId, null);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "OrdersV0Api-confirmShipment");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.confirmShipmentBucket.tryConsume(1L)) {
            return this.apiClient.execute(call);
        }
        throw new ApiException.RateLimitExceeded("confirmShipment operation exceeds rate limit");
    }

    public ApiResponse<Void> confirmShipmentWithHttpInfo(ConfirmShipmentRequest body, String orderId) throws ApiException, LWAException {
        return this.confirmShipmentWithHttpInfo(body, orderId, null);
    }

    public Call confirmShipmentAsync(ConfirmShipmentRequest body, String orderId, ApiCallback<Void> callback) throws ApiException, LWAException {
        return this.confirmShipmentAsync(body, orderId, callback, null);
    }

    public Call confirmShipmentAsync(ConfirmShipmentRequest body, String orderId, ApiCallback<Void> callback, String restrictedDataToken) throws ApiException, LWAException {
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressRequestListener = callback::onUploadProgress;
        }
        Call call = this.confirmShipmentValidateBeforeCall(body, orderId, progressRequestListener);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "OrdersV0Api-confirmShipment");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.confirmShipmentBucket.tryConsume(1L)) {
            this.apiClient.executeAsync(call, callback);
            return call;
        }
        throw new ApiException.RateLimitExceeded("confirmShipment operation exceeds rate limit");
    }

    private Call getOrderCall(String orderId, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        Object localVarPostBody = null;
        String localVarPath = "/orders/v0/orders/{orderId}".equals("/uploads/2020-11-01/uploadDestinations/{resource}") ? "/orders/v0/orders/{orderId}".replaceAll("\\{orderId\\}", orderId.toString()) : "/orders/v0/orders/{orderId}".replaceAll("\\{orderId\\}", this.apiClient.escapeString(orderId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, progressRequestListener);
    }

    private Call getOrderValidateBeforeCall(String orderId, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        if (orderId == null) {
            throw new ApiException("Missing the required parameter 'orderId' when calling getOrder(Async)");
        }
        return this.getOrderCall(orderId, progressRequestListener);
    }

    public GetOrderResponse getOrder(String orderId, String restrictedDataToken) throws ApiException, LWAException {
        ApiResponse<GetOrderResponse> resp = this.getOrderWithHttpInfo(orderId, restrictedDataToken);
        return resp.getData();
    }

    public GetOrderResponse getOrder(String orderId) throws ApiException, LWAException {
        ApiResponse<GetOrderResponse> resp = this.getOrderWithHttpInfo(orderId, null);
        return resp.getData();
    }

    public ApiResponse<GetOrderResponse> getOrderWithHttpInfo(String orderId, String restrictedDataToken) throws ApiException, LWAException {
        Call call = this.getOrderValidateBeforeCall(orderId, null);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "OrdersV0Api-getOrder");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.getOrderBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<GetOrderResponse>(){}.getType();
            return this.apiClient.execute(call, localVarReturnType);
        }
        throw new ApiException.RateLimitExceeded("getOrder operation exceeds rate limit");
    }

    public ApiResponse<GetOrderResponse> getOrderWithHttpInfo(String orderId) throws ApiException, LWAException {
        return this.getOrderWithHttpInfo(orderId, null);
    }

    public Call getOrderAsync(String orderId, ApiCallback<GetOrderResponse> callback) throws ApiException, LWAException {
        return this.getOrderAsync(orderId, callback, null);
    }

    public Call getOrderAsync(String orderId, ApiCallback<GetOrderResponse> callback, String restrictedDataToken) throws ApiException, LWAException {
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressRequestListener = callback::onUploadProgress;
        }
        Call call = this.getOrderValidateBeforeCall(orderId, progressRequestListener);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "OrdersV0Api-getOrder");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.getOrderBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<GetOrderResponse>(){}.getType();
            this.apiClient.executeAsync(call, localVarReturnType, callback);
            return call;
        }
        throw new ApiException.RateLimitExceeded("getOrder operation exceeds rate limit");
    }

    private Call getOrderAddressCall(String orderId, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        Object localVarPostBody = null;
        String localVarPath = "/orders/v0/orders/{orderId}/address".equals("/uploads/2020-11-01/uploadDestinations/{resource}") ? "/orders/v0/orders/{orderId}/address".replaceAll("\\{orderId\\}", orderId.toString()) : "/orders/v0/orders/{orderId}/address".replaceAll("\\{orderId\\}", this.apiClient.escapeString(orderId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, progressRequestListener);
    }

    private Call getOrderAddressValidateBeforeCall(String orderId, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        if (orderId == null) {
            throw new ApiException("Missing the required parameter 'orderId' when calling getOrderAddress(Async)");
        }
        return this.getOrderAddressCall(orderId, progressRequestListener);
    }

    public GetOrderAddressResponse getOrderAddress(String orderId, String restrictedDataToken) throws ApiException, LWAException {
        ApiResponse<GetOrderAddressResponse> resp = this.getOrderAddressWithHttpInfo(orderId, restrictedDataToken);
        return resp.getData();
    }

    public GetOrderAddressResponse getOrderAddress(String orderId) throws ApiException, LWAException {
        ApiResponse<GetOrderAddressResponse> resp = this.getOrderAddressWithHttpInfo(orderId, null);
        return resp.getData();
    }

    public ApiResponse<GetOrderAddressResponse> getOrderAddressWithHttpInfo(String orderId, String restrictedDataToken) throws ApiException, LWAException {
        Call call = this.getOrderAddressValidateBeforeCall(orderId, null);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "OrdersV0Api-getOrderAddress");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.getOrderAddressBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<GetOrderAddressResponse>(){}.getType();
            return this.apiClient.execute(call, localVarReturnType);
        }
        throw new ApiException.RateLimitExceeded("getOrderAddress operation exceeds rate limit");
    }

    public ApiResponse<GetOrderAddressResponse> getOrderAddressWithHttpInfo(String orderId) throws ApiException, LWAException {
        return this.getOrderAddressWithHttpInfo(orderId, null);
    }

    public Call getOrderAddressAsync(String orderId, ApiCallback<GetOrderAddressResponse> callback) throws ApiException, LWAException {
        return this.getOrderAddressAsync(orderId, callback, null);
    }

    public Call getOrderAddressAsync(String orderId, ApiCallback<GetOrderAddressResponse> callback, String restrictedDataToken) throws ApiException, LWAException {
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressRequestListener = callback::onUploadProgress;
        }
        Call call = this.getOrderAddressValidateBeforeCall(orderId, progressRequestListener);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "OrdersV0Api-getOrderAddress");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.getOrderAddressBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<GetOrderAddressResponse>(){}.getType();
            this.apiClient.executeAsync(call, localVarReturnType, callback);
            return call;
        }
        throw new ApiException.RateLimitExceeded("getOrderAddress operation exceeds rate limit");
    }

    private Call getOrderBuyerInfoCall(String orderId, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        Object localVarPostBody = null;
        String localVarPath = "/orders/v0/orders/{orderId}/buyerInfo".equals("/uploads/2020-11-01/uploadDestinations/{resource}") ? "/orders/v0/orders/{orderId}/buyerInfo".replaceAll("\\{orderId\\}", orderId.toString()) : "/orders/v0/orders/{orderId}/buyerInfo".replaceAll("\\{orderId\\}", this.apiClient.escapeString(orderId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, progressRequestListener);
    }

    private Call getOrderBuyerInfoValidateBeforeCall(String orderId, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        if (orderId == null) {
            throw new ApiException("Missing the required parameter 'orderId' when calling getOrderBuyerInfo(Async)");
        }
        return this.getOrderBuyerInfoCall(orderId, progressRequestListener);
    }

    public GetOrderBuyerInfoResponse getOrderBuyerInfo(String orderId, String restrictedDataToken) throws ApiException, LWAException {
        ApiResponse<GetOrderBuyerInfoResponse> resp = this.getOrderBuyerInfoWithHttpInfo(orderId, restrictedDataToken);
        return resp.getData();
    }

    public GetOrderBuyerInfoResponse getOrderBuyerInfo(String orderId) throws ApiException, LWAException {
        ApiResponse<GetOrderBuyerInfoResponse> resp = this.getOrderBuyerInfoWithHttpInfo(orderId, null);
        return resp.getData();
    }

    public ApiResponse<GetOrderBuyerInfoResponse> getOrderBuyerInfoWithHttpInfo(String orderId, String restrictedDataToken) throws ApiException, LWAException {
        Call call = this.getOrderBuyerInfoValidateBeforeCall(orderId, null);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "OrdersV0Api-getOrderBuyerInfo");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.getOrderBuyerInfoBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<GetOrderBuyerInfoResponse>(){}.getType();
            return this.apiClient.execute(call, localVarReturnType);
        }
        throw new ApiException.RateLimitExceeded("getOrderBuyerInfo operation exceeds rate limit");
    }

    public ApiResponse<GetOrderBuyerInfoResponse> getOrderBuyerInfoWithHttpInfo(String orderId) throws ApiException, LWAException {
        return this.getOrderBuyerInfoWithHttpInfo(orderId, null);
    }

    public Call getOrderBuyerInfoAsync(String orderId, ApiCallback<GetOrderBuyerInfoResponse> callback) throws ApiException, LWAException {
        return this.getOrderBuyerInfoAsync(orderId, callback, null);
    }

    public Call getOrderBuyerInfoAsync(String orderId, ApiCallback<GetOrderBuyerInfoResponse> callback, String restrictedDataToken) throws ApiException, LWAException {
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressRequestListener = callback::onUploadProgress;
        }
        Call call = this.getOrderBuyerInfoValidateBeforeCall(orderId, progressRequestListener);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "OrdersV0Api-getOrderBuyerInfo");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.getOrderBuyerInfoBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<GetOrderBuyerInfoResponse>(){}.getType();
            this.apiClient.executeAsync(call, localVarReturnType, callback);
            return call;
        }
        throw new ApiException.RateLimitExceeded("getOrderBuyerInfo operation exceeds rate limit");
    }

    private Call getOrderItemsCall(String orderId, String nextToken, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        Object localVarPostBody = null;
        String localVarPath = "/orders/v0/orders/{orderId}/orderItems".equals("/uploads/2020-11-01/uploadDestinations/{resource}") ? "/orders/v0/orders/{orderId}/orderItems".replaceAll("\\{orderId\\}", orderId.toString()) : "/orders/v0/orders/{orderId}/orderItems".replaceAll("\\{orderId\\}", this.apiClient.escapeString(orderId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (nextToken != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("NextToken", nextToken));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, progressRequestListener);
    }

    private Call getOrderItemsValidateBeforeCall(String orderId, String nextToken, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        if (orderId == null) {
            throw new ApiException("Missing the required parameter 'orderId' when calling getOrderItems(Async)");
        }
        return this.getOrderItemsCall(orderId, nextToken, progressRequestListener);
    }

    public GetOrderItemsResponse getOrderItems(String orderId, String nextToken, String restrictedDataToken) throws ApiException, LWAException {
        ApiResponse<GetOrderItemsResponse> resp = this.getOrderItemsWithHttpInfo(orderId, nextToken, restrictedDataToken);
        return resp.getData();
    }

    public GetOrderItemsResponse getOrderItems(String orderId, String nextToken) throws ApiException, LWAException {
        ApiResponse<GetOrderItemsResponse> resp = this.getOrderItemsWithHttpInfo(orderId, nextToken, null);
        return resp.getData();
    }

    public ApiResponse<GetOrderItemsResponse> getOrderItemsWithHttpInfo(String orderId, String nextToken, String restrictedDataToken) throws ApiException, LWAException {
        Call call = this.getOrderItemsValidateBeforeCall(orderId, nextToken, null);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "OrdersV0Api-getOrderItems");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.getOrderItemsBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<GetOrderItemsResponse>(){}.getType();
            return this.apiClient.execute(call, localVarReturnType);
        }
        throw new ApiException.RateLimitExceeded("getOrderItems operation exceeds rate limit");
    }

    public ApiResponse<GetOrderItemsResponse> getOrderItemsWithHttpInfo(String orderId, String nextToken) throws ApiException, LWAException {
        return this.getOrderItemsWithHttpInfo(orderId, nextToken, null);
    }

    public Call getOrderItemsAsync(String orderId, String nextToken, ApiCallback<GetOrderItemsResponse> callback) throws ApiException, LWAException {
        return this.getOrderItemsAsync(orderId, nextToken, callback, null);
    }

    public Call getOrderItemsAsync(String orderId, String nextToken, ApiCallback<GetOrderItemsResponse> callback, String restrictedDataToken) throws ApiException, LWAException {
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressRequestListener = callback::onUploadProgress;
        }
        Call call = this.getOrderItemsValidateBeforeCall(orderId, nextToken, progressRequestListener);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "OrdersV0Api-getOrderItems");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.getOrderItemsBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<GetOrderItemsResponse>(){}.getType();
            this.apiClient.executeAsync(call, localVarReturnType, callback);
            return call;
        }
        throw new ApiException.RateLimitExceeded("getOrderItems operation exceeds rate limit");
    }

    private Call getOrderItemsBuyerInfoCall(String orderId, String nextToken, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        Object localVarPostBody = null;
        String localVarPath = "/orders/v0/orders/{orderId}/orderItems/buyerInfo".equals("/uploads/2020-11-01/uploadDestinations/{resource}") ? "/orders/v0/orders/{orderId}/orderItems/buyerInfo".replaceAll("\\{orderId\\}", orderId.toString()) : "/orders/v0/orders/{orderId}/orderItems/buyerInfo".replaceAll("\\{orderId\\}", this.apiClient.escapeString(orderId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (nextToken != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("NextToken", nextToken));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, progressRequestListener);
    }

    private Call getOrderItemsBuyerInfoValidateBeforeCall(String orderId, String nextToken, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        if (orderId == null) {
            throw new ApiException("Missing the required parameter 'orderId' when calling getOrderItemsBuyerInfo(Async)");
        }
        return this.getOrderItemsBuyerInfoCall(orderId, nextToken, progressRequestListener);
    }

    public GetOrderItemsBuyerInfoResponse getOrderItemsBuyerInfo(String orderId, String nextToken, String restrictedDataToken) throws ApiException, LWAException {
        ApiResponse<GetOrderItemsBuyerInfoResponse> resp = this.getOrderItemsBuyerInfoWithHttpInfo(orderId, nextToken, restrictedDataToken);
        return resp.getData();
    }

    public GetOrderItemsBuyerInfoResponse getOrderItemsBuyerInfo(String orderId, String nextToken) throws ApiException, LWAException {
        ApiResponse<GetOrderItemsBuyerInfoResponse> resp = this.getOrderItemsBuyerInfoWithHttpInfo(orderId, nextToken, null);
        return resp.getData();
    }

    public ApiResponse<GetOrderItemsBuyerInfoResponse> getOrderItemsBuyerInfoWithHttpInfo(String orderId, String nextToken, String restrictedDataToken) throws ApiException, LWAException {
        Call call = this.getOrderItemsBuyerInfoValidateBeforeCall(orderId, nextToken, null);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "OrdersV0Api-getOrderItemsBuyerInfo");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.getOrderItemsBuyerInfoBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<GetOrderItemsBuyerInfoResponse>(){}.getType();
            return this.apiClient.execute(call, localVarReturnType);
        }
        throw new ApiException.RateLimitExceeded("getOrderItemsBuyerInfo operation exceeds rate limit");
    }

    public ApiResponse<GetOrderItemsBuyerInfoResponse> getOrderItemsBuyerInfoWithHttpInfo(String orderId, String nextToken) throws ApiException, LWAException {
        return this.getOrderItemsBuyerInfoWithHttpInfo(orderId, nextToken, null);
    }

    public Call getOrderItemsBuyerInfoAsync(String orderId, String nextToken, ApiCallback<GetOrderItemsBuyerInfoResponse> callback) throws ApiException, LWAException {
        return this.getOrderItemsBuyerInfoAsync(orderId, nextToken, callback, null);
    }

    public Call getOrderItemsBuyerInfoAsync(String orderId, String nextToken, ApiCallback<GetOrderItemsBuyerInfoResponse> callback, String restrictedDataToken) throws ApiException, LWAException {
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressRequestListener = callback::onUploadProgress;
        }
        Call call = this.getOrderItemsBuyerInfoValidateBeforeCall(orderId, nextToken, progressRequestListener);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "OrdersV0Api-getOrderItemsBuyerInfo");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.getOrderItemsBuyerInfoBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<GetOrderItemsBuyerInfoResponse>(){}.getType();
            this.apiClient.executeAsync(call, localVarReturnType, callback);
            return call;
        }
        throw new ApiException.RateLimitExceeded("getOrderItemsBuyerInfo operation exceeds rate limit");
    }

    private Call getOrderRegulatedInfoCall(String orderId, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        Object localVarPostBody = null;
        String localVarPath = "/orders/v0/orders/{orderId}/regulatedInfo".equals("/uploads/2020-11-01/uploadDestinations/{resource}") ? "/orders/v0/orders/{orderId}/regulatedInfo".replaceAll("\\{orderId\\}", orderId.toString()) : "/orders/v0/orders/{orderId}/regulatedInfo".replaceAll("\\{orderId\\}", this.apiClient.escapeString(orderId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "PendingOrder", "ApprovedOrder", "RejectedOrder"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, progressRequestListener);
    }

    private Call getOrderRegulatedInfoValidateBeforeCall(String orderId, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        if (orderId == null) {
            throw new ApiException("Missing the required parameter 'orderId' when calling getOrderRegulatedInfo(Async)");
        }
        return this.getOrderRegulatedInfoCall(orderId, progressRequestListener);
    }

    public GetOrderRegulatedInfoResponse getOrderRegulatedInfo(String orderId, String restrictedDataToken) throws ApiException, LWAException {
        ApiResponse<GetOrderRegulatedInfoResponse> resp = this.getOrderRegulatedInfoWithHttpInfo(orderId, restrictedDataToken);
        return resp.getData();
    }

    public GetOrderRegulatedInfoResponse getOrderRegulatedInfo(String orderId) throws ApiException, LWAException {
        ApiResponse<GetOrderRegulatedInfoResponse> resp = this.getOrderRegulatedInfoWithHttpInfo(orderId, null);
        return resp.getData();
    }

    public ApiResponse<GetOrderRegulatedInfoResponse> getOrderRegulatedInfoWithHttpInfo(String orderId, String restrictedDataToken) throws ApiException, LWAException {
        Call call = this.getOrderRegulatedInfoValidateBeforeCall(orderId, null);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "OrdersV0Api-getOrderRegulatedInfo");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.getOrderRegulatedInfoBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<GetOrderRegulatedInfoResponse>(){}.getType();
            return this.apiClient.execute(call, localVarReturnType);
        }
        throw new ApiException.RateLimitExceeded("getOrderRegulatedInfo operation exceeds rate limit");
    }

    public ApiResponse<GetOrderRegulatedInfoResponse> getOrderRegulatedInfoWithHttpInfo(String orderId) throws ApiException, LWAException {
        return this.getOrderRegulatedInfoWithHttpInfo(orderId, null);
    }

    public Call getOrderRegulatedInfoAsync(String orderId, ApiCallback<GetOrderRegulatedInfoResponse> callback) throws ApiException, LWAException {
        return this.getOrderRegulatedInfoAsync(orderId, callback, null);
    }

    public Call getOrderRegulatedInfoAsync(String orderId, ApiCallback<GetOrderRegulatedInfoResponse> callback, String restrictedDataToken) throws ApiException, LWAException {
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressRequestListener = callback::onUploadProgress;
        }
        Call call = this.getOrderRegulatedInfoValidateBeforeCall(orderId, progressRequestListener);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "OrdersV0Api-getOrderRegulatedInfo");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.getOrderRegulatedInfoBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<GetOrderRegulatedInfoResponse>(){}.getType();
            this.apiClient.executeAsync(call, localVarReturnType, callback);
            return call;
        }
        throw new ApiException.RateLimitExceeded("getOrderRegulatedInfo operation exceeds rate limit");
    }

    private Call getOrdersCall(List<String> marketplaceIds, String createdAfter, String createdBefore, String lastUpdatedAfter, String lastUpdatedBefore, List<String> orderStatuses, List<String> fulfillmentChannels, List<String> paymentMethods, String buyerEmail, String sellerOrderId, Integer maxResultsPerPage, List<String> easyShipShipmentStatuses, List<String> electronicInvoiceStatuses, String nextToken, List<String> amazonOrderIds, String actualFulfillmentSupplySourceId, Boolean isISPU, String storeChainStoreId, String earliestDeliveryDateBefore, String earliestDeliveryDateAfter, String latestDeliveryDateBefore, String latestDeliveryDateAfter, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        Object localVarPostBody = null;
        String localVarPath = "/orders/v0/orders".equals("/uploads/2020-11-01/uploadDestinations/{resource}") ? "/orders/v0/orders" : "/orders/v0/orders";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (createdAfter != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("CreatedAfter", createdAfter));
        }
        if (createdBefore != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("CreatedBefore", createdBefore));
        }
        if (lastUpdatedAfter != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("LastUpdatedAfter", lastUpdatedAfter));
        }
        if (lastUpdatedBefore != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("LastUpdatedBefore", lastUpdatedBefore));
        }
        if (orderStatuses != null) {
            localVarCollectionQueryParams.addAll(this.apiClient.parameterToPairs("csv", "OrderStatuses", orderStatuses));
        }
        if (marketplaceIds != null) {
            localVarCollectionQueryParams.addAll(this.apiClient.parameterToPairs("csv", "MarketplaceIds", marketplaceIds));
        }
        if (fulfillmentChannels != null) {
            localVarCollectionQueryParams.addAll(this.apiClient.parameterToPairs("csv", "FulfillmentChannels", fulfillmentChannels));
        }
        if (paymentMethods != null) {
            localVarCollectionQueryParams.addAll(this.apiClient.parameterToPairs("csv", "PaymentMethods", paymentMethods));
        }
        if (buyerEmail != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("BuyerEmail", buyerEmail));
        }
        if (sellerOrderId != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("SellerOrderId", sellerOrderId));
        }
        if (maxResultsPerPage != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("MaxResultsPerPage", maxResultsPerPage));
        }
        if (easyShipShipmentStatuses != null) {
            localVarCollectionQueryParams.addAll(this.apiClient.parameterToPairs("csv", "EasyShipShipmentStatuses", easyShipShipmentStatuses));
        }
        if (electronicInvoiceStatuses != null) {
            localVarCollectionQueryParams.addAll(this.apiClient.parameterToPairs("csv", "ElectronicInvoiceStatuses", electronicInvoiceStatuses));
        }
        if (nextToken != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("NextToken", nextToken));
        }
        if (amazonOrderIds != null) {
            localVarCollectionQueryParams.addAll(this.apiClient.parameterToPairs("csv", "AmazonOrderIds", amazonOrderIds));
        }
        if (actualFulfillmentSupplySourceId != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("ActualFulfillmentSupplySourceId", actualFulfillmentSupplySourceId));
        }
        if (isISPU != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("IsISPU", isISPU));
        }
        if (storeChainStoreId != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("StoreChainStoreId", storeChainStoreId));
        }
        if (earliestDeliveryDateBefore != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("EarliestDeliveryDateBefore", earliestDeliveryDateBefore));
        }
        if (earliestDeliveryDateAfter != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("EarliestDeliveryDateAfter", earliestDeliveryDateAfter));
        }
        if (latestDeliveryDateBefore != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("LatestDeliveryDateBefore", latestDeliveryDateBefore));
        }
        if (latestDeliveryDateAfter != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("LatestDeliveryDateAfter", latestDeliveryDateAfter));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, progressRequestListener);
    }

    private Call getOrdersValidateBeforeCall(List<String> marketplaceIds, String createdAfter, String createdBefore, String lastUpdatedAfter, String lastUpdatedBefore, List<String> orderStatuses, List<String> fulfillmentChannels, List<String> paymentMethods, String buyerEmail, String sellerOrderId, Integer maxResultsPerPage, List<String> easyShipShipmentStatuses, List<String> electronicInvoiceStatuses, String nextToken, List<String> amazonOrderIds, String actualFulfillmentSupplySourceId, Boolean isISPU, String storeChainStoreId, String earliestDeliveryDateBefore, String earliestDeliveryDateAfter, String latestDeliveryDateBefore, String latestDeliveryDateAfter, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        if (marketplaceIds == null) {
            throw new ApiException("Missing the required parameter 'marketplaceIds' when calling getOrders(Async)");
        }
        return this.getOrdersCall(marketplaceIds, createdAfter, createdBefore, lastUpdatedAfter, lastUpdatedBefore, orderStatuses, fulfillmentChannels, paymentMethods, buyerEmail, sellerOrderId, maxResultsPerPage, easyShipShipmentStatuses, electronicInvoiceStatuses, nextToken, amazonOrderIds, actualFulfillmentSupplySourceId, isISPU, storeChainStoreId, earliestDeliveryDateBefore, earliestDeliveryDateAfter, latestDeliveryDateBefore, latestDeliveryDateAfter, progressRequestListener);
    }

    public GetOrdersResponse getOrders(List<String> marketplaceIds, String createdAfter, String createdBefore, String lastUpdatedAfter, String lastUpdatedBefore, List<String> orderStatuses, List<String> fulfillmentChannels, List<String> paymentMethods, String buyerEmail, String sellerOrderId, Integer maxResultsPerPage, List<String> easyShipShipmentStatuses, List<String> electronicInvoiceStatuses, String nextToken, List<String> amazonOrderIds, String actualFulfillmentSupplySourceId, Boolean isISPU, String storeChainStoreId, String earliestDeliveryDateBefore, String earliestDeliveryDateAfter, String latestDeliveryDateBefore, String latestDeliveryDateAfter, String restrictedDataToken) throws ApiException, LWAException {
        ApiResponse<GetOrdersResponse> resp = this.getOrdersWithHttpInfo(marketplaceIds, createdAfter, createdBefore, lastUpdatedAfter, lastUpdatedBefore, orderStatuses, fulfillmentChannels, paymentMethods, buyerEmail, sellerOrderId, maxResultsPerPage, easyShipShipmentStatuses, electronicInvoiceStatuses, nextToken, amazonOrderIds, actualFulfillmentSupplySourceId, isISPU, storeChainStoreId, earliestDeliveryDateBefore, earliestDeliveryDateAfter, latestDeliveryDateBefore, latestDeliveryDateAfter, restrictedDataToken);
        return resp.getData();
    }

    public GetOrdersResponse getOrders(List<String> marketplaceIds, String createdAfter, String createdBefore, String lastUpdatedAfter, String lastUpdatedBefore, List<String> orderStatuses, List<String> fulfillmentChannels, List<String> paymentMethods, String buyerEmail, String sellerOrderId, Integer maxResultsPerPage, List<String> easyShipShipmentStatuses, List<String> electronicInvoiceStatuses, String nextToken, List<String> amazonOrderIds, String actualFulfillmentSupplySourceId, Boolean isISPU, String storeChainStoreId, String earliestDeliveryDateBefore, String earliestDeliveryDateAfter, String latestDeliveryDateBefore, String latestDeliveryDateAfter) throws ApiException, LWAException {
        ApiResponse<GetOrdersResponse> resp = this.getOrdersWithHttpInfo(marketplaceIds, createdAfter, createdBefore, lastUpdatedAfter, lastUpdatedBefore, orderStatuses, fulfillmentChannels, paymentMethods, buyerEmail, sellerOrderId, maxResultsPerPage, easyShipShipmentStatuses, electronicInvoiceStatuses, nextToken, amazonOrderIds, actualFulfillmentSupplySourceId, isISPU, storeChainStoreId, earliestDeliveryDateBefore, earliestDeliveryDateAfter, latestDeliveryDateBefore, latestDeliveryDateAfter, null);
        return resp.getData();
    }

    public ApiResponse<GetOrdersResponse> getOrdersWithHttpInfo(List<String> marketplaceIds, String createdAfter, String createdBefore, String lastUpdatedAfter, String lastUpdatedBefore, List<String> orderStatuses, List<String> fulfillmentChannels, List<String> paymentMethods, String buyerEmail, String sellerOrderId, Integer maxResultsPerPage, List<String> easyShipShipmentStatuses, List<String> electronicInvoiceStatuses, String nextToken, List<String> amazonOrderIds, String actualFulfillmentSupplySourceId, Boolean isISPU, String storeChainStoreId, String earliestDeliveryDateBefore, String earliestDeliveryDateAfter, String latestDeliveryDateBefore, String latestDeliveryDateAfter, String restrictedDataToken) throws ApiException, LWAException {
        Call call = this.getOrdersValidateBeforeCall(marketplaceIds, createdAfter, createdBefore, lastUpdatedAfter, lastUpdatedBefore, orderStatuses, fulfillmentChannels, paymentMethods, buyerEmail, sellerOrderId, maxResultsPerPage, easyShipShipmentStatuses, electronicInvoiceStatuses, nextToken, amazonOrderIds, actualFulfillmentSupplySourceId, isISPU, storeChainStoreId, earliestDeliveryDateBefore, earliestDeliveryDateAfter, latestDeliveryDateBefore, latestDeliveryDateAfter, null);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "OrdersV0Api-getOrders");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.getOrdersBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<GetOrdersResponse>(){}.getType();
            return this.apiClient.execute(call, localVarReturnType);
        }
        throw new ApiException.RateLimitExceeded("getOrders operation exceeds rate limit");
    }

    public ApiResponse<GetOrdersResponse> getOrdersWithHttpInfo(List<String> marketplaceIds, String createdAfter, String createdBefore, String lastUpdatedAfter, String lastUpdatedBefore, List<String> orderStatuses, List<String> fulfillmentChannels, List<String> paymentMethods, String buyerEmail, String sellerOrderId, Integer maxResultsPerPage, List<String> easyShipShipmentStatuses, List<String> electronicInvoiceStatuses, String nextToken, List<String> amazonOrderIds, String actualFulfillmentSupplySourceId, Boolean isISPU, String storeChainStoreId, String earliestDeliveryDateBefore, String earliestDeliveryDateAfter, String latestDeliveryDateBefore, String latestDeliveryDateAfter) throws ApiException, LWAException {
        return this.getOrdersWithHttpInfo(marketplaceIds, createdAfter, createdBefore, lastUpdatedAfter, lastUpdatedBefore, orderStatuses, fulfillmentChannels, paymentMethods, buyerEmail, sellerOrderId, maxResultsPerPage, easyShipShipmentStatuses, electronicInvoiceStatuses, nextToken, amazonOrderIds, actualFulfillmentSupplySourceId, isISPU, storeChainStoreId, earliestDeliveryDateBefore, earliestDeliveryDateAfter, latestDeliveryDateBefore, latestDeliveryDateAfter, null);
    }

    public Call getOrdersAsync(List<String> marketplaceIds, String createdAfter, String createdBefore, String lastUpdatedAfter, String lastUpdatedBefore, List<String> orderStatuses, List<String> fulfillmentChannels, List<String> paymentMethods, String buyerEmail, String sellerOrderId, Integer maxResultsPerPage, List<String> easyShipShipmentStatuses, List<String> electronicInvoiceStatuses, String nextToken, List<String> amazonOrderIds, String actualFulfillmentSupplySourceId, Boolean isISPU, String storeChainStoreId, String earliestDeliveryDateBefore, String earliestDeliveryDateAfter, String latestDeliveryDateBefore, String latestDeliveryDateAfter, ApiCallback<GetOrdersResponse> callback) throws ApiException, LWAException {
        return this.getOrdersAsync(marketplaceIds, createdAfter, createdBefore, lastUpdatedAfter, lastUpdatedBefore, orderStatuses, fulfillmentChannels, paymentMethods, buyerEmail, sellerOrderId, maxResultsPerPage, easyShipShipmentStatuses, electronicInvoiceStatuses, nextToken, amazonOrderIds, actualFulfillmentSupplySourceId, isISPU, storeChainStoreId, earliestDeliveryDateBefore, earliestDeliveryDateAfter, latestDeliveryDateBefore, latestDeliveryDateAfter, callback, null);
    }

    public Call getOrdersAsync(List<String> marketplaceIds, String createdAfter, String createdBefore, String lastUpdatedAfter, String lastUpdatedBefore, List<String> orderStatuses, List<String> fulfillmentChannels, List<String> paymentMethods, String buyerEmail, String sellerOrderId, Integer maxResultsPerPage, List<String> easyShipShipmentStatuses, List<String> electronicInvoiceStatuses, String nextToken, List<String> amazonOrderIds, String actualFulfillmentSupplySourceId, Boolean isISPU, String storeChainStoreId, String earliestDeliveryDateBefore, String earliestDeliveryDateAfter, String latestDeliveryDateBefore, String latestDeliveryDateAfter, ApiCallback<GetOrdersResponse> callback, String restrictedDataToken) throws ApiException, LWAException {
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressRequestListener = callback::onUploadProgress;
        }
        Call call = this.getOrdersValidateBeforeCall(marketplaceIds, createdAfter, createdBefore, lastUpdatedAfter, lastUpdatedBefore, orderStatuses, fulfillmentChannels, paymentMethods, buyerEmail, sellerOrderId, maxResultsPerPage, easyShipShipmentStatuses, electronicInvoiceStatuses, nextToken, amazonOrderIds, actualFulfillmentSupplySourceId, isISPU, storeChainStoreId, earliestDeliveryDateBefore, earliestDeliveryDateAfter, latestDeliveryDateBefore, latestDeliveryDateAfter, progressRequestListener);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "OrdersV0Api-getOrders");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.getOrdersBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<GetOrdersResponse>(){}.getType();
            this.apiClient.executeAsync(call, localVarReturnType, callback);
            return call;
        }
        throw new ApiException.RateLimitExceeded("getOrders operation exceeds rate limit");
    }

    private Call updateVerificationStatusCall(UpdateVerificationStatusRequest body, String orderId, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        UpdateVerificationStatusRequest localVarPostBody = body;
        String localVarPath = "/orders/v0/orders/{orderId}/regulatedInfo".equals("/uploads/2020-11-01/uploadDestinations/{resource}") ? "/orders/v0/orders/{orderId}/regulatedInfo".replaceAll("\\{orderId\\}", orderId.toString()) : "/orders/v0/orders/{orderId}/regulatedInfo".replaceAll("\\{orderId\\}", this.apiClient.escapeString(orderId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        return this.apiClient.buildCall(localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, progressRequestListener);
    }

    private Call updateVerificationStatusValidateBeforeCall(UpdateVerificationStatusRequest body, String orderId, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling updateVerificationStatus(Async)");
        }
        if (orderId == null) {
            throw new ApiException("Missing the required parameter 'orderId' when calling updateVerificationStatus(Async)");
        }
        return this.updateVerificationStatusCall(body, orderId, progressRequestListener);
    }

    public void updateVerificationStatus(UpdateVerificationStatusRequest body, String orderId, String restrictedDataToken) throws ApiException, LWAException {
        this.updateVerificationStatusWithHttpInfo(body, orderId, restrictedDataToken);
    }

    public void updateVerificationStatus(UpdateVerificationStatusRequest body, String orderId) throws ApiException, LWAException {
        this.updateVerificationStatusWithHttpInfo(body, orderId, null);
    }

    public ApiResponse<Void> updateVerificationStatusWithHttpInfo(UpdateVerificationStatusRequest body, String orderId, String restrictedDataToken) throws ApiException, LWAException {
        Call call = this.updateVerificationStatusValidateBeforeCall(body, orderId, null);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "OrdersV0Api-updateVerificationStatus");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.updateVerificationStatusBucket.tryConsume(1L)) {
            return this.apiClient.execute(call);
        }
        throw new ApiException.RateLimitExceeded("updateVerificationStatus operation exceeds rate limit");
    }

    public ApiResponse<Void> updateVerificationStatusWithHttpInfo(UpdateVerificationStatusRequest body, String orderId) throws ApiException, LWAException {
        return this.updateVerificationStatusWithHttpInfo(body, orderId, null);
    }

    public Call updateVerificationStatusAsync(UpdateVerificationStatusRequest body, String orderId, ApiCallback<Void> callback) throws ApiException, LWAException {
        return this.updateVerificationStatusAsync(body, orderId, callback, null);
    }

    public Call updateVerificationStatusAsync(UpdateVerificationStatusRequest body, String orderId, ApiCallback<Void> callback, String restrictedDataToken) throws ApiException, LWAException {
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressRequestListener = callback::onUploadProgress;
        }
        Call call = this.updateVerificationStatusValidateBeforeCall(body, orderId, progressRequestListener);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "OrdersV0Api-updateVerificationStatus");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.updateVerificationStatusBucket.tryConsume(1L)) {
            this.apiClient.executeAsync(call, callback);
            return call;
        }
        throw new ApiException.RateLimitExceeded("updateVerificationStatus operation exceeds rate limit");
    }

    public static class Builder {
        private LWAAuthorizationCredentials lwaAuthorizationCredentials;
        private String endpoint;
        private LWAAccessTokenCache lwaAccessTokenCache;
        private Boolean disableAccessTokenCache = false;
        private Boolean disableRateLimiting = false;

        public Builder lwaAuthorizationCredentials(LWAAuthorizationCredentials lwaAuthorizationCredentials) {
            this.lwaAuthorizationCredentials = lwaAuthorizationCredentials;
            return this;
        }

        public Builder endpoint(String endpoint) {
            this.endpoint = endpoint;
            return this;
        }

        public Builder lwaAccessTokenCache(LWAAccessTokenCache lwaAccessTokenCache) {
            this.lwaAccessTokenCache = lwaAccessTokenCache;
            return this;
        }

        public Builder disableAccessTokenCache() {
            this.disableAccessTokenCache = true;
            return this;
        }

        public Builder disableRateLimiting() {
            this.disableRateLimiting = true;
            return this;
        }

        public OrdersV0Api build() {
            if (this.lwaAuthorizationCredentials == null) {
                throw new RuntimeException("LWAAuthorizationCredentials not set");
            }
            if (StringUtil.isEmpty(this.endpoint)) {
                throw new RuntimeException("Endpoint not set");
            }
            LWAAuthorizationSigner lwaAuthorizationSigner = null;
            if (this.disableAccessTokenCache.booleanValue()) {
                lwaAuthorizationSigner = new LWAAuthorizationSigner(this.lwaAuthorizationCredentials);
            } else {
                if (this.lwaAccessTokenCache == null) {
                    this.lwaAccessTokenCache = new LWAAccessTokenCacheImpl();
                }
                lwaAuthorizationSigner = new LWAAuthorizationSigner(this.lwaAuthorizationCredentials, this.lwaAccessTokenCache);
            }
            return new OrdersV0Api(new ApiClient().setLWAAuthorizationSigner(lwaAuthorizationSigner).setBasePath(this.endpoint), this.disableRateLimiting);
        }
    }
}

