/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.api.notifications.v1;

import com.amazon.SellingPartnerAPIAA.LWAAccessTokenCache;
import com.amazon.SellingPartnerAPIAA.LWAAccessTokenCacheImpl;
import com.amazon.SellingPartnerAPIAA.LWAAuthorizationCredentials;
import com.amazon.SellingPartnerAPIAA.LWAAuthorizationSigner;
import com.amazon.SellingPartnerAPIAA.LWAException;
import com.amazon.SellingPartnerAPIAA.RestrictedDataTokenSigner;
import com.google.gson.reflect.TypeToken;
import io.github.bucket4j.Bucket;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import okhttp3.Call;
import okhttp3.Request;
import software.amazon.spapi.ApiCallback;
import software.amazon.spapi.ApiClient;
import software.amazon.spapi.ApiException;
import software.amazon.spapi.ApiResponse;
import software.amazon.spapi.Configuration;
import software.amazon.spapi.Pair;
import software.amazon.spapi.ProgressRequestBody;
import software.amazon.spapi.StringUtil;
import software.amazon.spapi.models.notifications.v1.CreateDestinationRequest;
import software.amazon.spapi.models.notifications.v1.CreateDestinationResponse;
import software.amazon.spapi.models.notifications.v1.CreateSubscriptionRequest;
import software.amazon.spapi.models.notifications.v1.CreateSubscriptionResponse;
import software.amazon.spapi.models.notifications.v1.DeleteDestinationResponse;
import software.amazon.spapi.models.notifications.v1.DeleteSubscriptionByIdResponse;
import software.amazon.spapi.models.notifications.v1.GetDestinationResponse;
import software.amazon.spapi.models.notifications.v1.GetDestinationsResponse;
import software.amazon.spapi.models.notifications.v1.GetSubscriptionByIdResponse;
import software.amazon.spapi.models.notifications.v1.GetSubscriptionResponse;

public class NotificationsApi {
    private ApiClient apiClient;
    private Boolean disableRateLimiting;
    private final Configuration config = Configuration.get();
    public final Bucket createDestinationBucket = Bucket.builder().addLimit(this.config.getLimit("NotificationsApi-createDestination")).build();
    public final Bucket createSubscriptionBucket = Bucket.builder().addLimit(this.config.getLimit("NotificationsApi-createSubscription")).build();
    public final Bucket deleteDestinationBucket = Bucket.builder().addLimit(this.config.getLimit("NotificationsApi-deleteDestination")).build();
    public final Bucket deleteSubscriptionByIdBucket = Bucket.builder().addLimit(this.config.getLimit("NotificationsApi-deleteSubscriptionById")).build();
    public final Bucket getDestinationBucket = Bucket.builder().addLimit(this.config.getLimit("NotificationsApi-getDestination")).build();
    public final Bucket getDestinationsBucket = Bucket.builder().addLimit(this.config.getLimit("NotificationsApi-getDestinations")).build();
    public final Bucket getSubscriptionBucket = Bucket.builder().addLimit(this.config.getLimit("NotificationsApi-getSubscription")).build();
    public final Bucket getSubscriptionByIdBucket = Bucket.builder().addLimit(this.config.getLimit("NotificationsApi-getSubscriptionById")).build();

    public NotificationsApi(ApiClient apiClient, Boolean disableRateLimiting) {
        this.apiClient = apiClient;
        this.disableRateLimiting = disableRateLimiting;
    }

    private Call createDestinationCall(CreateDestinationRequest body, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        CreateDestinationRequest localVarPostBody = body;
        String localVarPath = "/notifications/v1/destinations".equals("/uploads/2020-11-01/uploadDestinations/{resource}") ? "/notifications/v1/destinations" : "/notifications/v1/destinations";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "Successful Response"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, progressRequestListener);
    }

    private Call createDestinationValidateBeforeCall(CreateDestinationRequest body, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling createDestination(Async)");
        }
        return this.createDestinationCall(body, progressRequestListener);
    }

    public CreateDestinationResponse createDestination(CreateDestinationRequest body, String restrictedDataToken) throws ApiException, LWAException {
        ApiResponse<CreateDestinationResponse> resp = this.createDestinationWithHttpInfo(body, restrictedDataToken);
        return resp.getData();
    }

    public CreateDestinationResponse createDestination(CreateDestinationRequest body) throws ApiException, LWAException {
        ApiResponse<CreateDestinationResponse> resp = this.createDestinationWithHttpInfo(body, null);
        return resp.getData();
    }

    public ApiResponse<CreateDestinationResponse> createDestinationWithHttpInfo(CreateDestinationRequest body, String restrictedDataToken) throws ApiException, LWAException {
        Call call = this.createDestinationValidateBeforeCall(body, null);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "NotificationsApi-createDestination");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.createDestinationBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<CreateDestinationResponse>(){}.getType();
            return this.apiClient.execute(call, localVarReturnType);
        }
        throw new ApiException.RateLimitExceeded("createDestination operation exceeds rate limit");
    }

    public ApiResponse<CreateDestinationResponse> createDestinationWithHttpInfo(CreateDestinationRequest body) throws ApiException, LWAException {
        return this.createDestinationWithHttpInfo(body, null);
    }

    public Call createDestinationAsync(CreateDestinationRequest body, ApiCallback<CreateDestinationResponse> callback) throws ApiException, LWAException {
        return this.createDestinationAsync(body, callback, null);
    }

    public Call createDestinationAsync(CreateDestinationRequest body, ApiCallback<CreateDestinationResponse> callback, String restrictedDataToken) throws ApiException, LWAException {
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressRequestListener = callback::onUploadProgress;
        }
        Call call = this.createDestinationValidateBeforeCall(body, progressRequestListener);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "NotificationsApi-createDestination");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.createDestinationBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<CreateDestinationResponse>(){}.getType();
            this.apiClient.executeAsync(call, localVarReturnType, callback);
            return call;
        }
        throw new ApiException.RateLimitExceeded("createDestination operation exceeds rate limit");
    }

    private Call createSubscriptionCall(CreateSubscriptionRequest body, String notificationType, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        CreateSubscriptionRequest localVarPostBody = body;
        String localVarPath = "/notifications/v1/subscriptions/{notificationType}".equals("/uploads/2020-11-01/uploadDestinations/{resource}") ? "/notifications/v1/subscriptions/{notificationType}".replaceAll("\\{notificationType\\}", notificationType.toString()) : "/notifications/v1/subscriptions/{notificationType}".replaceAll("\\{notificationType\\}", this.apiClient.escapeString(notificationType.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "Successful Response"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, progressRequestListener);
    }

    private Call createSubscriptionValidateBeforeCall(CreateSubscriptionRequest body, String notificationType, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling createSubscription(Async)");
        }
        if (notificationType == null) {
            throw new ApiException("Missing the required parameter 'notificationType' when calling createSubscription(Async)");
        }
        return this.createSubscriptionCall(body, notificationType, progressRequestListener);
    }

    public CreateSubscriptionResponse createSubscription(CreateSubscriptionRequest body, String notificationType, String restrictedDataToken) throws ApiException, LWAException {
        ApiResponse<CreateSubscriptionResponse> resp = this.createSubscriptionWithHttpInfo(body, notificationType, restrictedDataToken);
        return resp.getData();
    }

    public CreateSubscriptionResponse createSubscription(CreateSubscriptionRequest body, String notificationType) throws ApiException, LWAException {
        ApiResponse<CreateSubscriptionResponse> resp = this.createSubscriptionWithHttpInfo(body, notificationType, null);
        return resp.getData();
    }

    public ApiResponse<CreateSubscriptionResponse> createSubscriptionWithHttpInfo(CreateSubscriptionRequest body, String notificationType, String restrictedDataToken) throws ApiException, LWAException {
        Call call = this.createSubscriptionValidateBeforeCall(body, notificationType, null);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "NotificationsApi-createSubscription");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.createSubscriptionBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<CreateSubscriptionResponse>(){}.getType();
            return this.apiClient.execute(call, localVarReturnType);
        }
        throw new ApiException.RateLimitExceeded("createSubscription operation exceeds rate limit");
    }

    public ApiResponse<CreateSubscriptionResponse> createSubscriptionWithHttpInfo(CreateSubscriptionRequest body, String notificationType) throws ApiException, LWAException {
        return this.createSubscriptionWithHttpInfo(body, notificationType, null);
    }

    public Call createSubscriptionAsync(CreateSubscriptionRequest body, String notificationType, ApiCallback<CreateSubscriptionResponse> callback) throws ApiException, LWAException {
        return this.createSubscriptionAsync(body, notificationType, callback, null);
    }

    public Call createSubscriptionAsync(CreateSubscriptionRequest body, String notificationType, ApiCallback<CreateSubscriptionResponse> callback, String restrictedDataToken) throws ApiException, LWAException {
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressRequestListener = callback::onUploadProgress;
        }
        Call call = this.createSubscriptionValidateBeforeCall(body, notificationType, progressRequestListener);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "NotificationsApi-createSubscription");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.createSubscriptionBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<CreateSubscriptionResponse>(){}.getType();
            this.apiClient.executeAsync(call, localVarReturnType, callback);
            return call;
        }
        throw new ApiException.RateLimitExceeded("createSubscription operation exceeds rate limit");
    }

    private Call deleteDestinationCall(String destinationId, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        Object localVarPostBody = null;
        String localVarPath = "/notifications/v1/destinations/{destinationId}".equals("/uploads/2020-11-01/uploadDestinations/{resource}") ? "/notifications/v1/destinations/{destinationId}".replaceAll("\\{destinationId\\}", destinationId.toString()) : "/notifications/v1/destinations/{destinationId}".replaceAll("\\{destinationId\\}", this.apiClient.escapeString(destinationId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "Successful Response"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        return this.apiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, progressRequestListener);
    }

    private Call deleteDestinationValidateBeforeCall(String destinationId, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        if (destinationId == null) {
            throw new ApiException("Missing the required parameter 'destinationId' when calling deleteDestination(Async)");
        }
        return this.deleteDestinationCall(destinationId, progressRequestListener);
    }

    public DeleteDestinationResponse deleteDestination(String destinationId, String restrictedDataToken) throws ApiException, LWAException {
        ApiResponse<DeleteDestinationResponse> resp = this.deleteDestinationWithHttpInfo(destinationId, restrictedDataToken);
        return resp.getData();
    }

    public DeleteDestinationResponse deleteDestination(String destinationId) throws ApiException, LWAException {
        ApiResponse<DeleteDestinationResponse> resp = this.deleteDestinationWithHttpInfo(destinationId, null);
        return resp.getData();
    }

    public ApiResponse<DeleteDestinationResponse> deleteDestinationWithHttpInfo(String destinationId, String restrictedDataToken) throws ApiException, LWAException {
        Call call = this.deleteDestinationValidateBeforeCall(destinationId, null);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "NotificationsApi-deleteDestination");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.deleteDestinationBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<DeleteDestinationResponse>(){}.getType();
            return this.apiClient.execute(call, localVarReturnType);
        }
        throw new ApiException.RateLimitExceeded("deleteDestination operation exceeds rate limit");
    }

    public ApiResponse<DeleteDestinationResponse> deleteDestinationWithHttpInfo(String destinationId) throws ApiException, LWAException {
        return this.deleteDestinationWithHttpInfo(destinationId, null);
    }

    public Call deleteDestinationAsync(String destinationId, ApiCallback<DeleteDestinationResponse> callback) throws ApiException, LWAException {
        return this.deleteDestinationAsync(destinationId, callback, null);
    }

    public Call deleteDestinationAsync(String destinationId, ApiCallback<DeleteDestinationResponse> callback, String restrictedDataToken) throws ApiException, LWAException {
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressRequestListener = callback::onUploadProgress;
        }
        Call call = this.deleteDestinationValidateBeforeCall(destinationId, progressRequestListener);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "NotificationsApi-deleteDestination");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.deleteDestinationBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<DeleteDestinationResponse>(){}.getType();
            this.apiClient.executeAsync(call, localVarReturnType, callback);
            return call;
        }
        throw new ApiException.RateLimitExceeded("deleteDestination operation exceeds rate limit");
    }

    private Call deleteSubscriptionByIdCall(String subscriptionId, String notificationType, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        Object localVarPostBody = null;
        String localVarPath = "/notifications/v1/subscriptions/{notificationType}/{subscriptionId}".equals("/uploads/2020-11-01/uploadDestinations/{resource}") ? "/notifications/v1/subscriptions/{notificationType}/{subscriptionId}".replaceAll("\\{subscriptionId\\}", subscriptionId.toString()).replaceAll("\\{notificationType\\}", notificationType.toString()) : "/notifications/v1/subscriptions/{notificationType}/{subscriptionId}".replaceAll("\\{subscriptionId\\}", this.apiClient.escapeString(subscriptionId.toString())).replaceAll("\\{notificationType\\}", this.apiClient.escapeString(notificationType.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "Successful Operation Response"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        return this.apiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, progressRequestListener);
    }

    private Call deleteSubscriptionByIdValidateBeforeCall(String subscriptionId, String notificationType, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        if (subscriptionId == null) {
            throw new ApiException("Missing the required parameter 'subscriptionId' when calling deleteSubscriptionById(Async)");
        }
        if (notificationType == null) {
            throw new ApiException("Missing the required parameter 'notificationType' when calling deleteSubscriptionById(Async)");
        }
        return this.deleteSubscriptionByIdCall(subscriptionId, notificationType, progressRequestListener);
    }

    public DeleteSubscriptionByIdResponse deleteSubscriptionById(String subscriptionId, String notificationType, String restrictedDataToken) throws ApiException, LWAException {
        ApiResponse<DeleteSubscriptionByIdResponse> resp = this.deleteSubscriptionByIdWithHttpInfo(subscriptionId, notificationType, restrictedDataToken);
        return resp.getData();
    }

    public DeleteSubscriptionByIdResponse deleteSubscriptionById(String subscriptionId, String notificationType) throws ApiException, LWAException {
        ApiResponse<DeleteSubscriptionByIdResponse> resp = this.deleteSubscriptionByIdWithHttpInfo(subscriptionId, notificationType, null);
        return resp.getData();
    }

    public ApiResponse<DeleteSubscriptionByIdResponse> deleteSubscriptionByIdWithHttpInfo(String subscriptionId, String notificationType, String restrictedDataToken) throws ApiException, LWAException {
        Call call = this.deleteSubscriptionByIdValidateBeforeCall(subscriptionId, notificationType, null);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "NotificationsApi-deleteSubscriptionById");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.deleteSubscriptionByIdBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<DeleteSubscriptionByIdResponse>(){}.getType();
            return this.apiClient.execute(call, localVarReturnType);
        }
        throw new ApiException.RateLimitExceeded("deleteSubscriptionById operation exceeds rate limit");
    }

    public ApiResponse<DeleteSubscriptionByIdResponse> deleteSubscriptionByIdWithHttpInfo(String subscriptionId, String notificationType) throws ApiException, LWAException {
        return this.deleteSubscriptionByIdWithHttpInfo(subscriptionId, notificationType, null);
    }

    public Call deleteSubscriptionByIdAsync(String subscriptionId, String notificationType, ApiCallback<DeleteSubscriptionByIdResponse> callback) throws ApiException, LWAException {
        return this.deleteSubscriptionByIdAsync(subscriptionId, notificationType, callback, null);
    }

    public Call deleteSubscriptionByIdAsync(String subscriptionId, String notificationType, ApiCallback<DeleteSubscriptionByIdResponse> callback, String restrictedDataToken) throws ApiException, LWAException {
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressRequestListener = callback::onUploadProgress;
        }
        Call call = this.deleteSubscriptionByIdValidateBeforeCall(subscriptionId, notificationType, progressRequestListener);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "NotificationsApi-deleteSubscriptionById");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.deleteSubscriptionByIdBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<DeleteSubscriptionByIdResponse>(){}.getType();
            this.apiClient.executeAsync(call, localVarReturnType, callback);
            return call;
        }
        throw new ApiException.RateLimitExceeded("deleteSubscriptionById operation exceeds rate limit");
    }

    private Call getDestinationCall(String destinationId, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        Object localVarPostBody = null;
        String localVarPath = "/notifications/v1/destinations/{destinationId}".equals("/uploads/2020-11-01/uploadDestinations/{resource}") ? "/notifications/v1/destinations/{destinationId}".replaceAll("\\{destinationId\\}", destinationId.toString()) : "/notifications/v1/destinations/{destinationId}".replaceAll("\\{destinationId\\}", this.apiClient.escapeString(destinationId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "Successful Response"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, progressRequestListener);
    }

    private Call getDestinationValidateBeforeCall(String destinationId, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        if (destinationId == null) {
            throw new ApiException("Missing the required parameter 'destinationId' when calling getDestination(Async)");
        }
        return this.getDestinationCall(destinationId, progressRequestListener);
    }

    public GetDestinationResponse getDestination(String destinationId, String restrictedDataToken) throws ApiException, LWAException {
        ApiResponse<GetDestinationResponse> resp = this.getDestinationWithHttpInfo(destinationId, restrictedDataToken);
        return resp.getData();
    }

    public GetDestinationResponse getDestination(String destinationId) throws ApiException, LWAException {
        ApiResponse<GetDestinationResponse> resp = this.getDestinationWithHttpInfo(destinationId, null);
        return resp.getData();
    }

    public ApiResponse<GetDestinationResponse> getDestinationWithHttpInfo(String destinationId, String restrictedDataToken) throws ApiException, LWAException {
        Call call = this.getDestinationValidateBeforeCall(destinationId, null);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "NotificationsApi-getDestination");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.getDestinationBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<GetDestinationResponse>(){}.getType();
            return this.apiClient.execute(call, localVarReturnType);
        }
        throw new ApiException.RateLimitExceeded("getDestination operation exceeds rate limit");
    }

    public ApiResponse<GetDestinationResponse> getDestinationWithHttpInfo(String destinationId) throws ApiException, LWAException {
        return this.getDestinationWithHttpInfo(destinationId, null);
    }

    public Call getDestinationAsync(String destinationId, ApiCallback<GetDestinationResponse> callback) throws ApiException, LWAException {
        return this.getDestinationAsync(destinationId, callback, null);
    }

    public Call getDestinationAsync(String destinationId, ApiCallback<GetDestinationResponse> callback, String restrictedDataToken) throws ApiException, LWAException {
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressRequestListener = callback::onUploadProgress;
        }
        Call call = this.getDestinationValidateBeforeCall(destinationId, progressRequestListener);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "NotificationsApi-getDestination");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.getDestinationBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<GetDestinationResponse>(){}.getType();
            this.apiClient.executeAsync(call, localVarReturnType, callback);
            return call;
        }
        throw new ApiException.RateLimitExceeded("getDestination operation exceeds rate limit");
    }

    private Call getDestinationsCall(ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        Object localVarPostBody = null;
        String localVarPath = "/notifications/v1/destinations".equals("/uploads/2020-11-01/uploadDestinations/{resource}") ? "/notifications/v1/destinations" : "/notifications/v1/destinations";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "Successful Response"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, progressRequestListener);
    }

    private Call getDestinationsValidateBeforeCall(ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        return this.getDestinationsCall(progressRequestListener);
    }

    public GetDestinationsResponse getDestinations(String restrictedDataToken) throws ApiException, LWAException {
        ApiResponse<GetDestinationsResponse> resp = this.getDestinationsWithHttpInfo(restrictedDataToken);
        return resp.getData();
    }

    public GetDestinationsResponse getDestinations() throws ApiException, LWAException {
        ApiResponse<GetDestinationsResponse> resp = this.getDestinationsWithHttpInfo(null);
        return resp.getData();
    }

    public ApiResponse<GetDestinationsResponse> getDestinationsWithHttpInfo(String restrictedDataToken) throws ApiException, LWAException {
        Call call = this.getDestinationsValidateBeforeCall(null);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "NotificationsApi-getDestinations");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.getDestinationsBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<GetDestinationsResponse>(){}.getType();
            return this.apiClient.execute(call, localVarReturnType);
        }
        throw new ApiException.RateLimitExceeded("getDestinations operation exceeds rate limit");
    }

    public ApiResponse<GetDestinationsResponse> getDestinationsWithHttpInfo() throws ApiException, LWAException {
        return this.getDestinationsWithHttpInfo(null);
    }

    public Call getDestinationsAsync(ApiCallback<GetDestinationsResponse> callback) throws ApiException, LWAException {
        return this.getDestinationsAsync(callback, null);
    }

    public Call getDestinationsAsync(ApiCallback<GetDestinationsResponse> callback, String restrictedDataToken) throws ApiException, LWAException {
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressRequestListener = callback::onUploadProgress;
        }
        Call call = this.getDestinationsValidateBeforeCall(progressRequestListener);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "NotificationsApi-getDestinations");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.getDestinationsBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<GetDestinationsResponse>(){}.getType();
            this.apiClient.executeAsync(call, localVarReturnType, callback);
            return call;
        }
        throw new ApiException.RateLimitExceeded("getDestinations operation exceeds rate limit");
    }

    private Call getSubscriptionCall(String notificationType, String payloadVersion, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        Object localVarPostBody = null;
        String localVarPath = "/notifications/v1/subscriptions/{notificationType}".equals("/uploads/2020-11-01/uploadDestinations/{resource}") ? "/notifications/v1/subscriptions/{notificationType}".replaceAll("\\{notificationType\\}", notificationType.toString()) : "/notifications/v1/subscriptions/{notificationType}".replaceAll("\\{notificationType\\}", this.apiClient.escapeString(notificationType.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (payloadVersion != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("payloadVersion", payloadVersion));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "Successful Response"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, progressRequestListener);
    }

    private Call getSubscriptionValidateBeforeCall(String notificationType, String payloadVersion, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        if (notificationType == null) {
            throw new ApiException("Missing the required parameter 'notificationType' when calling getSubscription(Async)");
        }
        return this.getSubscriptionCall(notificationType, payloadVersion, progressRequestListener);
    }

    public GetSubscriptionResponse getSubscription(String notificationType, String payloadVersion, String restrictedDataToken) throws ApiException, LWAException {
        ApiResponse<GetSubscriptionResponse> resp = this.getSubscriptionWithHttpInfo(notificationType, payloadVersion, restrictedDataToken);
        return resp.getData();
    }

    public GetSubscriptionResponse getSubscription(String notificationType, String payloadVersion) throws ApiException, LWAException {
        ApiResponse<GetSubscriptionResponse> resp = this.getSubscriptionWithHttpInfo(notificationType, payloadVersion, null);
        return resp.getData();
    }

    public ApiResponse<GetSubscriptionResponse> getSubscriptionWithHttpInfo(String notificationType, String payloadVersion, String restrictedDataToken) throws ApiException, LWAException {
        Call call = this.getSubscriptionValidateBeforeCall(notificationType, payloadVersion, null);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "NotificationsApi-getSubscription");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.getSubscriptionBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<GetSubscriptionResponse>(){}.getType();
            return this.apiClient.execute(call, localVarReturnType);
        }
        throw new ApiException.RateLimitExceeded("getSubscription operation exceeds rate limit");
    }

    public ApiResponse<GetSubscriptionResponse> getSubscriptionWithHttpInfo(String notificationType, String payloadVersion) throws ApiException, LWAException {
        return this.getSubscriptionWithHttpInfo(notificationType, payloadVersion, null);
    }

    public Call getSubscriptionAsync(String notificationType, String payloadVersion, ApiCallback<GetSubscriptionResponse> callback) throws ApiException, LWAException {
        return this.getSubscriptionAsync(notificationType, payloadVersion, callback, null);
    }

    public Call getSubscriptionAsync(String notificationType, String payloadVersion, ApiCallback<GetSubscriptionResponse> callback, String restrictedDataToken) throws ApiException, LWAException {
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressRequestListener = callback::onUploadProgress;
        }
        Call call = this.getSubscriptionValidateBeforeCall(notificationType, payloadVersion, progressRequestListener);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "NotificationsApi-getSubscription");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.getSubscriptionBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<GetSubscriptionResponse>(){}.getType();
            this.apiClient.executeAsync(call, localVarReturnType, callback);
            return call;
        }
        throw new ApiException.RateLimitExceeded("getSubscription operation exceeds rate limit");
    }

    private Call getSubscriptionByIdCall(String subscriptionId, String notificationType, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        Object localVarPostBody = null;
        String localVarPath = "/notifications/v1/subscriptions/{notificationType}/{subscriptionId}".equals("/uploads/2020-11-01/uploadDestinations/{resource}") ? "/notifications/v1/subscriptions/{notificationType}/{subscriptionId}".replaceAll("\\{subscriptionId\\}", subscriptionId.toString()).replaceAll("\\{notificationType\\}", notificationType.toString()) : "/notifications/v1/subscriptions/{notificationType}/{subscriptionId}".replaceAll("\\{subscriptionId\\}", this.apiClient.escapeString(subscriptionId.toString())).replaceAll("\\{notificationType\\}", this.apiClient.escapeString(notificationType.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "Successful Response"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, progressRequestListener);
    }

    private Call getSubscriptionByIdValidateBeforeCall(String subscriptionId, String notificationType, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        if (subscriptionId == null) {
            throw new ApiException("Missing the required parameter 'subscriptionId' when calling getSubscriptionById(Async)");
        }
        if (notificationType == null) {
            throw new ApiException("Missing the required parameter 'notificationType' when calling getSubscriptionById(Async)");
        }
        return this.getSubscriptionByIdCall(subscriptionId, notificationType, progressRequestListener);
    }

    public GetSubscriptionByIdResponse getSubscriptionById(String subscriptionId, String notificationType, String restrictedDataToken) throws ApiException, LWAException {
        ApiResponse<GetSubscriptionByIdResponse> resp = this.getSubscriptionByIdWithHttpInfo(subscriptionId, notificationType, restrictedDataToken);
        return resp.getData();
    }

    public GetSubscriptionByIdResponse getSubscriptionById(String subscriptionId, String notificationType) throws ApiException, LWAException {
        ApiResponse<GetSubscriptionByIdResponse> resp = this.getSubscriptionByIdWithHttpInfo(subscriptionId, notificationType, null);
        return resp.getData();
    }

    public ApiResponse<GetSubscriptionByIdResponse> getSubscriptionByIdWithHttpInfo(String subscriptionId, String notificationType, String restrictedDataToken) throws ApiException, LWAException {
        Call call = this.getSubscriptionByIdValidateBeforeCall(subscriptionId, notificationType, null);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "NotificationsApi-getSubscriptionById");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.getSubscriptionByIdBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<GetSubscriptionByIdResponse>(){}.getType();
            return this.apiClient.execute(call, localVarReturnType);
        }
        throw new ApiException.RateLimitExceeded("getSubscriptionById operation exceeds rate limit");
    }

    public ApiResponse<GetSubscriptionByIdResponse> getSubscriptionByIdWithHttpInfo(String subscriptionId, String notificationType) throws ApiException, LWAException {
        return this.getSubscriptionByIdWithHttpInfo(subscriptionId, notificationType, null);
    }

    public Call getSubscriptionByIdAsync(String subscriptionId, String notificationType, ApiCallback<GetSubscriptionByIdResponse> callback) throws ApiException, LWAException {
        return this.getSubscriptionByIdAsync(subscriptionId, notificationType, callback, null);
    }

    public Call getSubscriptionByIdAsync(String subscriptionId, String notificationType, ApiCallback<GetSubscriptionByIdResponse> callback, String restrictedDataToken) throws ApiException, LWAException {
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressRequestListener = callback::onUploadProgress;
        }
        Call call = this.getSubscriptionByIdValidateBeforeCall(subscriptionId, notificationType, progressRequestListener);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "NotificationsApi-getSubscriptionById");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.getSubscriptionByIdBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<GetSubscriptionByIdResponse>(){}.getType();
            this.apiClient.executeAsync(call, localVarReturnType, callback);
            return call;
        }
        throw new ApiException.RateLimitExceeded("getSubscriptionById operation exceeds rate limit");
    }

    public static class Builder {
        private LWAAuthorizationCredentials lwaAuthorizationCredentials;
        private String endpoint;
        private LWAAccessTokenCache lwaAccessTokenCache;
        private Boolean disableAccessTokenCache = false;
        private Boolean disableRateLimiting = false;

        public Builder lwaAuthorizationCredentials(LWAAuthorizationCredentials lwaAuthorizationCredentials) {
            this.lwaAuthorizationCredentials = lwaAuthorizationCredentials;
            return this;
        }

        public Builder endpoint(String endpoint) {
            this.endpoint = endpoint;
            return this;
        }

        public Builder lwaAccessTokenCache(LWAAccessTokenCache lwaAccessTokenCache) {
            this.lwaAccessTokenCache = lwaAccessTokenCache;
            return this;
        }

        public Builder disableAccessTokenCache() {
            this.disableAccessTokenCache = true;
            return this;
        }

        public Builder disableRateLimiting() {
            this.disableRateLimiting = true;
            return this;
        }

        public NotificationsApi build() {
            if (this.lwaAuthorizationCredentials == null) {
                throw new RuntimeException("LWAAuthorizationCredentials not set");
            }
            if (StringUtil.isEmpty(this.endpoint)) {
                throw new RuntimeException("Endpoint not set");
            }
            LWAAuthorizationSigner lwaAuthorizationSigner = null;
            if (this.disableAccessTokenCache.booleanValue()) {
                lwaAuthorizationSigner = new LWAAuthorizationSigner(this.lwaAuthorizationCredentials);
            } else {
                if (this.lwaAccessTokenCache == null) {
                    this.lwaAccessTokenCache = new LWAAccessTokenCacheImpl();
                }
                lwaAuthorizationSigner = new LWAAuthorizationSigner(this.lwaAuthorizationCredentials, this.lwaAccessTokenCache);
            }
            return new NotificationsApi(new ApiClient().setLWAAuthorizationSigner(lwaAuthorizationSigner).setBasePath(this.endpoint), this.disableRateLimiting);
        }
    }
}

