/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.api.merchantfulfillment.v0;

import com.amazon.SellingPartnerAPIAA.LWAAccessTokenCache;
import com.amazon.SellingPartnerAPIAA.LWAAccessTokenCacheImpl;
import com.amazon.SellingPartnerAPIAA.LWAAuthorizationCredentials;
import com.amazon.SellingPartnerAPIAA.LWAAuthorizationSigner;
import com.amazon.SellingPartnerAPIAA.LWAException;
import com.amazon.SellingPartnerAPIAA.RestrictedDataTokenSigner;
import com.google.gson.reflect.TypeToken;
import io.github.bucket4j.Bucket;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import okhttp3.Call;
import okhttp3.Request;
import software.amazon.spapi.ApiCallback;
import software.amazon.spapi.ApiClient;
import software.amazon.spapi.ApiException;
import software.amazon.spapi.ApiResponse;
import software.amazon.spapi.Configuration;
import software.amazon.spapi.Pair;
import software.amazon.spapi.ProgressRequestBody;
import software.amazon.spapi.StringUtil;
import software.amazon.spapi.models.merchantfulfillment.v0.CancelShipmentResponse;
import software.amazon.spapi.models.merchantfulfillment.v0.CreateShipmentRequest;
import software.amazon.spapi.models.merchantfulfillment.v0.CreateShipmentResponse;
import software.amazon.spapi.models.merchantfulfillment.v0.GetAdditionalSellerInputsRequest;
import software.amazon.spapi.models.merchantfulfillment.v0.GetAdditionalSellerInputsResponse;
import software.amazon.spapi.models.merchantfulfillment.v0.GetEligibleShipmentServicesRequest;
import software.amazon.spapi.models.merchantfulfillment.v0.GetEligibleShipmentServicesResponse;
import software.amazon.spapi.models.merchantfulfillment.v0.GetShipmentResponse;

public class MerchantFulfillmentApi {
    private ApiClient apiClient;
    private Boolean disableRateLimiting;
    private final Configuration config = Configuration.get();
    public final Bucket cancelShipmentBucket = Bucket.builder().addLimit(this.config.getLimit("MerchantFulfillmentApi-cancelShipment")).build();
    public final Bucket createShipmentBucket = Bucket.builder().addLimit(this.config.getLimit("MerchantFulfillmentApi-createShipment")).build();
    public final Bucket getAdditionalSellerInputsBucket = Bucket.builder().addLimit(this.config.getLimit("MerchantFulfillmentApi-getAdditionalSellerInputs")).build();
    public final Bucket getEligibleShipmentServicesBucket = Bucket.builder().addLimit(this.config.getLimit("MerchantFulfillmentApi-getEligibleShipmentServices")).build();
    public final Bucket getShipmentBucket = Bucket.builder().addLimit(this.config.getLimit("MerchantFulfillmentApi-getShipment")).build();

    public MerchantFulfillmentApi(ApiClient apiClient, Boolean disableRateLimiting) {
        this.apiClient = apiClient;
        this.disableRateLimiting = disableRateLimiting;
    }

    private Call cancelShipmentCall(String shipmentId, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        Object localVarPostBody = null;
        String localVarPath = "/mfn/v0/shipments/{shipmentId}".equals("/uploads/2020-11-01/uploadDestinations/{resource}") ? "/mfn/v0/shipments/{shipmentId}".replaceAll("\\{shipmentId\\}", shipmentId.toString()) : "/mfn/v0/shipments/{shipmentId}".replaceAll("\\{shipmentId\\}", this.apiClient.escapeString(shipmentId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        return this.apiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, progressRequestListener);
    }

    private Call cancelShipmentValidateBeforeCall(String shipmentId, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        if (shipmentId == null) {
            throw new ApiException("Missing the required parameter 'shipmentId' when calling cancelShipment(Async)");
        }
        return this.cancelShipmentCall(shipmentId, progressRequestListener);
    }

    public CancelShipmentResponse cancelShipment(String shipmentId, String restrictedDataToken) throws ApiException, LWAException {
        ApiResponse<CancelShipmentResponse> resp = this.cancelShipmentWithHttpInfo(shipmentId, restrictedDataToken);
        return resp.getData();
    }

    public CancelShipmentResponse cancelShipment(String shipmentId) throws ApiException, LWAException {
        ApiResponse<CancelShipmentResponse> resp = this.cancelShipmentWithHttpInfo(shipmentId, null);
        return resp.getData();
    }

    public ApiResponse<CancelShipmentResponse> cancelShipmentWithHttpInfo(String shipmentId, String restrictedDataToken) throws ApiException, LWAException {
        Call call = this.cancelShipmentValidateBeforeCall(shipmentId, null);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "MerchantFulfillmentApi-cancelShipment");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.cancelShipmentBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<CancelShipmentResponse>(){}.getType();
            return this.apiClient.execute(call, localVarReturnType);
        }
        throw new ApiException.RateLimitExceeded("cancelShipment operation exceeds rate limit");
    }

    public ApiResponse<CancelShipmentResponse> cancelShipmentWithHttpInfo(String shipmentId) throws ApiException, LWAException {
        return this.cancelShipmentWithHttpInfo(shipmentId, null);
    }

    public Call cancelShipmentAsync(String shipmentId, ApiCallback<CancelShipmentResponse> callback) throws ApiException, LWAException {
        return this.cancelShipmentAsync(shipmentId, callback, null);
    }

    public Call cancelShipmentAsync(String shipmentId, ApiCallback<CancelShipmentResponse> callback, String restrictedDataToken) throws ApiException, LWAException {
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressRequestListener = callback::onUploadProgress;
        }
        Call call = this.cancelShipmentValidateBeforeCall(shipmentId, progressRequestListener);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "MerchantFulfillmentApi-cancelShipment");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.cancelShipmentBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<CancelShipmentResponse>(){}.getType();
            this.apiClient.executeAsync(call, localVarReturnType, callback);
            return call;
        }
        throw new ApiException.RateLimitExceeded("cancelShipment operation exceeds rate limit");
    }

    private Call createShipmentCall(CreateShipmentRequest body, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        CreateShipmentRequest localVarPostBody = body;
        String localVarPath = "/mfn/v0/shipments".equals("/uploads/2020-11-01/uploadDestinations/{resource}") ? "/mfn/v0/shipments" : "/mfn/v0/shipments";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, progressRequestListener);
    }

    private Call createShipmentValidateBeforeCall(CreateShipmentRequest body, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling createShipment(Async)");
        }
        return this.createShipmentCall(body, progressRequestListener);
    }

    public CreateShipmentResponse createShipment(CreateShipmentRequest body, String restrictedDataToken) throws ApiException, LWAException {
        ApiResponse<CreateShipmentResponse> resp = this.createShipmentWithHttpInfo(body, restrictedDataToken);
        return resp.getData();
    }

    public CreateShipmentResponse createShipment(CreateShipmentRequest body) throws ApiException, LWAException {
        ApiResponse<CreateShipmentResponse> resp = this.createShipmentWithHttpInfo(body, null);
        return resp.getData();
    }

    public ApiResponse<CreateShipmentResponse> createShipmentWithHttpInfo(CreateShipmentRequest body, String restrictedDataToken) throws ApiException, LWAException {
        Call call = this.createShipmentValidateBeforeCall(body, null);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "MerchantFulfillmentApi-createShipment");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.createShipmentBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<CreateShipmentResponse>(){}.getType();
            return this.apiClient.execute(call, localVarReturnType);
        }
        throw new ApiException.RateLimitExceeded("createShipment operation exceeds rate limit");
    }

    public ApiResponse<CreateShipmentResponse> createShipmentWithHttpInfo(CreateShipmentRequest body) throws ApiException, LWAException {
        return this.createShipmentWithHttpInfo(body, null);
    }

    public Call createShipmentAsync(CreateShipmentRequest body, ApiCallback<CreateShipmentResponse> callback) throws ApiException, LWAException {
        return this.createShipmentAsync(body, callback, null);
    }

    public Call createShipmentAsync(CreateShipmentRequest body, ApiCallback<CreateShipmentResponse> callback, String restrictedDataToken) throws ApiException, LWAException {
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressRequestListener = callback::onUploadProgress;
        }
        Call call = this.createShipmentValidateBeforeCall(body, progressRequestListener);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "MerchantFulfillmentApi-createShipment");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.createShipmentBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<CreateShipmentResponse>(){}.getType();
            this.apiClient.executeAsync(call, localVarReturnType, callback);
            return call;
        }
        throw new ApiException.RateLimitExceeded("createShipment operation exceeds rate limit");
    }

    private Call getAdditionalSellerInputsCall(GetAdditionalSellerInputsRequest body, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        GetAdditionalSellerInputsRequest localVarPostBody = body;
        String localVarPath = "/mfn/v0/additionalSellerInputs".equals("/uploads/2020-11-01/uploadDestinations/{resource}") ? "/mfn/v0/additionalSellerInputs" : "/mfn/v0/additionalSellerInputs";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, progressRequestListener);
    }

    private Call getAdditionalSellerInputsValidateBeforeCall(GetAdditionalSellerInputsRequest body, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling getAdditionalSellerInputs(Async)");
        }
        return this.getAdditionalSellerInputsCall(body, progressRequestListener);
    }

    public GetAdditionalSellerInputsResponse getAdditionalSellerInputs(GetAdditionalSellerInputsRequest body, String restrictedDataToken) throws ApiException, LWAException {
        ApiResponse<GetAdditionalSellerInputsResponse> resp = this.getAdditionalSellerInputsWithHttpInfo(body, restrictedDataToken);
        return resp.getData();
    }

    public GetAdditionalSellerInputsResponse getAdditionalSellerInputs(GetAdditionalSellerInputsRequest body) throws ApiException, LWAException {
        ApiResponse<GetAdditionalSellerInputsResponse> resp = this.getAdditionalSellerInputsWithHttpInfo(body, null);
        return resp.getData();
    }

    public ApiResponse<GetAdditionalSellerInputsResponse> getAdditionalSellerInputsWithHttpInfo(GetAdditionalSellerInputsRequest body, String restrictedDataToken) throws ApiException, LWAException {
        Call call = this.getAdditionalSellerInputsValidateBeforeCall(body, null);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "MerchantFulfillmentApi-getAdditionalSellerInputs");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.getAdditionalSellerInputsBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<GetAdditionalSellerInputsResponse>(){}.getType();
            return this.apiClient.execute(call, localVarReturnType);
        }
        throw new ApiException.RateLimitExceeded("getAdditionalSellerInputs operation exceeds rate limit");
    }

    public ApiResponse<GetAdditionalSellerInputsResponse> getAdditionalSellerInputsWithHttpInfo(GetAdditionalSellerInputsRequest body) throws ApiException, LWAException {
        return this.getAdditionalSellerInputsWithHttpInfo(body, null);
    }

    public Call getAdditionalSellerInputsAsync(GetAdditionalSellerInputsRequest body, ApiCallback<GetAdditionalSellerInputsResponse> callback) throws ApiException, LWAException {
        return this.getAdditionalSellerInputsAsync(body, callback, null);
    }

    public Call getAdditionalSellerInputsAsync(GetAdditionalSellerInputsRequest body, ApiCallback<GetAdditionalSellerInputsResponse> callback, String restrictedDataToken) throws ApiException, LWAException {
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressRequestListener = callback::onUploadProgress;
        }
        Call call = this.getAdditionalSellerInputsValidateBeforeCall(body, progressRequestListener);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "MerchantFulfillmentApi-getAdditionalSellerInputs");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.getAdditionalSellerInputsBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<GetAdditionalSellerInputsResponse>(){}.getType();
            this.apiClient.executeAsync(call, localVarReturnType, callback);
            return call;
        }
        throw new ApiException.RateLimitExceeded("getAdditionalSellerInputs operation exceeds rate limit");
    }

    private Call getEligibleShipmentServicesCall(GetEligibleShipmentServicesRequest body, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        GetEligibleShipmentServicesRequest localVarPostBody = body;
        String localVarPath = "/mfn/v0/eligibleShippingServices".equals("/uploads/2020-11-01/uploadDestinations/{resource}") ? "/mfn/v0/eligibleShippingServices" : "/mfn/v0/eligibleShippingServices";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, progressRequestListener);
    }

    private Call getEligibleShipmentServicesValidateBeforeCall(GetEligibleShipmentServicesRequest body, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling getEligibleShipmentServices(Async)");
        }
        return this.getEligibleShipmentServicesCall(body, progressRequestListener);
    }

    public GetEligibleShipmentServicesResponse getEligibleShipmentServices(GetEligibleShipmentServicesRequest body, String restrictedDataToken) throws ApiException, LWAException {
        ApiResponse<GetEligibleShipmentServicesResponse> resp = this.getEligibleShipmentServicesWithHttpInfo(body, restrictedDataToken);
        return resp.getData();
    }

    public GetEligibleShipmentServicesResponse getEligibleShipmentServices(GetEligibleShipmentServicesRequest body) throws ApiException, LWAException {
        ApiResponse<GetEligibleShipmentServicesResponse> resp = this.getEligibleShipmentServicesWithHttpInfo(body, null);
        return resp.getData();
    }

    public ApiResponse<GetEligibleShipmentServicesResponse> getEligibleShipmentServicesWithHttpInfo(GetEligibleShipmentServicesRequest body, String restrictedDataToken) throws ApiException, LWAException {
        Call call = this.getEligibleShipmentServicesValidateBeforeCall(body, null);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "MerchantFulfillmentApi-getEligibleShipmentServices");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.getEligibleShipmentServicesBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<GetEligibleShipmentServicesResponse>(){}.getType();
            return this.apiClient.execute(call, localVarReturnType);
        }
        throw new ApiException.RateLimitExceeded("getEligibleShipmentServices operation exceeds rate limit");
    }

    public ApiResponse<GetEligibleShipmentServicesResponse> getEligibleShipmentServicesWithHttpInfo(GetEligibleShipmentServicesRequest body) throws ApiException, LWAException {
        return this.getEligibleShipmentServicesWithHttpInfo(body, null);
    }

    public Call getEligibleShipmentServicesAsync(GetEligibleShipmentServicesRequest body, ApiCallback<GetEligibleShipmentServicesResponse> callback) throws ApiException, LWAException {
        return this.getEligibleShipmentServicesAsync(body, callback, null);
    }

    public Call getEligibleShipmentServicesAsync(GetEligibleShipmentServicesRequest body, ApiCallback<GetEligibleShipmentServicesResponse> callback, String restrictedDataToken) throws ApiException, LWAException {
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressRequestListener = callback::onUploadProgress;
        }
        Call call = this.getEligibleShipmentServicesValidateBeforeCall(body, progressRequestListener);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "MerchantFulfillmentApi-getEligibleShipmentServices");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.getEligibleShipmentServicesBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<GetEligibleShipmentServicesResponse>(){}.getType();
            this.apiClient.executeAsync(call, localVarReturnType, callback);
            return call;
        }
        throw new ApiException.RateLimitExceeded("getEligibleShipmentServices operation exceeds rate limit");
    }

    private Call getShipmentCall(String shipmentId, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        Object localVarPostBody = null;
        String localVarPath = "/mfn/v0/shipments/{shipmentId}".equals("/uploads/2020-11-01/uploadDestinations/{resource}") ? "/mfn/v0/shipments/{shipmentId}".replaceAll("\\{shipmentId\\}", shipmentId.toString()) : "/mfn/v0/shipments/{shipmentId}".replaceAll("\\{shipmentId\\}", this.apiClient.escapeString(shipmentId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, progressRequestListener);
    }

    private Call getShipmentValidateBeforeCall(String shipmentId, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        if (shipmentId == null) {
            throw new ApiException("Missing the required parameter 'shipmentId' when calling getShipment(Async)");
        }
        return this.getShipmentCall(shipmentId, progressRequestListener);
    }

    public GetShipmentResponse getShipment(String shipmentId, String restrictedDataToken) throws ApiException, LWAException {
        ApiResponse<GetShipmentResponse> resp = this.getShipmentWithHttpInfo(shipmentId, restrictedDataToken);
        return resp.getData();
    }

    public GetShipmentResponse getShipment(String shipmentId) throws ApiException, LWAException {
        ApiResponse<GetShipmentResponse> resp = this.getShipmentWithHttpInfo(shipmentId, null);
        return resp.getData();
    }

    public ApiResponse<GetShipmentResponse> getShipmentWithHttpInfo(String shipmentId, String restrictedDataToken) throws ApiException, LWAException {
        Call call = this.getShipmentValidateBeforeCall(shipmentId, null);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "MerchantFulfillmentApi-getShipment");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.getShipmentBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<GetShipmentResponse>(){}.getType();
            return this.apiClient.execute(call, localVarReturnType);
        }
        throw new ApiException.RateLimitExceeded("getShipment operation exceeds rate limit");
    }

    public ApiResponse<GetShipmentResponse> getShipmentWithHttpInfo(String shipmentId) throws ApiException, LWAException {
        return this.getShipmentWithHttpInfo(shipmentId, null);
    }

    public Call getShipmentAsync(String shipmentId, ApiCallback<GetShipmentResponse> callback) throws ApiException, LWAException {
        return this.getShipmentAsync(shipmentId, callback, null);
    }

    public Call getShipmentAsync(String shipmentId, ApiCallback<GetShipmentResponse> callback, String restrictedDataToken) throws ApiException, LWAException {
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressRequestListener = callback::onUploadProgress;
        }
        Call call = this.getShipmentValidateBeforeCall(shipmentId, progressRequestListener);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "MerchantFulfillmentApi-getShipment");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.getShipmentBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<GetShipmentResponse>(){}.getType();
            this.apiClient.executeAsync(call, localVarReturnType, callback);
            return call;
        }
        throw new ApiException.RateLimitExceeded("getShipment operation exceeds rate limit");
    }

    public static class Builder {
        private LWAAuthorizationCredentials lwaAuthorizationCredentials;
        private String endpoint;
        private LWAAccessTokenCache lwaAccessTokenCache;
        private Boolean disableAccessTokenCache = false;
        private Boolean disableRateLimiting = false;

        public Builder lwaAuthorizationCredentials(LWAAuthorizationCredentials lwaAuthorizationCredentials) {
            this.lwaAuthorizationCredentials = lwaAuthorizationCredentials;
            return this;
        }

        public Builder endpoint(String endpoint) {
            this.endpoint = endpoint;
            return this;
        }

        public Builder lwaAccessTokenCache(LWAAccessTokenCache lwaAccessTokenCache) {
            this.lwaAccessTokenCache = lwaAccessTokenCache;
            return this;
        }

        public Builder disableAccessTokenCache() {
            this.disableAccessTokenCache = true;
            return this;
        }

        public Builder disableRateLimiting() {
            this.disableRateLimiting = true;
            return this;
        }

        public MerchantFulfillmentApi build() {
            if (this.lwaAuthorizationCredentials == null) {
                throw new RuntimeException("LWAAuthorizationCredentials not set");
            }
            if (StringUtil.isEmpty(this.endpoint)) {
                throw new RuntimeException("Endpoint not set");
            }
            LWAAuthorizationSigner lwaAuthorizationSigner = null;
            if (this.disableAccessTokenCache.booleanValue()) {
                lwaAuthorizationSigner = new LWAAuthorizationSigner(this.lwaAuthorizationCredentials);
            } else {
                if (this.lwaAccessTokenCache == null) {
                    this.lwaAccessTokenCache = new LWAAccessTokenCacheImpl();
                }
                lwaAuthorizationSigner = new LWAAuthorizationSigner(this.lwaAuthorizationCredentials, this.lwaAccessTokenCache);
            }
            return new MerchantFulfillmentApi(new ApiClient().setLWAAuthorizationSigner(lwaAuthorizationSigner).setBasePath(this.endpoint), this.disableRateLimiting);
        }
    }
}

