/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.api.listings.items.v2021_08_01;

import com.amazon.SellingPartnerAPIAA.LWAAccessTokenCache;
import com.amazon.SellingPartnerAPIAA.LWAAccessTokenCacheImpl;
import com.amazon.SellingPartnerAPIAA.LWAAuthorizationCredentials;
import com.amazon.SellingPartnerAPIAA.LWAAuthorizationSigner;
import com.amazon.SellingPartnerAPIAA.LWAException;
import com.amazon.SellingPartnerAPIAA.RestrictedDataTokenSigner;
import com.google.gson.reflect.TypeToken;
import io.github.bucket4j.Bucket;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import okhttp3.Call;
import okhttp3.Request;
import org.threeten.bp.OffsetDateTime;
import software.amazon.spapi.ApiCallback;
import software.amazon.spapi.ApiClient;
import software.amazon.spapi.ApiException;
import software.amazon.spapi.ApiResponse;
import software.amazon.spapi.Configuration;
import software.amazon.spapi.Pair;
import software.amazon.spapi.ProgressRequestBody;
import software.amazon.spapi.StringUtil;
import software.amazon.spapi.models.listings.items.v2021_08_01.Item;
import software.amazon.spapi.models.listings.items.v2021_08_01.ItemSearchResults;
import software.amazon.spapi.models.listings.items.v2021_08_01.ListingsItemPatchRequest;
import software.amazon.spapi.models.listings.items.v2021_08_01.ListingsItemPutRequest;
import software.amazon.spapi.models.listings.items.v2021_08_01.ListingsItemSubmissionResponse;

public class ListingsApi {
    private ApiClient apiClient;
    private Boolean disableRateLimiting;
    private final Configuration config = Configuration.get();
    public final Bucket deleteListingsItemBucket = Bucket.builder().addLimit(this.config.getLimit("ListingsApi-deleteListingsItem")).build();
    public final Bucket getListingsItemBucket = Bucket.builder().addLimit(this.config.getLimit("ListingsApi-getListingsItem")).build();
    public final Bucket patchListingsItemBucket = Bucket.builder().addLimit(this.config.getLimit("ListingsApi-patchListingsItem")).build();
    public final Bucket putListingsItemBucket = Bucket.builder().addLimit(this.config.getLimit("ListingsApi-putListingsItem")).build();
    public final Bucket searchListingsItemsBucket = Bucket.builder().addLimit(this.config.getLimit("ListingsApi-searchListingsItems")).build();

    public ListingsApi(ApiClient apiClient, Boolean disableRateLimiting) {
        this.apiClient = apiClient;
        this.disableRateLimiting = disableRateLimiting;
    }

    private Call deleteListingsItemCall(String sellerId, String sku, List<String> marketplaceIds, String issueLocale, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        Object localVarPostBody = null;
        String localVarPath = "/listings/2021-08-01/items/{sellerId}/{sku}".equals("/uploads/2020-11-01/uploadDestinations/{resource}") ? "/listings/2021-08-01/items/{sellerId}/{sku}".replaceAll("\\{sellerId\\}", sellerId.toString()).replaceAll("\\{sku\\}", sku.toString()) : "/listings/2021-08-01/items/{sellerId}/{sku}".replaceAll("\\{sellerId\\}", this.apiClient.escapeString(sellerId.toString())).replaceAll("\\{sku\\}", this.apiClient.escapeString(sku.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (marketplaceIds != null) {
            localVarCollectionQueryParams.addAll(this.apiClient.parameterToPairs("csv", "marketplaceIds", marketplaceIds));
        }
        if (issueLocale != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("issueLocale", issueLocale));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        return this.apiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, progressRequestListener);
    }

    private Call deleteListingsItemValidateBeforeCall(String sellerId, String sku, List<String> marketplaceIds, String issueLocale, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        if (sellerId == null) {
            throw new ApiException("Missing the required parameter 'sellerId' when calling deleteListingsItem(Async)");
        }
        if (sku == null) {
            throw new ApiException("Missing the required parameter 'sku' when calling deleteListingsItem(Async)");
        }
        if (marketplaceIds == null) {
            throw new ApiException("Missing the required parameter 'marketplaceIds' when calling deleteListingsItem(Async)");
        }
        return this.deleteListingsItemCall(sellerId, sku, marketplaceIds, issueLocale, progressRequestListener);
    }

    public ListingsItemSubmissionResponse deleteListingsItem(String sellerId, String sku, List<String> marketplaceIds, String issueLocale, String restrictedDataToken) throws ApiException, LWAException {
        ApiResponse<ListingsItemSubmissionResponse> resp = this.deleteListingsItemWithHttpInfo(sellerId, sku, marketplaceIds, issueLocale, restrictedDataToken);
        return resp.getData();
    }

    public ListingsItemSubmissionResponse deleteListingsItem(String sellerId, String sku, List<String> marketplaceIds, String issueLocale) throws ApiException, LWAException {
        ApiResponse<ListingsItemSubmissionResponse> resp = this.deleteListingsItemWithHttpInfo(sellerId, sku, marketplaceIds, issueLocale, null);
        return resp.getData();
    }

    public ApiResponse<ListingsItemSubmissionResponse> deleteListingsItemWithHttpInfo(String sellerId, String sku, List<String> marketplaceIds, String issueLocale, String restrictedDataToken) throws ApiException, LWAException {
        Call call = this.deleteListingsItemValidateBeforeCall(sellerId, sku, marketplaceIds, issueLocale, null);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "ListingsApi-deleteListingsItem");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.deleteListingsItemBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<ListingsItemSubmissionResponse>(){}.getType();
            return this.apiClient.execute(call, localVarReturnType);
        }
        throw new ApiException.RateLimitExceeded("deleteListingsItem operation exceeds rate limit");
    }

    public ApiResponse<ListingsItemSubmissionResponse> deleteListingsItemWithHttpInfo(String sellerId, String sku, List<String> marketplaceIds, String issueLocale) throws ApiException, LWAException {
        return this.deleteListingsItemWithHttpInfo(sellerId, sku, marketplaceIds, issueLocale, null);
    }

    public Call deleteListingsItemAsync(String sellerId, String sku, List<String> marketplaceIds, String issueLocale, ApiCallback<ListingsItemSubmissionResponse> callback) throws ApiException, LWAException {
        return this.deleteListingsItemAsync(sellerId, sku, marketplaceIds, issueLocale, callback, null);
    }

    public Call deleteListingsItemAsync(String sellerId, String sku, List<String> marketplaceIds, String issueLocale, ApiCallback<ListingsItemSubmissionResponse> callback, String restrictedDataToken) throws ApiException, LWAException {
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressRequestListener = callback::onUploadProgress;
        }
        Call call = this.deleteListingsItemValidateBeforeCall(sellerId, sku, marketplaceIds, issueLocale, progressRequestListener);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "ListingsApi-deleteListingsItem");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.deleteListingsItemBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<ListingsItemSubmissionResponse>(){}.getType();
            this.apiClient.executeAsync(call, localVarReturnType, callback);
            return call;
        }
        throw new ApiException.RateLimitExceeded("deleteListingsItem operation exceeds rate limit");
    }

    private Call getListingsItemCall(String sellerId, String sku, List<String> marketplaceIds, String issueLocale, List<String> includedData, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        Object localVarPostBody = null;
        String localVarPath = "/listings/2021-08-01/items/{sellerId}/{sku}".equals("/uploads/2020-11-01/uploadDestinations/{resource}") ? "/listings/2021-08-01/items/{sellerId}/{sku}".replaceAll("\\{sellerId\\}", sellerId.toString()).replaceAll("\\{sku\\}", sku.toString()) : "/listings/2021-08-01/items/{sellerId}/{sku}".replaceAll("\\{sellerId\\}", this.apiClient.escapeString(sellerId.toString())).replaceAll("\\{sku\\}", this.apiClient.escapeString(sku.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (marketplaceIds != null) {
            localVarCollectionQueryParams.addAll(this.apiClient.parameterToPairs("csv", "marketplaceIds", marketplaceIds));
        }
        if (issueLocale != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("issueLocale", issueLocale));
        }
        if (includedData != null) {
            localVarCollectionQueryParams.addAll(this.apiClient.parameterToPairs("csv", "includedData", includedData));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, progressRequestListener);
    }

    private Call getListingsItemValidateBeforeCall(String sellerId, String sku, List<String> marketplaceIds, String issueLocale, List<String> includedData, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        if (sellerId == null) {
            throw new ApiException("Missing the required parameter 'sellerId' when calling getListingsItem(Async)");
        }
        if (sku == null) {
            throw new ApiException("Missing the required parameter 'sku' when calling getListingsItem(Async)");
        }
        if (marketplaceIds == null) {
            throw new ApiException("Missing the required parameter 'marketplaceIds' when calling getListingsItem(Async)");
        }
        return this.getListingsItemCall(sellerId, sku, marketplaceIds, issueLocale, includedData, progressRequestListener);
    }

    public Item getListingsItem(String sellerId, String sku, List<String> marketplaceIds, String issueLocale, List<String> includedData, String restrictedDataToken) throws ApiException, LWAException {
        ApiResponse<Item> resp = this.getListingsItemWithHttpInfo(sellerId, sku, marketplaceIds, issueLocale, includedData, restrictedDataToken);
        return resp.getData();
    }

    public Item getListingsItem(String sellerId, String sku, List<String> marketplaceIds, String issueLocale, List<String> includedData) throws ApiException, LWAException {
        ApiResponse<Item> resp = this.getListingsItemWithHttpInfo(sellerId, sku, marketplaceIds, issueLocale, includedData, null);
        return resp.getData();
    }

    public ApiResponse<Item> getListingsItemWithHttpInfo(String sellerId, String sku, List<String> marketplaceIds, String issueLocale, List<String> includedData, String restrictedDataToken) throws ApiException, LWAException {
        Call call = this.getListingsItemValidateBeforeCall(sellerId, sku, marketplaceIds, issueLocale, includedData, null);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "ListingsApi-getListingsItem");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.getListingsItemBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<Item>(){}.getType();
            return this.apiClient.execute(call, localVarReturnType);
        }
        throw new ApiException.RateLimitExceeded("getListingsItem operation exceeds rate limit");
    }

    public ApiResponse<Item> getListingsItemWithHttpInfo(String sellerId, String sku, List<String> marketplaceIds, String issueLocale, List<String> includedData) throws ApiException, LWAException {
        return this.getListingsItemWithHttpInfo(sellerId, sku, marketplaceIds, issueLocale, includedData, null);
    }

    public Call getListingsItemAsync(String sellerId, String sku, List<String> marketplaceIds, String issueLocale, List<String> includedData, ApiCallback<Item> callback) throws ApiException, LWAException {
        return this.getListingsItemAsync(sellerId, sku, marketplaceIds, issueLocale, includedData, callback, null);
    }

    public Call getListingsItemAsync(String sellerId, String sku, List<String> marketplaceIds, String issueLocale, List<String> includedData, ApiCallback<Item> callback, String restrictedDataToken) throws ApiException, LWAException {
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressRequestListener = callback::onUploadProgress;
        }
        Call call = this.getListingsItemValidateBeforeCall(sellerId, sku, marketplaceIds, issueLocale, includedData, progressRequestListener);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "ListingsApi-getListingsItem");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.getListingsItemBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<Item>(){}.getType();
            this.apiClient.executeAsync(call, localVarReturnType, callback);
            return call;
        }
        throw new ApiException.RateLimitExceeded("getListingsItem operation exceeds rate limit");
    }

    private Call patchListingsItemCall(ListingsItemPatchRequest body, String sellerId, String sku, List<String> marketplaceIds, List<String> includedData, String mode, String issueLocale, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        ListingsItemPatchRequest localVarPostBody = body;
        String localVarPath = "/listings/2021-08-01/items/{sellerId}/{sku}".equals("/uploads/2020-11-01/uploadDestinations/{resource}") ? "/listings/2021-08-01/items/{sellerId}/{sku}".replaceAll("\\{sellerId\\}", sellerId.toString()).replaceAll("\\{sku\\}", sku.toString()) : "/listings/2021-08-01/items/{sellerId}/{sku}".replaceAll("\\{sellerId\\}", this.apiClient.escapeString(sellerId.toString())).replaceAll("\\{sku\\}", this.apiClient.escapeString(sku.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (marketplaceIds != null) {
            localVarCollectionQueryParams.addAll(this.apiClient.parameterToPairs("csv", "marketplaceIds", marketplaceIds));
        }
        if (includedData != null) {
            localVarCollectionQueryParams.addAll(this.apiClient.parameterToPairs("csv", "includedData", includedData));
        }
        if (mode != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("mode", mode));
        }
        if (issueLocale != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("issueLocale", issueLocale));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        return this.apiClient.buildCall(localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, progressRequestListener);
    }

    private Call patchListingsItemValidateBeforeCall(ListingsItemPatchRequest body, String sellerId, String sku, List<String> marketplaceIds, List<String> includedData, String mode, String issueLocale, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling patchListingsItem(Async)");
        }
        if (sellerId == null) {
            throw new ApiException("Missing the required parameter 'sellerId' when calling patchListingsItem(Async)");
        }
        if (sku == null) {
            throw new ApiException("Missing the required parameter 'sku' when calling patchListingsItem(Async)");
        }
        if (marketplaceIds == null) {
            throw new ApiException("Missing the required parameter 'marketplaceIds' when calling patchListingsItem(Async)");
        }
        return this.patchListingsItemCall(body, sellerId, sku, marketplaceIds, includedData, mode, issueLocale, progressRequestListener);
    }

    public ListingsItemSubmissionResponse patchListingsItem(ListingsItemPatchRequest body, String sellerId, String sku, List<String> marketplaceIds, List<String> includedData, String mode, String issueLocale, String restrictedDataToken) throws ApiException, LWAException {
        ApiResponse<ListingsItemSubmissionResponse> resp = this.patchListingsItemWithHttpInfo(body, sellerId, sku, marketplaceIds, includedData, mode, issueLocale, restrictedDataToken);
        return resp.getData();
    }

    public ListingsItemSubmissionResponse patchListingsItem(ListingsItemPatchRequest body, String sellerId, String sku, List<String> marketplaceIds, List<String> includedData, String mode, String issueLocale) throws ApiException, LWAException {
        ApiResponse<ListingsItemSubmissionResponse> resp = this.patchListingsItemWithHttpInfo(body, sellerId, sku, marketplaceIds, includedData, mode, issueLocale, null);
        return resp.getData();
    }

    public ApiResponse<ListingsItemSubmissionResponse> patchListingsItemWithHttpInfo(ListingsItemPatchRequest body, String sellerId, String sku, List<String> marketplaceIds, List<String> includedData, String mode, String issueLocale, String restrictedDataToken) throws ApiException, LWAException {
        Call call = this.patchListingsItemValidateBeforeCall(body, sellerId, sku, marketplaceIds, includedData, mode, issueLocale, null);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "ListingsApi-patchListingsItem");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.patchListingsItemBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<ListingsItemSubmissionResponse>(){}.getType();
            return this.apiClient.execute(call, localVarReturnType);
        }
        throw new ApiException.RateLimitExceeded("patchListingsItem operation exceeds rate limit");
    }

    public ApiResponse<ListingsItemSubmissionResponse> patchListingsItemWithHttpInfo(ListingsItemPatchRequest body, String sellerId, String sku, List<String> marketplaceIds, List<String> includedData, String mode, String issueLocale) throws ApiException, LWAException {
        return this.patchListingsItemWithHttpInfo(body, sellerId, sku, marketplaceIds, includedData, mode, issueLocale, null);
    }

    public Call patchListingsItemAsync(ListingsItemPatchRequest body, String sellerId, String sku, List<String> marketplaceIds, List<String> includedData, String mode, String issueLocale, ApiCallback<ListingsItemSubmissionResponse> callback) throws ApiException, LWAException {
        return this.patchListingsItemAsync(body, sellerId, sku, marketplaceIds, includedData, mode, issueLocale, callback, null);
    }

    public Call patchListingsItemAsync(ListingsItemPatchRequest body, String sellerId, String sku, List<String> marketplaceIds, List<String> includedData, String mode, String issueLocale, ApiCallback<ListingsItemSubmissionResponse> callback, String restrictedDataToken) throws ApiException, LWAException {
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressRequestListener = callback::onUploadProgress;
        }
        Call call = this.patchListingsItemValidateBeforeCall(body, sellerId, sku, marketplaceIds, includedData, mode, issueLocale, progressRequestListener);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "ListingsApi-patchListingsItem");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.patchListingsItemBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<ListingsItemSubmissionResponse>(){}.getType();
            this.apiClient.executeAsync(call, localVarReturnType, callback);
            return call;
        }
        throw new ApiException.RateLimitExceeded("patchListingsItem operation exceeds rate limit");
    }

    private Call putListingsItemCall(ListingsItemPutRequest body, String sellerId, String sku, List<String> marketplaceIds, List<String> includedData, String mode, String issueLocale, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        ListingsItemPutRequest localVarPostBody = body;
        String localVarPath = "/listings/2021-08-01/items/{sellerId}/{sku}".equals("/uploads/2020-11-01/uploadDestinations/{resource}") ? "/listings/2021-08-01/items/{sellerId}/{sku}".replaceAll("\\{sellerId\\}", sellerId.toString()).replaceAll("\\{sku\\}", sku.toString()) : "/listings/2021-08-01/items/{sellerId}/{sku}".replaceAll("\\{sellerId\\}", this.apiClient.escapeString(sellerId.toString())).replaceAll("\\{sku\\}", this.apiClient.escapeString(sku.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (marketplaceIds != null) {
            localVarCollectionQueryParams.addAll(this.apiClient.parameterToPairs("csv", "marketplaceIds", marketplaceIds));
        }
        if (includedData != null) {
            localVarCollectionQueryParams.addAll(this.apiClient.parameterToPairs("csv", "includedData", includedData));
        }
        if (mode != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("mode", mode));
        }
        if (issueLocale != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("issueLocale", issueLocale));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        return this.apiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, progressRequestListener);
    }

    private Call putListingsItemValidateBeforeCall(ListingsItemPutRequest body, String sellerId, String sku, List<String> marketplaceIds, List<String> includedData, String mode, String issueLocale, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling putListingsItem(Async)");
        }
        if (sellerId == null) {
            throw new ApiException("Missing the required parameter 'sellerId' when calling putListingsItem(Async)");
        }
        if (sku == null) {
            throw new ApiException("Missing the required parameter 'sku' when calling putListingsItem(Async)");
        }
        if (marketplaceIds == null) {
            throw new ApiException("Missing the required parameter 'marketplaceIds' when calling putListingsItem(Async)");
        }
        return this.putListingsItemCall(body, sellerId, sku, marketplaceIds, includedData, mode, issueLocale, progressRequestListener);
    }

    public ListingsItemSubmissionResponse putListingsItem(ListingsItemPutRequest body, String sellerId, String sku, List<String> marketplaceIds, List<String> includedData, String mode, String issueLocale, String restrictedDataToken) throws ApiException, LWAException {
        ApiResponse<ListingsItemSubmissionResponse> resp = this.putListingsItemWithHttpInfo(body, sellerId, sku, marketplaceIds, includedData, mode, issueLocale, restrictedDataToken);
        return resp.getData();
    }

    public ListingsItemSubmissionResponse putListingsItem(ListingsItemPutRequest body, String sellerId, String sku, List<String> marketplaceIds, List<String> includedData, String mode, String issueLocale) throws ApiException, LWAException {
        ApiResponse<ListingsItemSubmissionResponse> resp = this.putListingsItemWithHttpInfo(body, sellerId, sku, marketplaceIds, includedData, mode, issueLocale, null);
        return resp.getData();
    }

    public ApiResponse<ListingsItemSubmissionResponse> putListingsItemWithHttpInfo(ListingsItemPutRequest body, String sellerId, String sku, List<String> marketplaceIds, List<String> includedData, String mode, String issueLocale, String restrictedDataToken) throws ApiException, LWAException {
        Call call = this.putListingsItemValidateBeforeCall(body, sellerId, sku, marketplaceIds, includedData, mode, issueLocale, null);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "ListingsApi-putListingsItem");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.putListingsItemBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<ListingsItemSubmissionResponse>(){}.getType();
            return this.apiClient.execute(call, localVarReturnType);
        }
        throw new ApiException.RateLimitExceeded("putListingsItem operation exceeds rate limit");
    }

    public ApiResponse<ListingsItemSubmissionResponse> putListingsItemWithHttpInfo(ListingsItemPutRequest body, String sellerId, String sku, List<String> marketplaceIds, List<String> includedData, String mode, String issueLocale) throws ApiException, LWAException {
        return this.putListingsItemWithHttpInfo(body, sellerId, sku, marketplaceIds, includedData, mode, issueLocale, null);
    }

    public Call putListingsItemAsync(ListingsItemPutRequest body, String sellerId, String sku, List<String> marketplaceIds, List<String> includedData, String mode, String issueLocale, ApiCallback<ListingsItemSubmissionResponse> callback) throws ApiException, LWAException {
        return this.putListingsItemAsync(body, sellerId, sku, marketplaceIds, includedData, mode, issueLocale, callback, null);
    }

    public Call putListingsItemAsync(ListingsItemPutRequest body, String sellerId, String sku, List<String> marketplaceIds, List<String> includedData, String mode, String issueLocale, ApiCallback<ListingsItemSubmissionResponse> callback, String restrictedDataToken) throws ApiException, LWAException {
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressRequestListener = callback::onUploadProgress;
        }
        Call call = this.putListingsItemValidateBeforeCall(body, sellerId, sku, marketplaceIds, includedData, mode, issueLocale, progressRequestListener);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "ListingsApi-putListingsItem");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.putListingsItemBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<ListingsItemSubmissionResponse>(){}.getType();
            this.apiClient.executeAsync(call, localVarReturnType, callback);
            return call;
        }
        throw new ApiException.RateLimitExceeded("putListingsItem operation exceeds rate limit");
    }

    private Call searchListingsItemsCall(String sellerId, List<String> marketplaceIds, String issueLocale, List<String> includedData, List<String> identifiers, String identifiersType, String variationParentSku, String packageHierarchySku, OffsetDateTime createdAfter, OffsetDateTime createdBefore, OffsetDateTime lastUpdatedAfter, OffsetDateTime lastUpdatedBefore, List<String> withIssueSeverity, List<String> withStatus, List<String> withoutStatus, String sortBy, String sortOrder, Integer pageSize, String pageToken, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        Object localVarPostBody = null;
        String localVarPath = "/listings/2021-08-01/items/{sellerId}".equals("/uploads/2020-11-01/uploadDestinations/{resource}") ? "/listings/2021-08-01/items/{sellerId}".replaceAll("\\{sellerId\\}", sellerId.toString()) : "/listings/2021-08-01/items/{sellerId}".replaceAll("\\{sellerId\\}", this.apiClient.escapeString(sellerId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (marketplaceIds != null) {
            localVarCollectionQueryParams.addAll(this.apiClient.parameterToPairs("csv", "marketplaceIds", marketplaceIds));
        }
        if (issueLocale != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("issueLocale", issueLocale));
        }
        if (includedData != null) {
            localVarCollectionQueryParams.addAll(this.apiClient.parameterToPairs("csv", "includedData", includedData));
        }
        if (identifiers != null) {
            localVarCollectionQueryParams.addAll(this.apiClient.parameterToPairs("csv", "identifiers", identifiers));
        }
        if (identifiersType != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("identifiersType", identifiersType));
        }
        if (variationParentSku != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("variationParentSku", variationParentSku));
        }
        if (packageHierarchySku != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("packageHierarchySku", packageHierarchySku));
        }
        if (createdAfter != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("createdAfter", createdAfter));
        }
        if (createdBefore != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("createdBefore", createdBefore));
        }
        if (lastUpdatedAfter != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("lastUpdatedAfter", lastUpdatedAfter));
        }
        if (lastUpdatedBefore != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("lastUpdatedBefore", lastUpdatedBefore));
        }
        if (withIssueSeverity != null) {
            localVarCollectionQueryParams.addAll(this.apiClient.parameterToPairs("csv", "withIssueSeverity", withIssueSeverity));
        }
        if (withStatus != null) {
            localVarCollectionQueryParams.addAll(this.apiClient.parameterToPairs("csv", "withStatus", withStatus));
        }
        if (withoutStatus != null) {
            localVarCollectionQueryParams.addAll(this.apiClient.parameterToPairs("csv", "withoutStatus", withoutStatus));
        }
        if (sortBy != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("sortBy", sortBy));
        }
        if (sortOrder != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("sortOrder", sortOrder));
        }
        if (pageSize != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("pageSize", pageSize));
        }
        if (pageToken != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("pageToken", pageToken));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, progressRequestListener);
    }

    private Call searchListingsItemsValidateBeforeCall(String sellerId, List<String> marketplaceIds, String issueLocale, List<String> includedData, List<String> identifiers, String identifiersType, String variationParentSku, String packageHierarchySku, OffsetDateTime createdAfter, OffsetDateTime createdBefore, OffsetDateTime lastUpdatedAfter, OffsetDateTime lastUpdatedBefore, List<String> withIssueSeverity, List<String> withStatus, List<String> withoutStatus, String sortBy, String sortOrder, Integer pageSize, String pageToken, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        if (sellerId == null) {
            throw new ApiException("Missing the required parameter 'sellerId' when calling searchListingsItems(Async)");
        }
        if (marketplaceIds == null) {
            throw new ApiException("Missing the required parameter 'marketplaceIds' when calling searchListingsItems(Async)");
        }
        return this.searchListingsItemsCall(sellerId, marketplaceIds, issueLocale, includedData, identifiers, identifiersType, variationParentSku, packageHierarchySku, createdAfter, createdBefore, lastUpdatedAfter, lastUpdatedBefore, withIssueSeverity, withStatus, withoutStatus, sortBy, sortOrder, pageSize, pageToken, progressRequestListener);
    }

    public ItemSearchResults searchListingsItems(String sellerId, List<String> marketplaceIds, String issueLocale, List<String> includedData, List<String> identifiers, String identifiersType, String variationParentSku, String packageHierarchySku, OffsetDateTime createdAfter, OffsetDateTime createdBefore, OffsetDateTime lastUpdatedAfter, OffsetDateTime lastUpdatedBefore, List<String> withIssueSeverity, List<String> withStatus, List<String> withoutStatus, String sortBy, String sortOrder, Integer pageSize, String pageToken, String restrictedDataToken) throws ApiException, LWAException {
        ApiResponse<ItemSearchResults> resp = this.searchListingsItemsWithHttpInfo(sellerId, marketplaceIds, issueLocale, includedData, identifiers, identifiersType, variationParentSku, packageHierarchySku, createdAfter, createdBefore, lastUpdatedAfter, lastUpdatedBefore, withIssueSeverity, withStatus, withoutStatus, sortBy, sortOrder, pageSize, pageToken, restrictedDataToken);
        return resp.getData();
    }

    public ItemSearchResults searchListingsItems(String sellerId, List<String> marketplaceIds, String issueLocale, List<String> includedData, List<String> identifiers, String identifiersType, String variationParentSku, String packageHierarchySku, OffsetDateTime createdAfter, OffsetDateTime createdBefore, OffsetDateTime lastUpdatedAfter, OffsetDateTime lastUpdatedBefore, List<String> withIssueSeverity, List<String> withStatus, List<String> withoutStatus, String sortBy, String sortOrder, Integer pageSize, String pageToken) throws ApiException, LWAException {
        ApiResponse<ItemSearchResults> resp = this.searchListingsItemsWithHttpInfo(sellerId, marketplaceIds, issueLocale, includedData, identifiers, identifiersType, variationParentSku, packageHierarchySku, createdAfter, createdBefore, lastUpdatedAfter, lastUpdatedBefore, withIssueSeverity, withStatus, withoutStatus, sortBy, sortOrder, pageSize, pageToken, null);
        return resp.getData();
    }

    public ApiResponse<ItemSearchResults> searchListingsItemsWithHttpInfo(String sellerId, List<String> marketplaceIds, String issueLocale, List<String> includedData, List<String> identifiers, String identifiersType, String variationParentSku, String packageHierarchySku, OffsetDateTime createdAfter, OffsetDateTime createdBefore, OffsetDateTime lastUpdatedAfter, OffsetDateTime lastUpdatedBefore, List<String> withIssueSeverity, List<String> withStatus, List<String> withoutStatus, String sortBy, String sortOrder, Integer pageSize, String pageToken, String restrictedDataToken) throws ApiException, LWAException {
        Call call = this.searchListingsItemsValidateBeforeCall(sellerId, marketplaceIds, issueLocale, includedData, identifiers, identifiersType, variationParentSku, packageHierarchySku, createdAfter, createdBefore, lastUpdatedAfter, lastUpdatedBefore, withIssueSeverity, withStatus, withoutStatus, sortBy, sortOrder, pageSize, pageToken, null);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "ListingsApi-searchListingsItems");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.searchListingsItemsBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<ItemSearchResults>(){}.getType();
            return this.apiClient.execute(call, localVarReturnType);
        }
        throw new ApiException.RateLimitExceeded("searchListingsItems operation exceeds rate limit");
    }

    public ApiResponse<ItemSearchResults> searchListingsItemsWithHttpInfo(String sellerId, List<String> marketplaceIds, String issueLocale, List<String> includedData, List<String> identifiers, String identifiersType, String variationParentSku, String packageHierarchySku, OffsetDateTime createdAfter, OffsetDateTime createdBefore, OffsetDateTime lastUpdatedAfter, OffsetDateTime lastUpdatedBefore, List<String> withIssueSeverity, List<String> withStatus, List<String> withoutStatus, String sortBy, String sortOrder, Integer pageSize, String pageToken) throws ApiException, LWAException {
        return this.searchListingsItemsWithHttpInfo(sellerId, marketplaceIds, issueLocale, includedData, identifiers, identifiersType, variationParentSku, packageHierarchySku, createdAfter, createdBefore, lastUpdatedAfter, lastUpdatedBefore, withIssueSeverity, withStatus, withoutStatus, sortBy, sortOrder, pageSize, pageToken, null);
    }

    public Call searchListingsItemsAsync(String sellerId, List<String> marketplaceIds, String issueLocale, List<String> includedData, List<String> identifiers, String identifiersType, String variationParentSku, String packageHierarchySku, OffsetDateTime createdAfter, OffsetDateTime createdBefore, OffsetDateTime lastUpdatedAfter, OffsetDateTime lastUpdatedBefore, List<String> withIssueSeverity, List<String> withStatus, List<String> withoutStatus, String sortBy, String sortOrder, Integer pageSize, String pageToken, ApiCallback<ItemSearchResults> callback) throws ApiException, LWAException {
        return this.searchListingsItemsAsync(sellerId, marketplaceIds, issueLocale, includedData, identifiers, identifiersType, variationParentSku, packageHierarchySku, createdAfter, createdBefore, lastUpdatedAfter, lastUpdatedBefore, withIssueSeverity, withStatus, withoutStatus, sortBy, sortOrder, pageSize, pageToken, callback, null);
    }

    public Call searchListingsItemsAsync(String sellerId, List<String> marketplaceIds, String issueLocale, List<String> includedData, List<String> identifiers, String identifiersType, String variationParentSku, String packageHierarchySku, OffsetDateTime createdAfter, OffsetDateTime createdBefore, OffsetDateTime lastUpdatedAfter, OffsetDateTime lastUpdatedBefore, List<String> withIssueSeverity, List<String> withStatus, List<String> withoutStatus, String sortBy, String sortOrder, Integer pageSize, String pageToken, ApiCallback<ItemSearchResults> callback, String restrictedDataToken) throws ApiException, LWAException {
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressRequestListener = callback::onUploadProgress;
        }
        Call call = this.searchListingsItemsValidateBeforeCall(sellerId, marketplaceIds, issueLocale, includedData, identifiers, identifiersType, variationParentSku, packageHierarchySku, createdAfter, createdBefore, lastUpdatedAfter, lastUpdatedBefore, withIssueSeverity, withStatus, withoutStatus, sortBy, sortOrder, pageSize, pageToken, progressRequestListener);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "ListingsApi-searchListingsItems");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.searchListingsItemsBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<ItemSearchResults>(){}.getType();
            this.apiClient.executeAsync(call, localVarReturnType, callback);
            return call;
        }
        throw new ApiException.RateLimitExceeded("searchListingsItems operation exceeds rate limit");
    }

    public static class Builder {
        private LWAAuthorizationCredentials lwaAuthorizationCredentials;
        private String endpoint;
        private LWAAccessTokenCache lwaAccessTokenCache;
        private Boolean disableAccessTokenCache = false;
        private Boolean disableRateLimiting = false;

        public Builder lwaAuthorizationCredentials(LWAAuthorizationCredentials lwaAuthorizationCredentials) {
            this.lwaAuthorizationCredentials = lwaAuthorizationCredentials;
            return this;
        }

        public Builder endpoint(String endpoint) {
            this.endpoint = endpoint;
            return this;
        }

        public Builder lwaAccessTokenCache(LWAAccessTokenCache lwaAccessTokenCache) {
            this.lwaAccessTokenCache = lwaAccessTokenCache;
            return this;
        }

        public Builder disableAccessTokenCache() {
            this.disableAccessTokenCache = true;
            return this;
        }

        public Builder disableRateLimiting() {
            this.disableRateLimiting = true;
            return this;
        }

        public ListingsApi build() {
            if (this.lwaAuthorizationCredentials == null) {
                throw new RuntimeException("LWAAuthorizationCredentials not set");
            }
            if (StringUtil.isEmpty(this.endpoint)) {
                throw new RuntimeException("Endpoint not set");
            }
            LWAAuthorizationSigner lwaAuthorizationSigner = null;
            if (this.disableAccessTokenCache.booleanValue()) {
                lwaAuthorizationSigner = new LWAAuthorizationSigner(this.lwaAuthorizationCredentials);
            } else {
                if (this.lwaAccessTokenCache == null) {
                    this.lwaAccessTokenCache = new LWAAccessTokenCacheImpl();
                }
                lwaAuthorizationSigner = new LWAAuthorizationSigner(this.lwaAuthorizationCredentials, this.lwaAccessTokenCache);
            }
            return new ListingsApi(new ApiClient().setLWAAuthorizationSigner(lwaAuthorizationSigner).setBasePath(this.endpoint), this.disableRateLimiting);
        }
    }
}

