/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.api.invoices.v2024_06_19;

import com.amazon.SellingPartnerAPIAA.LWAAccessTokenCache;
import com.amazon.SellingPartnerAPIAA.LWAAccessTokenCacheImpl;
import com.amazon.SellingPartnerAPIAA.LWAAuthorizationCredentials;
import com.amazon.SellingPartnerAPIAA.LWAAuthorizationSigner;
import com.amazon.SellingPartnerAPIAA.LWAException;
import com.amazon.SellingPartnerAPIAA.RestrictedDataTokenSigner;
import com.google.gson.reflect.TypeToken;
import io.github.bucket4j.Bucket;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import okhttp3.Call;
import okhttp3.Request;
import org.threeten.bp.OffsetDateTime;
import software.amazon.spapi.ApiCallback;
import software.amazon.spapi.ApiClient;
import software.amazon.spapi.ApiException;
import software.amazon.spapi.ApiResponse;
import software.amazon.spapi.Configuration;
import software.amazon.spapi.Pair;
import software.amazon.spapi.ProgressRequestBody;
import software.amazon.spapi.StringUtil;
import software.amazon.spapi.models.invoices.v2024_06_19.ExportInvoicesRequest;
import software.amazon.spapi.models.invoices.v2024_06_19.ExportInvoicesResponse;
import software.amazon.spapi.models.invoices.v2024_06_19.GetInvoiceResponse;
import software.amazon.spapi.models.invoices.v2024_06_19.GetInvoicesAttributesResponse;
import software.amazon.spapi.models.invoices.v2024_06_19.GetInvoicesDocumentResponse;
import software.amazon.spapi.models.invoices.v2024_06_19.GetInvoicesExportResponse;
import software.amazon.spapi.models.invoices.v2024_06_19.GetInvoicesExportsResponse;
import software.amazon.spapi.models.invoices.v2024_06_19.GetInvoicesResponse;

public class InvoicesApi {
    private ApiClient apiClient;
    private Boolean disableRateLimiting;
    private final Configuration config = Configuration.get();
    public final Bucket createInvoicesExportBucket = Bucket.builder().addLimit(this.config.getLimit("InvoicesApi-createInvoicesExport")).build();
    public final Bucket getInvoiceBucket = Bucket.builder().addLimit(this.config.getLimit("InvoicesApi-getInvoice")).build();
    public final Bucket getInvoicesBucket = Bucket.builder().addLimit(this.config.getLimit("InvoicesApi-getInvoices")).build();
    public final Bucket getInvoicesAttributesBucket = Bucket.builder().addLimit(this.config.getLimit("InvoicesApi-getInvoicesAttributes")).build();
    public final Bucket getInvoicesDocumentBucket = Bucket.builder().addLimit(this.config.getLimit("InvoicesApi-getInvoicesDocument")).build();
    public final Bucket getInvoicesExportBucket = Bucket.builder().addLimit(this.config.getLimit("InvoicesApi-getInvoicesExport")).build();
    public final Bucket getInvoicesExportsBucket = Bucket.builder().addLimit(this.config.getLimit("InvoicesApi-getInvoicesExports")).build();

    public InvoicesApi(ApiClient apiClient, Boolean disableRateLimiting) {
        this.apiClient = apiClient;
        this.disableRateLimiting = disableRateLimiting;
    }

    private Call createInvoicesExportCall(ExportInvoicesRequest body, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        ExportInvoicesRequest localVarPostBody = body;
        String localVarPath = "/tax/invoices/2024-06-19/exports".equals("/uploads/2020-11-01/uploadDestinations/{resource}") ? "/tax/invoices/2024-06-19/exports" : "/tax/invoices/2024-06-19/exports";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, progressRequestListener);
    }

    private Call createInvoicesExportValidateBeforeCall(ExportInvoicesRequest body, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling createInvoicesExport(Async)");
        }
        return this.createInvoicesExportCall(body, progressRequestListener);
    }

    public ExportInvoicesResponse createInvoicesExport(ExportInvoicesRequest body, String restrictedDataToken) throws ApiException, LWAException {
        ApiResponse<ExportInvoicesResponse> resp = this.createInvoicesExportWithHttpInfo(body, restrictedDataToken);
        return resp.getData();
    }

    public ExportInvoicesResponse createInvoicesExport(ExportInvoicesRequest body) throws ApiException, LWAException {
        ApiResponse<ExportInvoicesResponse> resp = this.createInvoicesExportWithHttpInfo(body, null);
        return resp.getData();
    }

    public ApiResponse<ExportInvoicesResponse> createInvoicesExportWithHttpInfo(ExportInvoicesRequest body, String restrictedDataToken) throws ApiException, LWAException {
        Call call = this.createInvoicesExportValidateBeforeCall(body, null);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "InvoicesApi-createInvoicesExport");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.createInvoicesExportBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<ExportInvoicesResponse>(){}.getType();
            return this.apiClient.execute(call, localVarReturnType);
        }
        throw new ApiException.RateLimitExceeded("createInvoicesExport operation exceeds rate limit");
    }

    public ApiResponse<ExportInvoicesResponse> createInvoicesExportWithHttpInfo(ExportInvoicesRequest body) throws ApiException, LWAException {
        return this.createInvoicesExportWithHttpInfo(body, null);
    }

    public Call createInvoicesExportAsync(ExportInvoicesRequest body, ApiCallback<ExportInvoicesResponse> callback) throws ApiException, LWAException {
        return this.createInvoicesExportAsync(body, callback, null);
    }

    public Call createInvoicesExportAsync(ExportInvoicesRequest body, ApiCallback<ExportInvoicesResponse> callback, String restrictedDataToken) throws ApiException, LWAException {
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressRequestListener = callback::onUploadProgress;
        }
        Call call = this.createInvoicesExportValidateBeforeCall(body, progressRequestListener);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "InvoicesApi-createInvoicesExport");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.createInvoicesExportBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<ExportInvoicesResponse>(){}.getType();
            this.apiClient.executeAsync(call, localVarReturnType, callback);
            return call;
        }
        throw new ApiException.RateLimitExceeded("createInvoicesExport operation exceeds rate limit");
    }

    private Call getInvoiceCall(String marketplaceId, String invoiceId, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        Object localVarPostBody = null;
        String localVarPath = "/tax/invoices/2024-06-19/invoices/{invoiceId}".equals("/uploads/2020-11-01/uploadDestinations/{resource}") ? "/tax/invoices/2024-06-19/invoices/{invoiceId}".replaceAll("\\{invoiceId\\}", invoiceId.toString()) : "/tax/invoices/2024-06-19/invoices/{invoiceId}".replaceAll("\\{invoiceId\\}", this.apiClient.escapeString(invoiceId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (marketplaceId != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("marketplaceId", marketplaceId));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, progressRequestListener);
    }

    private Call getInvoiceValidateBeforeCall(String marketplaceId, String invoiceId, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        if (marketplaceId == null) {
            throw new ApiException("Missing the required parameter 'marketplaceId' when calling getInvoice(Async)");
        }
        if (invoiceId == null) {
            throw new ApiException("Missing the required parameter 'invoiceId' when calling getInvoice(Async)");
        }
        return this.getInvoiceCall(marketplaceId, invoiceId, progressRequestListener);
    }

    public GetInvoiceResponse getInvoice(String marketplaceId, String invoiceId, String restrictedDataToken) throws ApiException, LWAException {
        ApiResponse<GetInvoiceResponse> resp = this.getInvoiceWithHttpInfo(marketplaceId, invoiceId, restrictedDataToken);
        return resp.getData();
    }

    public GetInvoiceResponse getInvoice(String marketplaceId, String invoiceId) throws ApiException, LWAException {
        ApiResponse<GetInvoiceResponse> resp = this.getInvoiceWithHttpInfo(marketplaceId, invoiceId, null);
        return resp.getData();
    }

    public ApiResponse<GetInvoiceResponse> getInvoiceWithHttpInfo(String marketplaceId, String invoiceId, String restrictedDataToken) throws ApiException, LWAException {
        Call call = this.getInvoiceValidateBeforeCall(marketplaceId, invoiceId, null);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "InvoicesApi-getInvoice");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.getInvoiceBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<GetInvoiceResponse>(){}.getType();
            return this.apiClient.execute(call, localVarReturnType);
        }
        throw new ApiException.RateLimitExceeded("getInvoice operation exceeds rate limit");
    }

    public ApiResponse<GetInvoiceResponse> getInvoiceWithHttpInfo(String marketplaceId, String invoiceId) throws ApiException, LWAException {
        return this.getInvoiceWithHttpInfo(marketplaceId, invoiceId, null);
    }

    public Call getInvoiceAsync(String marketplaceId, String invoiceId, ApiCallback<GetInvoiceResponse> callback) throws ApiException, LWAException {
        return this.getInvoiceAsync(marketplaceId, invoiceId, callback, null);
    }

    public Call getInvoiceAsync(String marketplaceId, String invoiceId, ApiCallback<GetInvoiceResponse> callback, String restrictedDataToken) throws ApiException, LWAException {
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressRequestListener = callback::onUploadProgress;
        }
        Call call = this.getInvoiceValidateBeforeCall(marketplaceId, invoiceId, progressRequestListener);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "InvoicesApi-getInvoice");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.getInvoiceBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<GetInvoiceResponse>(){}.getType();
            this.apiClient.executeAsync(call, localVarReturnType, callback);
            return call;
        }
        throw new ApiException.RateLimitExceeded("getInvoice operation exceeds rate limit");
    }

    private Call getInvoicesCall(String marketplaceId, String transactionIdentifierName, Integer pageSize, OffsetDateTime dateEnd, String transactionType, String transactionIdentifierId, OffsetDateTime dateStart, String series, String nextToken, String sortOrder, String invoiceType, List<String> statuses, String externalInvoiceId, String sortBy, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        Object localVarPostBody = null;
        String localVarPath = "/tax/invoices/2024-06-19/invoices".equals("/uploads/2020-11-01/uploadDestinations/{resource}") ? "/tax/invoices/2024-06-19/invoices" : "/tax/invoices/2024-06-19/invoices";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (transactionIdentifierName != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("transactionIdentifierName", transactionIdentifierName));
        }
        if (pageSize != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("pageSize", pageSize));
        }
        if (dateEnd != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("dateEnd", dateEnd));
        }
        if (marketplaceId != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("marketplaceId", marketplaceId));
        }
        if (transactionType != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("transactionType", transactionType));
        }
        if (transactionIdentifierId != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("transactionIdentifierId", transactionIdentifierId));
        }
        if (dateStart != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("dateStart", dateStart));
        }
        if (series != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("series", series));
        }
        if (nextToken != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("nextToken", nextToken));
        }
        if (sortOrder != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("sortOrder", sortOrder));
        }
        if (invoiceType != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("invoiceType", invoiceType));
        }
        if (statuses != null) {
            localVarCollectionQueryParams.addAll(this.apiClient.parameterToPairs("csv", "statuses", statuses));
        }
        if (externalInvoiceId != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("externalInvoiceId", externalInvoiceId));
        }
        if (sortBy != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("sortBy", sortBy));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, progressRequestListener);
    }

    private Call getInvoicesValidateBeforeCall(String marketplaceId, String transactionIdentifierName, Integer pageSize, OffsetDateTime dateEnd, String transactionType, String transactionIdentifierId, OffsetDateTime dateStart, String series, String nextToken, String sortOrder, String invoiceType, List<String> statuses, String externalInvoiceId, String sortBy, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        if (marketplaceId == null) {
            throw new ApiException("Missing the required parameter 'marketplaceId' when calling getInvoices(Async)");
        }
        return this.getInvoicesCall(marketplaceId, transactionIdentifierName, pageSize, dateEnd, transactionType, transactionIdentifierId, dateStart, series, nextToken, sortOrder, invoiceType, statuses, externalInvoiceId, sortBy, progressRequestListener);
    }

    public GetInvoicesResponse getInvoices(String marketplaceId, String transactionIdentifierName, Integer pageSize, OffsetDateTime dateEnd, String transactionType, String transactionIdentifierId, OffsetDateTime dateStart, String series, String nextToken, String sortOrder, String invoiceType, List<String> statuses, String externalInvoiceId, String sortBy, String restrictedDataToken) throws ApiException, LWAException {
        ApiResponse<GetInvoicesResponse> resp = this.getInvoicesWithHttpInfo(marketplaceId, transactionIdentifierName, pageSize, dateEnd, transactionType, transactionIdentifierId, dateStart, series, nextToken, sortOrder, invoiceType, statuses, externalInvoiceId, sortBy, restrictedDataToken);
        return resp.getData();
    }

    public GetInvoicesResponse getInvoices(String marketplaceId, String transactionIdentifierName, Integer pageSize, OffsetDateTime dateEnd, String transactionType, String transactionIdentifierId, OffsetDateTime dateStart, String series, String nextToken, String sortOrder, String invoiceType, List<String> statuses, String externalInvoiceId, String sortBy) throws ApiException, LWAException {
        ApiResponse<GetInvoicesResponse> resp = this.getInvoicesWithHttpInfo(marketplaceId, transactionIdentifierName, pageSize, dateEnd, transactionType, transactionIdentifierId, dateStart, series, nextToken, sortOrder, invoiceType, statuses, externalInvoiceId, sortBy, null);
        return resp.getData();
    }

    public ApiResponse<GetInvoicesResponse> getInvoicesWithHttpInfo(String marketplaceId, String transactionIdentifierName, Integer pageSize, OffsetDateTime dateEnd, String transactionType, String transactionIdentifierId, OffsetDateTime dateStart, String series, String nextToken, String sortOrder, String invoiceType, List<String> statuses, String externalInvoiceId, String sortBy, String restrictedDataToken) throws ApiException, LWAException {
        Call call = this.getInvoicesValidateBeforeCall(marketplaceId, transactionIdentifierName, pageSize, dateEnd, transactionType, transactionIdentifierId, dateStart, series, nextToken, sortOrder, invoiceType, statuses, externalInvoiceId, sortBy, null);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "InvoicesApi-getInvoices");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.getInvoicesBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<GetInvoicesResponse>(){}.getType();
            return this.apiClient.execute(call, localVarReturnType);
        }
        throw new ApiException.RateLimitExceeded("getInvoices operation exceeds rate limit");
    }

    public ApiResponse<GetInvoicesResponse> getInvoicesWithHttpInfo(String marketplaceId, String transactionIdentifierName, Integer pageSize, OffsetDateTime dateEnd, String transactionType, String transactionIdentifierId, OffsetDateTime dateStart, String series, String nextToken, String sortOrder, String invoiceType, List<String> statuses, String externalInvoiceId, String sortBy) throws ApiException, LWAException {
        return this.getInvoicesWithHttpInfo(marketplaceId, transactionIdentifierName, pageSize, dateEnd, transactionType, transactionIdentifierId, dateStart, series, nextToken, sortOrder, invoiceType, statuses, externalInvoiceId, sortBy, null);
    }

    public Call getInvoicesAsync(String marketplaceId, String transactionIdentifierName, Integer pageSize, OffsetDateTime dateEnd, String transactionType, String transactionIdentifierId, OffsetDateTime dateStart, String series, String nextToken, String sortOrder, String invoiceType, List<String> statuses, String externalInvoiceId, String sortBy, ApiCallback<GetInvoicesResponse> callback) throws ApiException, LWAException {
        return this.getInvoicesAsync(marketplaceId, transactionIdentifierName, pageSize, dateEnd, transactionType, transactionIdentifierId, dateStart, series, nextToken, sortOrder, invoiceType, statuses, externalInvoiceId, sortBy, callback, null);
    }

    public Call getInvoicesAsync(String marketplaceId, String transactionIdentifierName, Integer pageSize, OffsetDateTime dateEnd, String transactionType, String transactionIdentifierId, OffsetDateTime dateStart, String series, String nextToken, String sortOrder, String invoiceType, List<String> statuses, String externalInvoiceId, String sortBy, ApiCallback<GetInvoicesResponse> callback, String restrictedDataToken) throws ApiException, LWAException {
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressRequestListener = callback::onUploadProgress;
        }
        Call call = this.getInvoicesValidateBeforeCall(marketplaceId, transactionIdentifierName, pageSize, dateEnd, transactionType, transactionIdentifierId, dateStart, series, nextToken, sortOrder, invoiceType, statuses, externalInvoiceId, sortBy, progressRequestListener);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "InvoicesApi-getInvoices");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.getInvoicesBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<GetInvoicesResponse>(){}.getType();
            this.apiClient.executeAsync(call, localVarReturnType, callback);
            return call;
        }
        throw new ApiException.RateLimitExceeded("getInvoices operation exceeds rate limit");
    }

    private Call getInvoicesAttributesCall(String marketplaceId, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        Object localVarPostBody = null;
        String localVarPath = "/tax/invoices/2024-06-19/attributes".equals("/uploads/2020-11-01/uploadDestinations/{resource}") ? "/tax/invoices/2024-06-19/attributes" : "/tax/invoices/2024-06-19/attributes";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (marketplaceId != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("marketplaceId", marketplaceId));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, progressRequestListener);
    }

    private Call getInvoicesAttributesValidateBeforeCall(String marketplaceId, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        if (marketplaceId == null) {
            throw new ApiException("Missing the required parameter 'marketplaceId' when calling getInvoicesAttributes(Async)");
        }
        return this.getInvoicesAttributesCall(marketplaceId, progressRequestListener);
    }

    public GetInvoicesAttributesResponse getInvoicesAttributes(String marketplaceId, String restrictedDataToken) throws ApiException, LWAException {
        ApiResponse<GetInvoicesAttributesResponse> resp = this.getInvoicesAttributesWithHttpInfo(marketplaceId, restrictedDataToken);
        return resp.getData();
    }

    public GetInvoicesAttributesResponse getInvoicesAttributes(String marketplaceId) throws ApiException, LWAException {
        ApiResponse<GetInvoicesAttributesResponse> resp = this.getInvoicesAttributesWithHttpInfo(marketplaceId, null);
        return resp.getData();
    }

    public ApiResponse<GetInvoicesAttributesResponse> getInvoicesAttributesWithHttpInfo(String marketplaceId, String restrictedDataToken) throws ApiException, LWAException {
        Call call = this.getInvoicesAttributesValidateBeforeCall(marketplaceId, null);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "InvoicesApi-getInvoicesAttributes");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.getInvoicesAttributesBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<GetInvoicesAttributesResponse>(){}.getType();
            return this.apiClient.execute(call, localVarReturnType);
        }
        throw new ApiException.RateLimitExceeded("getInvoicesAttributes operation exceeds rate limit");
    }

    public ApiResponse<GetInvoicesAttributesResponse> getInvoicesAttributesWithHttpInfo(String marketplaceId) throws ApiException, LWAException {
        return this.getInvoicesAttributesWithHttpInfo(marketplaceId, null);
    }

    public Call getInvoicesAttributesAsync(String marketplaceId, ApiCallback<GetInvoicesAttributesResponse> callback) throws ApiException, LWAException {
        return this.getInvoicesAttributesAsync(marketplaceId, callback, null);
    }

    public Call getInvoicesAttributesAsync(String marketplaceId, ApiCallback<GetInvoicesAttributesResponse> callback, String restrictedDataToken) throws ApiException, LWAException {
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressRequestListener = callback::onUploadProgress;
        }
        Call call = this.getInvoicesAttributesValidateBeforeCall(marketplaceId, progressRequestListener);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "InvoicesApi-getInvoicesAttributes");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.getInvoicesAttributesBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<GetInvoicesAttributesResponse>(){}.getType();
            this.apiClient.executeAsync(call, localVarReturnType, callback);
            return call;
        }
        throw new ApiException.RateLimitExceeded("getInvoicesAttributes operation exceeds rate limit");
    }

    private Call getInvoicesDocumentCall(String invoicesDocumentId, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        Object localVarPostBody = null;
        String localVarPath = "/tax/invoices/2024-06-19/documents/{invoicesDocumentId}".equals("/uploads/2020-11-01/uploadDestinations/{resource}") ? "/tax/invoices/2024-06-19/documents/{invoicesDocumentId}".replaceAll("\\{invoicesDocumentId\\}", invoicesDocumentId.toString()) : "/tax/invoices/2024-06-19/documents/{invoicesDocumentId}".replaceAll("\\{invoicesDocumentId\\}", this.apiClient.escapeString(invoicesDocumentId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, progressRequestListener);
    }

    private Call getInvoicesDocumentValidateBeforeCall(String invoicesDocumentId, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        if (invoicesDocumentId == null) {
            throw new ApiException("Missing the required parameter 'invoicesDocumentId' when calling getInvoicesDocument(Async)");
        }
        return this.getInvoicesDocumentCall(invoicesDocumentId, progressRequestListener);
    }

    public GetInvoicesDocumentResponse getInvoicesDocument(String invoicesDocumentId, String restrictedDataToken) throws ApiException, LWAException {
        ApiResponse<GetInvoicesDocumentResponse> resp = this.getInvoicesDocumentWithHttpInfo(invoicesDocumentId, restrictedDataToken);
        return resp.getData();
    }

    public GetInvoicesDocumentResponse getInvoicesDocument(String invoicesDocumentId) throws ApiException, LWAException {
        ApiResponse<GetInvoicesDocumentResponse> resp = this.getInvoicesDocumentWithHttpInfo(invoicesDocumentId, null);
        return resp.getData();
    }

    public ApiResponse<GetInvoicesDocumentResponse> getInvoicesDocumentWithHttpInfo(String invoicesDocumentId, String restrictedDataToken) throws ApiException, LWAException {
        Call call = this.getInvoicesDocumentValidateBeforeCall(invoicesDocumentId, null);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "InvoicesApi-getInvoicesDocument");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.getInvoicesDocumentBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<GetInvoicesDocumentResponse>(){}.getType();
            return this.apiClient.execute(call, localVarReturnType);
        }
        throw new ApiException.RateLimitExceeded("getInvoicesDocument operation exceeds rate limit");
    }

    public ApiResponse<GetInvoicesDocumentResponse> getInvoicesDocumentWithHttpInfo(String invoicesDocumentId) throws ApiException, LWAException {
        return this.getInvoicesDocumentWithHttpInfo(invoicesDocumentId, null);
    }

    public Call getInvoicesDocumentAsync(String invoicesDocumentId, ApiCallback<GetInvoicesDocumentResponse> callback) throws ApiException, LWAException {
        return this.getInvoicesDocumentAsync(invoicesDocumentId, callback, null);
    }

    public Call getInvoicesDocumentAsync(String invoicesDocumentId, ApiCallback<GetInvoicesDocumentResponse> callback, String restrictedDataToken) throws ApiException, LWAException {
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressRequestListener = callback::onUploadProgress;
        }
        Call call = this.getInvoicesDocumentValidateBeforeCall(invoicesDocumentId, progressRequestListener);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "InvoicesApi-getInvoicesDocument");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.getInvoicesDocumentBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<GetInvoicesDocumentResponse>(){}.getType();
            this.apiClient.executeAsync(call, localVarReturnType, callback);
            return call;
        }
        throw new ApiException.RateLimitExceeded("getInvoicesDocument operation exceeds rate limit");
    }

    private Call getInvoicesExportCall(String exportId, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        Object localVarPostBody = null;
        String localVarPath = "/tax/invoices/2024-06-19/exports/{exportId}".equals("/uploads/2020-11-01/uploadDestinations/{resource}") ? "/tax/invoices/2024-06-19/exports/{exportId}".replaceAll("\\{exportId\\}", exportId.toString()) : "/tax/invoices/2024-06-19/exports/{exportId}".replaceAll("\\{exportId\\}", this.apiClient.escapeString(exportId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, progressRequestListener);
    }

    private Call getInvoicesExportValidateBeforeCall(String exportId, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        if (exportId == null) {
            throw new ApiException("Missing the required parameter 'exportId' when calling getInvoicesExport(Async)");
        }
        return this.getInvoicesExportCall(exportId, progressRequestListener);
    }

    public GetInvoicesExportResponse getInvoicesExport(String exportId, String restrictedDataToken) throws ApiException, LWAException {
        ApiResponse<GetInvoicesExportResponse> resp = this.getInvoicesExportWithHttpInfo(exportId, restrictedDataToken);
        return resp.getData();
    }

    public GetInvoicesExportResponse getInvoicesExport(String exportId) throws ApiException, LWAException {
        ApiResponse<GetInvoicesExportResponse> resp = this.getInvoicesExportWithHttpInfo(exportId, null);
        return resp.getData();
    }

    public ApiResponse<GetInvoicesExportResponse> getInvoicesExportWithHttpInfo(String exportId, String restrictedDataToken) throws ApiException, LWAException {
        Call call = this.getInvoicesExportValidateBeforeCall(exportId, null);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "InvoicesApi-getInvoicesExport");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.getInvoicesExportBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<GetInvoicesExportResponse>(){}.getType();
            return this.apiClient.execute(call, localVarReturnType);
        }
        throw new ApiException.RateLimitExceeded("getInvoicesExport operation exceeds rate limit");
    }

    public ApiResponse<GetInvoicesExportResponse> getInvoicesExportWithHttpInfo(String exportId) throws ApiException, LWAException {
        return this.getInvoicesExportWithHttpInfo(exportId, null);
    }

    public Call getInvoicesExportAsync(String exportId, ApiCallback<GetInvoicesExportResponse> callback) throws ApiException, LWAException {
        return this.getInvoicesExportAsync(exportId, callback, null);
    }

    public Call getInvoicesExportAsync(String exportId, ApiCallback<GetInvoicesExportResponse> callback, String restrictedDataToken) throws ApiException, LWAException {
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressRequestListener = callback::onUploadProgress;
        }
        Call call = this.getInvoicesExportValidateBeforeCall(exportId, progressRequestListener);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "InvoicesApi-getInvoicesExport");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.getInvoicesExportBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<GetInvoicesExportResponse>(){}.getType();
            this.apiClient.executeAsync(call, localVarReturnType, callback);
            return call;
        }
        throw new ApiException.RateLimitExceeded("getInvoicesExport operation exceeds rate limit");
    }

    private Call getInvoicesExportsCall(String marketplaceId, OffsetDateTime dateStart, String nextToken, Integer pageSize, OffsetDateTime dateEnd, String status, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        Object localVarPostBody = null;
        String localVarPath = "/tax/invoices/2024-06-19/exports".equals("/uploads/2020-11-01/uploadDestinations/{resource}") ? "/tax/invoices/2024-06-19/exports" : "/tax/invoices/2024-06-19/exports";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (marketplaceId != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("marketplaceId", marketplaceId));
        }
        if (dateStart != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("dateStart", dateStart));
        }
        if (nextToken != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("nextToken", nextToken));
        }
        if (pageSize != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("pageSize", pageSize));
        }
        if (dateEnd != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("dateEnd", dateEnd));
        }
        if (status != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("status", status));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, progressRequestListener);
    }

    private Call getInvoicesExportsValidateBeforeCall(String marketplaceId, OffsetDateTime dateStart, String nextToken, Integer pageSize, OffsetDateTime dateEnd, String status, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        if (marketplaceId == null) {
            throw new ApiException("Missing the required parameter 'marketplaceId' when calling getInvoicesExports(Async)");
        }
        return this.getInvoicesExportsCall(marketplaceId, dateStart, nextToken, pageSize, dateEnd, status, progressRequestListener);
    }

    public GetInvoicesExportsResponse getInvoicesExports(String marketplaceId, OffsetDateTime dateStart, String nextToken, Integer pageSize, OffsetDateTime dateEnd, String status, String restrictedDataToken) throws ApiException, LWAException {
        ApiResponse<GetInvoicesExportsResponse> resp = this.getInvoicesExportsWithHttpInfo(marketplaceId, dateStart, nextToken, pageSize, dateEnd, status, restrictedDataToken);
        return resp.getData();
    }

    public GetInvoicesExportsResponse getInvoicesExports(String marketplaceId, OffsetDateTime dateStart, String nextToken, Integer pageSize, OffsetDateTime dateEnd, String status) throws ApiException, LWAException {
        ApiResponse<GetInvoicesExportsResponse> resp = this.getInvoicesExportsWithHttpInfo(marketplaceId, dateStart, nextToken, pageSize, dateEnd, status, null);
        return resp.getData();
    }

    public ApiResponse<GetInvoicesExportsResponse> getInvoicesExportsWithHttpInfo(String marketplaceId, OffsetDateTime dateStart, String nextToken, Integer pageSize, OffsetDateTime dateEnd, String status, String restrictedDataToken) throws ApiException, LWAException {
        Call call = this.getInvoicesExportsValidateBeforeCall(marketplaceId, dateStart, nextToken, pageSize, dateEnd, status, null);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "InvoicesApi-getInvoicesExports");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.getInvoicesExportsBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<GetInvoicesExportsResponse>(){}.getType();
            return this.apiClient.execute(call, localVarReturnType);
        }
        throw new ApiException.RateLimitExceeded("getInvoicesExports operation exceeds rate limit");
    }

    public ApiResponse<GetInvoicesExportsResponse> getInvoicesExportsWithHttpInfo(String marketplaceId, OffsetDateTime dateStart, String nextToken, Integer pageSize, OffsetDateTime dateEnd, String status) throws ApiException, LWAException {
        return this.getInvoicesExportsWithHttpInfo(marketplaceId, dateStart, nextToken, pageSize, dateEnd, status, null);
    }

    public Call getInvoicesExportsAsync(String marketplaceId, OffsetDateTime dateStart, String nextToken, Integer pageSize, OffsetDateTime dateEnd, String status, ApiCallback<GetInvoicesExportsResponse> callback) throws ApiException, LWAException {
        return this.getInvoicesExportsAsync(marketplaceId, dateStart, nextToken, pageSize, dateEnd, status, callback, null);
    }

    public Call getInvoicesExportsAsync(String marketplaceId, OffsetDateTime dateStart, String nextToken, Integer pageSize, OffsetDateTime dateEnd, String status, ApiCallback<GetInvoicesExportsResponse> callback, String restrictedDataToken) throws ApiException, LWAException {
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressRequestListener = callback::onUploadProgress;
        }
        Call call = this.getInvoicesExportsValidateBeforeCall(marketplaceId, dateStart, nextToken, pageSize, dateEnd, status, progressRequestListener);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "InvoicesApi-getInvoicesExports");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.getInvoicesExportsBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<GetInvoicesExportsResponse>(){}.getType();
            this.apiClient.executeAsync(call, localVarReturnType, callback);
            return call;
        }
        throw new ApiException.RateLimitExceeded("getInvoicesExports operation exceeds rate limit");
    }

    public static class Builder {
        private LWAAuthorizationCredentials lwaAuthorizationCredentials;
        private String endpoint;
        private LWAAccessTokenCache lwaAccessTokenCache;
        private Boolean disableAccessTokenCache = false;
        private Boolean disableRateLimiting = false;

        public Builder lwaAuthorizationCredentials(LWAAuthorizationCredentials lwaAuthorizationCredentials) {
            this.lwaAuthorizationCredentials = lwaAuthorizationCredentials;
            return this;
        }

        public Builder endpoint(String endpoint) {
            this.endpoint = endpoint;
            return this;
        }

        public Builder lwaAccessTokenCache(LWAAccessTokenCache lwaAccessTokenCache) {
            this.lwaAccessTokenCache = lwaAccessTokenCache;
            return this;
        }

        public Builder disableAccessTokenCache() {
            this.disableAccessTokenCache = true;
            return this;
        }

        public Builder disableRateLimiting() {
            this.disableRateLimiting = true;
            return this;
        }

        public InvoicesApi build() {
            if (this.lwaAuthorizationCredentials == null) {
                throw new RuntimeException("LWAAuthorizationCredentials not set");
            }
            if (StringUtil.isEmpty(this.endpoint)) {
                throw new RuntimeException("Endpoint not set");
            }
            LWAAuthorizationSigner lwaAuthorizationSigner = null;
            if (this.disableAccessTokenCache.booleanValue()) {
                lwaAuthorizationSigner = new LWAAuthorizationSigner(this.lwaAuthorizationCredentials);
            } else {
                if (this.lwaAccessTokenCache == null) {
                    this.lwaAccessTokenCache = new LWAAccessTokenCacheImpl();
                }
                lwaAuthorizationSigner = new LWAAuthorizationSigner(this.lwaAuthorizationCredentials, this.lwaAccessTokenCache);
            }
            return new InvoicesApi(new ApiClient().setLWAAuthorizationSigner(lwaAuthorizationSigner).setBasePath(this.endpoint), this.disableRateLimiting);
        }
    }
}

