/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.api.finances.v2024_06_19;

import com.amazon.SellingPartnerAPIAA.LWAAccessTokenCache;
import com.amazon.SellingPartnerAPIAA.LWAAccessTokenCacheImpl;
import com.amazon.SellingPartnerAPIAA.LWAAuthorizationCredentials;
import com.amazon.SellingPartnerAPIAA.LWAAuthorizationSigner;
import com.amazon.SellingPartnerAPIAA.LWAException;
import com.amazon.SellingPartnerAPIAA.RestrictedDataTokenSigner;
import com.google.gson.reflect.TypeToken;
import io.github.bucket4j.Bucket;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import okhttp3.Call;
import okhttp3.Request;
import org.threeten.bp.OffsetDateTime;
import software.amazon.spapi.ApiCallback;
import software.amazon.spapi.ApiClient;
import software.amazon.spapi.ApiException;
import software.amazon.spapi.ApiResponse;
import software.amazon.spapi.Configuration;
import software.amazon.spapi.Pair;
import software.amazon.spapi.ProgressRequestBody;
import software.amazon.spapi.StringUtil;
import software.amazon.spapi.models.finances.v2024_06_19.ListTransactionsResponse;

public class DefaultApi {
    private ApiClient apiClient;
    private Boolean disableRateLimiting;
    private final Configuration config = Configuration.get();
    public final Bucket listTransactionsBucket = Bucket.builder().addLimit(this.config.getLimit("DefaultApi-listTransactions")).build();

    public DefaultApi(ApiClient apiClient, Boolean disableRateLimiting) {
        this.apiClient = apiClient;
        this.disableRateLimiting = disableRateLimiting;
    }

    private Call listTransactionsCall(OffsetDateTime postedAfter, OffsetDateTime postedBefore, String marketplaceId, String transactionStatus, String nextToken, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        Object localVarPostBody = null;
        String localVarPath = "/finances/2024-06-19/transactions".equals("/uploads/2020-11-01/uploadDestinations/{resource}") ? "/finances/2024-06-19/transactions" : "/finances/2024-06-19/transactions";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (postedAfter != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("postedAfter", postedAfter));
        }
        if (postedBefore != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("postedBefore", postedBefore));
        }
        if (marketplaceId != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("marketplaceId", marketplaceId));
        }
        if (transactionStatus != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("transactionStatus", transactionStatus));
        }
        if (nextToken != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("nextToken", nextToken));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, progressRequestListener);
    }

    private Call listTransactionsValidateBeforeCall(OffsetDateTime postedAfter, OffsetDateTime postedBefore, String marketplaceId, String transactionStatus, String nextToken, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        if (postedAfter == null) {
            throw new ApiException("Missing the required parameter 'postedAfter' when calling listTransactions(Async)");
        }
        return this.listTransactionsCall(postedAfter, postedBefore, marketplaceId, transactionStatus, nextToken, progressRequestListener);
    }

    public ListTransactionsResponse listTransactions(OffsetDateTime postedAfter, OffsetDateTime postedBefore, String marketplaceId, String transactionStatus, String nextToken, String restrictedDataToken) throws ApiException, LWAException {
        ApiResponse<ListTransactionsResponse> resp = this.listTransactionsWithHttpInfo(postedAfter, postedBefore, marketplaceId, transactionStatus, nextToken, restrictedDataToken);
        return resp.getData();
    }

    public ListTransactionsResponse listTransactions(OffsetDateTime postedAfter, OffsetDateTime postedBefore, String marketplaceId, String transactionStatus, String nextToken) throws ApiException, LWAException {
        ApiResponse<ListTransactionsResponse> resp = this.listTransactionsWithHttpInfo(postedAfter, postedBefore, marketplaceId, transactionStatus, nextToken, null);
        return resp.getData();
    }

    public ApiResponse<ListTransactionsResponse> listTransactionsWithHttpInfo(OffsetDateTime postedAfter, OffsetDateTime postedBefore, String marketplaceId, String transactionStatus, String nextToken, String restrictedDataToken) throws ApiException, LWAException {
        Call call = this.listTransactionsValidateBeforeCall(postedAfter, postedBefore, marketplaceId, transactionStatus, nextToken, null);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "DefaultApi-listTransactions");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.listTransactionsBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<ListTransactionsResponse>(){}.getType();
            return this.apiClient.execute(call, localVarReturnType);
        }
        throw new ApiException.RateLimitExceeded("listTransactions operation exceeds rate limit");
    }

    public ApiResponse<ListTransactionsResponse> listTransactionsWithHttpInfo(OffsetDateTime postedAfter, OffsetDateTime postedBefore, String marketplaceId, String transactionStatus, String nextToken) throws ApiException, LWAException {
        return this.listTransactionsWithHttpInfo(postedAfter, postedBefore, marketplaceId, transactionStatus, nextToken, null);
    }

    public Call listTransactionsAsync(OffsetDateTime postedAfter, OffsetDateTime postedBefore, String marketplaceId, String transactionStatus, String nextToken, ApiCallback<ListTransactionsResponse> callback) throws ApiException, LWAException {
        return this.listTransactionsAsync(postedAfter, postedBefore, marketplaceId, transactionStatus, nextToken, callback, null);
    }

    public Call listTransactionsAsync(OffsetDateTime postedAfter, OffsetDateTime postedBefore, String marketplaceId, String transactionStatus, String nextToken, ApiCallback<ListTransactionsResponse> callback, String restrictedDataToken) throws ApiException, LWAException {
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressRequestListener = callback::onUploadProgress;
        }
        Call call = this.listTransactionsValidateBeforeCall(postedAfter, postedBefore, marketplaceId, transactionStatus, nextToken, progressRequestListener);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "DefaultApi-listTransactions");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.listTransactionsBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<ListTransactionsResponse>(){}.getType();
            this.apiClient.executeAsync(call, localVarReturnType, callback);
            return call;
        }
        throw new ApiException.RateLimitExceeded("listTransactions operation exceeds rate limit");
    }

    public static class Builder {
        private LWAAuthorizationCredentials lwaAuthorizationCredentials;
        private String endpoint;
        private LWAAccessTokenCache lwaAccessTokenCache;
        private Boolean disableAccessTokenCache = false;
        private Boolean disableRateLimiting = false;

        public Builder lwaAuthorizationCredentials(LWAAuthorizationCredentials lwaAuthorizationCredentials) {
            this.lwaAuthorizationCredentials = lwaAuthorizationCredentials;
            return this;
        }

        public Builder endpoint(String endpoint) {
            this.endpoint = endpoint;
            return this;
        }

        public Builder lwaAccessTokenCache(LWAAccessTokenCache lwaAccessTokenCache) {
            this.lwaAccessTokenCache = lwaAccessTokenCache;
            return this;
        }

        public Builder disableAccessTokenCache() {
            this.disableAccessTokenCache = true;
            return this;
        }

        public Builder disableRateLimiting() {
            this.disableRateLimiting = true;
            return this;
        }

        public DefaultApi build() {
            if (this.lwaAuthorizationCredentials == null) {
                throw new RuntimeException("LWAAuthorizationCredentials not set");
            }
            if (StringUtil.isEmpty(this.endpoint)) {
                throw new RuntimeException("Endpoint not set");
            }
            LWAAuthorizationSigner lwaAuthorizationSigner = null;
            if (this.disableAccessTokenCache.booleanValue()) {
                lwaAuthorizationSigner = new LWAAuthorizationSigner(this.lwaAuthorizationCredentials);
            } else {
                if (this.lwaAccessTokenCache == null) {
                    this.lwaAccessTokenCache = new LWAAccessTokenCacheImpl();
                }
                lwaAuthorizationSigner = new LWAAuthorizationSigner(this.lwaAuthorizationCredentials, this.lwaAccessTokenCache);
            }
            return new DefaultApi(new ApiClient().setLWAAuthorizationSigner(lwaAuthorizationSigner).setBasePath(this.endpoint), this.disableRateLimiting);
        }
    }
}

