/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.api.finances.v0;

import com.amazon.SellingPartnerAPIAA.LWAAccessTokenCache;
import com.amazon.SellingPartnerAPIAA.LWAAccessTokenCacheImpl;
import com.amazon.SellingPartnerAPIAA.LWAAuthorizationCredentials;
import com.amazon.SellingPartnerAPIAA.LWAAuthorizationSigner;
import com.amazon.SellingPartnerAPIAA.LWAException;
import com.amazon.SellingPartnerAPIAA.RestrictedDataTokenSigner;
import com.google.gson.reflect.TypeToken;
import io.github.bucket4j.Bucket;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import okhttp3.Call;
import okhttp3.Request;
import org.threeten.bp.OffsetDateTime;
import software.amazon.spapi.ApiCallback;
import software.amazon.spapi.ApiClient;
import software.amazon.spapi.ApiException;
import software.amazon.spapi.ApiResponse;
import software.amazon.spapi.Configuration;
import software.amazon.spapi.Pair;
import software.amazon.spapi.ProgressRequestBody;
import software.amazon.spapi.StringUtil;
import software.amazon.spapi.models.finances.v0.ListFinancialEventGroupsResponse;
import software.amazon.spapi.models.finances.v0.ListFinancialEventsResponse;

public class DefaultApi {
    private ApiClient apiClient;
    private Boolean disableRateLimiting;
    private final Configuration config = Configuration.get();
    public final Bucket listFinancialEventGroupsBucket = Bucket.builder().addLimit(this.config.getLimit("DefaultApi-listFinancialEventGroups")).build();
    public final Bucket listFinancialEventsBucket = Bucket.builder().addLimit(this.config.getLimit("DefaultApi-listFinancialEvents")).build();
    public final Bucket listFinancialEventsByGroupIdBucket = Bucket.builder().addLimit(this.config.getLimit("DefaultApi-listFinancialEventsByGroupId")).build();
    public final Bucket listFinancialEventsByOrderIdBucket = Bucket.builder().addLimit(this.config.getLimit("DefaultApi-listFinancialEventsByOrderId")).build();

    public DefaultApi(ApiClient apiClient, Boolean disableRateLimiting) {
        this.apiClient = apiClient;
        this.disableRateLimiting = disableRateLimiting;
    }

    private Call listFinancialEventGroupsCall(Integer maxResultsPerPage, OffsetDateTime financialEventGroupStartedBefore, OffsetDateTime financialEventGroupStartedAfter, String nextToken, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        Object localVarPostBody = null;
        String localVarPath = "/finances/v0/financialEventGroups".equals("/uploads/2020-11-01/uploadDestinations/{resource}") ? "/finances/v0/financialEventGroups" : "/finances/v0/financialEventGroups";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (maxResultsPerPage != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("MaxResultsPerPage", maxResultsPerPage));
        }
        if (financialEventGroupStartedBefore != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("FinancialEventGroupStartedBefore", financialEventGroupStartedBefore));
        }
        if (financialEventGroupStartedAfter != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("FinancialEventGroupStartedAfter", financialEventGroupStartedAfter));
        }
        if (nextToken != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("NextToken", nextToken));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, progressRequestListener);
    }

    private Call listFinancialEventGroupsValidateBeforeCall(Integer maxResultsPerPage, OffsetDateTime financialEventGroupStartedBefore, OffsetDateTime financialEventGroupStartedAfter, String nextToken, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        return this.listFinancialEventGroupsCall(maxResultsPerPage, financialEventGroupStartedBefore, financialEventGroupStartedAfter, nextToken, progressRequestListener);
    }

    public ListFinancialEventGroupsResponse listFinancialEventGroups(Integer maxResultsPerPage, OffsetDateTime financialEventGroupStartedBefore, OffsetDateTime financialEventGroupStartedAfter, String nextToken, String restrictedDataToken) throws ApiException, LWAException {
        ApiResponse<ListFinancialEventGroupsResponse> resp = this.listFinancialEventGroupsWithHttpInfo(maxResultsPerPage, financialEventGroupStartedBefore, financialEventGroupStartedAfter, nextToken, restrictedDataToken);
        return resp.getData();
    }

    public ListFinancialEventGroupsResponse listFinancialEventGroups(Integer maxResultsPerPage, OffsetDateTime financialEventGroupStartedBefore, OffsetDateTime financialEventGroupStartedAfter, String nextToken) throws ApiException, LWAException {
        ApiResponse<ListFinancialEventGroupsResponse> resp = this.listFinancialEventGroupsWithHttpInfo(maxResultsPerPage, financialEventGroupStartedBefore, financialEventGroupStartedAfter, nextToken, null);
        return resp.getData();
    }

    public ApiResponse<ListFinancialEventGroupsResponse> listFinancialEventGroupsWithHttpInfo(Integer maxResultsPerPage, OffsetDateTime financialEventGroupStartedBefore, OffsetDateTime financialEventGroupStartedAfter, String nextToken, String restrictedDataToken) throws ApiException, LWAException {
        Call call = this.listFinancialEventGroupsValidateBeforeCall(maxResultsPerPage, financialEventGroupStartedBefore, financialEventGroupStartedAfter, nextToken, null);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "DefaultApi-listFinancialEventGroups");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.listFinancialEventGroupsBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<ListFinancialEventGroupsResponse>(){}.getType();
            return this.apiClient.execute(call, localVarReturnType);
        }
        throw new ApiException.RateLimitExceeded("listFinancialEventGroups operation exceeds rate limit");
    }

    public ApiResponse<ListFinancialEventGroupsResponse> listFinancialEventGroupsWithHttpInfo(Integer maxResultsPerPage, OffsetDateTime financialEventGroupStartedBefore, OffsetDateTime financialEventGroupStartedAfter, String nextToken) throws ApiException, LWAException {
        return this.listFinancialEventGroupsWithHttpInfo(maxResultsPerPage, financialEventGroupStartedBefore, financialEventGroupStartedAfter, nextToken, null);
    }

    public Call listFinancialEventGroupsAsync(Integer maxResultsPerPage, OffsetDateTime financialEventGroupStartedBefore, OffsetDateTime financialEventGroupStartedAfter, String nextToken, ApiCallback<ListFinancialEventGroupsResponse> callback) throws ApiException, LWAException {
        return this.listFinancialEventGroupsAsync(maxResultsPerPage, financialEventGroupStartedBefore, financialEventGroupStartedAfter, nextToken, callback, null);
    }

    public Call listFinancialEventGroupsAsync(Integer maxResultsPerPage, OffsetDateTime financialEventGroupStartedBefore, OffsetDateTime financialEventGroupStartedAfter, String nextToken, ApiCallback<ListFinancialEventGroupsResponse> callback, String restrictedDataToken) throws ApiException, LWAException {
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressRequestListener = callback::onUploadProgress;
        }
        Call call = this.listFinancialEventGroupsValidateBeforeCall(maxResultsPerPage, financialEventGroupStartedBefore, financialEventGroupStartedAfter, nextToken, progressRequestListener);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "DefaultApi-listFinancialEventGroups");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.listFinancialEventGroupsBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<ListFinancialEventGroupsResponse>(){}.getType();
            this.apiClient.executeAsync(call, localVarReturnType, callback);
            return call;
        }
        throw new ApiException.RateLimitExceeded("listFinancialEventGroups operation exceeds rate limit");
    }

    private Call listFinancialEventsCall(Integer maxResultsPerPage, OffsetDateTime postedAfter, OffsetDateTime postedBefore, String nextToken, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        Object localVarPostBody = null;
        String localVarPath = "/finances/v0/financialEvents".equals("/uploads/2020-11-01/uploadDestinations/{resource}") ? "/finances/v0/financialEvents" : "/finances/v0/financialEvents";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (maxResultsPerPage != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("MaxResultsPerPage", maxResultsPerPage));
        }
        if (postedAfter != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("PostedAfter", postedAfter));
        }
        if (postedBefore != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("PostedBefore", postedBefore));
        }
        if (nextToken != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("NextToken", nextToken));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, progressRequestListener);
    }

    private Call listFinancialEventsValidateBeforeCall(Integer maxResultsPerPage, OffsetDateTime postedAfter, OffsetDateTime postedBefore, String nextToken, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        return this.listFinancialEventsCall(maxResultsPerPage, postedAfter, postedBefore, nextToken, progressRequestListener);
    }

    public ListFinancialEventsResponse listFinancialEvents(Integer maxResultsPerPage, OffsetDateTime postedAfter, OffsetDateTime postedBefore, String nextToken, String restrictedDataToken) throws ApiException, LWAException {
        ApiResponse<ListFinancialEventsResponse> resp = this.listFinancialEventsWithHttpInfo(maxResultsPerPage, postedAfter, postedBefore, nextToken, restrictedDataToken);
        return resp.getData();
    }

    public ListFinancialEventsResponse listFinancialEvents(Integer maxResultsPerPage, OffsetDateTime postedAfter, OffsetDateTime postedBefore, String nextToken) throws ApiException, LWAException {
        ApiResponse<ListFinancialEventsResponse> resp = this.listFinancialEventsWithHttpInfo(maxResultsPerPage, postedAfter, postedBefore, nextToken, null);
        return resp.getData();
    }

    public ApiResponse<ListFinancialEventsResponse> listFinancialEventsWithHttpInfo(Integer maxResultsPerPage, OffsetDateTime postedAfter, OffsetDateTime postedBefore, String nextToken, String restrictedDataToken) throws ApiException, LWAException {
        Call call = this.listFinancialEventsValidateBeforeCall(maxResultsPerPage, postedAfter, postedBefore, nextToken, null);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "DefaultApi-listFinancialEvents");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.listFinancialEventsBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<ListFinancialEventsResponse>(){}.getType();
            return this.apiClient.execute(call, localVarReturnType);
        }
        throw new ApiException.RateLimitExceeded("listFinancialEvents operation exceeds rate limit");
    }

    public ApiResponse<ListFinancialEventsResponse> listFinancialEventsWithHttpInfo(Integer maxResultsPerPage, OffsetDateTime postedAfter, OffsetDateTime postedBefore, String nextToken) throws ApiException, LWAException {
        return this.listFinancialEventsWithHttpInfo(maxResultsPerPage, postedAfter, postedBefore, nextToken, null);
    }

    public Call listFinancialEventsAsync(Integer maxResultsPerPage, OffsetDateTime postedAfter, OffsetDateTime postedBefore, String nextToken, ApiCallback<ListFinancialEventsResponse> callback) throws ApiException, LWAException {
        return this.listFinancialEventsAsync(maxResultsPerPage, postedAfter, postedBefore, nextToken, callback, null);
    }

    public Call listFinancialEventsAsync(Integer maxResultsPerPage, OffsetDateTime postedAfter, OffsetDateTime postedBefore, String nextToken, ApiCallback<ListFinancialEventsResponse> callback, String restrictedDataToken) throws ApiException, LWAException {
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressRequestListener = callback::onUploadProgress;
        }
        Call call = this.listFinancialEventsValidateBeforeCall(maxResultsPerPage, postedAfter, postedBefore, nextToken, progressRequestListener);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "DefaultApi-listFinancialEvents");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.listFinancialEventsBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<ListFinancialEventsResponse>(){}.getType();
            this.apiClient.executeAsync(call, localVarReturnType, callback);
            return call;
        }
        throw new ApiException.RateLimitExceeded("listFinancialEvents operation exceeds rate limit");
    }

    private Call listFinancialEventsByGroupIdCall(String eventGroupId, Integer maxResultsPerPage, OffsetDateTime postedAfter, OffsetDateTime postedBefore, String nextToken, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        Object localVarPostBody = null;
        String localVarPath = "/finances/v0/financialEventGroups/{eventGroupId}/financialEvents".equals("/uploads/2020-11-01/uploadDestinations/{resource}") ? "/finances/v0/financialEventGroups/{eventGroupId}/financialEvents".replaceAll("\\{eventGroupId\\}", eventGroupId.toString()) : "/finances/v0/financialEventGroups/{eventGroupId}/financialEvents".replaceAll("\\{eventGroupId\\}", this.apiClient.escapeString(eventGroupId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (maxResultsPerPage != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("MaxResultsPerPage", maxResultsPerPage));
        }
        if (postedAfter != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("PostedAfter", postedAfter));
        }
        if (postedBefore != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("PostedBefore", postedBefore));
        }
        if (nextToken != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("NextToken", nextToken));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, progressRequestListener);
    }

    private Call listFinancialEventsByGroupIdValidateBeforeCall(String eventGroupId, Integer maxResultsPerPage, OffsetDateTime postedAfter, OffsetDateTime postedBefore, String nextToken, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        if (eventGroupId == null) {
            throw new ApiException("Missing the required parameter 'eventGroupId' when calling listFinancialEventsByGroupId(Async)");
        }
        return this.listFinancialEventsByGroupIdCall(eventGroupId, maxResultsPerPage, postedAfter, postedBefore, nextToken, progressRequestListener);
    }

    public ListFinancialEventsResponse listFinancialEventsByGroupId(String eventGroupId, Integer maxResultsPerPage, OffsetDateTime postedAfter, OffsetDateTime postedBefore, String nextToken, String restrictedDataToken) throws ApiException, LWAException {
        ApiResponse<ListFinancialEventsResponse> resp = this.listFinancialEventsByGroupIdWithHttpInfo(eventGroupId, maxResultsPerPage, postedAfter, postedBefore, nextToken, restrictedDataToken);
        return resp.getData();
    }

    public ListFinancialEventsResponse listFinancialEventsByGroupId(String eventGroupId, Integer maxResultsPerPage, OffsetDateTime postedAfter, OffsetDateTime postedBefore, String nextToken) throws ApiException, LWAException {
        ApiResponse<ListFinancialEventsResponse> resp = this.listFinancialEventsByGroupIdWithHttpInfo(eventGroupId, maxResultsPerPage, postedAfter, postedBefore, nextToken, null);
        return resp.getData();
    }

    public ApiResponse<ListFinancialEventsResponse> listFinancialEventsByGroupIdWithHttpInfo(String eventGroupId, Integer maxResultsPerPage, OffsetDateTime postedAfter, OffsetDateTime postedBefore, String nextToken, String restrictedDataToken) throws ApiException, LWAException {
        Call call = this.listFinancialEventsByGroupIdValidateBeforeCall(eventGroupId, maxResultsPerPage, postedAfter, postedBefore, nextToken, null);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "DefaultApi-listFinancialEventsByGroupId");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.listFinancialEventsByGroupIdBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<ListFinancialEventsResponse>(){}.getType();
            return this.apiClient.execute(call, localVarReturnType);
        }
        throw new ApiException.RateLimitExceeded("listFinancialEventsByGroupId operation exceeds rate limit");
    }

    public ApiResponse<ListFinancialEventsResponse> listFinancialEventsByGroupIdWithHttpInfo(String eventGroupId, Integer maxResultsPerPage, OffsetDateTime postedAfter, OffsetDateTime postedBefore, String nextToken) throws ApiException, LWAException {
        return this.listFinancialEventsByGroupIdWithHttpInfo(eventGroupId, maxResultsPerPage, postedAfter, postedBefore, nextToken, null);
    }

    public Call listFinancialEventsByGroupIdAsync(String eventGroupId, Integer maxResultsPerPage, OffsetDateTime postedAfter, OffsetDateTime postedBefore, String nextToken, ApiCallback<ListFinancialEventsResponse> callback) throws ApiException, LWAException {
        return this.listFinancialEventsByGroupIdAsync(eventGroupId, maxResultsPerPage, postedAfter, postedBefore, nextToken, callback, null);
    }

    public Call listFinancialEventsByGroupIdAsync(String eventGroupId, Integer maxResultsPerPage, OffsetDateTime postedAfter, OffsetDateTime postedBefore, String nextToken, ApiCallback<ListFinancialEventsResponse> callback, String restrictedDataToken) throws ApiException, LWAException {
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressRequestListener = callback::onUploadProgress;
        }
        Call call = this.listFinancialEventsByGroupIdValidateBeforeCall(eventGroupId, maxResultsPerPage, postedAfter, postedBefore, nextToken, progressRequestListener);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "DefaultApi-listFinancialEventsByGroupId");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.listFinancialEventsByGroupIdBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<ListFinancialEventsResponse>(){}.getType();
            this.apiClient.executeAsync(call, localVarReturnType, callback);
            return call;
        }
        throw new ApiException.RateLimitExceeded("listFinancialEventsByGroupId operation exceeds rate limit");
    }

    private Call listFinancialEventsByOrderIdCall(String orderId, Integer maxResultsPerPage, String nextToken, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        Object localVarPostBody = null;
        String localVarPath = "/finances/v0/orders/{orderId}/financialEvents".equals("/uploads/2020-11-01/uploadDestinations/{resource}") ? "/finances/v0/orders/{orderId}/financialEvents".replaceAll("\\{orderId\\}", orderId.toString()) : "/finances/v0/orders/{orderId}/financialEvents".replaceAll("\\{orderId\\}", this.apiClient.escapeString(orderId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (maxResultsPerPage != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("MaxResultsPerPage", maxResultsPerPage));
        }
        if (nextToken != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("NextToken", nextToken));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, progressRequestListener);
    }

    private Call listFinancialEventsByOrderIdValidateBeforeCall(String orderId, Integer maxResultsPerPage, String nextToken, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        if (orderId == null) {
            throw new ApiException("Missing the required parameter 'orderId' when calling listFinancialEventsByOrderId(Async)");
        }
        return this.listFinancialEventsByOrderIdCall(orderId, maxResultsPerPage, nextToken, progressRequestListener);
    }

    public ListFinancialEventsResponse listFinancialEventsByOrderId(String orderId, Integer maxResultsPerPage, String nextToken, String restrictedDataToken) throws ApiException, LWAException {
        ApiResponse<ListFinancialEventsResponse> resp = this.listFinancialEventsByOrderIdWithHttpInfo(orderId, maxResultsPerPage, nextToken, restrictedDataToken);
        return resp.getData();
    }

    public ListFinancialEventsResponse listFinancialEventsByOrderId(String orderId, Integer maxResultsPerPage, String nextToken) throws ApiException, LWAException {
        ApiResponse<ListFinancialEventsResponse> resp = this.listFinancialEventsByOrderIdWithHttpInfo(orderId, maxResultsPerPage, nextToken, null);
        return resp.getData();
    }

    public ApiResponse<ListFinancialEventsResponse> listFinancialEventsByOrderIdWithHttpInfo(String orderId, Integer maxResultsPerPage, String nextToken, String restrictedDataToken) throws ApiException, LWAException {
        Call call = this.listFinancialEventsByOrderIdValidateBeforeCall(orderId, maxResultsPerPage, nextToken, null);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "DefaultApi-listFinancialEventsByOrderId");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.listFinancialEventsByOrderIdBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<ListFinancialEventsResponse>(){}.getType();
            return this.apiClient.execute(call, localVarReturnType);
        }
        throw new ApiException.RateLimitExceeded("listFinancialEventsByOrderId operation exceeds rate limit");
    }

    public ApiResponse<ListFinancialEventsResponse> listFinancialEventsByOrderIdWithHttpInfo(String orderId, Integer maxResultsPerPage, String nextToken) throws ApiException, LWAException {
        return this.listFinancialEventsByOrderIdWithHttpInfo(orderId, maxResultsPerPage, nextToken, null);
    }

    public Call listFinancialEventsByOrderIdAsync(String orderId, Integer maxResultsPerPage, String nextToken, ApiCallback<ListFinancialEventsResponse> callback) throws ApiException, LWAException {
        return this.listFinancialEventsByOrderIdAsync(orderId, maxResultsPerPage, nextToken, callback, null);
    }

    public Call listFinancialEventsByOrderIdAsync(String orderId, Integer maxResultsPerPage, String nextToken, ApiCallback<ListFinancialEventsResponse> callback, String restrictedDataToken) throws ApiException, LWAException {
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressRequestListener = callback::onUploadProgress;
        }
        Call call = this.listFinancialEventsByOrderIdValidateBeforeCall(orderId, maxResultsPerPage, nextToken, progressRequestListener);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "DefaultApi-listFinancialEventsByOrderId");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.listFinancialEventsByOrderIdBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<ListFinancialEventsResponse>(){}.getType();
            this.apiClient.executeAsync(call, localVarReturnType, callback);
            return call;
        }
        throw new ApiException.RateLimitExceeded("listFinancialEventsByOrderId operation exceeds rate limit");
    }

    public static class Builder {
        private LWAAuthorizationCredentials lwaAuthorizationCredentials;
        private String endpoint;
        private LWAAccessTokenCache lwaAccessTokenCache;
        private Boolean disableAccessTokenCache = false;
        private Boolean disableRateLimiting = false;

        public Builder lwaAuthorizationCredentials(LWAAuthorizationCredentials lwaAuthorizationCredentials) {
            this.lwaAuthorizationCredentials = lwaAuthorizationCredentials;
            return this;
        }

        public Builder endpoint(String endpoint) {
            this.endpoint = endpoint;
            return this;
        }

        public Builder lwaAccessTokenCache(LWAAccessTokenCache lwaAccessTokenCache) {
            this.lwaAccessTokenCache = lwaAccessTokenCache;
            return this;
        }

        public Builder disableAccessTokenCache() {
            this.disableAccessTokenCache = true;
            return this;
        }

        public Builder disableRateLimiting() {
            this.disableRateLimiting = true;
            return this;
        }

        public DefaultApi build() {
            if (this.lwaAuthorizationCredentials == null) {
                throw new RuntimeException("LWAAuthorizationCredentials not set");
            }
            if (StringUtil.isEmpty(this.endpoint)) {
                throw new RuntimeException("Endpoint not set");
            }
            LWAAuthorizationSigner lwaAuthorizationSigner = null;
            if (this.disableAccessTokenCache.booleanValue()) {
                lwaAuthorizationSigner = new LWAAuthorizationSigner(this.lwaAuthorizationCredentials);
            } else {
                if (this.lwaAccessTokenCache == null) {
                    this.lwaAccessTokenCache = new LWAAccessTokenCacheImpl();
                }
                lwaAuthorizationSigner = new LWAAuthorizationSigner(this.lwaAuthorizationCredentials, this.lwaAccessTokenCache);
            }
            return new DefaultApi(new ApiClient().setLWAAuthorizationSigner(lwaAuthorizationSigner).setBasePath(this.endpoint), this.disableRateLimiting);
        }
    }
}

