/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.api.fba.eligibility.v1;

import com.amazon.SellingPartnerAPIAA.LWAAccessTokenCache;
import com.amazon.SellingPartnerAPIAA.LWAAccessTokenCacheImpl;
import com.amazon.SellingPartnerAPIAA.LWAAuthorizationCredentials;
import com.amazon.SellingPartnerAPIAA.LWAAuthorizationSigner;
import com.amazon.SellingPartnerAPIAA.LWAException;
import com.amazon.SellingPartnerAPIAA.RestrictedDataTokenSigner;
import com.google.gson.reflect.TypeToken;
import io.github.bucket4j.Bucket;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import okhttp3.Call;
import okhttp3.Request;
import software.amazon.spapi.ApiCallback;
import software.amazon.spapi.ApiClient;
import software.amazon.spapi.ApiException;
import software.amazon.spapi.ApiResponse;
import software.amazon.spapi.Configuration;
import software.amazon.spapi.Pair;
import software.amazon.spapi.ProgressRequestBody;
import software.amazon.spapi.StringUtil;
import software.amazon.spapi.models.fba.eligibility.v1.GetItemEligibilityPreviewResponse;

public class FbaInboundApi {
    private ApiClient apiClient;
    private Boolean disableRateLimiting;
    private final Configuration config = Configuration.get();
    public final Bucket getItemEligibilityPreviewBucket = Bucket.builder().addLimit(this.config.getLimit("FbaInboundApi-getItemEligibilityPreview")).build();

    public FbaInboundApi(ApiClient apiClient, Boolean disableRateLimiting) {
        this.apiClient = apiClient;
        this.disableRateLimiting = disableRateLimiting;
    }

    private Call getItemEligibilityPreviewCall(String asin, String program, List<String> marketplaceIds, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        Object localVarPostBody = null;
        String localVarPath = "/fba/inbound/v1/eligibility/itemPreview".equals("/uploads/2020-11-01/uploadDestinations/{resource}") ? "/fba/inbound/v1/eligibility/itemPreview" : "/fba/inbound/v1/eligibility/itemPreview";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (marketplaceIds != null) {
            localVarCollectionQueryParams.addAll(this.apiClient.parameterToPairs("csv", "marketplaceIds", marketplaceIds));
        }
        if (asin != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("asin", asin));
        }
        if (program != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("program", program));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "ItemEligibilityPreview"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, progressRequestListener);
    }

    private Call getItemEligibilityPreviewValidateBeforeCall(String asin, String program, List<String> marketplaceIds, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        if (asin == null) {
            throw new ApiException("Missing the required parameter 'asin' when calling getItemEligibilityPreview(Async)");
        }
        if (program == null) {
            throw new ApiException("Missing the required parameter 'program' when calling getItemEligibilityPreview(Async)");
        }
        return this.getItemEligibilityPreviewCall(asin, program, marketplaceIds, progressRequestListener);
    }

    public GetItemEligibilityPreviewResponse getItemEligibilityPreview(String asin, String program, List<String> marketplaceIds, String restrictedDataToken) throws ApiException, LWAException {
        ApiResponse<GetItemEligibilityPreviewResponse> resp = this.getItemEligibilityPreviewWithHttpInfo(asin, program, marketplaceIds, restrictedDataToken);
        return resp.getData();
    }

    public GetItemEligibilityPreviewResponse getItemEligibilityPreview(String asin, String program, List<String> marketplaceIds) throws ApiException, LWAException {
        ApiResponse<GetItemEligibilityPreviewResponse> resp = this.getItemEligibilityPreviewWithHttpInfo(asin, program, marketplaceIds, null);
        return resp.getData();
    }

    public ApiResponse<GetItemEligibilityPreviewResponse> getItemEligibilityPreviewWithHttpInfo(String asin, String program, List<String> marketplaceIds, String restrictedDataToken) throws ApiException, LWAException {
        Call call = this.getItemEligibilityPreviewValidateBeforeCall(asin, program, marketplaceIds, null);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "FbaInboundApi-getItemEligibilityPreview");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.getItemEligibilityPreviewBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<GetItemEligibilityPreviewResponse>(){}.getType();
            return this.apiClient.execute(call, localVarReturnType);
        }
        throw new ApiException.RateLimitExceeded("getItemEligibilityPreview operation exceeds rate limit");
    }

    public ApiResponse<GetItemEligibilityPreviewResponse> getItemEligibilityPreviewWithHttpInfo(String asin, String program, List<String> marketplaceIds) throws ApiException, LWAException {
        return this.getItemEligibilityPreviewWithHttpInfo(asin, program, marketplaceIds, null);
    }

    public Call getItemEligibilityPreviewAsync(String asin, String program, List<String> marketplaceIds, ApiCallback<GetItemEligibilityPreviewResponse> callback) throws ApiException, LWAException {
        return this.getItemEligibilityPreviewAsync(asin, program, marketplaceIds, callback, null);
    }

    public Call getItemEligibilityPreviewAsync(String asin, String program, List<String> marketplaceIds, ApiCallback<GetItemEligibilityPreviewResponse> callback, String restrictedDataToken) throws ApiException, LWAException {
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressRequestListener = callback::onUploadProgress;
        }
        Call call = this.getItemEligibilityPreviewValidateBeforeCall(asin, program, marketplaceIds, progressRequestListener);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "FbaInboundApi-getItemEligibilityPreview");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.getItemEligibilityPreviewBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<GetItemEligibilityPreviewResponse>(){}.getType();
            this.apiClient.executeAsync(call, localVarReturnType, callback);
            return call;
        }
        throw new ApiException.RateLimitExceeded("getItemEligibilityPreview operation exceeds rate limit");
    }

    public static class Builder {
        private LWAAuthorizationCredentials lwaAuthorizationCredentials;
        private String endpoint;
        private LWAAccessTokenCache lwaAccessTokenCache;
        private Boolean disableAccessTokenCache = false;
        private Boolean disableRateLimiting = false;

        public Builder lwaAuthorizationCredentials(LWAAuthorizationCredentials lwaAuthorizationCredentials) {
            this.lwaAuthorizationCredentials = lwaAuthorizationCredentials;
            return this;
        }

        public Builder endpoint(String endpoint) {
            this.endpoint = endpoint;
            return this;
        }

        public Builder lwaAccessTokenCache(LWAAccessTokenCache lwaAccessTokenCache) {
            this.lwaAccessTokenCache = lwaAccessTokenCache;
            return this;
        }

        public Builder disableAccessTokenCache() {
            this.disableAccessTokenCache = true;
            return this;
        }

        public Builder disableRateLimiting() {
            this.disableRateLimiting = true;
            return this;
        }

        public FbaInboundApi build() {
            if (this.lwaAuthorizationCredentials == null) {
                throw new RuntimeException("LWAAuthorizationCredentials not set");
            }
            if (StringUtil.isEmpty(this.endpoint)) {
                throw new RuntimeException("Endpoint not set");
            }
            LWAAuthorizationSigner lwaAuthorizationSigner = null;
            if (this.disableAccessTokenCache.booleanValue()) {
                lwaAuthorizationSigner = new LWAAuthorizationSigner(this.lwaAuthorizationCredentials);
            } else {
                if (this.lwaAccessTokenCache == null) {
                    this.lwaAccessTokenCache = new LWAAccessTokenCacheImpl();
                }
                lwaAuthorizationSigner = new LWAAuthorizationSigner(this.lwaAuthorizationCredentials, this.lwaAccessTokenCache);
            }
            return new FbaInboundApi(new ApiClient().setLWAAuthorizationSigner(lwaAuthorizationSigner).setBasePath(this.endpoint), this.disableRateLimiting);
        }
    }
}

