/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.api.datakiosk.v2023_11_15;

import com.amazon.SellingPartnerAPIAA.LWAAccessTokenCache;
import com.amazon.SellingPartnerAPIAA.LWAAccessTokenCacheImpl;
import com.amazon.SellingPartnerAPIAA.LWAAuthorizationCredentials;
import com.amazon.SellingPartnerAPIAA.LWAAuthorizationSigner;
import com.amazon.SellingPartnerAPIAA.LWAException;
import com.amazon.SellingPartnerAPIAA.RestrictedDataTokenSigner;
import com.google.gson.reflect.TypeToken;
import io.github.bucket4j.Bucket;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import okhttp3.Call;
import okhttp3.Request;
import org.threeten.bp.OffsetDateTime;
import software.amazon.spapi.ApiCallback;
import software.amazon.spapi.ApiClient;
import software.amazon.spapi.ApiException;
import software.amazon.spapi.ApiResponse;
import software.amazon.spapi.Configuration;
import software.amazon.spapi.Pair;
import software.amazon.spapi.ProgressRequestBody;
import software.amazon.spapi.StringUtil;
import software.amazon.spapi.models.datakiosk.v2023_11_15.CreateQueryResponse;
import software.amazon.spapi.models.datakiosk.v2023_11_15.CreateQuerySpecification;
import software.amazon.spapi.models.datakiosk.v2023_11_15.GetDocumentResponse;
import software.amazon.spapi.models.datakiosk.v2023_11_15.GetQueriesResponse;
import software.amazon.spapi.models.datakiosk.v2023_11_15.Query;

public class QueriesApi {
    private ApiClient apiClient;
    private Boolean disableRateLimiting;
    private final Configuration config = Configuration.get();
    public final Bucket cancelQueryBucket = Bucket.builder().addLimit(this.config.getLimit("QueriesApi-cancelQuery")).build();
    public final Bucket createQueryBucket = Bucket.builder().addLimit(this.config.getLimit("QueriesApi-createQuery")).build();
    public final Bucket getDocumentBucket = Bucket.builder().addLimit(this.config.getLimit("QueriesApi-getDocument")).build();
    public final Bucket getQueriesBucket = Bucket.builder().addLimit(this.config.getLimit("QueriesApi-getQueries")).build();
    public final Bucket getQueryBucket = Bucket.builder().addLimit(this.config.getLimit("QueriesApi-getQuery")).build();

    public QueriesApi(ApiClient apiClient, Boolean disableRateLimiting) {
        this.apiClient = apiClient;
        this.disableRateLimiting = disableRateLimiting;
    }

    private Call cancelQueryCall(String queryId, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        Object localVarPostBody = null;
        String localVarPath = "/dataKiosk/2023-11-15/queries/{queryId}".equals("/uploads/2020-11-01/uploadDestinations/{resource}") ? "/dataKiosk/2023-11-15/queries/{queryId}".replaceAll("\\{queryId\\}", queryId.toString()) : "/dataKiosk/2023-11-15/queries/{queryId}".replaceAll("\\{queryId\\}", this.apiClient.escapeString(queryId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        return this.apiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, progressRequestListener);
    }

    private Call cancelQueryValidateBeforeCall(String queryId, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        if (queryId == null) {
            throw new ApiException("Missing the required parameter 'queryId' when calling cancelQuery(Async)");
        }
        return this.cancelQueryCall(queryId, progressRequestListener);
    }

    public void cancelQuery(String queryId, String restrictedDataToken) throws ApiException, LWAException {
        this.cancelQueryWithHttpInfo(queryId, restrictedDataToken);
    }

    public void cancelQuery(String queryId) throws ApiException, LWAException {
        this.cancelQueryWithHttpInfo(queryId, null);
    }

    public ApiResponse<Void> cancelQueryWithHttpInfo(String queryId, String restrictedDataToken) throws ApiException, LWAException {
        Call call = this.cancelQueryValidateBeforeCall(queryId, null);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "QueriesApi-cancelQuery");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.cancelQueryBucket.tryConsume(1L)) {
            return this.apiClient.execute(call);
        }
        throw new ApiException.RateLimitExceeded("cancelQuery operation exceeds rate limit");
    }

    public ApiResponse<Void> cancelQueryWithHttpInfo(String queryId) throws ApiException, LWAException {
        return this.cancelQueryWithHttpInfo(queryId, null);
    }

    public Call cancelQueryAsync(String queryId, ApiCallback<Void> callback) throws ApiException, LWAException {
        return this.cancelQueryAsync(queryId, callback, null);
    }

    public Call cancelQueryAsync(String queryId, ApiCallback<Void> callback, String restrictedDataToken) throws ApiException, LWAException {
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressRequestListener = callback::onUploadProgress;
        }
        Call call = this.cancelQueryValidateBeforeCall(queryId, progressRequestListener);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "QueriesApi-cancelQuery");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.cancelQueryBucket.tryConsume(1L)) {
            this.apiClient.executeAsync(call, callback);
            return call;
        }
        throw new ApiException.RateLimitExceeded("cancelQuery operation exceeds rate limit");
    }

    private Call createQueryCall(CreateQuerySpecification body, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        CreateQuerySpecification localVarPostBody = body;
        String localVarPath = "/dataKiosk/2023-11-15/queries".equals("/uploads/2020-11-01/uploadDestinations/{resource}") ? "/dataKiosk/2023-11-15/queries" : "/dataKiosk/2023-11-15/queries";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, progressRequestListener);
    }

    private Call createQueryValidateBeforeCall(CreateQuerySpecification body, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling createQuery(Async)");
        }
        return this.createQueryCall(body, progressRequestListener);
    }

    public CreateQueryResponse createQuery(CreateQuerySpecification body, String restrictedDataToken) throws ApiException, LWAException {
        ApiResponse<CreateQueryResponse> resp = this.createQueryWithHttpInfo(body, restrictedDataToken);
        return resp.getData();
    }

    public CreateQueryResponse createQuery(CreateQuerySpecification body) throws ApiException, LWAException {
        ApiResponse<CreateQueryResponse> resp = this.createQueryWithHttpInfo(body, null);
        return resp.getData();
    }

    public ApiResponse<CreateQueryResponse> createQueryWithHttpInfo(CreateQuerySpecification body, String restrictedDataToken) throws ApiException, LWAException {
        Call call = this.createQueryValidateBeforeCall(body, null);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "QueriesApi-createQuery");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.createQueryBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<CreateQueryResponse>(){}.getType();
            return this.apiClient.execute(call, localVarReturnType);
        }
        throw new ApiException.RateLimitExceeded("createQuery operation exceeds rate limit");
    }

    public ApiResponse<CreateQueryResponse> createQueryWithHttpInfo(CreateQuerySpecification body) throws ApiException, LWAException {
        return this.createQueryWithHttpInfo(body, null);
    }

    public Call createQueryAsync(CreateQuerySpecification body, ApiCallback<CreateQueryResponse> callback) throws ApiException, LWAException {
        return this.createQueryAsync(body, callback, null);
    }

    public Call createQueryAsync(CreateQuerySpecification body, ApiCallback<CreateQueryResponse> callback, String restrictedDataToken) throws ApiException, LWAException {
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressRequestListener = callback::onUploadProgress;
        }
        Call call = this.createQueryValidateBeforeCall(body, progressRequestListener);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "QueriesApi-createQuery");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.createQueryBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<CreateQueryResponse>(){}.getType();
            this.apiClient.executeAsync(call, localVarReturnType, callback);
            return call;
        }
        throw new ApiException.RateLimitExceeded("createQuery operation exceeds rate limit");
    }

    private Call getDocumentCall(String documentId, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        Object localVarPostBody = null;
        String localVarPath = "/dataKiosk/2023-11-15/documents/{documentId}".equals("/uploads/2020-11-01/uploadDestinations/{resource}") ? "/dataKiosk/2023-11-15/documents/{documentId}".replaceAll("\\{documentId\\}", documentId.toString()) : "/dataKiosk/2023-11-15/documents/{documentId}".replaceAll("\\{documentId\\}", this.apiClient.escapeString(documentId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, progressRequestListener);
    }

    private Call getDocumentValidateBeforeCall(String documentId, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        if (documentId == null) {
            throw new ApiException("Missing the required parameter 'documentId' when calling getDocument(Async)");
        }
        return this.getDocumentCall(documentId, progressRequestListener);
    }

    public GetDocumentResponse getDocument(String documentId, String restrictedDataToken) throws ApiException, LWAException {
        ApiResponse<GetDocumentResponse> resp = this.getDocumentWithHttpInfo(documentId, restrictedDataToken);
        return resp.getData();
    }

    public GetDocumentResponse getDocument(String documentId) throws ApiException, LWAException {
        ApiResponse<GetDocumentResponse> resp = this.getDocumentWithHttpInfo(documentId, null);
        return resp.getData();
    }

    public ApiResponse<GetDocumentResponse> getDocumentWithHttpInfo(String documentId, String restrictedDataToken) throws ApiException, LWAException {
        Call call = this.getDocumentValidateBeforeCall(documentId, null);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "QueriesApi-getDocument");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.getDocumentBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<GetDocumentResponse>(){}.getType();
            return this.apiClient.execute(call, localVarReturnType);
        }
        throw new ApiException.RateLimitExceeded("getDocument operation exceeds rate limit");
    }

    public ApiResponse<GetDocumentResponse> getDocumentWithHttpInfo(String documentId) throws ApiException, LWAException {
        return this.getDocumentWithHttpInfo(documentId, null);
    }

    public Call getDocumentAsync(String documentId, ApiCallback<GetDocumentResponse> callback) throws ApiException, LWAException {
        return this.getDocumentAsync(documentId, callback, null);
    }

    public Call getDocumentAsync(String documentId, ApiCallback<GetDocumentResponse> callback, String restrictedDataToken) throws ApiException, LWAException {
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressRequestListener = callback::onUploadProgress;
        }
        Call call = this.getDocumentValidateBeforeCall(documentId, progressRequestListener);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "QueriesApi-getDocument");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.getDocumentBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<GetDocumentResponse>(){}.getType();
            this.apiClient.executeAsync(call, localVarReturnType, callback);
            return call;
        }
        throw new ApiException.RateLimitExceeded("getDocument operation exceeds rate limit");
    }

    private Call getQueriesCall(List<String> processingStatuses, Integer pageSize, OffsetDateTime createdSince, OffsetDateTime createdUntil, String paginationToken, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        Object localVarPostBody = null;
        String localVarPath = "/dataKiosk/2023-11-15/queries".equals("/uploads/2020-11-01/uploadDestinations/{resource}") ? "/dataKiosk/2023-11-15/queries" : "/dataKiosk/2023-11-15/queries";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (processingStatuses != null) {
            localVarCollectionQueryParams.addAll(this.apiClient.parameterToPairs("csv", "processingStatuses", processingStatuses));
        }
        if (pageSize != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("pageSize", pageSize));
        }
        if (createdSince != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("createdSince", createdSince));
        }
        if (createdUntil != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("createdUntil", createdUntil));
        }
        if (paginationToken != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("paginationToken", paginationToken));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, progressRequestListener);
    }

    private Call getQueriesValidateBeforeCall(List<String> processingStatuses, Integer pageSize, OffsetDateTime createdSince, OffsetDateTime createdUntil, String paginationToken, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        return this.getQueriesCall(processingStatuses, pageSize, createdSince, createdUntil, paginationToken, progressRequestListener);
    }

    public GetQueriesResponse getQueries(List<String> processingStatuses, Integer pageSize, OffsetDateTime createdSince, OffsetDateTime createdUntil, String paginationToken, String restrictedDataToken) throws ApiException, LWAException {
        ApiResponse<GetQueriesResponse> resp = this.getQueriesWithHttpInfo(processingStatuses, pageSize, createdSince, createdUntil, paginationToken, restrictedDataToken);
        return resp.getData();
    }

    public GetQueriesResponse getQueries(List<String> processingStatuses, Integer pageSize, OffsetDateTime createdSince, OffsetDateTime createdUntil, String paginationToken) throws ApiException, LWAException {
        ApiResponse<GetQueriesResponse> resp = this.getQueriesWithHttpInfo(processingStatuses, pageSize, createdSince, createdUntil, paginationToken, null);
        return resp.getData();
    }

    public ApiResponse<GetQueriesResponse> getQueriesWithHttpInfo(List<String> processingStatuses, Integer pageSize, OffsetDateTime createdSince, OffsetDateTime createdUntil, String paginationToken, String restrictedDataToken) throws ApiException, LWAException {
        Call call = this.getQueriesValidateBeforeCall(processingStatuses, pageSize, createdSince, createdUntil, paginationToken, null);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "QueriesApi-getQueries");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.getQueriesBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<GetQueriesResponse>(){}.getType();
            return this.apiClient.execute(call, localVarReturnType);
        }
        throw new ApiException.RateLimitExceeded("getQueries operation exceeds rate limit");
    }

    public ApiResponse<GetQueriesResponse> getQueriesWithHttpInfo(List<String> processingStatuses, Integer pageSize, OffsetDateTime createdSince, OffsetDateTime createdUntil, String paginationToken) throws ApiException, LWAException {
        return this.getQueriesWithHttpInfo(processingStatuses, pageSize, createdSince, createdUntil, paginationToken, null);
    }

    public Call getQueriesAsync(List<String> processingStatuses, Integer pageSize, OffsetDateTime createdSince, OffsetDateTime createdUntil, String paginationToken, ApiCallback<GetQueriesResponse> callback) throws ApiException, LWAException {
        return this.getQueriesAsync(processingStatuses, pageSize, createdSince, createdUntil, paginationToken, callback, null);
    }

    public Call getQueriesAsync(List<String> processingStatuses, Integer pageSize, OffsetDateTime createdSince, OffsetDateTime createdUntil, String paginationToken, ApiCallback<GetQueriesResponse> callback, String restrictedDataToken) throws ApiException, LWAException {
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressRequestListener = callback::onUploadProgress;
        }
        Call call = this.getQueriesValidateBeforeCall(processingStatuses, pageSize, createdSince, createdUntil, paginationToken, progressRequestListener);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "QueriesApi-getQueries");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.getQueriesBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<GetQueriesResponse>(){}.getType();
            this.apiClient.executeAsync(call, localVarReturnType, callback);
            return call;
        }
        throw new ApiException.RateLimitExceeded("getQueries operation exceeds rate limit");
    }

    private Call getQueryCall(String queryId, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        Object localVarPostBody = null;
        String localVarPath = "/dataKiosk/2023-11-15/queries/{queryId}".equals("/uploads/2020-11-01/uploadDestinations/{resource}") ? "/dataKiosk/2023-11-15/queries/{queryId}".replaceAll("\\{queryId\\}", queryId.toString()) : "/dataKiosk/2023-11-15/queries/{queryId}".replaceAll("\\{queryId\\}", this.apiClient.escapeString(queryId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, progressRequestListener);
    }

    private Call getQueryValidateBeforeCall(String queryId, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        if (queryId == null) {
            throw new ApiException("Missing the required parameter 'queryId' when calling getQuery(Async)");
        }
        return this.getQueryCall(queryId, progressRequestListener);
    }

    public Query getQuery(String queryId, String restrictedDataToken) throws ApiException, LWAException {
        ApiResponse<Query> resp = this.getQueryWithHttpInfo(queryId, restrictedDataToken);
        return resp.getData();
    }

    public Query getQuery(String queryId) throws ApiException, LWAException {
        ApiResponse<Query> resp = this.getQueryWithHttpInfo(queryId, null);
        return resp.getData();
    }

    public ApiResponse<Query> getQueryWithHttpInfo(String queryId, String restrictedDataToken) throws ApiException, LWAException {
        Call call = this.getQueryValidateBeforeCall(queryId, null);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "QueriesApi-getQuery");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.getQueryBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<Query>(){}.getType();
            return this.apiClient.execute(call, localVarReturnType);
        }
        throw new ApiException.RateLimitExceeded("getQuery operation exceeds rate limit");
    }

    public ApiResponse<Query> getQueryWithHttpInfo(String queryId) throws ApiException, LWAException {
        return this.getQueryWithHttpInfo(queryId, null);
    }

    public Call getQueryAsync(String queryId, ApiCallback<Query> callback) throws ApiException, LWAException {
        return this.getQueryAsync(queryId, callback, null);
    }

    public Call getQueryAsync(String queryId, ApiCallback<Query> callback, String restrictedDataToken) throws ApiException, LWAException {
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressRequestListener = callback::onUploadProgress;
        }
        Call call = this.getQueryValidateBeforeCall(queryId, progressRequestListener);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "QueriesApi-getQuery");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.getQueryBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<Query>(){}.getType();
            this.apiClient.executeAsync(call, localVarReturnType, callback);
            return call;
        }
        throw new ApiException.RateLimitExceeded("getQuery operation exceeds rate limit");
    }

    public static class Builder {
        private LWAAuthorizationCredentials lwaAuthorizationCredentials;
        private String endpoint;
        private LWAAccessTokenCache lwaAccessTokenCache;
        private Boolean disableAccessTokenCache = false;
        private Boolean disableRateLimiting = false;

        public Builder lwaAuthorizationCredentials(LWAAuthorizationCredentials lwaAuthorizationCredentials) {
            this.lwaAuthorizationCredentials = lwaAuthorizationCredentials;
            return this;
        }

        public Builder endpoint(String endpoint) {
            this.endpoint = endpoint;
            return this;
        }

        public Builder lwaAccessTokenCache(LWAAccessTokenCache lwaAccessTokenCache) {
            this.lwaAccessTokenCache = lwaAccessTokenCache;
            return this;
        }

        public Builder disableAccessTokenCache() {
            this.disableAccessTokenCache = true;
            return this;
        }

        public Builder disableRateLimiting() {
            this.disableRateLimiting = true;
            return this;
        }

        public QueriesApi build() {
            if (this.lwaAuthorizationCredentials == null) {
                throw new RuntimeException("LWAAuthorizationCredentials not set");
            }
            if (StringUtil.isEmpty(this.endpoint)) {
                throw new RuntimeException("Endpoint not set");
            }
            LWAAuthorizationSigner lwaAuthorizationSigner = null;
            if (this.disableAccessTokenCache.booleanValue()) {
                lwaAuthorizationSigner = new LWAAuthorizationSigner(this.lwaAuthorizationCredentials);
            } else {
                if (this.lwaAccessTokenCache == null) {
                    this.lwaAccessTokenCache = new LWAAccessTokenCacheImpl();
                }
                lwaAuthorizationSigner = new LWAAuthorizationSigner(this.lwaAuthorizationCredentials, this.lwaAccessTokenCache);
            }
            return new QueriesApi(new ApiClient().setLWAAuthorizationSigner(lwaAuthorizationSigner).setBasePath(this.endpoint), this.disableRateLimiting);
        }
    }
}

