/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.api.customerfeedback.v2024_06_01;

import com.amazon.SellingPartnerAPIAA.LWAAccessTokenCache;
import com.amazon.SellingPartnerAPIAA.LWAAccessTokenCacheImpl;
import com.amazon.SellingPartnerAPIAA.LWAAuthorizationCredentials;
import com.amazon.SellingPartnerAPIAA.LWAAuthorizationSigner;
import com.amazon.SellingPartnerAPIAA.LWAException;
import com.amazon.SellingPartnerAPIAA.RestrictedDataTokenSigner;
import com.google.gson.reflect.TypeToken;
import io.github.bucket4j.Bucket;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import okhttp3.Call;
import okhttp3.Request;
import software.amazon.spapi.ApiCallback;
import software.amazon.spapi.ApiClient;
import software.amazon.spapi.ApiException;
import software.amazon.spapi.ApiResponse;
import software.amazon.spapi.Configuration;
import software.amazon.spapi.Pair;
import software.amazon.spapi.ProgressRequestBody;
import software.amazon.spapi.StringUtil;
import software.amazon.spapi.models.customerfeedback.v2024_06_01.BrowseNodeResponse;
import software.amazon.spapi.models.customerfeedback.v2024_06_01.BrowseNodeReturnTopicsResponse;
import software.amazon.spapi.models.customerfeedback.v2024_06_01.BrowseNodeReturnTrendsResponse;
import software.amazon.spapi.models.customerfeedback.v2024_06_01.BrowseNodeReviewTopicsResponse;
import software.amazon.spapi.models.customerfeedback.v2024_06_01.BrowseNodeReviewTrendsResponse;
import software.amazon.spapi.models.customerfeedback.v2024_06_01.ItemReviewTopicsResponse;
import software.amazon.spapi.models.customerfeedback.v2024_06_01.ItemReviewTrendsResponse;

public class CustomerFeedbackApi {
    private ApiClient apiClient;
    private Boolean disableRateLimiting;
    private final Configuration config = Configuration.get();
    public final Bucket getBrowseNodeReturnTopicsBucket = Bucket.builder().addLimit(this.config.getLimit("CustomerFeedbackApi-getBrowseNodeReturnTopics")).build();
    public final Bucket getBrowseNodeReturnTrendsBucket = Bucket.builder().addLimit(this.config.getLimit("CustomerFeedbackApi-getBrowseNodeReturnTrends")).build();
    public final Bucket getBrowseNodeReviewTopicsBucket = Bucket.builder().addLimit(this.config.getLimit("CustomerFeedbackApi-getBrowseNodeReviewTopics")).build();
    public final Bucket getBrowseNodeReviewTrendsBucket = Bucket.builder().addLimit(this.config.getLimit("CustomerFeedbackApi-getBrowseNodeReviewTrends")).build();
    public final Bucket getItemBrowseNodeBucket = Bucket.builder().addLimit(this.config.getLimit("CustomerFeedbackApi-getItemBrowseNode")).build();
    public final Bucket getItemReviewTopicsBucket = Bucket.builder().addLimit(this.config.getLimit("CustomerFeedbackApi-getItemReviewTopics")).build();
    public final Bucket getItemReviewTrendsBucket = Bucket.builder().addLimit(this.config.getLimit("CustomerFeedbackApi-getItemReviewTrends")).build();

    public CustomerFeedbackApi(ApiClient apiClient, Boolean disableRateLimiting) {
        this.apiClient = apiClient;
        this.disableRateLimiting = disableRateLimiting;
    }

    private Call getBrowseNodeReturnTopicsCall(String browseNodeId, String marketplaceId, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        Object localVarPostBody = null;
        String localVarPath = "/customerFeedback/2024-06-01/browseNodes/{browseNodeId}/returns/topics".equals("/uploads/2020-11-01/uploadDestinations/{resource}") ? "/customerFeedback/2024-06-01/browseNodes/{browseNodeId}/returns/topics".replaceAll("\\{browseNodeId\\}", browseNodeId.toString()) : "/customerFeedback/2024-06-01/browseNodes/{browseNodeId}/returns/topics".replaceAll("\\{browseNodeId\\}", this.apiClient.escapeString(browseNodeId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (marketplaceId != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("marketplaceId", marketplaceId));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, progressRequestListener);
    }

    private Call getBrowseNodeReturnTopicsValidateBeforeCall(String browseNodeId, String marketplaceId, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        if (browseNodeId == null) {
            throw new ApiException("Missing the required parameter 'browseNodeId' when calling getBrowseNodeReturnTopics(Async)");
        }
        if (marketplaceId == null) {
            throw new ApiException("Missing the required parameter 'marketplaceId' when calling getBrowseNodeReturnTopics(Async)");
        }
        return this.getBrowseNodeReturnTopicsCall(browseNodeId, marketplaceId, progressRequestListener);
    }

    public BrowseNodeReturnTopicsResponse getBrowseNodeReturnTopics(String browseNodeId, String marketplaceId, String restrictedDataToken) throws ApiException, LWAException {
        ApiResponse<BrowseNodeReturnTopicsResponse> resp = this.getBrowseNodeReturnTopicsWithHttpInfo(browseNodeId, marketplaceId, restrictedDataToken);
        return resp.getData();
    }

    public BrowseNodeReturnTopicsResponse getBrowseNodeReturnTopics(String browseNodeId, String marketplaceId) throws ApiException, LWAException {
        ApiResponse<BrowseNodeReturnTopicsResponse> resp = this.getBrowseNodeReturnTopicsWithHttpInfo(browseNodeId, marketplaceId, null);
        return resp.getData();
    }

    public ApiResponse<BrowseNodeReturnTopicsResponse> getBrowseNodeReturnTopicsWithHttpInfo(String browseNodeId, String marketplaceId, String restrictedDataToken) throws ApiException, LWAException {
        Call call = this.getBrowseNodeReturnTopicsValidateBeforeCall(browseNodeId, marketplaceId, null);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "CustomerFeedbackApi-getBrowseNodeReturnTopics");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.getBrowseNodeReturnTopicsBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<BrowseNodeReturnTopicsResponse>(){}.getType();
            return this.apiClient.execute(call, localVarReturnType);
        }
        throw new ApiException.RateLimitExceeded("getBrowseNodeReturnTopics operation exceeds rate limit");
    }

    public ApiResponse<BrowseNodeReturnTopicsResponse> getBrowseNodeReturnTopicsWithHttpInfo(String browseNodeId, String marketplaceId) throws ApiException, LWAException {
        return this.getBrowseNodeReturnTopicsWithHttpInfo(browseNodeId, marketplaceId, null);
    }

    public Call getBrowseNodeReturnTopicsAsync(String browseNodeId, String marketplaceId, ApiCallback<BrowseNodeReturnTopicsResponse> callback) throws ApiException, LWAException {
        return this.getBrowseNodeReturnTopicsAsync(browseNodeId, marketplaceId, callback, null);
    }

    public Call getBrowseNodeReturnTopicsAsync(String browseNodeId, String marketplaceId, ApiCallback<BrowseNodeReturnTopicsResponse> callback, String restrictedDataToken) throws ApiException, LWAException {
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressRequestListener = callback::onUploadProgress;
        }
        Call call = this.getBrowseNodeReturnTopicsValidateBeforeCall(browseNodeId, marketplaceId, progressRequestListener);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "CustomerFeedbackApi-getBrowseNodeReturnTopics");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.getBrowseNodeReturnTopicsBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<BrowseNodeReturnTopicsResponse>(){}.getType();
            this.apiClient.executeAsync(call, localVarReturnType, callback);
            return call;
        }
        throw new ApiException.RateLimitExceeded("getBrowseNodeReturnTopics operation exceeds rate limit");
    }

    private Call getBrowseNodeReturnTrendsCall(String browseNodeId, String marketplaceId, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        Object localVarPostBody = null;
        String localVarPath = "/customerFeedback/2024-06-01/browseNodes/{browseNodeId}/returns/trends".equals("/uploads/2020-11-01/uploadDestinations/{resource}") ? "/customerFeedback/2024-06-01/browseNodes/{browseNodeId}/returns/trends".replaceAll("\\{browseNodeId\\}", browseNodeId.toString()) : "/customerFeedback/2024-06-01/browseNodes/{browseNodeId}/returns/trends".replaceAll("\\{browseNodeId\\}", this.apiClient.escapeString(browseNodeId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (marketplaceId != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("marketplaceId", marketplaceId));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, progressRequestListener);
    }

    private Call getBrowseNodeReturnTrendsValidateBeforeCall(String browseNodeId, String marketplaceId, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        if (browseNodeId == null) {
            throw new ApiException("Missing the required parameter 'browseNodeId' when calling getBrowseNodeReturnTrends(Async)");
        }
        if (marketplaceId == null) {
            throw new ApiException("Missing the required parameter 'marketplaceId' when calling getBrowseNodeReturnTrends(Async)");
        }
        return this.getBrowseNodeReturnTrendsCall(browseNodeId, marketplaceId, progressRequestListener);
    }

    public BrowseNodeReturnTrendsResponse getBrowseNodeReturnTrends(String browseNodeId, String marketplaceId, String restrictedDataToken) throws ApiException, LWAException {
        ApiResponse<BrowseNodeReturnTrendsResponse> resp = this.getBrowseNodeReturnTrendsWithHttpInfo(browseNodeId, marketplaceId, restrictedDataToken);
        return resp.getData();
    }

    public BrowseNodeReturnTrendsResponse getBrowseNodeReturnTrends(String browseNodeId, String marketplaceId) throws ApiException, LWAException {
        ApiResponse<BrowseNodeReturnTrendsResponse> resp = this.getBrowseNodeReturnTrendsWithHttpInfo(browseNodeId, marketplaceId, null);
        return resp.getData();
    }

    public ApiResponse<BrowseNodeReturnTrendsResponse> getBrowseNodeReturnTrendsWithHttpInfo(String browseNodeId, String marketplaceId, String restrictedDataToken) throws ApiException, LWAException {
        Call call = this.getBrowseNodeReturnTrendsValidateBeforeCall(browseNodeId, marketplaceId, null);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "CustomerFeedbackApi-getBrowseNodeReturnTrends");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.getBrowseNodeReturnTrendsBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<BrowseNodeReturnTrendsResponse>(){}.getType();
            return this.apiClient.execute(call, localVarReturnType);
        }
        throw new ApiException.RateLimitExceeded("getBrowseNodeReturnTrends operation exceeds rate limit");
    }

    public ApiResponse<BrowseNodeReturnTrendsResponse> getBrowseNodeReturnTrendsWithHttpInfo(String browseNodeId, String marketplaceId) throws ApiException, LWAException {
        return this.getBrowseNodeReturnTrendsWithHttpInfo(browseNodeId, marketplaceId, null);
    }

    public Call getBrowseNodeReturnTrendsAsync(String browseNodeId, String marketplaceId, ApiCallback<BrowseNodeReturnTrendsResponse> callback) throws ApiException, LWAException {
        return this.getBrowseNodeReturnTrendsAsync(browseNodeId, marketplaceId, callback, null);
    }

    public Call getBrowseNodeReturnTrendsAsync(String browseNodeId, String marketplaceId, ApiCallback<BrowseNodeReturnTrendsResponse> callback, String restrictedDataToken) throws ApiException, LWAException {
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressRequestListener = callback::onUploadProgress;
        }
        Call call = this.getBrowseNodeReturnTrendsValidateBeforeCall(browseNodeId, marketplaceId, progressRequestListener);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "CustomerFeedbackApi-getBrowseNodeReturnTrends");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.getBrowseNodeReturnTrendsBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<BrowseNodeReturnTrendsResponse>(){}.getType();
            this.apiClient.executeAsync(call, localVarReturnType, callback);
            return call;
        }
        throw new ApiException.RateLimitExceeded("getBrowseNodeReturnTrends operation exceeds rate limit");
    }

    private Call getBrowseNodeReviewTopicsCall(String browseNodeId, String marketplaceId, String sortBy, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        Object localVarPostBody = null;
        String localVarPath = "/customerFeedback/2024-06-01/browseNodes/{browseNodeId}/reviews/topics".equals("/uploads/2020-11-01/uploadDestinations/{resource}") ? "/customerFeedback/2024-06-01/browseNodes/{browseNodeId}/reviews/topics".replaceAll("\\{browseNodeId\\}", browseNodeId.toString()) : "/customerFeedback/2024-06-01/browseNodes/{browseNodeId}/reviews/topics".replaceAll("\\{browseNodeId\\}", this.apiClient.escapeString(browseNodeId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (marketplaceId != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("marketplaceId", marketplaceId));
        }
        if (sortBy != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("sortBy", sortBy));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, progressRequestListener);
    }

    private Call getBrowseNodeReviewTopicsValidateBeforeCall(String browseNodeId, String marketplaceId, String sortBy, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        if (browseNodeId == null) {
            throw new ApiException("Missing the required parameter 'browseNodeId' when calling getBrowseNodeReviewTopics(Async)");
        }
        if (marketplaceId == null) {
            throw new ApiException("Missing the required parameter 'marketplaceId' when calling getBrowseNodeReviewTopics(Async)");
        }
        if (sortBy == null) {
            throw new ApiException("Missing the required parameter 'sortBy' when calling getBrowseNodeReviewTopics(Async)");
        }
        return this.getBrowseNodeReviewTopicsCall(browseNodeId, marketplaceId, sortBy, progressRequestListener);
    }

    public BrowseNodeReviewTopicsResponse getBrowseNodeReviewTopics(String browseNodeId, String marketplaceId, String sortBy, String restrictedDataToken) throws ApiException, LWAException {
        ApiResponse<BrowseNodeReviewTopicsResponse> resp = this.getBrowseNodeReviewTopicsWithHttpInfo(browseNodeId, marketplaceId, sortBy, restrictedDataToken);
        return resp.getData();
    }

    public BrowseNodeReviewTopicsResponse getBrowseNodeReviewTopics(String browseNodeId, String marketplaceId, String sortBy) throws ApiException, LWAException {
        ApiResponse<BrowseNodeReviewTopicsResponse> resp = this.getBrowseNodeReviewTopicsWithHttpInfo(browseNodeId, marketplaceId, sortBy, null);
        return resp.getData();
    }

    public ApiResponse<BrowseNodeReviewTopicsResponse> getBrowseNodeReviewTopicsWithHttpInfo(String browseNodeId, String marketplaceId, String sortBy, String restrictedDataToken) throws ApiException, LWAException {
        Call call = this.getBrowseNodeReviewTopicsValidateBeforeCall(browseNodeId, marketplaceId, sortBy, null);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "CustomerFeedbackApi-getBrowseNodeReviewTopics");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.getBrowseNodeReviewTopicsBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<BrowseNodeReviewTopicsResponse>(){}.getType();
            return this.apiClient.execute(call, localVarReturnType);
        }
        throw new ApiException.RateLimitExceeded("getBrowseNodeReviewTopics operation exceeds rate limit");
    }

    public ApiResponse<BrowseNodeReviewTopicsResponse> getBrowseNodeReviewTopicsWithHttpInfo(String browseNodeId, String marketplaceId, String sortBy) throws ApiException, LWAException {
        return this.getBrowseNodeReviewTopicsWithHttpInfo(browseNodeId, marketplaceId, sortBy, null);
    }

    public Call getBrowseNodeReviewTopicsAsync(String browseNodeId, String marketplaceId, String sortBy, ApiCallback<BrowseNodeReviewTopicsResponse> callback) throws ApiException, LWAException {
        return this.getBrowseNodeReviewTopicsAsync(browseNodeId, marketplaceId, sortBy, callback, null);
    }

    public Call getBrowseNodeReviewTopicsAsync(String browseNodeId, String marketplaceId, String sortBy, ApiCallback<BrowseNodeReviewTopicsResponse> callback, String restrictedDataToken) throws ApiException, LWAException {
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressRequestListener = callback::onUploadProgress;
        }
        Call call = this.getBrowseNodeReviewTopicsValidateBeforeCall(browseNodeId, marketplaceId, sortBy, progressRequestListener);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "CustomerFeedbackApi-getBrowseNodeReviewTopics");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.getBrowseNodeReviewTopicsBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<BrowseNodeReviewTopicsResponse>(){}.getType();
            this.apiClient.executeAsync(call, localVarReturnType, callback);
            return call;
        }
        throw new ApiException.RateLimitExceeded("getBrowseNodeReviewTopics operation exceeds rate limit");
    }

    private Call getBrowseNodeReviewTrendsCall(String browseNodeId, String marketplaceId, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        Object localVarPostBody = null;
        String localVarPath = "/customerFeedback/2024-06-01/browseNodes/{browseNodeId}/reviews/trends".equals("/uploads/2020-11-01/uploadDestinations/{resource}") ? "/customerFeedback/2024-06-01/browseNodes/{browseNodeId}/reviews/trends".replaceAll("\\{browseNodeId\\}", browseNodeId.toString()) : "/customerFeedback/2024-06-01/browseNodes/{browseNodeId}/reviews/trends".replaceAll("\\{browseNodeId\\}", this.apiClient.escapeString(browseNodeId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (marketplaceId != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("marketplaceId", marketplaceId));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, progressRequestListener);
    }

    private Call getBrowseNodeReviewTrendsValidateBeforeCall(String browseNodeId, String marketplaceId, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        if (browseNodeId == null) {
            throw new ApiException("Missing the required parameter 'browseNodeId' when calling getBrowseNodeReviewTrends(Async)");
        }
        if (marketplaceId == null) {
            throw new ApiException("Missing the required parameter 'marketplaceId' when calling getBrowseNodeReviewTrends(Async)");
        }
        return this.getBrowseNodeReviewTrendsCall(browseNodeId, marketplaceId, progressRequestListener);
    }

    public BrowseNodeReviewTrendsResponse getBrowseNodeReviewTrends(String browseNodeId, String marketplaceId, String restrictedDataToken) throws ApiException, LWAException {
        ApiResponse<BrowseNodeReviewTrendsResponse> resp = this.getBrowseNodeReviewTrendsWithHttpInfo(browseNodeId, marketplaceId, restrictedDataToken);
        return resp.getData();
    }

    public BrowseNodeReviewTrendsResponse getBrowseNodeReviewTrends(String browseNodeId, String marketplaceId) throws ApiException, LWAException {
        ApiResponse<BrowseNodeReviewTrendsResponse> resp = this.getBrowseNodeReviewTrendsWithHttpInfo(browseNodeId, marketplaceId, null);
        return resp.getData();
    }

    public ApiResponse<BrowseNodeReviewTrendsResponse> getBrowseNodeReviewTrendsWithHttpInfo(String browseNodeId, String marketplaceId, String restrictedDataToken) throws ApiException, LWAException {
        Call call = this.getBrowseNodeReviewTrendsValidateBeforeCall(browseNodeId, marketplaceId, null);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "CustomerFeedbackApi-getBrowseNodeReviewTrends");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.getBrowseNodeReviewTrendsBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<BrowseNodeReviewTrendsResponse>(){}.getType();
            return this.apiClient.execute(call, localVarReturnType);
        }
        throw new ApiException.RateLimitExceeded("getBrowseNodeReviewTrends operation exceeds rate limit");
    }

    public ApiResponse<BrowseNodeReviewTrendsResponse> getBrowseNodeReviewTrendsWithHttpInfo(String browseNodeId, String marketplaceId) throws ApiException, LWAException {
        return this.getBrowseNodeReviewTrendsWithHttpInfo(browseNodeId, marketplaceId, null);
    }

    public Call getBrowseNodeReviewTrendsAsync(String browseNodeId, String marketplaceId, ApiCallback<BrowseNodeReviewTrendsResponse> callback) throws ApiException, LWAException {
        return this.getBrowseNodeReviewTrendsAsync(browseNodeId, marketplaceId, callback, null);
    }

    public Call getBrowseNodeReviewTrendsAsync(String browseNodeId, String marketplaceId, ApiCallback<BrowseNodeReviewTrendsResponse> callback, String restrictedDataToken) throws ApiException, LWAException {
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressRequestListener = callback::onUploadProgress;
        }
        Call call = this.getBrowseNodeReviewTrendsValidateBeforeCall(browseNodeId, marketplaceId, progressRequestListener);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "CustomerFeedbackApi-getBrowseNodeReviewTrends");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.getBrowseNodeReviewTrendsBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<BrowseNodeReviewTrendsResponse>(){}.getType();
            this.apiClient.executeAsync(call, localVarReturnType, callback);
            return call;
        }
        throw new ApiException.RateLimitExceeded("getBrowseNodeReviewTrends operation exceeds rate limit");
    }

    private Call getItemBrowseNodeCall(String asin, String marketplaceId, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        Object localVarPostBody = null;
        String localVarPath = "/customerFeedback/2024-06-01/items/{asin}/browseNode".equals("/uploads/2020-11-01/uploadDestinations/{resource}") ? "/customerFeedback/2024-06-01/items/{asin}/browseNode".replaceAll("\\{asin\\}", asin.toString()) : "/customerFeedback/2024-06-01/items/{asin}/browseNode".replaceAll("\\{asin\\}", this.apiClient.escapeString(asin.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (marketplaceId != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("marketplaceId", marketplaceId));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, progressRequestListener);
    }

    private Call getItemBrowseNodeValidateBeforeCall(String asin, String marketplaceId, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        if (asin == null) {
            throw new ApiException("Missing the required parameter 'asin' when calling getItemBrowseNode(Async)");
        }
        if (marketplaceId == null) {
            throw new ApiException("Missing the required parameter 'marketplaceId' when calling getItemBrowseNode(Async)");
        }
        return this.getItemBrowseNodeCall(asin, marketplaceId, progressRequestListener);
    }

    public BrowseNodeResponse getItemBrowseNode(String asin, String marketplaceId, String restrictedDataToken) throws ApiException, LWAException {
        ApiResponse<BrowseNodeResponse> resp = this.getItemBrowseNodeWithHttpInfo(asin, marketplaceId, restrictedDataToken);
        return resp.getData();
    }

    public BrowseNodeResponse getItemBrowseNode(String asin, String marketplaceId) throws ApiException, LWAException {
        ApiResponse<BrowseNodeResponse> resp = this.getItemBrowseNodeWithHttpInfo(asin, marketplaceId, null);
        return resp.getData();
    }

    public ApiResponse<BrowseNodeResponse> getItemBrowseNodeWithHttpInfo(String asin, String marketplaceId, String restrictedDataToken) throws ApiException, LWAException {
        Call call = this.getItemBrowseNodeValidateBeforeCall(asin, marketplaceId, null);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "CustomerFeedbackApi-getItemBrowseNode");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.getItemBrowseNodeBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<BrowseNodeResponse>(){}.getType();
            return this.apiClient.execute(call, localVarReturnType);
        }
        throw new ApiException.RateLimitExceeded("getItemBrowseNode operation exceeds rate limit");
    }

    public ApiResponse<BrowseNodeResponse> getItemBrowseNodeWithHttpInfo(String asin, String marketplaceId) throws ApiException, LWAException {
        return this.getItemBrowseNodeWithHttpInfo(asin, marketplaceId, null);
    }

    public Call getItemBrowseNodeAsync(String asin, String marketplaceId, ApiCallback<BrowseNodeResponse> callback) throws ApiException, LWAException {
        return this.getItemBrowseNodeAsync(asin, marketplaceId, callback, null);
    }

    public Call getItemBrowseNodeAsync(String asin, String marketplaceId, ApiCallback<BrowseNodeResponse> callback, String restrictedDataToken) throws ApiException, LWAException {
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressRequestListener = callback::onUploadProgress;
        }
        Call call = this.getItemBrowseNodeValidateBeforeCall(asin, marketplaceId, progressRequestListener);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "CustomerFeedbackApi-getItemBrowseNode");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.getItemBrowseNodeBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<BrowseNodeResponse>(){}.getType();
            this.apiClient.executeAsync(call, localVarReturnType, callback);
            return call;
        }
        throw new ApiException.RateLimitExceeded("getItemBrowseNode operation exceeds rate limit");
    }

    private Call getItemReviewTopicsCall(String asin, String marketplaceId, String sortBy, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        Object localVarPostBody = null;
        String localVarPath = "/customerFeedback/2024-06-01/items/{asin}/reviews/topics".equals("/uploads/2020-11-01/uploadDestinations/{resource}") ? "/customerFeedback/2024-06-01/items/{asin}/reviews/topics".replaceAll("\\{asin\\}", asin.toString()) : "/customerFeedback/2024-06-01/items/{asin}/reviews/topics".replaceAll("\\{asin\\}", this.apiClient.escapeString(asin.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (marketplaceId != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("marketplaceId", marketplaceId));
        }
        if (sortBy != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("sortBy", sortBy));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, progressRequestListener);
    }

    private Call getItemReviewTopicsValidateBeforeCall(String asin, String marketplaceId, String sortBy, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        if (asin == null) {
            throw new ApiException("Missing the required parameter 'asin' when calling getItemReviewTopics(Async)");
        }
        if (marketplaceId == null) {
            throw new ApiException("Missing the required parameter 'marketplaceId' when calling getItemReviewTopics(Async)");
        }
        if (sortBy == null) {
            throw new ApiException("Missing the required parameter 'sortBy' when calling getItemReviewTopics(Async)");
        }
        return this.getItemReviewTopicsCall(asin, marketplaceId, sortBy, progressRequestListener);
    }

    public ItemReviewTopicsResponse getItemReviewTopics(String asin, String marketplaceId, String sortBy, String restrictedDataToken) throws ApiException, LWAException {
        ApiResponse<ItemReviewTopicsResponse> resp = this.getItemReviewTopicsWithHttpInfo(asin, marketplaceId, sortBy, restrictedDataToken);
        return resp.getData();
    }

    public ItemReviewTopicsResponse getItemReviewTopics(String asin, String marketplaceId, String sortBy) throws ApiException, LWAException {
        ApiResponse<ItemReviewTopicsResponse> resp = this.getItemReviewTopicsWithHttpInfo(asin, marketplaceId, sortBy, null);
        return resp.getData();
    }

    public ApiResponse<ItemReviewTopicsResponse> getItemReviewTopicsWithHttpInfo(String asin, String marketplaceId, String sortBy, String restrictedDataToken) throws ApiException, LWAException {
        Call call = this.getItemReviewTopicsValidateBeforeCall(asin, marketplaceId, sortBy, null);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "CustomerFeedbackApi-getItemReviewTopics");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.getItemReviewTopicsBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<ItemReviewTopicsResponse>(){}.getType();
            return this.apiClient.execute(call, localVarReturnType);
        }
        throw new ApiException.RateLimitExceeded("getItemReviewTopics operation exceeds rate limit");
    }

    public ApiResponse<ItemReviewTopicsResponse> getItemReviewTopicsWithHttpInfo(String asin, String marketplaceId, String sortBy) throws ApiException, LWAException {
        return this.getItemReviewTopicsWithHttpInfo(asin, marketplaceId, sortBy, null);
    }

    public Call getItemReviewTopicsAsync(String asin, String marketplaceId, String sortBy, ApiCallback<ItemReviewTopicsResponse> callback) throws ApiException, LWAException {
        return this.getItemReviewTopicsAsync(asin, marketplaceId, sortBy, callback, null);
    }

    public Call getItemReviewTopicsAsync(String asin, String marketplaceId, String sortBy, ApiCallback<ItemReviewTopicsResponse> callback, String restrictedDataToken) throws ApiException, LWAException {
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressRequestListener = callback::onUploadProgress;
        }
        Call call = this.getItemReviewTopicsValidateBeforeCall(asin, marketplaceId, sortBy, progressRequestListener);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "CustomerFeedbackApi-getItemReviewTopics");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.getItemReviewTopicsBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<ItemReviewTopicsResponse>(){}.getType();
            this.apiClient.executeAsync(call, localVarReturnType, callback);
            return call;
        }
        throw new ApiException.RateLimitExceeded("getItemReviewTopics operation exceeds rate limit");
    }

    private Call getItemReviewTrendsCall(String asin, String marketplaceId, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        Object localVarPostBody = null;
        String localVarPath = "/customerFeedback/2024-06-01/items/{asin}/reviews/trends".equals("/uploads/2020-11-01/uploadDestinations/{resource}") ? "/customerFeedback/2024-06-01/items/{asin}/reviews/trends".replaceAll("\\{asin\\}", asin.toString()) : "/customerFeedback/2024-06-01/items/{asin}/reviews/trends".replaceAll("\\{asin\\}", this.apiClient.escapeString(asin.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (marketplaceId != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("marketplaceId", marketplaceId));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, progressRequestListener);
    }

    private Call getItemReviewTrendsValidateBeforeCall(String asin, String marketplaceId, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        if (asin == null) {
            throw new ApiException("Missing the required parameter 'asin' when calling getItemReviewTrends(Async)");
        }
        if (marketplaceId == null) {
            throw new ApiException("Missing the required parameter 'marketplaceId' when calling getItemReviewTrends(Async)");
        }
        return this.getItemReviewTrendsCall(asin, marketplaceId, progressRequestListener);
    }

    public ItemReviewTrendsResponse getItemReviewTrends(String asin, String marketplaceId, String restrictedDataToken) throws ApiException, LWAException {
        ApiResponse<ItemReviewTrendsResponse> resp = this.getItemReviewTrendsWithHttpInfo(asin, marketplaceId, restrictedDataToken);
        return resp.getData();
    }

    public ItemReviewTrendsResponse getItemReviewTrends(String asin, String marketplaceId) throws ApiException, LWAException {
        ApiResponse<ItemReviewTrendsResponse> resp = this.getItemReviewTrendsWithHttpInfo(asin, marketplaceId, null);
        return resp.getData();
    }

    public ApiResponse<ItemReviewTrendsResponse> getItemReviewTrendsWithHttpInfo(String asin, String marketplaceId, String restrictedDataToken) throws ApiException, LWAException {
        Call call = this.getItemReviewTrendsValidateBeforeCall(asin, marketplaceId, null);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "CustomerFeedbackApi-getItemReviewTrends");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.getItemReviewTrendsBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<ItemReviewTrendsResponse>(){}.getType();
            return this.apiClient.execute(call, localVarReturnType);
        }
        throw new ApiException.RateLimitExceeded("getItemReviewTrends operation exceeds rate limit");
    }

    public ApiResponse<ItemReviewTrendsResponse> getItemReviewTrendsWithHttpInfo(String asin, String marketplaceId) throws ApiException, LWAException {
        return this.getItemReviewTrendsWithHttpInfo(asin, marketplaceId, null);
    }

    public Call getItemReviewTrendsAsync(String asin, String marketplaceId, ApiCallback<ItemReviewTrendsResponse> callback) throws ApiException, LWAException {
        return this.getItemReviewTrendsAsync(asin, marketplaceId, callback, null);
    }

    public Call getItemReviewTrendsAsync(String asin, String marketplaceId, ApiCallback<ItemReviewTrendsResponse> callback, String restrictedDataToken) throws ApiException, LWAException {
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressRequestListener = callback::onUploadProgress;
        }
        Call call = this.getItemReviewTrendsValidateBeforeCall(asin, marketplaceId, progressRequestListener);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "CustomerFeedbackApi-getItemReviewTrends");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.getItemReviewTrendsBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<ItemReviewTrendsResponse>(){}.getType();
            this.apiClient.executeAsync(call, localVarReturnType, callback);
            return call;
        }
        throw new ApiException.RateLimitExceeded("getItemReviewTrends operation exceeds rate limit");
    }

    public static class Builder {
        private LWAAuthorizationCredentials lwaAuthorizationCredentials;
        private String endpoint;
        private LWAAccessTokenCache lwaAccessTokenCache;
        private Boolean disableAccessTokenCache = false;
        private Boolean disableRateLimiting = false;

        public Builder lwaAuthorizationCredentials(LWAAuthorizationCredentials lwaAuthorizationCredentials) {
            this.lwaAuthorizationCredentials = lwaAuthorizationCredentials;
            return this;
        }

        public Builder endpoint(String endpoint) {
            this.endpoint = endpoint;
            return this;
        }

        public Builder lwaAccessTokenCache(LWAAccessTokenCache lwaAccessTokenCache) {
            this.lwaAccessTokenCache = lwaAccessTokenCache;
            return this;
        }

        public Builder disableAccessTokenCache() {
            this.disableAccessTokenCache = true;
            return this;
        }

        public Builder disableRateLimiting() {
            this.disableRateLimiting = true;
            return this;
        }

        public CustomerFeedbackApi build() {
            if (this.lwaAuthorizationCredentials == null) {
                throw new RuntimeException("LWAAuthorizationCredentials not set");
            }
            if (StringUtil.isEmpty(this.endpoint)) {
                throw new RuntimeException("Endpoint not set");
            }
            LWAAuthorizationSigner lwaAuthorizationSigner = null;
            if (this.disableAccessTokenCache.booleanValue()) {
                lwaAuthorizationSigner = new LWAAuthorizationSigner(this.lwaAuthorizationCredentials);
            } else {
                if (this.lwaAccessTokenCache == null) {
                    this.lwaAccessTokenCache = new LWAAccessTokenCacheImpl();
                }
                lwaAuthorizationSigner = new LWAAuthorizationSigner(this.lwaAuthorizationCredentials, this.lwaAccessTokenCache);
            }
            return new CustomerFeedbackApi(new ApiClient().setLWAAuthorizationSigner(lwaAuthorizationSigner).setBasePath(this.endpoint), this.disableRateLimiting);
        }
    }
}

