/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.api.apluscontent.v2020_11_01;

import com.amazon.SellingPartnerAPIAA.LWAAccessTokenCache;
import com.amazon.SellingPartnerAPIAA.LWAAccessTokenCacheImpl;
import com.amazon.SellingPartnerAPIAA.LWAAuthorizationCredentials;
import com.amazon.SellingPartnerAPIAA.LWAAuthorizationSigner;
import com.amazon.SellingPartnerAPIAA.LWAException;
import com.amazon.SellingPartnerAPIAA.RestrictedDataTokenSigner;
import com.google.gson.reflect.TypeToken;
import io.github.bucket4j.Bucket;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import okhttp3.Call;
import okhttp3.Request;
import software.amazon.spapi.ApiCallback;
import software.amazon.spapi.ApiClient;
import software.amazon.spapi.ApiException;
import software.amazon.spapi.ApiResponse;
import software.amazon.spapi.Configuration;
import software.amazon.spapi.Pair;
import software.amazon.spapi.ProgressRequestBody;
import software.amazon.spapi.StringUtil;
import software.amazon.spapi.models.apluscontent.v2020_11_01.GetContentDocumentResponse;
import software.amazon.spapi.models.apluscontent.v2020_11_01.ListContentDocumentAsinRelationsResponse;
import software.amazon.spapi.models.apluscontent.v2020_11_01.PostContentDocumentApprovalSubmissionResponse;
import software.amazon.spapi.models.apluscontent.v2020_11_01.PostContentDocumentAsinRelationsRequest;
import software.amazon.spapi.models.apluscontent.v2020_11_01.PostContentDocumentAsinRelationsResponse;
import software.amazon.spapi.models.apluscontent.v2020_11_01.PostContentDocumentRequest;
import software.amazon.spapi.models.apluscontent.v2020_11_01.PostContentDocumentResponse;
import software.amazon.spapi.models.apluscontent.v2020_11_01.PostContentDocumentSuspendSubmissionResponse;
import software.amazon.spapi.models.apluscontent.v2020_11_01.SearchContentDocumentsResponse;
import software.amazon.spapi.models.apluscontent.v2020_11_01.SearchContentPublishRecordsResponse;
import software.amazon.spapi.models.apluscontent.v2020_11_01.ValidateContentDocumentAsinRelationsResponse;

public class AplusContentApi {
    private ApiClient apiClient;
    private Boolean disableRateLimiting;
    private final Configuration config = Configuration.get();
    public final Bucket createContentDocumentBucket = Bucket.builder().addLimit(this.config.getLimit("AplusContentApi-createContentDocument")).build();
    public final Bucket getContentDocumentBucket = Bucket.builder().addLimit(this.config.getLimit("AplusContentApi-getContentDocument")).build();
    public final Bucket listContentDocumentAsinRelationsBucket = Bucket.builder().addLimit(this.config.getLimit("AplusContentApi-listContentDocumentAsinRelations")).build();
    public final Bucket postContentDocumentApprovalSubmissionBucket = Bucket.builder().addLimit(this.config.getLimit("AplusContentApi-postContentDocumentApprovalSubmission")).build();
    public final Bucket postContentDocumentAsinRelationsBucket = Bucket.builder().addLimit(this.config.getLimit("AplusContentApi-postContentDocumentAsinRelations")).build();
    public final Bucket postContentDocumentSuspendSubmissionBucket = Bucket.builder().addLimit(this.config.getLimit("AplusContentApi-postContentDocumentSuspendSubmission")).build();
    public final Bucket searchContentDocumentsBucket = Bucket.builder().addLimit(this.config.getLimit("AplusContentApi-searchContentDocuments")).build();
    public final Bucket searchContentPublishRecordsBucket = Bucket.builder().addLimit(this.config.getLimit("AplusContentApi-searchContentPublishRecords")).build();
    public final Bucket updateContentDocumentBucket = Bucket.builder().addLimit(this.config.getLimit("AplusContentApi-updateContentDocument")).build();
    public final Bucket validateContentDocumentAsinRelationsBucket = Bucket.builder().addLimit(this.config.getLimit("AplusContentApi-validateContentDocumentAsinRelations")).build();

    public AplusContentApi(ApiClient apiClient, Boolean disableRateLimiting) {
        this.apiClient = apiClient;
        this.disableRateLimiting = disableRateLimiting;
    }

    private Call createContentDocumentCall(PostContentDocumentRequest body, String marketplaceId, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        PostContentDocumentRequest localVarPostBody = body;
        String localVarPath = "/aplus/2020-11-01/contentDocuments".equals("/uploads/2020-11-01/uploadDestinations/{resource}") ? "/aplus/2020-11-01/contentDocuments" : "/aplus/2020-11-01/contentDocuments";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (marketplaceId != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("marketplaceId", marketplaceId));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, progressRequestListener);
    }

    private Call createContentDocumentValidateBeforeCall(PostContentDocumentRequest body, String marketplaceId, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling createContentDocument(Async)");
        }
        if (marketplaceId == null) {
            throw new ApiException("Missing the required parameter 'marketplaceId' when calling createContentDocument(Async)");
        }
        return this.createContentDocumentCall(body, marketplaceId, progressRequestListener);
    }

    public PostContentDocumentResponse createContentDocument(PostContentDocumentRequest body, String marketplaceId, String restrictedDataToken) throws ApiException, LWAException {
        ApiResponse<PostContentDocumentResponse> resp = this.createContentDocumentWithHttpInfo(body, marketplaceId, restrictedDataToken);
        return resp.getData();
    }

    public PostContentDocumentResponse createContentDocument(PostContentDocumentRequest body, String marketplaceId) throws ApiException, LWAException {
        ApiResponse<PostContentDocumentResponse> resp = this.createContentDocumentWithHttpInfo(body, marketplaceId, null);
        return resp.getData();
    }

    public ApiResponse<PostContentDocumentResponse> createContentDocumentWithHttpInfo(PostContentDocumentRequest body, String marketplaceId, String restrictedDataToken) throws ApiException, LWAException {
        Call call = this.createContentDocumentValidateBeforeCall(body, marketplaceId, null);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "AplusContentApi-createContentDocument");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.createContentDocumentBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<PostContentDocumentResponse>(){}.getType();
            return this.apiClient.execute(call, localVarReturnType);
        }
        throw new ApiException.RateLimitExceeded("createContentDocument operation exceeds rate limit");
    }

    public ApiResponse<PostContentDocumentResponse> createContentDocumentWithHttpInfo(PostContentDocumentRequest body, String marketplaceId) throws ApiException, LWAException {
        return this.createContentDocumentWithHttpInfo(body, marketplaceId, null);
    }

    public Call createContentDocumentAsync(PostContentDocumentRequest body, String marketplaceId, ApiCallback<PostContentDocumentResponse> callback) throws ApiException, LWAException {
        return this.createContentDocumentAsync(body, marketplaceId, callback, null);
    }

    public Call createContentDocumentAsync(PostContentDocumentRequest body, String marketplaceId, ApiCallback<PostContentDocumentResponse> callback, String restrictedDataToken) throws ApiException, LWAException {
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressRequestListener = callback::onUploadProgress;
        }
        Call call = this.createContentDocumentValidateBeforeCall(body, marketplaceId, progressRequestListener);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "AplusContentApi-createContentDocument");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.createContentDocumentBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<PostContentDocumentResponse>(){}.getType();
            this.apiClient.executeAsync(call, localVarReturnType, callback);
            return call;
        }
        throw new ApiException.RateLimitExceeded("createContentDocument operation exceeds rate limit");
    }

    private Call getContentDocumentCall(String contentReferenceKey, String marketplaceId, List<String> includedDataSet, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        Object localVarPostBody = null;
        String localVarPath = "/aplus/2020-11-01/contentDocuments/{contentReferenceKey}".equals("/uploads/2020-11-01/uploadDestinations/{resource}") ? "/aplus/2020-11-01/contentDocuments/{contentReferenceKey}".replaceAll("\\{contentReferenceKey\\}", contentReferenceKey.toString()) : "/aplus/2020-11-01/contentDocuments/{contentReferenceKey}".replaceAll("\\{contentReferenceKey\\}", this.apiClient.escapeString(contentReferenceKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (marketplaceId != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("marketplaceId", marketplaceId));
        }
        if (includedDataSet != null) {
            localVarCollectionQueryParams.addAll(this.apiClient.parameterToPairs("csv", "includedDataSet", includedDataSet));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, progressRequestListener);
    }

    private Call getContentDocumentValidateBeforeCall(String contentReferenceKey, String marketplaceId, List<String> includedDataSet, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        if (contentReferenceKey == null) {
            throw new ApiException("Missing the required parameter 'contentReferenceKey' when calling getContentDocument(Async)");
        }
        if (marketplaceId == null) {
            throw new ApiException("Missing the required parameter 'marketplaceId' when calling getContentDocument(Async)");
        }
        if (includedDataSet == null) {
            throw new ApiException("Missing the required parameter 'includedDataSet' when calling getContentDocument(Async)");
        }
        return this.getContentDocumentCall(contentReferenceKey, marketplaceId, includedDataSet, progressRequestListener);
    }

    public GetContentDocumentResponse getContentDocument(String contentReferenceKey, String marketplaceId, List<String> includedDataSet, String restrictedDataToken) throws ApiException, LWAException {
        ApiResponse<GetContentDocumentResponse> resp = this.getContentDocumentWithHttpInfo(contentReferenceKey, marketplaceId, includedDataSet, restrictedDataToken);
        return resp.getData();
    }

    public GetContentDocumentResponse getContentDocument(String contentReferenceKey, String marketplaceId, List<String> includedDataSet) throws ApiException, LWAException {
        ApiResponse<GetContentDocumentResponse> resp = this.getContentDocumentWithHttpInfo(contentReferenceKey, marketplaceId, includedDataSet, null);
        return resp.getData();
    }

    public ApiResponse<GetContentDocumentResponse> getContentDocumentWithHttpInfo(String contentReferenceKey, String marketplaceId, List<String> includedDataSet, String restrictedDataToken) throws ApiException, LWAException {
        Call call = this.getContentDocumentValidateBeforeCall(contentReferenceKey, marketplaceId, includedDataSet, null);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "AplusContentApi-getContentDocument");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.getContentDocumentBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<GetContentDocumentResponse>(){}.getType();
            return this.apiClient.execute(call, localVarReturnType);
        }
        throw new ApiException.RateLimitExceeded("getContentDocument operation exceeds rate limit");
    }

    public ApiResponse<GetContentDocumentResponse> getContentDocumentWithHttpInfo(String contentReferenceKey, String marketplaceId, List<String> includedDataSet) throws ApiException, LWAException {
        return this.getContentDocumentWithHttpInfo(contentReferenceKey, marketplaceId, includedDataSet, null);
    }

    public Call getContentDocumentAsync(String contentReferenceKey, String marketplaceId, List<String> includedDataSet, ApiCallback<GetContentDocumentResponse> callback) throws ApiException, LWAException {
        return this.getContentDocumentAsync(contentReferenceKey, marketplaceId, includedDataSet, callback, null);
    }

    public Call getContentDocumentAsync(String contentReferenceKey, String marketplaceId, List<String> includedDataSet, ApiCallback<GetContentDocumentResponse> callback, String restrictedDataToken) throws ApiException, LWAException {
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressRequestListener = callback::onUploadProgress;
        }
        Call call = this.getContentDocumentValidateBeforeCall(contentReferenceKey, marketplaceId, includedDataSet, progressRequestListener);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "AplusContentApi-getContentDocument");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.getContentDocumentBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<GetContentDocumentResponse>(){}.getType();
            this.apiClient.executeAsync(call, localVarReturnType, callback);
            return call;
        }
        throw new ApiException.RateLimitExceeded("getContentDocument operation exceeds rate limit");
    }

    private Call listContentDocumentAsinRelationsCall(String contentReferenceKey, String marketplaceId, List<String> includedDataSet, List<String> asinSet, String pageToken, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        Object localVarPostBody = null;
        String localVarPath = "/aplus/2020-11-01/contentDocuments/{contentReferenceKey}/asins".equals("/uploads/2020-11-01/uploadDestinations/{resource}") ? "/aplus/2020-11-01/contentDocuments/{contentReferenceKey}/asins".replaceAll("\\{contentReferenceKey\\}", contentReferenceKey.toString()) : "/aplus/2020-11-01/contentDocuments/{contentReferenceKey}/asins".replaceAll("\\{contentReferenceKey\\}", this.apiClient.escapeString(contentReferenceKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (marketplaceId != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("marketplaceId", marketplaceId));
        }
        if (includedDataSet != null) {
            localVarCollectionQueryParams.addAll(this.apiClient.parameterToPairs("csv", "includedDataSet", includedDataSet));
        }
        if (asinSet != null) {
            localVarCollectionQueryParams.addAll(this.apiClient.parameterToPairs("csv", "asinSet", asinSet));
        }
        if (pageToken != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("pageToken", pageToken));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, progressRequestListener);
    }

    private Call listContentDocumentAsinRelationsValidateBeforeCall(String contentReferenceKey, String marketplaceId, List<String> includedDataSet, List<String> asinSet, String pageToken, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        if (contentReferenceKey == null) {
            throw new ApiException("Missing the required parameter 'contentReferenceKey' when calling listContentDocumentAsinRelations(Async)");
        }
        if (marketplaceId == null) {
            throw new ApiException("Missing the required parameter 'marketplaceId' when calling listContentDocumentAsinRelations(Async)");
        }
        return this.listContentDocumentAsinRelationsCall(contentReferenceKey, marketplaceId, includedDataSet, asinSet, pageToken, progressRequestListener);
    }

    public ListContentDocumentAsinRelationsResponse listContentDocumentAsinRelations(String contentReferenceKey, String marketplaceId, List<String> includedDataSet, List<String> asinSet, String pageToken, String restrictedDataToken) throws ApiException, LWAException {
        ApiResponse<ListContentDocumentAsinRelationsResponse> resp = this.listContentDocumentAsinRelationsWithHttpInfo(contentReferenceKey, marketplaceId, includedDataSet, asinSet, pageToken, restrictedDataToken);
        return resp.getData();
    }

    public ListContentDocumentAsinRelationsResponse listContentDocumentAsinRelations(String contentReferenceKey, String marketplaceId, List<String> includedDataSet, List<String> asinSet, String pageToken) throws ApiException, LWAException {
        ApiResponse<ListContentDocumentAsinRelationsResponse> resp = this.listContentDocumentAsinRelationsWithHttpInfo(contentReferenceKey, marketplaceId, includedDataSet, asinSet, pageToken, null);
        return resp.getData();
    }

    public ApiResponse<ListContentDocumentAsinRelationsResponse> listContentDocumentAsinRelationsWithHttpInfo(String contentReferenceKey, String marketplaceId, List<String> includedDataSet, List<String> asinSet, String pageToken, String restrictedDataToken) throws ApiException, LWAException {
        Call call = this.listContentDocumentAsinRelationsValidateBeforeCall(contentReferenceKey, marketplaceId, includedDataSet, asinSet, pageToken, null);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "AplusContentApi-listContentDocumentAsinRelations");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.listContentDocumentAsinRelationsBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<ListContentDocumentAsinRelationsResponse>(){}.getType();
            return this.apiClient.execute(call, localVarReturnType);
        }
        throw new ApiException.RateLimitExceeded("listContentDocumentAsinRelations operation exceeds rate limit");
    }

    public ApiResponse<ListContentDocumentAsinRelationsResponse> listContentDocumentAsinRelationsWithHttpInfo(String contentReferenceKey, String marketplaceId, List<String> includedDataSet, List<String> asinSet, String pageToken) throws ApiException, LWAException {
        return this.listContentDocumentAsinRelationsWithHttpInfo(contentReferenceKey, marketplaceId, includedDataSet, asinSet, pageToken, null);
    }

    public Call listContentDocumentAsinRelationsAsync(String contentReferenceKey, String marketplaceId, List<String> includedDataSet, List<String> asinSet, String pageToken, ApiCallback<ListContentDocumentAsinRelationsResponse> callback) throws ApiException, LWAException {
        return this.listContentDocumentAsinRelationsAsync(contentReferenceKey, marketplaceId, includedDataSet, asinSet, pageToken, callback, null);
    }

    public Call listContentDocumentAsinRelationsAsync(String contentReferenceKey, String marketplaceId, List<String> includedDataSet, List<String> asinSet, String pageToken, ApiCallback<ListContentDocumentAsinRelationsResponse> callback, String restrictedDataToken) throws ApiException, LWAException {
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressRequestListener = callback::onUploadProgress;
        }
        Call call = this.listContentDocumentAsinRelationsValidateBeforeCall(contentReferenceKey, marketplaceId, includedDataSet, asinSet, pageToken, progressRequestListener);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "AplusContentApi-listContentDocumentAsinRelations");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.listContentDocumentAsinRelationsBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<ListContentDocumentAsinRelationsResponse>(){}.getType();
            this.apiClient.executeAsync(call, localVarReturnType, callback);
            return call;
        }
        throw new ApiException.RateLimitExceeded("listContentDocumentAsinRelations operation exceeds rate limit");
    }

    private Call postContentDocumentApprovalSubmissionCall(String contentReferenceKey, String marketplaceId, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        Object localVarPostBody = null;
        String localVarPath = "/aplus/2020-11-01/contentDocuments/{contentReferenceKey}/approvalSubmissions".equals("/uploads/2020-11-01/uploadDestinations/{resource}") ? "/aplus/2020-11-01/contentDocuments/{contentReferenceKey}/approvalSubmissions".replaceAll("\\{contentReferenceKey\\}", contentReferenceKey.toString()) : "/aplus/2020-11-01/contentDocuments/{contentReferenceKey}/approvalSubmissions".replaceAll("\\{contentReferenceKey\\}", this.apiClient.escapeString(contentReferenceKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (marketplaceId != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("marketplaceId", marketplaceId));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, progressRequestListener);
    }

    private Call postContentDocumentApprovalSubmissionValidateBeforeCall(String contentReferenceKey, String marketplaceId, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        if (contentReferenceKey == null) {
            throw new ApiException("Missing the required parameter 'contentReferenceKey' when calling postContentDocumentApprovalSubmission(Async)");
        }
        if (marketplaceId == null) {
            throw new ApiException("Missing the required parameter 'marketplaceId' when calling postContentDocumentApprovalSubmission(Async)");
        }
        return this.postContentDocumentApprovalSubmissionCall(contentReferenceKey, marketplaceId, progressRequestListener);
    }

    public PostContentDocumentApprovalSubmissionResponse postContentDocumentApprovalSubmission(String contentReferenceKey, String marketplaceId, String restrictedDataToken) throws ApiException, LWAException {
        ApiResponse<PostContentDocumentApprovalSubmissionResponse> resp = this.postContentDocumentApprovalSubmissionWithHttpInfo(contentReferenceKey, marketplaceId, restrictedDataToken);
        return resp.getData();
    }

    public PostContentDocumentApprovalSubmissionResponse postContentDocumentApprovalSubmission(String contentReferenceKey, String marketplaceId) throws ApiException, LWAException {
        ApiResponse<PostContentDocumentApprovalSubmissionResponse> resp = this.postContentDocumentApprovalSubmissionWithHttpInfo(contentReferenceKey, marketplaceId, null);
        return resp.getData();
    }

    public ApiResponse<PostContentDocumentApprovalSubmissionResponse> postContentDocumentApprovalSubmissionWithHttpInfo(String contentReferenceKey, String marketplaceId, String restrictedDataToken) throws ApiException, LWAException {
        Call call = this.postContentDocumentApprovalSubmissionValidateBeforeCall(contentReferenceKey, marketplaceId, null);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "AplusContentApi-postContentDocumentApprovalSubmission");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.postContentDocumentApprovalSubmissionBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<PostContentDocumentApprovalSubmissionResponse>(){}.getType();
            return this.apiClient.execute(call, localVarReturnType);
        }
        throw new ApiException.RateLimitExceeded("postContentDocumentApprovalSubmission operation exceeds rate limit");
    }

    public ApiResponse<PostContentDocumentApprovalSubmissionResponse> postContentDocumentApprovalSubmissionWithHttpInfo(String contentReferenceKey, String marketplaceId) throws ApiException, LWAException {
        return this.postContentDocumentApprovalSubmissionWithHttpInfo(contentReferenceKey, marketplaceId, null);
    }

    public Call postContentDocumentApprovalSubmissionAsync(String contentReferenceKey, String marketplaceId, ApiCallback<PostContentDocumentApprovalSubmissionResponse> callback) throws ApiException, LWAException {
        return this.postContentDocumentApprovalSubmissionAsync(contentReferenceKey, marketplaceId, callback, null);
    }

    public Call postContentDocumentApprovalSubmissionAsync(String contentReferenceKey, String marketplaceId, ApiCallback<PostContentDocumentApprovalSubmissionResponse> callback, String restrictedDataToken) throws ApiException, LWAException {
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressRequestListener = callback::onUploadProgress;
        }
        Call call = this.postContentDocumentApprovalSubmissionValidateBeforeCall(contentReferenceKey, marketplaceId, progressRequestListener);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "AplusContentApi-postContentDocumentApprovalSubmission");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.postContentDocumentApprovalSubmissionBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<PostContentDocumentApprovalSubmissionResponse>(){}.getType();
            this.apiClient.executeAsync(call, localVarReturnType, callback);
            return call;
        }
        throw new ApiException.RateLimitExceeded("postContentDocumentApprovalSubmission operation exceeds rate limit");
    }

    private Call postContentDocumentAsinRelationsCall(PostContentDocumentAsinRelationsRequest body, String contentReferenceKey, String marketplaceId, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        PostContentDocumentAsinRelationsRequest localVarPostBody = body;
        String localVarPath = "/aplus/2020-11-01/contentDocuments/{contentReferenceKey}/asins".equals("/uploads/2020-11-01/uploadDestinations/{resource}") ? "/aplus/2020-11-01/contentDocuments/{contentReferenceKey}/asins".replaceAll("\\{contentReferenceKey\\}", contentReferenceKey.toString()) : "/aplus/2020-11-01/contentDocuments/{contentReferenceKey}/asins".replaceAll("\\{contentReferenceKey\\}", this.apiClient.escapeString(contentReferenceKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (marketplaceId != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("marketplaceId", marketplaceId));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, progressRequestListener);
    }

    private Call postContentDocumentAsinRelationsValidateBeforeCall(PostContentDocumentAsinRelationsRequest body, String contentReferenceKey, String marketplaceId, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling postContentDocumentAsinRelations(Async)");
        }
        if (contentReferenceKey == null) {
            throw new ApiException("Missing the required parameter 'contentReferenceKey' when calling postContentDocumentAsinRelations(Async)");
        }
        if (marketplaceId == null) {
            throw new ApiException("Missing the required parameter 'marketplaceId' when calling postContentDocumentAsinRelations(Async)");
        }
        return this.postContentDocumentAsinRelationsCall(body, contentReferenceKey, marketplaceId, progressRequestListener);
    }

    public PostContentDocumentAsinRelationsResponse postContentDocumentAsinRelations(PostContentDocumentAsinRelationsRequest body, String contentReferenceKey, String marketplaceId, String restrictedDataToken) throws ApiException, LWAException {
        ApiResponse<PostContentDocumentAsinRelationsResponse> resp = this.postContentDocumentAsinRelationsWithHttpInfo(body, contentReferenceKey, marketplaceId, restrictedDataToken);
        return resp.getData();
    }

    public PostContentDocumentAsinRelationsResponse postContentDocumentAsinRelations(PostContentDocumentAsinRelationsRequest body, String contentReferenceKey, String marketplaceId) throws ApiException, LWAException {
        ApiResponse<PostContentDocumentAsinRelationsResponse> resp = this.postContentDocumentAsinRelationsWithHttpInfo(body, contentReferenceKey, marketplaceId, null);
        return resp.getData();
    }

    public ApiResponse<PostContentDocumentAsinRelationsResponse> postContentDocumentAsinRelationsWithHttpInfo(PostContentDocumentAsinRelationsRequest body, String contentReferenceKey, String marketplaceId, String restrictedDataToken) throws ApiException, LWAException {
        Call call = this.postContentDocumentAsinRelationsValidateBeforeCall(body, contentReferenceKey, marketplaceId, null);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "AplusContentApi-postContentDocumentAsinRelations");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.postContentDocumentAsinRelationsBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<PostContentDocumentAsinRelationsResponse>(){}.getType();
            return this.apiClient.execute(call, localVarReturnType);
        }
        throw new ApiException.RateLimitExceeded("postContentDocumentAsinRelations operation exceeds rate limit");
    }

    public ApiResponse<PostContentDocumentAsinRelationsResponse> postContentDocumentAsinRelationsWithHttpInfo(PostContentDocumentAsinRelationsRequest body, String contentReferenceKey, String marketplaceId) throws ApiException, LWAException {
        return this.postContentDocumentAsinRelationsWithHttpInfo(body, contentReferenceKey, marketplaceId, null);
    }

    public Call postContentDocumentAsinRelationsAsync(PostContentDocumentAsinRelationsRequest body, String contentReferenceKey, String marketplaceId, ApiCallback<PostContentDocumentAsinRelationsResponse> callback) throws ApiException, LWAException {
        return this.postContentDocumentAsinRelationsAsync(body, contentReferenceKey, marketplaceId, callback, null);
    }

    public Call postContentDocumentAsinRelationsAsync(PostContentDocumentAsinRelationsRequest body, String contentReferenceKey, String marketplaceId, ApiCallback<PostContentDocumentAsinRelationsResponse> callback, String restrictedDataToken) throws ApiException, LWAException {
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressRequestListener = callback::onUploadProgress;
        }
        Call call = this.postContentDocumentAsinRelationsValidateBeforeCall(body, contentReferenceKey, marketplaceId, progressRequestListener);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "AplusContentApi-postContentDocumentAsinRelations");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.postContentDocumentAsinRelationsBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<PostContentDocumentAsinRelationsResponse>(){}.getType();
            this.apiClient.executeAsync(call, localVarReturnType, callback);
            return call;
        }
        throw new ApiException.RateLimitExceeded("postContentDocumentAsinRelations operation exceeds rate limit");
    }

    private Call postContentDocumentSuspendSubmissionCall(String contentReferenceKey, String marketplaceId, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        Object localVarPostBody = null;
        String localVarPath = "/aplus/2020-11-01/contentDocuments/{contentReferenceKey}/suspendSubmissions".equals("/uploads/2020-11-01/uploadDestinations/{resource}") ? "/aplus/2020-11-01/contentDocuments/{contentReferenceKey}/suspendSubmissions".replaceAll("\\{contentReferenceKey\\}", contentReferenceKey.toString()) : "/aplus/2020-11-01/contentDocuments/{contentReferenceKey}/suspendSubmissions".replaceAll("\\{contentReferenceKey\\}", this.apiClient.escapeString(contentReferenceKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (marketplaceId != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("marketplaceId", marketplaceId));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, progressRequestListener);
    }

    private Call postContentDocumentSuspendSubmissionValidateBeforeCall(String contentReferenceKey, String marketplaceId, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        if (contentReferenceKey == null) {
            throw new ApiException("Missing the required parameter 'contentReferenceKey' when calling postContentDocumentSuspendSubmission(Async)");
        }
        if (marketplaceId == null) {
            throw new ApiException("Missing the required parameter 'marketplaceId' when calling postContentDocumentSuspendSubmission(Async)");
        }
        return this.postContentDocumentSuspendSubmissionCall(contentReferenceKey, marketplaceId, progressRequestListener);
    }

    public PostContentDocumentSuspendSubmissionResponse postContentDocumentSuspendSubmission(String contentReferenceKey, String marketplaceId, String restrictedDataToken) throws ApiException, LWAException {
        ApiResponse<PostContentDocumentSuspendSubmissionResponse> resp = this.postContentDocumentSuspendSubmissionWithHttpInfo(contentReferenceKey, marketplaceId, restrictedDataToken);
        return resp.getData();
    }

    public PostContentDocumentSuspendSubmissionResponse postContentDocumentSuspendSubmission(String contentReferenceKey, String marketplaceId) throws ApiException, LWAException {
        ApiResponse<PostContentDocumentSuspendSubmissionResponse> resp = this.postContentDocumentSuspendSubmissionWithHttpInfo(contentReferenceKey, marketplaceId, null);
        return resp.getData();
    }

    public ApiResponse<PostContentDocumentSuspendSubmissionResponse> postContentDocumentSuspendSubmissionWithHttpInfo(String contentReferenceKey, String marketplaceId, String restrictedDataToken) throws ApiException, LWAException {
        Call call = this.postContentDocumentSuspendSubmissionValidateBeforeCall(contentReferenceKey, marketplaceId, null);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "AplusContentApi-postContentDocumentSuspendSubmission");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.postContentDocumentSuspendSubmissionBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<PostContentDocumentSuspendSubmissionResponse>(){}.getType();
            return this.apiClient.execute(call, localVarReturnType);
        }
        throw new ApiException.RateLimitExceeded("postContentDocumentSuspendSubmission operation exceeds rate limit");
    }

    public ApiResponse<PostContentDocumentSuspendSubmissionResponse> postContentDocumentSuspendSubmissionWithHttpInfo(String contentReferenceKey, String marketplaceId) throws ApiException, LWAException {
        return this.postContentDocumentSuspendSubmissionWithHttpInfo(contentReferenceKey, marketplaceId, null);
    }

    public Call postContentDocumentSuspendSubmissionAsync(String contentReferenceKey, String marketplaceId, ApiCallback<PostContentDocumentSuspendSubmissionResponse> callback) throws ApiException, LWAException {
        return this.postContentDocumentSuspendSubmissionAsync(contentReferenceKey, marketplaceId, callback, null);
    }

    public Call postContentDocumentSuspendSubmissionAsync(String contentReferenceKey, String marketplaceId, ApiCallback<PostContentDocumentSuspendSubmissionResponse> callback, String restrictedDataToken) throws ApiException, LWAException {
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressRequestListener = callback::onUploadProgress;
        }
        Call call = this.postContentDocumentSuspendSubmissionValidateBeforeCall(contentReferenceKey, marketplaceId, progressRequestListener);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "AplusContentApi-postContentDocumentSuspendSubmission");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.postContentDocumentSuspendSubmissionBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<PostContentDocumentSuspendSubmissionResponse>(){}.getType();
            this.apiClient.executeAsync(call, localVarReturnType, callback);
            return call;
        }
        throw new ApiException.RateLimitExceeded("postContentDocumentSuspendSubmission operation exceeds rate limit");
    }

    private Call searchContentDocumentsCall(String marketplaceId, String pageToken, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        Object localVarPostBody = null;
        String localVarPath = "/aplus/2020-11-01/contentDocuments".equals("/uploads/2020-11-01/uploadDestinations/{resource}") ? "/aplus/2020-11-01/contentDocuments" : "/aplus/2020-11-01/contentDocuments";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (marketplaceId != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("marketplaceId", marketplaceId));
        }
        if (pageToken != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("pageToken", pageToken));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, progressRequestListener);
    }

    private Call searchContentDocumentsValidateBeforeCall(String marketplaceId, String pageToken, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        if (marketplaceId == null) {
            throw new ApiException("Missing the required parameter 'marketplaceId' when calling searchContentDocuments(Async)");
        }
        return this.searchContentDocumentsCall(marketplaceId, pageToken, progressRequestListener);
    }

    public SearchContentDocumentsResponse searchContentDocuments(String marketplaceId, String pageToken, String restrictedDataToken) throws ApiException, LWAException {
        ApiResponse<SearchContentDocumentsResponse> resp = this.searchContentDocumentsWithHttpInfo(marketplaceId, pageToken, restrictedDataToken);
        return resp.getData();
    }

    public SearchContentDocumentsResponse searchContentDocuments(String marketplaceId, String pageToken) throws ApiException, LWAException {
        ApiResponse<SearchContentDocumentsResponse> resp = this.searchContentDocumentsWithHttpInfo(marketplaceId, pageToken, null);
        return resp.getData();
    }

    public ApiResponse<SearchContentDocumentsResponse> searchContentDocumentsWithHttpInfo(String marketplaceId, String pageToken, String restrictedDataToken) throws ApiException, LWAException {
        Call call = this.searchContentDocumentsValidateBeforeCall(marketplaceId, pageToken, null);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "AplusContentApi-searchContentDocuments");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.searchContentDocumentsBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<SearchContentDocumentsResponse>(){}.getType();
            return this.apiClient.execute(call, localVarReturnType);
        }
        throw new ApiException.RateLimitExceeded("searchContentDocuments operation exceeds rate limit");
    }

    public ApiResponse<SearchContentDocumentsResponse> searchContentDocumentsWithHttpInfo(String marketplaceId, String pageToken) throws ApiException, LWAException {
        return this.searchContentDocumentsWithHttpInfo(marketplaceId, pageToken, null);
    }

    public Call searchContentDocumentsAsync(String marketplaceId, String pageToken, ApiCallback<SearchContentDocumentsResponse> callback) throws ApiException, LWAException {
        return this.searchContentDocumentsAsync(marketplaceId, pageToken, callback, null);
    }

    public Call searchContentDocumentsAsync(String marketplaceId, String pageToken, ApiCallback<SearchContentDocumentsResponse> callback, String restrictedDataToken) throws ApiException, LWAException {
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressRequestListener = callback::onUploadProgress;
        }
        Call call = this.searchContentDocumentsValidateBeforeCall(marketplaceId, pageToken, progressRequestListener);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "AplusContentApi-searchContentDocuments");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.searchContentDocumentsBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<SearchContentDocumentsResponse>(){}.getType();
            this.apiClient.executeAsync(call, localVarReturnType, callback);
            return call;
        }
        throw new ApiException.RateLimitExceeded("searchContentDocuments operation exceeds rate limit");
    }

    private Call searchContentPublishRecordsCall(String marketplaceId, String asin, String pageToken, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        Object localVarPostBody = null;
        String localVarPath = "/aplus/2020-11-01/contentPublishRecords".equals("/uploads/2020-11-01/uploadDestinations/{resource}") ? "/aplus/2020-11-01/contentPublishRecords" : "/aplus/2020-11-01/contentPublishRecords";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (marketplaceId != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("marketplaceId", marketplaceId));
        }
        if (asin != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("asin", asin));
        }
        if (pageToken != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("pageToken", pageToken));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, progressRequestListener);
    }

    private Call searchContentPublishRecordsValidateBeforeCall(String marketplaceId, String asin, String pageToken, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        if (marketplaceId == null) {
            throw new ApiException("Missing the required parameter 'marketplaceId' when calling searchContentPublishRecords(Async)");
        }
        if (asin == null) {
            throw new ApiException("Missing the required parameter 'asin' when calling searchContentPublishRecords(Async)");
        }
        return this.searchContentPublishRecordsCall(marketplaceId, asin, pageToken, progressRequestListener);
    }

    public SearchContentPublishRecordsResponse searchContentPublishRecords(String marketplaceId, String asin, String pageToken, String restrictedDataToken) throws ApiException, LWAException {
        ApiResponse<SearchContentPublishRecordsResponse> resp = this.searchContentPublishRecordsWithHttpInfo(marketplaceId, asin, pageToken, restrictedDataToken);
        return resp.getData();
    }

    public SearchContentPublishRecordsResponse searchContentPublishRecords(String marketplaceId, String asin, String pageToken) throws ApiException, LWAException {
        ApiResponse<SearchContentPublishRecordsResponse> resp = this.searchContentPublishRecordsWithHttpInfo(marketplaceId, asin, pageToken, null);
        return resp.getData();
    }

    public ApiResponse<SearchContentPublishRecordsResponse> searchContentPublishRecordsWithHttpInfo(String marketplaceId, String asin, String pageToken, String restrictedDataToken) throws ApiException, LWAException {
        Call call = this.searchContentPublishRecordsValidateBeforeCall(marketplaceId, asin, pageToken, null);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "AplusContentApi-searchContentPublishRecords");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.searchContentPublishRecordsBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<SearchContentPublishRecordsResponse>(){}.getType();
            return this.apiClient.execute(call, localVarReturnType);
        }
        throw new ApiException.RateLimitExceeded("searchContentPublishRecords operation exceeds rate limit");
    }

    public ApiResponse<SearchContentPublishRecordsResponse> searchContentPublishRecordsWithHttpInfo(String marketplaceId, String asin, String pageToken) throws ApiException, LWAException {
        return this.searchContentPublishRecordsWithHttpInfo(marketplaceId, asin, pageToken, null);
    }

    public Call searchContentPublishRecordsAsync(String marketplaceId, String asin, String pageToken, ApiCallback<SearchContentPublishRecordsResponse> callback) throws ApiException, LWAException {
        return this.searchContentPublishRecordsAsync(marketplaceId, asin, pageToken, callback, null);
    }

    public Call searchContentPublishRecordsAsync(String marketplaceId, String asin, String pageToken, ApiCallback<SearchContentPublishRecordsResponse> callback, String restrictedDataToken) throws ApiException, LWAException {
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressRequestListener = callback::onUploadProgress;
        }
        Call call = this.searchContentPublishRecordsValidateBeforeCall(marketplaceId, asin, pageToken, progressRequestListener);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "AplusContentApi-searchContentPublishRecords");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.searchContentPublishRecordsBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<SearchContentPublishRecordsResponse>(){}.getType();
            this.apiClient.executeAsync(call, localVarReturnType, callback);
            return call;
        }
        throw new ApiException.RateLimitExceeded("searchContentPublishRecords operation exceeds rate limit");
    }

    private Call updateContentDocumentCall(PostContentDocumentRequest body, String contentReferenceKey, String marketplaceId, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        PostContentDocumentRequest localVarPostBody = body;
        String localVarPath = "/aplus/2020-11-01/contentDocuments/{contentReferenceKey}".equals("/uploads/2020-11-01/uploadDestinations/{resource}") ? "/aplus/2020-11-01/contentDocuments/{contentReferenceKey}".replaceAll("\\{contentReferenceKey\\}", contentReferenceKey.toString()) : "/aplus/2020-11-01/contentDocuments/{contentReferenceKey}".replaceAll("\\{contentReferenceKey\\}", this.apiClient.escapeString(contentReferenceKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (marketplaceId != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("marketplaceId", marketplaceId));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, progressRequestListener);
    }

    private Call updateContentDocumentValidateBeforeCall(PostContentDocumentRequest body, String contentReferenceKey, String marketplaceId, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling updateContentDocument(Async)");
        }
        if (contentReferenceKey == null) {
            throw new ApiException("Missing the required parameter 'contentReferenceKey' when calling updateContentDocument(Async)");
        }
        if (marketplaceId == null) {
            throw new ApiException("Missing the required parameter 'marketplaceId' when calling updateContentDocument(Async)");
        }
        return this.updateContentDocumentCall(body, contentReferenceKey, marketplaceId, progressRequestListener);
    }

    public PostContentDocumentResponse updateContentDocument(PostContentDocumentRequest body, String contentReferenceKey, String marketplaceId, String restrictedDataToken) throws ApiException, LWAException {
        ApiResponse<PostContentDocumentResponse> resp = this.updateContentDocumentWithHttpInfo(body, contentReferenceKey, marketplaceId, restrictedDataToken);
        return resp.getData();
    }

    public PostContentDocumentResponse updateContentDocument(PostContentDocumentRequest body, String contentReferenceKey, String marketplaceId) throws ApiException, LWAException {
        ApiResponse<PostContentDocumentResponse> resp = this.updateContentDocumentWithHttpInfo(body, contentReferenceKey, marketplaceId, null);
        return resp.getData();
    }

    public ApiResponse<PostContentDocumentResponse> updateContentDocumentWithHttpInfo(PostContentDocumentRequest body, String contentReferenceKey, String marketplaceId, String restrictedDataToken) throws ApiException, LWAException {
        Call call = this.updateContentDocumentValidateBeforeCall(body, contentReferenceKey, marketplaceId, null);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "AplusContentApi-updateContentDocument");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.updateContentDocumentBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<PostContentDocumentResponse>(){}.getType();
            return this.apiClient.execute(call, localVarReturnType);
        }
        throw new ApiException.RateLimitExceeded("updateContentDocument operation exceeds rate limit");
    }

    public ApiResponse<PostContentDocumentResponse> updateContentDocumentWithHttpInfo(PostContentDocumentRequest body, String contentReferenceKey, String marketplaceId) throws ApiException, LWAException {
        return this.updateContentDocumentWithHttpInfo(body, contentReferenceKey, marketplaceId, null);
    }

    public Call updateContentDocumentAsync(PostContentDocumentRequest body, String contentReferenceKey, String marketplaceId, ApiCallback<PostContentDocumentResponse> callback) throws ApiException, LWAException {
        return this.updateContentDocumentAsync(body, contentReferenceKey, marketplaceId, callback, null);
    }

    public Call updateContentDocumentAsync(PostContentDocumentRequest body, String contentReferenceKey, String marketplaceId, ApiCallback<PostContentDocumentResponse> callback, String restrictedDataToken) throws ApiException, LWAException {
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressRequestListener = callback::onUploadProgress;
        }
        Call call = this.updateContentDocumentValidateBeforeCall(body, contentReferenceKey, marketplaceId, progressRequestListener);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "AplusContentApi-updateContentDocument");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.updateContentDocumentBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<PostContentDocumentResponse>(){}.getType();
            this.apiClient.executeAsync(call, localVarReturnType, callback);
            return call;
        }
        throw new ApiException.RateLimitExceeded("updateContentDocument operation exceeds rate limit");
    }

    private Call validateContentDocumentAsinRelationsCall(PostContentDocumentRequest body, String marketplaceId, List<String> asinSet, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        PostContentDocumentRequest localVarPostBody = body;
        String localVarPath = "/aplus/2020-11-01/contentAsinValidations".equals("/uploads/2020-11-01/uploadDestinations/{resource}") ? "/aplus/2020-11-01/contentAsinValidations" : "/aplus/2020-11-01/contentAsinValidations";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (marketplaceId != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("marketplaceId", marketplaceId));
        }
        if (asinSet != null) {
            localVarCollectionQueryParams.addAll(this.apiClient.parameterToPairs("csv", "asinSet", asinSet));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, progressRequestListener);
    }

    private Call validateContentDocumentAsinRelationsValidateBeforeCall(PostContentDocumentRequest body, String marketplaceId, List<String> asinSet, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling validateContentDocumentAsinRelations(Async)");
        }
        if (marketplaceId == null) {
            throw new ApiException("Missing the required parameter 'marketplaceId' when calling validateContentDocumentAsinRelations(Async)");
        }
        return this.validateContentDocumentAsinRelationsCall(body, marketplaceId, asinSet, progressRequestListener);
    }

    public ValidateContentDocumentAsinRelationsResponse validateContentDocumentAsinRelations(PostContentDocumentRequest body, String marketplaceId, List<String> asinSet, String restrictedDataToken) throws ApiException, LWAException {
        ApiResponse<ValidateContentDocumentAsinRelationsResponse> resp = this.validateContentDocumentAsinRelationsWithHttpInfo(body, marketplaceId, asinSet, restrictedDataToken);
        return resp.getData();
    }

    public ValidateContentDocumentAsinRelationsResponse validateContentDocumentAsinRelations(PostContentDocumentRequest body, String marketplaceId, List<String> asinSet) throws ApiException, LWAException {
        ApiResponse<ValidateContentDocumentAsinRelationsResponse> resp = this.validateContentDocumentAsinRelationsWithHttpInfo(body, marketplaceId, asinSet, null);
        return resp.getData();
    }

    public ApiResponse<ValidateContentDocumentAsinRelationsResponse> validateContentDocumentAsinRelationsWithHttpInfo(PostContentDocumentRequest body, String marketplaceId, List<String> asinSet, String restrictedDataToken) throws ApiException, LWAException {
        Call call = this.validateContentDocumentAsinRelationsValidateBeforeCall(body, marketplaceId, asinSet, null);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "AplusContentApi-validateContentDocumentAsinRelations");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.validateContentDocumentAsinRelationsBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<ValidateContentDocumentAsinRelationsResponse>(){}.getType();
            return this.apiClient.execute(call, localVarReturnType);
        }
        throw new ApiException.RateLimitExceeded("validateContentDocumentAsinRelations operation exceeds rate limit");
    }

    public ApiResponse<ValidateContentDocumentAsinRelationsResponse> validateContentDocumentAsinRelationsWithHttpInfo(PostContentDocumentRequest body, String marketplaceId, List<String> asinSet) throws ApiException, LWAException {
        return this.validateContentDocumentAsinRelationsWithHttpInfo(body, marketplaceId, asinSet, null);
    }

    public Call validateContentDocumentAsinRelationsAsync(PostContentDocumentRequest body, String marketplaceId, List<String> asinSet, ApiCallback<ValidateContentDocumentAsinRelationsResponse> callback) throws ApiException, LWAException {
        return this.validateContentDocumentAsinRelationsAsync(body, marketplaceId, asinSet, callback, null);
    }

    public Call validateContentDocumentAsinRelationsAsync(PostContentDocumentRequest body, String marketplaceId, List<String> asinSet, ApiCallback<ValidateContentDocumentAsinRelationsResponse> callback, String restrictedDataToken) throws ApiException, LWAException {
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressRequestListener = callback::onUploadProgress;
        }
        Call call = this.validateContentDocumentAsinRelationsValidateBeforeCall(body, marketplaceId, asinSet, progressRequestListener);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "AplusContentApi-validateContentDocumentAsinRelations");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.validateContentDocumentAsinRelationsBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<ValidateContentDocumentAsinRelationsResponse>(){}.getType();
            this.apiClient.executeAsync(call, localVarReturnType, callback);
            return call;
        }
        throw new ApiException.RateLimitExceeded("validateContentDocumentAsinRelations operation exceeds rate limit");
    }

    public static class Builder {
        private LWAAuthorizationCredentials lwaAuthorizationCredentials;
        private String endpoint;
        private LWAAccessTokenCache lwaAccessTokenCache;
        private Boolean disableAccessTokenCache = false;
        private Boolean disableRateLimiting = false;

        public Builder lwaAuthorizationCredentials(LWAAuthorizationCredentials lwaAuthorizationCredentials) {
            this.lwaAuthorizationCredentials = lwaAuthorizationCredentials;
            return this;
        }

        public Builder endpoint(String endpoint) {
            this.endpoint = endpoint;
            return this;
        }

        public Builder lwaAccessTokenCache(LWAAccessTokenCache lwaAccessTokenCache) {
            this.lwaAccessTokenCache = lwaAccessTokenCache;
            return this;
        }

        public Builder disableAccessTokenCache() {
            this.disableAccessTokenCache = true;
            return this;
        }

        public Builder disableRateLimiting() {
            this.disableRateLimiting = true;
            return this;
        }

        public AplusContentApi build() {
            if (this.lwaAuthorizationCredentials == null) {
                throw new RuntimeException("LWAAuthorizationCredentials not set");
            }
            if (StringUtil.isEmpty(this.endpoint)) {
                throw new RuntimeException("Endpoint not set");
            }
            LWAAuthorizationSigner lwaAuthorizationSigner = null;
            if (this.disableAccessTokenCache.booleanValue()) {
                lwaAuthorizationSigner = new LWAAuthorizationSigner(this.lwaAuthorizationCredentials);
            } else {
                if (this.lwaAccessTokenCache == null) {
                    this.lwaAccessTokenCache = new LWAAccessTokenCacheImpl();
                }
                lwaAuthorizationSigner = new LWAAuthorizationSigner(this.lwaAuthorizationCredentials, this.lwaAccessTokenCache);
            }
            return new AplusContentApi(new ApiClient().setLWAAuthorizationSigner(lwaAuthorizationSigner).setBasePath(this.endpoint), this.disableRateLimiting);
        }
    }
}

