/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi;

import io.github.bucket4j.BandwidthBuilder;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import okhttp3.OkHttpClient;
import org.yaml.snakeyaml.Yaml;

public class Configuration {
    private final Map<String, List<Integer>> rateLimitConfiguration = (Map)new Yaml().load(this.getClass().getClassLoader().getResourceAsStream("rate-limits.yml"));
    private OkHttpClient okHttpClient;
    private static Configuration instance;

    private Configuration() {
    }

    public OkHttpClient getOkHttpClient() {
        if (this.okHttpClient == null) {
            this.okHttpClient = new OkHttpClient();
        }
        return this.okHttpClient;
    }

    public Function<BandwidthBuilder.BandwidthBuilderCapacityStage, BandwidthBuilder.BandwidthBuilderBuildStage> getLimit(String operation) {
        return limit -> limit.capacity((long)this.getValue(operation, 1).intValue()).refillGreedy((long)this.getValue(operation, 0).intValue(), Duration.ofSeconds(this.getValue(operation, 2).intValue()));
    }

    private Integer getValue(String operation, Integer position) {
        if (this.rateLimitConfiguration.containsKey(operation) && this.rateLimitConfiguration.get(operation).size() > position) {
            return this.rateLimitConfiguration.get(operation).get(position);
        }
        return 1;
    }

    public static Configuration get() {
        if (instance == null) {
            instance = new Configuration();
        }
        return instance;
    }
}

