/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.SellingPartnerAPIAA;

import com.amazon.SellingPartnerAPIAA.LWAAccessTokenCache;
import com.amazon.SellingPartnerAPIAA.LWAAccessTokenCacheItem;
import java.util.concurrent.ConcurrentHashMap;

public class LWAAccessTokenCacheImpl
implements LWAAccessTokenCache {
    private long expiryAdjustment = 60000L;
    private static final long SECOND_TO_MILLIS = 1000L;
    private ConcurrentHashMap<Object, Object> accessTokenHashMap = new ConcurrentHashMap();

    @Override
    public void put(Object oLWAAccessTokenRequestMeta, String accessToken, long tokenTTLInSeconds) {
        LWAAccessTokenCacheItem accessTokenCacheItem = new LWAAccessTokenCacheItem();
        long insertTime = System.currentTimeMillis();
        long accessTokenExpiresValueMillis = tokenTTLInSeconds * 1000L + insertTime;
        accessTokenCacheItem.setAccessToken(accessToken);
        accessTokenCacheItem.setAccessTokenExpiredTime(accessTokenExpiresValueMillis);
        this.accessTokenHashMap.put(oLWAAccessTokenRequestMeta, accessTokenCacheItem);
    }

    @Override
    public String get(Object oLWAAccessTokenRequestMeta) {
        Object accessTokenValue = this.accessTokenHashMap.get(oLWAAccessTokenRequestMeta);
        if (accessTokenValue != null) {
            long accessTokenExpiredTime;
            LWAAccessTokenCacheItem accessTokenData = (LWAAccessTokenCacheItem)accessTokenValue;
            long currentTime = System.currentTimeMillis();
            if (currentTime < (accessTokenExpiredTime = accessTokenData.getAccessTokenExpiredTime() - this.expiryAdjustment)) {
                return accessTokenData.getAccessToken();
            }
        }
        return null;
    }
}

