/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.boot.admin.server.notify;

import de.codecentric.boot.admin.server.domain.entities.Instance;
import de.codecentric.boot.admin.server.domain.entities.InstanceRepository;
import de.codecentric.boot.admin.server.domain.events.InstanceEvent;
import de.codecentric.boot.admin.server.domain.events.InstanceStatusChangedEvent;
import de.codecentric.boot.admin.server.notify.AbstractStatusChangeNotifier;
import java.net.URI;
import java.util.HashMap;
import org.springframework.context.expression.MapAccessor;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.ParserContext;
import org.springframework.expression.PropertyAccessor;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;
import reactor.core.publisher.Mono;

public class OpsGenieNotifier
extends AbstractStatusChangeNotifier {
    private static final URI DEFAULT_URI = URI.create("https://api.opsgenie.com/v2/alerts");
    private static final String DEFAULT_MESSAGE = "#{instance.registration.name}/#{instance.id} is #{instance.statusInfo.status}";
    private final SpelExpressionParser parser = new SpelExpressionParser();
    private RestTemplate restTemplate = new RestTemplate();
    private URI url = DEFAULT_URI;
    private String apiKey;
    private String actions;
    private String source;
    private String tags;
    private String entity;
    private String user;
    private Expression description = this.parser.parseExpression("#{instance.registration.name}/#{instance.id} is #{instance.statusInfo.status}", ParserContext.TEMPLATE_EXPRESSION);

    public OpsGenieNotifier(InstanceRepository repository) {
        super(repository);
    }

    @Override
    protected Mono<Void> doNotify(InstanceEvent event, Instance instance) {
        return Mono.fromRunnable(() -> this.restTemplate.exchange(this.buildUrl(event, instance), HttpMethod.POST, this.createRequest(event, instance), Void.class, new Object[0]));
    }

    protected String buildUrl(InstanceEvent event, Instance instance) {
        if (event instanceof InstanceStatusChangedEvent && "UP".equals(((InstanceStatusChangedEvent)event).getStatusInfo().getStatus())) {
            return String.format("%s/%s/close", this.url.toString(), this.generateAlias(instance));
        }
        return this.url.toString();
    }

    protected HttpEntity<?> createRequest(InstanceEvent event, Instance instance) {
        HashMap<String, Object> body = new HashMap<String, Object>();
        if (this.user != null) {
            body.put("user", this.user);
        }
        if (this.source != null) {
            body.put("source", this.source);
        }
        if (event instanceof InstanceStatusChangedEvent && !"UP".equals(((InstanceStatusChangedEvent)event).getStatusInfo().getStatus())) {
            body.put("message", this.getMessage(event, instance));
            body.put("alias", this.generateAlias(instance));
            body.put("description", this.getDescription(event, instance));
            if (this.actions != null) {
                body.put("actions", this.actions);
            }
            if (this.tags != null) {
                body.put("tags", this.tags);
            }
            if (this.entity != null) {
                body.put("entity", this.entity);
            }
            HashMap<String, String> details = new HashMap<String, String>();
            details.put("type", "link");
            details.put("href", instance.getRegistration().getHealthUrl());
            details.put("text", "Instance health-endpoint");
            body.put("details", details);
        }
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.set("Authorization", "GenieKey " + this.apiKey);
        return new HttpEntity(body, (MultiValueMap)headers);
    }

    protected String generateAlias(Instance instance) {
        return instance.getRegistration().getName() + "_" + instance.getId();
    }

    protected String getMessage(InstanceEvent event, Instance instance) {
        HashMap<String, Object> root = new HashMap<String, Object>();
        root.put("event", event);
        root.put("instance", instance);
        root.put("lastStatus", this.getLastStatus(event.getInstance()));
        StandardEvaluationContext context = new StandardEvaluationContext(root);
        context.addPropertyAccessor((PropertyAccessor)new MapAccessor());
        return (String)this.description.getValue((EvaluationContext)context, String.class);
    }

    protected String getDescription(InstanceEvent event, Instance instance) {
        return String.format("Instance %s (%s) went from %s to %s", instance.getRegistration().getName(), instance.getId(), this.getLastStatus(instance.getId()), ((InstanceStatusChangedEvent)event).getStatusInfo().getStatus());
    }

    public void setApiKey(String apiKey) {
        this.apiKey = apiKey;
    }

    public String getApiKey() {
        return this.apiKey;
    }

    public void setDescription(String description) {
        this.description = this.parser.parseExpression(description, ParserContext.TEMPLATE_EXPRESSION);
    }

    public String getMessage() {
        return this.description.getExpressionString();
    }

    public void setRestTemplate(RestTemplate restTemplate) {
        this.restTemplate = restTemplate;
    }

    public String getActions() {
        return this.actions;
    }

    public void setActions(String actions) {
        this.actions = actions;
    }

    public String getSource() {
        return this.source;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public String getTags() {
        return this.tags;
    }

    public void setTags(String tags) {
        this.tags = tags;
    }

    public String getEntity() {
        return this.entity;
    }

    public void setEntity(String entity) {
        this.entity = entity;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }
}

