/*
 * Decompiled with CFR 0.152.
 */
package com.github.houbb.opencc4j.support.convert.core.impl;

import com.github.houbb.heaven.annotation.ThreadSafe;
import com.github.houbb.heaven.util.lang.StringUtil;
import com.github.houbb.opencc4j.support.convert.context.UnitConvertContext;
import com.github.houbb.opencc4j.support.convert.core.UnitConvert;
import java.util.Map;

@ThreadSafe
public class DefaultUnitConvert
implements UnitConvert {
    @Override
    public String convert(UnitConvertContext context) {
        String unit = context.getUnit();
        Map<String, String> charMap = context.getCharData();
        Map<String, String> phaseMap = context.getPhraseData();
        return this.getPhraseResult(unit, phaseMap, charMap);
    }

    private String getPhraseResult(String original, Map<String, String> phraseMap, Map<String, String> charMap) {
        String phrase = phraseMap.get(original);
        if (StringUtil.isNotEmpty((String)phrase) && !"\ud86d\uddf5".equals(phrase)) {
            return phrase;
        }
        char[] chars = original.toCharArray();
        StringBuilder stringBuilder = new StringBuilder();
        for (char c : chars) {
            String result = this.getCharResult(Character.toString(c), charMap);
            stringBuilder.append(result);
        }
        return stringBuilder.toString();
    }

    private String getCharResult(String original, Map<String, String> charMap) {
        String c = charMap.get(original);
        if (StringUtil.isNotEmpty((String)c) && !"\ud86d\uddf5".equals(c)) {
            return c;
        }
        return original;
    }
}

