/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.dubbo.autoconfigure.condition;

import com.alibaba.cloud.dubbo.registry.SpringCloudRegistryFactory;
import com.alibaba.spring.util.PropertySourcesUtils;
import java.util.Map;
import org.springframework.boot.autoconfigure.condition.ConditionOutcome;
import org.springframework.boot.autoconfigure.condition.SpringBootCondition;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.PropertySources;
import org.springframework.core.type.AnnotatedTypeMetadata;
import org.springframework.util.StringUtils;

public class MissingSpringCloudRegistryConfigPropertyCondition
extends SpringBootCondition {
    public ConditionOutcome getMatchOutcome(ConditionContext context, AnnotatedTypeMetadata metadata) {
        ConfigurableEnvironment environment = (ConfigurableEnvironment)context.getEnvironment();
        String protocol = environment.getProperty("dubbo.registry.protocol");
        if (SpringCloudRegistryFactory.PROTOCOL.equals(protocol)) {
            return ConditionOutcome.noMatch((String)"'spring-cloud' protocol was found from 'dubbo.registry.protocol'");
        }
        String address = environment.getProperty("dubbo.registry.address");
        if (StringUtils.startsWithIgnoreCase((String)address, (String)SpringCloudRegistryFactory.PROTOCOL)) {
            return ConditionOutcome.noMatch((String)"'spring-cloud' protocol was found from 'dubbo.registry.address'");
        }
        Map properties = PropertySourcesUtils.getSubProperties((PropertySources)environment.getPropertySources(), (String)"dubbo.registries.");
        boolean found = properties.entrySet().stream().anyMatch(entry -> {
            String key = (String)entry.getKey();
            String value = String.valueOf(entry.getValue());
            return key.endsWith(".address") && value.startsWith(SpringCloudRegistryFactory.PROTOCOL) || key.endsWith(".protocol") && SpringCloudRegistryFactory.PROTOCOL.equals(value);
        });
        return found ? ConditionOutcome.noMatch((String)"'spring-cloud' protocol was found in 'dubbo.registries.*'") : ConditionOutcome.match();
    }
}

