/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.models.vendor.shipments.v1;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.threeten.bp.OffsetDateTime;
import software.amazon.spapi.models.vendor.shipments.v1.LabelData;
import software.amazon.spapi.models.vendor.shipments.v1.ShipmentInformation;

@Schema(description="A list of one or more ShipmentLabels.")
public class TransportLabel {
    @SerializedName(value="labelCreateDateTime")
    private OffsetDateTime labelCreateDateTime = null;
    @SerializedName(value="shipmentInformation")
    private ShipmentInformation shipmentInformation = null;
    @SerializedName(value="labelData")
    private List<LabelData> labelData = null;

    public TransportLabel labelCreateDateTime(OffsetDateTime labelCreateDateTime) {
        this.labelCreateDateTime = labelCreateDateTime;
        return this;
    }

    @Schema(description="Date on which label is created.")
    public OffsetDateTime getLabelCreateDateTime() {
        return this.labelCreateDateTime;
    }

    public void setLabelCreateDateTime(OffsetDateTime labelCreateDateTime) {
        this.labelCreateDateTime = labelCreateDateTime;
    }

    public TransportLabel shipmentInformation(ShipmentInformation shipmentInformation) {
        this.shipmentInformation = shipmentInformation;
        return this;
    }

    @Schema(description="")
    public ShipmentInformation getShipmentInformation() {
        return this.shipmentInformation;
    }

    public void setShipmentInformation(ShipmentInformation shipmentInformation) {
        this.shipmentInformation = shipmentInformation;
    }

    public TransportLabel labelData(List<LabelData> labelData) {
        this.labelData = labelData;
        return this;
    }

    public TransportLabel addLabelDataItem(LabelData labelDataItem) {
        if (this.labelData == null) {
            this.labelData = new ArrayList<LabelData>();
        }
        this.labelData.add(labelDataItem);
        return this;
    }

    @Schema(description="Indicates the label data,format and type associated .")
    public List<LabelData> getLabelData() {
        return this.labelData;
    }

    public void setLabelData(List<LabelData> labelData) {
        this.labelData = labelData;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TransportLabel transportLabel = (TransportLabel)o;
        return Objects.equals(this.labelCreateDateTime, transportLabel.labelCreateDateTime) && Objects.equals(this.shipmentInformation, transportLabel.shipmentInformation) && Objects.equals(this.labelData, transportLabel.labelData);
    }

    public int hashCode() {
        return Objects.hash(this.labelCreateDateTime, this.shipmentInformation, this.labelData);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TransportLabel {\n");
        sb.append("    labelCreateDateTime: ").append(this.toIndentedString(this.labelCreateDateTime)).append("\n");
        sb.append("    shipmentInformation: ").append(this.toIndentedString(this.shipmentInformation)).append("\n");
        sb.append("    labelData: ").append(this.toIndentedString(this.labelData)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

