/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.models.vendor.shipments.v1;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.IOException;
import java.util.Objects;
import org.threeten.bp.OffsetDateTime;

@Schema(description="Shipment Status details.")
public class ShipmentStatusDetails {
    @SerializedName(value="shipmentStatus")
    private ShipmentStatusEnum shipmentStatus = null;
    @SerializedName(value="shipmentStatusDate")
    private OffsetDateTime shipmentStatusDate = null;

    public ShipmentStatusDetails shipmentStatus(ShipmentStatusEnum shipmentStatus) {
        this.shipmentStatus = shipmentStatus;
        return this;
    }

    @Schema(description="Current status of the shipment on whether it is picked up or scheduled.")
    public ShipmentStatusEnum getShipmentStatus() {
        return this.shipmentStatus;
    }

    public void setShipmentStatus(ShipmentStatusEnum shipmentStatus) {
        this.shipmentStatus = shipmentStatus;
    }

    public ShipmentStatusDetails shipmentStatusDate(OffsetDateTime shipmentStatusDate) {
        this.shipmentStatusDate = shipmentStatusDate;
        return this;
    }

    @Schema(description="Date and time on last status update received for the shipment")
    public OffsetDateTime getShipmentStatusDate() {
        return this.shipmentStatusDate;
    }

    public void setShipmentStatusDate(OffsetDateTime shipmentStatusDate) {
        this.shipmentStatusDate = shipmentStatusDate;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ShipmentStatusDetails shipmentStatusDetails = (ShipmentStatusDetails)o;
        return Objects.equals((Object)this.shipmentStatus, (Object)shipmentStatusDetails.shipmentStatus) && Objects.equals(this.shipmentStatusDate, shipmentStatusDetails.shipmentStatusDate);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.shipmentStatus, this.shipmentStatusDate});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ShipmentStatusDetails {\n");
        sb.append("    shipmentStatus: ").append(this.toIndentedString((Object)this.shipmentStatus)).append("\n");
        sb.append("    shipmentStatusDate: ").append(this.toIndentedString(this.shipmentStatusDate)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum ShipmentStatusEnum {
        CREATED("Created"),
        TRANSPORTATIONREQUESTED("TransportationRequested"),
        CARRIERASSIGNED("CarrierAssigned"),
        SHIPPED("Shipped");

        private String value;

        private ShipmentStatusEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static ShipmentStatusEnum fromValue(String input) {
            for (ShipmentStatusEnum b : ShipmentStatusEnum.values()) {
                if (!b.value.equals(input)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<ShipmentStatusEnum> {
            public void write(JsonWriter jsonWriter, ShipmentStatusEnum enumeration) throws IOException {
                jsonWriter.value(String.valueOf(enumeration.getValue()));
            }

            public ShipmentStatusEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return ShipmentStatusEnum.fromValue(value);
            }
        }
    }
}

