/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.models.vendor.shipments.v1;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.IOException;
import java.util.Objects;
import software.amazon.spapi.models.vendor.shipments.v1.PartyIdentification;
import software.amazon.spapi.models.vendor.shipments.v1.VendorDetails;

@Schema(description="Shipment Information details for Label request.")
public class ShipmentInformation {
    @SerializedName(value="vendorDetails")
    private VendorDetails vendorDetails = null;
    @SerializedName(value="buyerReferenceNumber")
    private String buyerReferenceNumber = null;
    @SerializedName(value="shipToParty")
    private PartyIdentification shipToParty = null;
    @SerializedName(value="shipFromParty")
    private PartyIdentification shipFromParty = null;
    @SerializedName(value="warehouseId")
    private String warehouseId = null;
    @SerializedName(value="masterTrackingId")
    private String masterTrackingId = null;
    @SerializedName(value="totalLabelCount")
    private Integer totalLabelCount = null;
    @SerializedName(value="shipMode")
    private ShipModeEnum shipMode = null;

    public ShipmentInformation vendorDetails(VendorDetails vendorDetails) {
        this.vendorDetails = vendorDetails;
        return this;
    }

    @Schema(description="")
    public VendorDetails getVendorDetails() {
        return this.vendorDetails;
    }

    public void setVendorDetails(VendorDetails vendorDetails) {
        this.vendorDetails = vendorDetails;
    }

    public ShipmentInformation buyerReferenceNumber(String buyerReferenceNumber) {
        this.buyerReferenceNumber = buyerReferenceNumber;
        return this;
    }

    @Schema(description="The buyer reference number is a unique identifier generated by the buyer for all Collect and WePay shipments.")
    public String getBuyerReferenceNumber() {
        return this.buyerReferenceNumber;
    }

    public void setBuyerReferenceNumber(String buyerReferenceNumber) {
        this.buyerReferenceNumber = buyerReferenceNumber;
    }

    public ShipmentInformation shipToParty(PartyIdentification shipToParty) {
        this.shipToParty = shipToParty;
        return this;
    }

    @Schema(description="")
    public PartyIdentification getShipToParty() {
        return this.shipToParty;
    }

    public void setShipToParty(PartyIdentification shipToParty) {
        this.shipToParty = shipToParty;
    }

    public ShipmentInformation shipFromParty(PartyIdentification shipFromParty) {
        this.shipFromParty = shipFromParty;
        return this;
    }

    @Schema(description="")
    public PartyIdentification getShipFromParty() {
        return this.shipFromParty;
    }

    public void setShipFromParty(PartyIdentification shipFromParty) {
        this.shipFromParty = shipFromParty;
    }

    public ShipmentInformation warehouseId(String warehouseId) {
        this.warehouseId = warehouseId;
        return this;
    }

    @Schema(description="Vendor Warehouse ID from where the shipment is scheduled to be picked up by buyer / Carrier.")
    public String getWarehouseId() {
        return this.warehouseId;
    }

    public void setWarehouseId(String warehouseId) {
        this.warehouseId = warehouseId;
    }

    public ShipmentInformation masterTrackingId(String masterTrackingId) {
        this.masterTrackingId = masterTrackingId;
        return this;
    }

    @Schema(description="Unique Id with  which  the shipment can be tracked for Small Parcels.")
    public String getMasterTrackingId() {
        return this.masterTrackingId;
    }

    public void setMasterTrackingId(String masterTrackingId) {
        this.masterTrackingId = masterTrackingId;
    }

    public ShipmentInformation totalLabelCount(Integer totalLabelCount) {
        this.totalLabelCount = totalLabelCount;
        return this;
    }

    @Schema(description="Number of Labels that are created as part of this shipment.")
    public Integer getTotalLabelCount() {
        return this.totalLabelCount;
    }

    public void setTotalLabelCount(Integer totalLabelCount) {
        this.totalLabelCount = totalLabelCount;
    }

    public ShipmentInformation shipMode(ShipModeEnum shipMode) {
        this.shipMode = shipMode;
        return this;
    }

    @Schema(description="Type of shipment whether it is Small Parcel")
    public ShipModeEnum getShipMode() {
        return this.shipMode;
    }

    public void setShipMode(ShipModeEnum shipMode) {
        this.shipMode = shipMode;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ShipmentInformation shipmentInformation = (ShipmentInformation)o;
        return Objects.equals(this.vendorDetails, shipmentInformation.vendorDetails) && Objects.equals(this.buyerReferenceNumber, shipmentInformation.buyerReferenceNumber) && Objects.equals(this.shipToParty, shipmentInformation.shipToParty) && Objects.equals(this.shipFromParty, shipmentInformation.shipFromParty) && Objects.equals(this.warehouseId, shipmentInformation.warehouseId) && Objects.equals(this.masterTrackingId, shipmentInformation.masterTrackingId) && Objects.equals(this.totalLabelCount, shipmentInformation.totalLabelCount) && Objects.equals((Object)this.shipMode, (Object)shipmentInformation.shipMode);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.vendorDetails, this.buyerReferenceNumber, this.shipToParty, this.shipFromParty, this.warehouseId, this.masterTrackingId, this.totalLabelCount, this.shipMode});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ShipmentInformation {\n");
        sb.append("    vendorDetails: ").append(this.toIndentedString(this.vendorDetails)).append("\n");
        sb.append("    buyerReferenceNumber: ").append(this.toIndentedString(this.buyerReferenceNumber)).append("\n");
        sb.append("    shipToParty: ").append(this.toIndentedString(this.shipToParty)).append("\n");
        sb.append("    shipFromParty: ").append(this.toIndentedString(this.shipFromParty)).append("\n");
        sb.append("    warehouseId: ").append(this.toIndentedString(this.warehouseId)).append("\n");
        sb.append("    masterTrackingId: ").append(this.toIndentedString(this.masterTrackingId)).append("\n");
        sb.append("    totalLabelCount: ").append(this.toIndentedString(this.totalLabelCount)).append("\n");
        sb.append("    shipMode: ").append(this.toIndentedString((Object)this.shipMode)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum ShipModeEnum {
        SMALLPARCEL("SmallParcel"),
        LTL("LTL");

        private String value;

        private ShipModeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static ShipModeEnum fromValue(String input) {
            for (ShipModeEnum b : ShipModeEnum.values()) {
                if (!b.value.equals(input)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<ShipModeEnum> {
            public void write(JsonWriter jsonWriter, ShipModeEnum enumeration) throws IOException {
                jsonWriter.value(String.valueOf(enumeration.getValue()));
            }

            public ShipModeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return ShipModeEnum.fromValue(value);
            }
        }
    }
}

