/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.models.vendor.shipments.v1;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.threeten.bp.OffsetDateTime;
import software.amazon.spapi.models.vendor.shipments.v1.Carton;
import software.amazon.spapi.models.vendor.shipments.v1.ImportDetails;
import software.amazon.spapi.models.vendor.shipments.v1.Item;
import software.amazon.spapi.models.vendor.shipments.v1.Pallet;
import software.amazon.spapi.models.vendor.shipments.v1.PartyIdentification;
import software.amazon.spapi.models.vendor.shipments.v1.ShipmentMeasurements;
import software.amazon.spapi.models.vendor.shipments.v1.TransportationDetailsForShipmentConfirmation;

@Schema(description="A list of one or more shipment confirmations.")
public class ShipmentConfirmation {
    @SerializedName(value="shipmentIdentifier")
    private String shipmentIdentifier = null;
    @SerializedName(value="shipmentConfirmationType")
    private ShipmentConfirmationTypeEnum shipmentConfirmationType = null;
    @SerializedName(value="shipmentType")
    private ShipmentTypeEnum shipmentType = null;
    @SerializedName(value="shipmentStructure")
    private ShipmentStructureEnum shipmentStructure = null;
    @SerializedName(value="transportationDetails")
    private TransportationDetailsForShipmentConfirmation transportationDetails = null;
    @SerializedName(value="amazonReferenceNumber")
    private String amazonReferenceNumber = null;
    @SerializedName(value="shipmentConfirmationDate")
    private OffsetDateTime shipmentConfirmationDate = null;
    @SerializedName(value="shippedDate")
    private OffsetDateTime shippedDate = null;
    @SerializedName(value="estimatedDeliveryDate")
    private OffsetDateTime estimatedDeliveryDate = null;
    @SerializedName(value="sellingParty")
    private PartyIdentification sellingParty = null;
    @SerializedName(value="shipFromParty")
    private PartyIdentification shipFromParty = null;
    @SerializedName(value="shipToParty")
    private PartyIdentification shipToParty = null;
    @SerializedName(value="shipmentMeasurements")
    private ShipmentMeasurements shipmentMeasurements = null;
    @SerializedName(value="importDetails")
    private ImportDetails importDetails = null;
    @SerializedName(value="shippedItems")
    private List<Item> shippedItems = new ArrayList<Item>();
    @SerializedName(value="cartons")
    private List<Carton> cartons = null;
    @SerializedName(value="pallets")
    private List<Pallet> pallets = null;

    public ShipmentConfirmation shipmentIdentifier(String shipmentIdentifier) {
        this.shipmentIdentifier = shipmentIdentifier;
        return this;
    }

    @Schema(required=true, description="Unique shipment ID (not used over the last 365 days).")
    public String getShipmentIdentifier() {
        return this.shipmentIdentifier;
    }

    public void setShipmentIdentifier(String shipmentIdentifier) {
        this.shipmentIdentifier = shipmentIdentifier;
    }

    public ShipmentConfirmation shipmentConfirmationType(ShipmentConfirmationTypeEnum shipmentConfirmationType) {
        this.shipmentConfirmationType = shipmentConfirmationType;
        return this;
    }

    @Schema(required=true, description="Indicates if this shipment confirmation is the initial confirmation, or intended to replace an already posted shipment confirmation. If replacing an existing shipment confirmation, be sure to provide the identical shipmentIdentifier and sellingParty information as in the previous confirmation.")
    public ShipmentConfirmationTypeEnum getShipmentConfirmationType() {
        return this.shipmentConfirmationType;
    }

    public void setShipmentConfirmationType(ShipmentConfirmationTypeEnum shipmentConfirmationType) {
        this.shipmentConfirmationType = shipmentConfirmationType;
    }

    public ShipmentConfirmation shipmentType(ShipmentTypeEnum shipmentType) {
        this.shipmentType = shipmentType;
        return this;
    }

    @Schema(description="The type of shipment.")
    public ShipmentTypeEnum getShipmentType() {
        return this.shipmentType;
    }

    public void setShipmentType(ShipmentTypeEnum shipmentType) {
        this.shipmentType = shipmentType;
    }

    public ShipmentConfirmation shipmentStructure(ShipmentStructureEnum shipmentStructure) {
        this.shipmentStructure = shipmentStructure;
        return this;
    }

    @Schema(description="Shipment hierarchical structure.")
    public ShipmentStructureEnum getShipmentStructure() {
        return this.shipmentStructure;
    }

    public void setShipmentStructure(ShipmentStructureEnum shipmentStructure) {
        this.shipmentStructure = shipmentStructure;
    }

    public ShipmentConfirmation transportationDetails(TransportationDetailsForShipmentConfirmation transportationDetails) {
        this.transportationDetails = transportationDetails;
        return this;
    }

    @Schema(description="")
    public TransportationDetailsForShipmentConfirmation getTransportationDetails() {
        return this.transportationDetails;
    }

    public void setTransportationDetails(TransportationDetailsForShipmentConfirmation transportationDetails) {
        this.transportationDetails = transportationDetails;
    }

    public ShipmentConfirmation amazonReferenceNumber(String amazonReferenceNumber) {
        this.amazonReferenceNumber = amazonReferenceNumber;
        return this;
    }

    @Schema(description="The Amazon Reference Number is a unique identifier generated by Amazon for all Collect/WePay shipments when you submit  a routing request. This field is mandatory for Collect/WePay shipments.")
    public String getAmazonReferenceNumber() {
        return this.amazonReferenceNumber;
    }

    public void setAmazonReferenceNumber(String amazonReferenceNumber) {
        this.amazonReferenceNumber = amazonReferenceNumber;
    }

    public ShipmentConfirmation shipmentConfirmationDate(OffsetDateTime shipmentConfirmationDate) {
        this.shipmentConfirmationDate = shipmentConfirmationDate;
        return this;
    }

    @Schema(required=true, description="Date on which the shipment confirmation was submitted.")
    public OffsetDateTime getShipmentConfirmationDate() {
        return this.shipmentConfirmationDate;
    }

    public void setShipmentConfirmationDate(OffsetDateTime shipmentConfirmationDate) {
        this.shipmentConfirmationDate = shipmentConfirmationDate;
    }

    public ShipmentConfirmation shippedDate(OffsetDateTime shippedDate) {
        this.shippedDate = shippedDate;
        return this;
    }

    @Schema(description="The date and time of the departure of the shipment from the vendor's location. Vendors are requested to send ASNs within 30 minutes of departure from their warehouse/distribution center or at least 6 hours prior to the appointment time at the buyer destination warehouse, whichever is sooner. Shipped date mentioned in the shipment confirmation should not be in the future.")
    public OffsetDateTime getShippedDate() {
        return this.shippedDate;
    }

    public void setShippedDate(OffsetDateTime shippedDate) {
        this.shippedDate = shippedDate;
    }

    public ShipmentConfirmation estimatedDeliveryDate(OffsetDateTime estimatedDeliveryDate) {
        this.estimatedDeliveryDate = estimatedDeliveryDate;
        return this;
    }

    @Schema(description="The date and time on which the shipment is estimated to reach buyer's warehouse. It needs to be an estimate based on the average transit time between ship from location and the destination. The exact appointment time will be provided by the buyer and is potentially not known when creating the shipment confirmation.")
    public OffsetDateTime getEstimatedDeliveryDate() {
        return this.estimatedDeliveryDate;
    }

    public void setEstimatedDeliveryDate(OffsetDateTime estimatedDeliveryDate) {
        this.estimatedDeliveryDate = estimatedDeliveryDate;
    }

    public ShipmentConfirmation sellingParty(PartyIdentification sellingParty) {
        this.sellingParty = sellingParty;
        return this;
    }

    @Schema(required=true, description="")
    public PartyIdentification getSellingParty() {
        return this.sellingParty;
    }

    public void setSellingParty(PartyIdentification sellingParty) {
        this.sellingParty = sellingParty;
    }

    public ShipmentConfirmation shipFromParty(PartyIdentification shipFromParty) {
        this.shipFromParty = shipFromParty;
        return this;
    }

    @Schema(required=true, description="")
    public PartyIdentification getShipFromParty() {
        return this.shipFromParty;
    }

    public void setShipFromParty(PartyIdentification shipFromParty) {
        this.shipFromParty = shipFromParty;
    }

    public ShipmentConfirmation shipToParty(PartyIdentification shipToParty) {
        this.shipToParty = shipToParty;
        return this;
    }

    @Schema(required=true, description="")
    public PartyIdentification getShipToParty() {
        return this.shipToParty;
    }

    public void setShipToParty(PartyIdentification shipToParty) {
        this.shipToParty = shipToParty;
    }

    public ShipmentConfirmation shipmentMeasurements(ShipmentMeasurements shipmentMeasurements) {
        this.shipmentMeasurements = shipmentMeasurements;
        return this;
    }

    @Schema(description="")
    public ShipmentMeasurements getShipmentMeasurements() {
        return this.shipmentMeasurements;
    }

    public void setShipmentMeasurements(ShipmentMeasurements shipmentMeasurements) {
        this.shipmentMeasurements = shipmentMeasurements;
    }

    public ShipmentConfirmation importDetails(ImportDetails importDetails) {
        this.importDetails = importDetails;
        return this;
    }

    @Schema(description="")
    public ImportDetails getImportDetails() {
        return this.importDetails;
    }

    public void setImportDetails(ImportDetails importDetails) {
        this.importDetails = importDetails;
    }

    public ShipmentConfirmation shippedItems(List<Item> shippedItems) {
        this.shippedItems = shippedItems;
        return this;
    }

    public ShipmentConfirmation addShippedItemsItem(Item shippedItemsItem) {
        this.shippedItems.add(shippedItemsItem);
        return this;
    }

    @Schema(required=true, description="A list of the items in this shipment and their associated details. If any of the item detail fields are common at a carton or a pallet level, provide them at the corresponding carton or pallet level.")
    public List<Item> getShippedItems() {
        return this.shippedItems;
    }

    public void setShippedItems(List<Item> shippedItems) {
        this.shippedItems = shippedItems;
    }

    public ShipmentConfirmation cartons(List<Carton> cartons) {
        this.cartons = cartons;
        return this;
    }

    public ShipmentConfirmation addCartonsItem(Carton cartonsItem) {
        if (this.cartons == null) {
            this.cartons = new ArrayList<Carton>();
        }
        this.cartons.add(cartonsItem);
        return this;
    }

    @Schema(description="A list of the cartons in this shipment.")
    public List<Carton> getCartons() {
        return this.cartons;
    }

    public void setCartons(List<Carton> cartons) {
        this.cartons = cartons;
    }

    public ShipmentConfirmation pallets(List<Pallet> pallets) {
        this.pallets = pallets;
        return this;
    }

    public ShipmentConfirmation addPalletsItem(Pallet palletsItem) {
        if (this.pallets == null) {
            this.pallets = new ArrayList<Pallet>();
        }
        this.pallets.add(palletsItem);
        return this;
    }

    @Schema(description="A list of the pallets in this shipment.")
    public List<Pallet> getPallets() {
        return this.pallets;
    }

    public void setPallets(List<Pallet> pallets) {
        this.pallets = pallets;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ShipmentConfirmation shipmentConfirmation = (ShipmentConfirmation)o;
        return Objects.equals(this.shipmentIdentifier, shipmentConfirmation.shipmentIdentifier) && Objects.equals((Object)this.shipmentConfirmationType, (Object)shipmentConfirmation.shipmentConfirmationType) && Objects.equals((Object)this.shipmentType, (Object)shipmentConfirmation.shipmentType) && Objects.equals((Object)this.shipmentStructure, (Object)shipmentConfirmation.shipmentStructure) && Objects.equals(this.transportationDetails, shipmentConfirmation.transportationDetails) && Objects.equals(this.amazonReferenceNumber, shipmentConfirmation.amazonReferenceNumber) && Objects.equals(this.shipmentConfirmationDate, shipmentConfirmation.shipmentConfirmationDate) && Objects.equals(this.shippedDate, shipmentConfirmation.shippedDate) && Objects.equals(this.estimatedDeliveryDate, shipmentConfirmation.estimatedDeliveryDate) && Objects.equals(this.sellingParty, shipmentConfirmation.sellingParty) && Objects.equals(this.shipFromParty, shipmentConfirmation.shipFromParty) && Objects.equals(this.shipToParty, shipmentConfirmation.shipToParty) && Objects.equals(this.shipmentMeasurements, shipmentConfirmation.shipmentMeasurements) && Objects.equals(this.importDetails, shipmentConfirmation.importDetails) && Objects.equals(this.shippedItems, shipmentConfirmation.shippedItems) && Objects.equals(this.cartons, shipmentConfirmation.cartons) && Objects.equals(this.pallets, shipmentConfirmation.pallets);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.shipmentIdentifier, this.shipmentConfirmationType, this.shipmentType, this.shipmentStructure, this.transportationDetails, this.amazonReferenceNumber, this.shipmentConfirmationDate, this.shippedDate, this.estimatedDeliveryDate, this.sellingParty, this.shipFromParty, this.shipToParty, this.shipmentMeasurements, this.importDetails, this.shippedItems, this.cartons, this.pallets});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ShipmentConfirmation {\n");
        sb.append("    shipmentIdentifier: ").append(this.toIndentedString(this.shipmentIdentifier)).append("\n");
        sb.append("    shipmentConfirmationType: ").append(this.toIndentedString((Object)this.shipmentConfirmationType)).append("\n");
        sb.append("    shipmentType: ").append(this.toIndentedString((Object)this.shipmentType)).append("\n");
        sb.append("    shipmentStructure: ").append(this.toIndentedString((Object)this.shipmentStructure)).append("\n");
        sb.append("    transportationDetails: ").append(this.toIndentedString(this.transportationDetails)).append("\n");
        sb.append("    amazonReferenceNumber: ").append(this.toIndentedString(this.amazonReferenceNumber)).append("\n");
        sb.append("    shipmentConfirmationDate: ").append(this.toIndentedString(this.shipmentConfirmationDate)).append("\n");
        sb.append("    shippedDate: ").append(this.toIndentedString(this.shippedDate)).append("\n");
        sb.append("    estimatedDeliveryDate: ").append(this.toIndentedString(this.estimatedDeliveryDate)).append("\n");
        sb.append("    sellingParty: ").append(this.toIndentedString(this.sellingParty)).append("\n");
        sb.append("    shipFromParty: ").append(this.toIndentedString(this.shipFromParty)).append("\n");
        sb.append("    shipToParty: ").append(this.toIndentedString(this.shipToParty)).append("\n");
        sb.append("    shipmentMeasurements: ").append(this.toIndentedString(this.shipmentMeasurements)).append("\n");
        sb.append("    importDetails: ").append(this.toIndentedString(this.importDetails)).append("\n");
        sb.append("    shippedItems: ").append(this.toIndentedString(this.shippedItems)).append("\n");
        sb.append("    cartons: ").append(this.toIndentedString(this.cartons)).append("\n");
        sb.append("    pallets: ").append(this.toIndentedString(this.pallets)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum ShipmentStructureEnum {
        PALLETIZEDASSORTMENTCASE("PalletizedAssortmentCase"),
        LOOSEASSORTMENTCASE("LooseAssortmentCase"),
        PALLETOFITEMS("PalletOfItems"),
        PALLETIZEDSTANDARDCASE("PalletizedStandardCase"),
        LOOSESTANDARDCASE("LooseStandardCase"),
        MASTERPALLET("MasterPallet"),
        MASTERCASE("MasterCase");

        private String value;

        private ShipmentStructureEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static ShipmentStructureEnum fromValue(String input) {
            for (ShipmentStructureEnum b : ShipmentStructureEnum.values()) {
                if (!b.value.equals(input)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<ShipmentStructureEnum> {
            public void write(JsonWriter jsonWriter, ShipmentStructureEnum enumeration) throws IOException {
                jsonWriter.value(String.valueOf(enumeration.getValue()));
            }

            public ShipmentStructureEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return ShipmentStructureEnum.fromValue(value);
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum ShipmentTypeEnum {
        TRUCKLOAD("TruckLoad"),
        LESSTHANTRUCKLOAD("LessThanTruckLoad"),
        SMALLPARCEL("SmallParcel");

        private String value;

        private ShipmentTypeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static ShipmentTypeEnum fromValue(String input) {
            for (ShipmentTypeEnum b : ShipmentTypeEnum.values()) {
                if (!b.value.equals(input)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<ShipmentTypeEnum> {
            public void write(JsonWriter jsonWriter, ShipmentTypeEnum enumeration) throws IOException {
                jsonWriter.value(String.valueOf(enumeration.getValue()));
            }

            public ShipmentTypeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return ShipmentTypeEnum.fromValue(value);
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum ShipmentConfirmationTypeEnum {
        ORIGINAL("Original"),
        REPLACE("Replace");

        private String value;

        private ShipmentConfirmationTypeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static ShipmentConfirmationTypeEnum fromValue(String input) {
            for (ShipmentConfirmationTypeEnum b : ShipmentConfirmationTypeEnum.values()) {
                if (!b.value.equals(input)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<ShipmentConfirmationTypeEnum> {
            public void write(JsonWriter jsonWriter, ShipmentConfirmationTypeEnum enumeration) throws IOException {
                jsonWriter.value(String.valueOf(enumeration.getValue()));
            }

            public ShipmentConfirmationTypeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return ShipmentConfirmationTypeEnum.fromValue(value);
            }
        }
    }
}

