/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.models.vendor.shipments.v1;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.threeten.bp.OffsetDateTime;
import software.amazon.spapi.models.vendor.shipments.v1.CollectFreightPickupDetails;
import software.amazon.spapi.models.vendor.shipments.v1.Containers;
import software.amazon.spapi.models.vendor.shipments.v1.ImportDetails;
import software.amazon.spapi.models.vendor.shipments.v1.PartyIdentification;
import software.amazon.spapi.models.vendor.shipments.v1.PurchaseOrders;
import software.amazon.spapi.models.vendor.shipments.v1.ShipmentStatusDetails;
import software.amazon.spapi.models.vendor.shipments.v1.TransportShipmentMeasurements;
import software.amazon.spapi.models.vendor.shipments.v1.TransportationDetails;

@Schema(description="A list of one or more shipments with respective details.")
public class Shipment {
    @SerializedName(value="vendorShipmentIdentifier")
    private String vendorShipmentIdentifier = null;
    @SerializedName(value="transactionType")
    private TransactionTypeEnum transactionType = null;
    @SerializedName(value="buyerReferenceNumber")
    private String buyerReferenceNumber = null;
    @SerializedName(value="transactionDate")
    private OffsetDateTime transactionDate = null;
    @SerializedName(value="currentShipmentStatus")
    private CurrentShipmentStatusEnum currentShipmentStatus = null;
    @SerializedName(value="currentshipmentStatusDate")
    private OffsetDateTime currentshipmentStatusDate = null;
    @SerializedName(value="shipmentStatusDetails")
    private List<ShipmentStatusDetails> shipmentStatusDetails = null;
    @SerializedName(value="shipmentCreateDate")
    private OffsetDateTime shipmentCreateDate = null;
    @SerializedName(value="shipmentConfirmDate")
    private OffsetDateTime shipmentConfirmDate = null;
    @SerializedName(value="packageLabelCreateDate")
    private OffsetDateTime packageLabelCreateDate = null;
    @SerializedName(value="shipmentFreightTerm")
    private ShipmentFreightTermEnum shipmentFreightTerm = null;
    @SerializedName(value="sellingParty")
    private PartyIdentification sellingParty = null;
    @SerializedName(value="shipFromParty")
    private PartyIdentification shipFromParty = null;
    @SerializedName(value="shipToParty")
    private PartyIdentification shipToParty = null;
    @SerializedName(value="shipmentMeasurements")
    private TransportShipmentMeasurements shipmentMeasurements = null;
    @SerializedName(value="collectFreightPickupDetails")
    private CollectFreightPickupDetails collectFreightPickupDetails = null;
    @SerializedName(value="purchaseOrders")
    private List<PurchaseOrders> purchaseOrders = null;
    @SerializedName(value="importDetails")
    private ImportDetails importDetails = null;
    @SerializedName(value="containers")
    private List<Containers> containers = null;
    @SerializedName(value="transportationDetails")
    private TransportationDetails transportationDetails = null;

    public Shipment vendorShipmentIdentifier(String vendorShipmentIdentifier) {
        this.vendorShipmentIdentifier = vendorShipmentIdentifier;
        return this;
    }

    @Schema(required=true, description="Unique Transportation ID created by Vendor (Should not be used over the last 365 days).")
    public String getVendorShipmentIdentifier() {
        return this.vendorShipmentIdentifier;
    }

    public void setVendorShipmentIdentifier(String vendorShipmentIdentifier) {
        this.vendorShipmentIdentifier = vendorShipmentIdentifier;
    }

    public Shipment transactionType(TransactionTypeEnum transactionType) {
        this.transactionType = transactionType;
        return this;
    }

    @Schema(required=true, description="Indicates the type of transportation request (for example, `New` or `Cancel`). Each `transactionType` has a unique set of operations and there are corresponding details to be populated for each operation.")
    public TransactionTypeEnum getTransactionType() {
        return this.transactionType;
    }

    public void setTransactionType(TransactionTypeEnum transactionType) {
        this.transactionType = transactionType;
    }

    public Shipment buyerReferenceNumber(String buyerReferenceNumber) {
        this.buyerReferenceNumber = buyerReferenceNumber;
        return this;
    }

    @Schema(description="The buyer Reference Number is a unique identifier generated by buyer for all Collect/WePay shipments when you submit a transportation request. This field is mandatory for Collect/WePay shipments.")
    public String getBuyerReferenceNumber() {
        return this.buyerReferenceNumber;
    }

    public void setBuyerReferenceNumber(String buyerReferenceNumber) {
        this.buyerReferenceNumber = buyerReferenceNumber;
    }

    public Shipment transactionDate(OffsetDateTime transactionDate) {
        this.transactionDate = transactionDate;
        return this;
    }

    @Schema(required=true, description="Date on which the transportation request was submitted.")
    public OffsetDateTime getTransactionDate() {
        return this.transactionDate;
    }

    public void setTransactionDate(OffsetDateTime transactionDate) {
        this.transactionDate = transactionDate;
    }

    public Shipment currentShipmentStatus(CurrentShipmentStatusEnum currentShipmentStatus) {
        this.currentShipmentStatus = currentShipmentStatus;
        return this;
    }

    @Schema(description="Indicates the current shipment status.")
    public CurrentShipmentStatusEnum getCurrentShipmentStatus() {
        return this.currentShipmentStatus;
    }

    public void setCurrentShipmentStatus(CurrentShipmentStatusEnum currentShipmentStatus) {
        this.currentShipmentStatus = currentShipmentStatus;
    }

    public Shipment currentshipmentStatusDate(OffsetDateTime currentshipmentStatusDate) {
        this.currentshipmentStatusDate = currentshipmentStatusDate;
        return this;
    }

    @Schema(description="Date and time when the last status was updated.")
    public OffsetDateTime getCurrentshipmentStatusDate() {
        return this.currentshipmentStatusDate;
    }

    public void setCurrentshipmentStatusDate(OffsetDateTime currentshipmentStatusDate) {
        this.currentshipmentStatusDate = currentshipmentStatusDate;
    }

    public Shipment shipmentStatusDetails(List<ShipmentStatusDetails> shipmentStatusDetails) {
        this.shipmentStatusDetails = shipmentStatusDetails;
        return this;
    }

    public Shipment addShipmentStatusDetailsItem(ShipmentStatusDetails shipmentStatusDetailsItem) {
        if (this.shipmentStatusDetails == null) {
            this.shipmentStatusDetails = new ArrayList<ShipmentStatusDetails>();
        }
        this.shipmentStatusDetails.add(shipmentStatusDetailsItem);
        return this;
    }

    @Schema(description="Indicates the list of current shipment status details and when the last update was received from carrier this is available on shipment Details response.")
    public List<ShipmentStatusDetails> getShipmentStatusDetails() {
        return this.shipmentStatusDetails;
    }

    public void setShipmentStatusDetails(List<ShipmentStatusDetails> shipmentStatusDetails) {
        this.shipmentStatusDetails = shipmentStatusDetails;
    }

    public Shipment shipmentCreateDate(OffsetDateTime shipmentCreateDate) {
        this.shipmentCreateDate = shipmentCreateDate;
        return this;
    }

    @Schema(description="The date and time of the shipment request created by vendor.")
    public OffsetDateTime getShipmentCreateDate() {
        return this.shipmentCreateDate;
    }

    public void setShipmentCreateDate(OffsetDateTime shipmentCreateDate) {
        this.shipmentCreateDate = shipmentCreateDate;
    }

    public Shipment shipmentConfirmDate(OffsetDateTime shipmentConfirmDate) {
        this.shipmentConfirmDate = shipmentConfirmDate;
        return this;
    }

    @Schema(description="The date and time of the departure of the shipment from the vendor's location. Vendors are requested to send ASNs within 30 minutes of departure from their warehouse/distribution center or at least 6 hours prior to the appointment time at the Buyer destination warehouse, whichever is sooner. Shipped date mentioned in the shipment confirmation should not be in the future.")
    public OffsetDateTime getShipmentConfirmDate() {
        return this.shipmentConfirmDate;
    }

    public void setShipmentConfirmDate(OffsetDateTime shipmentConfirmDate) {
        this.shipmentConfirmDate = shipmentConfirmDate;
    }

    public Shipment packageLabelCreateDate(OffsetDateTime packageLabelCreateDate) {
        this.packageLabelCreateDate = packageLabelCreateDate;
        return this;
    }

    @Schema(description="The date and time of the package label created for the shipment by buyer.")
    public OffsetDateTime getPackageLabelCreateDate() {
        return this.packageLabelCreateDate;
    }

    public void setPackageLabelCreateDate(OffsetDateTime packageLabelCreateDate) {
        this.packageLabelCreateDate = packageLabelCreateDate;
    }

    public Shipment shipmentFreightTerm(ShipmentFreightTermEnum shipmentFreightTerm) {
        this.shipmentFreightTerm = shipmentFreightTerm;
        return this;
    }

    @Schema(description="Specifies if payment is Collect (WePay) or Prepaid (TheyPay). Required.")
    public ShipmentFreightTermEnum getShipmentFreightTerm() {
        return this.shipmentFreightTerm;
    }

    public void setShipmentFreightTerm(ShipmentFreightTermEnum shipmentFreightTerm) {
        this.shipmentFreightTerm = shipmentFreightTerm;
    }

    public Shipment sellingParty(PartyIdentification sellingParty) {
        this.sellingParty = sellingParty;
        return this;
    }

    @Schema(required=true, description="")
    public PartyIdentification getSellingParty() {
        return this.sellingParty;
    }

    public void setSellingParty(PartyIdentification sellingParty) {
        this.sellingParty = sellingParty;
    }

    public Shipment shipFromParty(PartyIdentification shipFromParty) {
        this.shipFromParty = shipFromParty;
        return this;
    }

    @Schema(required=true, description="")
    public PartyIdentification getShipFromParty() {
        return this.shipFromParty;
    }

    public void setShipFromParty(PartyIdentification shipFromParty) {
        this.shipFromParty = shipFromParty;
    }

    public Shipment shipToParty(PartyIdentification shipToParty) {
        this.shipToParty = shipToParty;
        return this;
    }

    @Schema(required=true, description="")
    public PartyIdentification getShipToParty() {
        return this.shipToParty;
    }

    public void setShipToParty(PartyIdentification shipToParty) {
        this.shipToParty = shipToParty;
    }

    public Shipment shipmentMeasurements(TransportShipmentMeasurements shipmentMeasurements) {
        this.shipmentMeasurements = shipmentMeasurements;
        return this;
    }

    @Schema(description="")
    public TransportShipmentMeasurements getShipmentMeasurements() {
        return this.shipmentMeasurements;
    }

    public void setShipmentMeasurements(TransportShipmentMeasurements shipmentMeasurements) {
        this.shipmentMeasurements = shipmentMeasurements;
    }

    public Shipment collectFreightPickupDetails(CollectFreightPickupDetails collectFreightPickupDetails) {
        this.collectFreightPickupDetails = collectFreightPickupDetails;
        return this;
    }

    @Schema(description="")
    public CollectFreightPickupDetails getCollectFreightPickupDetails() {
        return this.collectFreightPickupDetails;
    }

    public void setCollectFreightPickupDetails(CollectFreightPickupDetails collectFreightPickupDetails) {
        this.collectFreightPickupDetails = collectFreightPickupDetails;
    }

    public Shipment purchaseOrders(List<PurchaseOrders> purchaseOrders) {
        this.purchaseOrders = purchaseOrders;
        return this;
    }

    public Shipment addPurchaseOrdersItem(PurchaseOrders purchaseOrdersItem) {
        if (this.purchaseOrders == null) {
            this.purchaseOrders = new ArrayList<PurchaseOrders>();
        }
        this.purchaseOrders.add(purchaseOrdersItem);
        return this;
    }

    @Schema(description="Indicates the purchase orders involved for the transportation request. This group is an array create 1 for each PO and list their corresponding items. This information is used for deciding the route,truck allocation and storage efficiently. This is a mandatory information for Buyer performing transportation from vendor warehouse (WePay/Collect)")
    public List<PurchaseOrders> getPurchaseOrders() {
        return this.purchaseOrders;
    }

    public void setPurchaseOrders(List<PurchaseOrders> purchaseOrders) {
        this.purchaseOrders = purchaseOrders;
    }

    public Shipment importDetails(ImportDetails importDetails) {
        this.importDetails = importDetails;
        return this;
    }

    @Schema(description="")
    public ImportDetails getImportDetails() {
        return this.importDetails;
    }

    public void setImportDetails(ImportDetails importDetails) {
        this.importDetails = importDetails;
    }

    public Shipment containers(List<Containers> containers) {
        this.containers = containers;
        return this;
    }

    public Shipment addContainersItem(Containers containersItem) {
        if (this.containers == null) {
            this.containers = new ArrayList<Containers>();
        }
        this.containers.add(containersItem);
        return this;
    }

    @Schema(description="A list of the items in this transportation and their associated inner container details. If any of the item detail fields are common at a carton or a pallet level, provide them at the corresponding carton or pallet level.")
    public List<Containers> getContainers() {
        return this.containers;
    }

    public void setContainers(List<Containers> containers) {
        this.containers = containers;
    }

    public Shipment transportationDetails(TransportationDetails transportationDetails) {
        this.transportationDetails = transportationDetails;
        return this;
    }

    @Schema(description="")
    public TransportationDetails getTransportationDetails() {
        return this.transportationDetails;
    }

    public void setTransportationDetails(TransportationDetails transportationDetails) {
        this.transportationDetails = transportationDetails;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Shipment shipment = (Shipment)o;
        return Objects.equals(this.vendorShipmentIdentifier, shipment.vendorShipmentIdentifier) && Objects.equals((Object)this.transactionType, (Object)shipment.transactionType) && Objects.equals(this.buyerReferenceNumber, shipment.buyerReferenceNumber) && Objects.equals(this.transactionDate, shipment.transactionDate) && Objects.equals((Object)this.currentShipmentStatus, (Object)shipment.currentShipmentStatus) && Objects.equals(this.currentshipmentStatusDate, shipment.currentshipmentStatusDate) && Objects.equals(this.shipmentStatusDetails, shipment.shipmentStatusDetails) && Objects.equals(this.shipmentCreateDate, shipment.shipmentCreateDate) && Objects.equals(this.shipmentConfirmDate, shipment.shipmentConfirmDate) && Objects.equals(this.packageLabelCreateDate, shipment.packageLabelCreateDate) && Objects.equals((Object)this.shipmentFreightTerm, (Object)shipment.shipmentFreightTerm) && Objects.equals(this.sellingParty, shipment.sellingParty) && Objects.equals(this.shipFromParty, shipment.shipFromParty) && Objects.equals(this.shipToParty, shipment.shipToParty) && Objects.equals(this.shipmentMeasurements, shipment.shipmentMeasurements) && Objects.equals(this.collectFreightPickupDetails, shipment.collectFreightPickupDetails) && Objects.equals(this.purchaseOrders, shipment.purchaseOrders) && Objects.equals(this.importDetails, shipment.importDetails) && Objects.equals(this.containers, shipment.containers) && Objects.equals(this.transportationDetails, shipment.transportationDetails);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.vendorShipmentIdentifier, this.transactionType, this.buyerReferenceNumber, this.transactionDate, this.currentShipmentStatus, this.currentshipmentStatusDate, this.shipmentStatusDetails, this.shipmentCreateDate, this.shipmentConfirmDate, this.packageLabelCreateDate, this.shipmentFreightTerm, this.sellingParty, this.shipFromParty, this.shipToParty, this.shipmentMeasurements, this.collectFreightPickupDetails, this.purchaseOrders, this.importDetails, this.containers, this.transportationDetails});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Shipment {\n");
        sb.append("    vendorShipmentIdentifier: ").append(this.toIndentedString(this.vendorShipmentIdentifier)).append("\n");
        sb.append("    transactionType: ").append(this.toIndentedString((Object)this.transactionType)).append("\n");
        sb.append("    buyerReferenceNumber: ").append(this.toIndentedString(this.buyerReferenceNumber)).append("\n");
        sb.append("    transactionDate: ").append(this.toIndentedString(this.transactionDate)).append("\n");
        sb.append("    currentShipmentStatus: ").append(this.toIndentedString((Object)this.currentShipmentStatus)).append("\n");
        sb.append("    currentshipmentStatusDate: ").append(this.toIndentedString(this.currentshipmentStatusDate)).append("\n");
        sb.append("    shipmentStatusDetails: ").append(this.toIndentedString(this.shipmentStatusDetails)).append("\n");
        sb.append("    shipmentCreateDate: ").append(this.toIndentedString(this.shipmentCreateDate)).append("\n");
        sb.append("    shipmentConfirmDate: ").append(this.toIndentedString(this.shipmentConfirmDate)).append("\n");
        sb.append("    packageLabelCreateDate: ").append(this.toIndentedString(this.packageLabelCreateDate)).append("\n");
        sb.append("    shipmentFreightTerm: ").append(this.toIndentedString((Object)this.shipmentFreightTerm)).append("\n");
        sb.append("    sellingParty: ").append(this.toIndentedString(this.sellingParty)).append("\n");
        sb.append("    shipFromParty: ").append(this.toIndentedString(this.shipFromParty)).append("\n");
        sb.append("    shipToParty: ").append(this.toIndentedString(this.shipToParty)).append("\n");
        sb.append("    shipmentMeasurements: ").append(this.toIndentedString(this.shipmentMeasurements)).append("\n");
        sb.append("    collectFreightPickupDetails: ").append(this.toIndentedString(this.collectFreightPickupDetails)).append("\n");
        sb.append("    purchaseOrders: ").append(this.toIndentedString(this.purchaseOrders)).append("\n");
        sb.append("    importDetails: ").append(this.toIndentedString(this.importDetails)).append("\n");
        sb.append("    containers: ").append(this.toIndentedString(this.containers)).append("\n");
        sb.append("    transportationDetails: ").append(this.toIndentedString(this.transportationDetails)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum ShipmentFreightTermEnum {
        COLLECT("Collect"),
        PREPAID("Prepaid");

        private String value;

        private ShipmentFreightTermEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static ShipmentFreightTermEnum fromValue(String input) {
            for (ShipmentFreightTermEnum b : ShipmentFreightTermEnum.values()) {
                if (!b.value.equals(input)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<ShipmentFreightTermEnum> {
            public void write(JsonWriter jsonWriter, ShipmentFreightTermEnum enumeration) throws IOException {
                jsonWriter.value(String.valueOf(enumeration.getValue()));
            }

            public ShipmentFreightTermEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return ShipmentFreightTermEnum.fromValue(value);
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum CurrentShipmentStatusEnum {
        CREATED("Created"),
        TRANSPORTATIONREQUESTED("TransportationRequested"),
        CARRIERASSIGNED("CarrierAssigned"),
        SHIPPED("Shipped");

        private String value;

        private CurrentShipmentStatusEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static CurrentShipmentStatusEnum fromValue(String input) {
            for (CurrentShipmentStatusEnum b : CurrentShipmentStatusEnum.values()) {
                if (!b.value.equals(input)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<CurrentShipmentStatusEnum> {
            public void write(JsonWriter jsonWriter, CurrentShipmentStatusEnum enumeration) throws IOException {
                jsonWriter.value(String.valueOf(enumeration.getValue()));
            }

            public CurrentShipmentStatusEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return CurrentShipmentStatusEnum.fromValue(value);
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum TransactionTypeEnum {
        NEW("New"),
        CANCEL("Cancel");

        private String value;

        private TransactionTypeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static TransactionTypeEnum fromValue(String input) {
            for (TransactionTypeEnum b : TransactionTypeEnum.values()) {
                if (!b.value.equals(input)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<TransactionTypeEnum> {
            public void write(JsonWriter jsonWriter, TransactionTypeEnum enumeration) throws IOException {
                jsonWriter.value(String.valueOf(enumeration.getValue()));
            }

            public TransactionTypeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return TransactionTypeEnum.fromValue(value);
            }
        }
    }
}

