/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.models.vendor.shipments.v1;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import software.amazon.spapi.models.vendor.shipments.v1.ItemQuantity;
import software.amazon.spapi.models.vendor.shipments.v1.Money;

@Schema(description="Details of the item being shipped.")
public class PurchaseOrderItems {
    @SerializedName(value="itemSequenceNumber")
    private String itemSequenceNumber = null;
    @SerializedName(value="buyerProductIdentifier")
    private String buyerProductIdentifier = null;
    @SerializedName(value="vendorProductIdentifier")
    private String vendorProductIdentifier = null;
    @SerializedName(value="shippedQuantity")
    private ItemQuantity shippedQuantity = null;
    @SerializedName(value="maximumRetailPrice")
    private Money maximumRetailPrice = null;

    public PurchaseOrderItems itemSequenceNumber(String itemSequenceNumber) {
        this.itemSequenceNumber = itemSequenceNumber;
        return this;
    }

    @Schema(required=true, description="Item sequence number for the item. The first item will be 001, the second 002, and so on. This number is used as a reference to refer to this item from the carton or pallet level.")
    public String getItemSequenceNumber() {
        return this.itemSequenceNumber;
    }

    public void setItemSequenceNumber(String itemSequenceNumber) {
        this.itemSequenceNumber = itemSequenceNumber;
    }

    public PurchaseOrderItems buyerProductIdentifier(String buyerProductIdentifier) {
        this.buyerProductIdentifier = buyerProductIdentifier;
        return this;
    }

    @Schema(description="Amazon Standard Identification Number (ASIN) for a SKU")
    public String getBuyerProductIdentifier() {
        return this.buyerProductIdentifier;
    }

    public void setBuyerProductIdentifier(String buyerProductIdentifier) {
        this.buyerProductIdentifier = buyerProductIdentifier;
    }

    public PurchaseOrderItems vendorProductIdentifier(String vendorProductIdentifier) {
        this.vendorProductIdentifier = vendorProductIdentifier;
        return this;
    }

    @Schema(description="The vendor selected product identification of the item. Should be the same as was sent in the purchase order.")
    public String getVendorProductIdentifier() {
        return this.vendorProductIdentifier;
    }

    public void setVendorProductIdentifier(String vendorProductIdentifier) {
        this.vendorProductIdentifier = vendorProductIdentifier;
    }

    public PurchaseOrderItems shippedQuantity(ItemQuantity shippedQuantity) {
        this.shippedQuantity = shippedQuantity;
        return this;
    }

    @Schema(required=true, description="")
    public ItemQuantity getShippedQuantity() {
        return this.shippedQuantity;
    }

    public void setShippedQuantity(ItemQuantity shippedQuantity) {
        this.shippedQuantity = shippedQuantity;
    }

    public PurchaseOrderItems maximumRetailPrice(Money maximumRetailPrice) {
        this.maximumRetailPrice = maximumRetailPrice;
        return this;
    }

    @Schema(description="")
    public Money getMaximumRetailPrice() {
        return this.maximumRetailPrice;
    }

    public void setMaximumRetailPrice(Money maximumRetailPrice) {
        this.maximumRetailPrice = maximumRetailPrice;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PurchaseOrderItems purchaseOrderItems = (PurchaseOrderItems)o;
        return Objects.equals(this.itemSequenceNumber, purchaseOrderItems.itemSequenceNumber) && Objects.equals(this.buyerProductIdentifier, purchaseOrderItems.buyerProductIdentifier) && Objects.equals(this.vendorProductIdentifier, purchaseOrderItems.vendorProductIdentifier) && Objects.equals(this.shippedQuantity, purchaseOrderItems.shippedQuantity) && Objects.equals(this.maximumRetailPrice, purchaseOrderItems.maximumRetailPrice);
    }

    public int hashCode() {
        return Objects.hash(this.itemSequenceNumber, this.buyerProductIdentifier, this.vendorProductIdentifier, this.shippedQuantity, this.maximumRetailPrice);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PurchaseOrderItems {\n");
        sb.append("    itemSequenceNumber: ").append(this.toIndentedString(this.itemSequenceNumber)).append("\n");
        sb.append("    buyerProductIdentifier: ").append(this.toIndentedString(this.buyerProductIdentifier)).append("\n");
        sb.append("    vendorProductIdentifier: ").append(this.toIndentedString(this.vendorProductIdentifier)).append("\n");
        sb.append("    shippedQuantity: ").append(this.toIndentedString(this.shippedQuantity)).append("\n");
        sb.append("    maximumRetailPrice: ").append(this.toIndentedString(this.maximumRetailPrice)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

