/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.models.vendor.shipments.v1;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import software.amazon.spapi.models.vendor.shipments.v1.ItemQuantity;
import software.amazon.spapi.models.vendor.shipments.v1.PackageItemDetails;

@Schema(description="Details of the item being shipped.")
public class PackedItems {
    @SerializedName(value="itemSequenceNumber")
    private String itemSequenceNumber = null;
    @SerializedName(value="buyerProductIdentifier")
    private String buyerProductIdentifier = null;
    @SerializedName(value="vendorProductIdentifier")
    private String vendorProductIdentifier = null;
    @SerializedName(value="packedQuantity")
    private ItemQuantity packedQuantity = null;
    @SerializedName(value="itemDetails")
    private PackageItemDetails itemDetails = null;

    public PackedItems itemSequenceNumber(String itemSequenceNumber) {
        this.itemSequenceNumber = itemSequenceNumber;
        return this;
    }

    @Schema(description="Item sequence number for the item. The first item will be 001, the second 002, and so on. This number is used as a reference to refer to this item from the carton or pallet level.")
    public String getItemSequenceNumber() {
        return this.itemSequenceNumber;
    }

    public void setItemSequenceNumber(String itemSequenceNumber) {
        this.itemSequenceNumber = itemSequenceNumber;
    }

    public PackedItems buyerProductIdentifier(String buyerProductIdentifier) {
        this.buyerProductIdentifier = buyerProductIdentifier;
        return this;
    }

    @Schema(description="Buyer Standard Identification Number (ASIN) of an item.")
    public String getBuyerProductIdentifier() {
        return this.buyerProductIdentifier;
    }

    public void setBuyerProductIdentifier(String buyerProductIdentifier) {
        this.buyerProductIdentifier = buyerProductIdentifier;
    }

    public PackedItems vendorProductIdentifier(String vendorProductIdentifier) {
        this.vendorProductIdentifier = vendorProductIdentifier;
        return this;
    }

    @Schema(description="The vendor selected product identification of the item. Should be the same as was sent in the purchase order.")
    public String getVendorProductIdentifier() {
        return this.vendorProductIdentifier;
    }

    public void setVendorProductIdentifier(String vendorProductIdentifier) {
        this.vendorProductIdentifier = vendorProductIdentifier;
    }

    public PackedItems packedQuantity(ItemQuantity packedQuantity) {
        this.packedQuantity = packedQuantity;
        return this;
    }

    @Schema(description="")
    public ItemQuantity getPackedQuantity() {
        return this.packedQuantity;
    }

    public void setPackedQuantity(ItemQuantity packedQuantity) {
        this.packedQuantity = packedQuantity;
    }

    public PackedItems itemDetails(PackageItemDetails itemDetails) {
        this.itemDetails = itemDetails;
        return this;
    }

    @Schema(description="")
    public PackageItemDetails getItemDetails() {
        return this.itemDetails;
    }

    public void setItemDetails(PackageItemDetails itemDetails) {
        this.itemDetails = itemDetails;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PackedItems packedItems = (PackedItems)o;
        return Objects.equals(this.itemSequenceNumber, packedItems.itemSequenceNumber) && Objects.equals(this.buyerProductIdentifier, packedItems.buyerProductIdentifier) && Objects.equals(this.vendorProductIdentifier, packedItems.vendorProductIdentifier) && Objects.equals(this.packedQuantity, packedItems.packedQuantity) && Objects.equals(this.itemDetails, packedItems.itemDetails);
    }

    public int hashCode() {
        return Objects.hash(this.itemSequenceNumber, this.buyerProductIdentifier, this.vendorProductIdentifier, this.packedQuantity, this.itemDetails);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PackedItems {\n");
        sb.append("    itemSequenceNumber: ").append(this.toIndentedString(this.itemSequenceNumber)).append("\n");
        sb.append("    buyerProductIdentifier: ").append(this.toIndentedString(this.buyerProductIdentifier)).append("\n");
        sb.append("    vendorProductIdentifier: ").append(this.toIndentedString(this.vendorProductIdentifier)).append("\n");
        sb.append("    packedQuantity: ").append(this.toIndentedString(this.packedQuantity)).append("\n");
        sb.append("    itemDetails: ").append(this.toIndentedString(this.itemDetails)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

