/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.models.vendor.shipments.v1;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import software.amazon.spapi.models.vendor.shipments.v1.Expiry;

@Schema(description="Item details for be provided for every item in shipment at either the item or carton or pallet level, whichever is appropriate.")
public class PackageItemDetails {
    @SerializedName(value="purchaseOrderNumber")
    private String purchaseOrderNumber = null;
    @SerializedName(value="lotNumber")
    private String lotNumber = null;
    @SerializedName(value="expiry")
    private Expiry expiry = null;

    public PackageItemDetails purchaseOrderNumber(String purchaseOrderNumber) {
        this.purchaseOrderNumber = purchaseOrderNumber;
        return this;
    }

    @Schema(description="The purchase order number for the shipment being confirmed. If the items in this shipment belong to multiple purchase order numbers that are in particular carton or pallet within the shipment, then provide the purchaseOrderNumber at the appropriate carton or pallet level. Formatting Notes: 8-character alpha-numeric code.")
    public String getPurchaseOrderNumber() {
        return this.purchaseOrderNumber;
    }

    public void setPurchaseOrderNumber(String purchaseOrderNumber) {
        this.purchaseOrderNumber = purchaseOrderNumber;
    }

    public PackageItemDetails lotNumber(String lotNumber) {
        this.lotNumber = lotNumber;
        return this;
    }

    @Schema(description="The batch or lot number associates an item with information the manufacturer considers relevant for traceability of the trade item to which the Element String is applied. The data may refer to the trade item itself or to items contained. This field is mandatory for all perishable items.")
    public String getLotNumber() {
        return this.lotNumber;
    }

    public void setLotNumber(String lotNumber) {
        this.lotNumber = lotNumber;
    }

    public PackageItemDetails expiry(Expiry expiry) {
        this.expiry = expiry;
        return this;
    }

    @Schema(description="")
    public Expiry getExpiry() {
        return this.expiry;
    }

    public void setExpiry(Expiry expiry) {
        this.expiry = expiry;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PackageItemDetails packageItemDetails = (PackageItemDetails)o;
        return Objects.equals(this.purchaseOrderNumber, packageItemDetails.purchaseOrderNumber) && Objects.equals(this.lotNumber, packageItemDetails.lotNumber) && Objects.equals(this.expiry, packageItemDetails.expiry);
    }

    public int hashCode() {
        return Objects.hash(this.purchaseOrderNumber, this.lotNumber, this.expiry);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PackageItemDetails {\n");
        sb.append("    purchaseOrderNumber: ").append(this.toIndentedString(this.purchaseOrderNumber)).append("\n");
        sb.append("    lotNumber: ").append(this.toIndentedString(this.lotNumber)).append("\n");
        sb.append("    expiry: ").append(this.toIndentedString(this.expiry)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

