/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.models.vendor.shipments.v1;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.IOException;
import java.util.Objects;
import software.amazon.spapi.models.vendor.shipments.v1.Expiry;
import software.amazon.spapi.models.vendor.shipments.v1.Money;

@Schema(description="Item details for be provided for every item in shipment at either the item or carton or pallet level, whichever is appropriate.")
public class ItemDetails {
    @SerializedName(value="purchaseOrderNumber")
    private String purchaseOrderNumber = null;
    @SerializedName(value="lotNumber")
    private String lotNumber = null;
    @SerializedName(value="expiry")
    private Expiry expiry = null;
    @SerializedName(value="maximumRetailPrice")
    private Money maximumRetailPrice = null;
    @SerializedName(value="handlingCode")
    private HandlingCodeEnum handlingCode = null;

    public ItemDetails purchaseOrderNumber(String purchaseOrderNumber) {
        this.purchaseOrderNumber = purchaseOrderNumber;
        return this;
    }

    @Schema(description="The purchase order number for the shipment being confirmed. If the items in this shipment belong to multiple purchase order numbers that are in particular carton or pallet within the shipment, then provide the purchaseOrderNumber at the appropriate carton or pallet level. Formatting Notes: 8-character alpha-numeric code.")
    public String getPurchaseOrderNumber() {
        return this.purchaseOrderNumber;
    }

    public void setPurchaseOrderNumber(String purchaseOrderNumber) {
        this.purchaseOrderNumber = purchaseOrderNumber;
    }

    public ItemDetails lotNumber(String lotNumber) {
        this.lotNumber = lotNumber;
        return this;
    }

    @Schema(description="The batch or lot number associates an item with information the manufacturer considers relevant for traceability of the trade item to which the Element String is applied. The data may refer to the trade item itself or to items contained. This field is mandatory for all perishable items.")
    public String getLotNumber() {
        return this.lotNumber;
    }

    public void setLotNumber(String lotNumber) {
        this.lotNumber = lotNumber;
    }

    public ItemDetails expiry(Expiry expiry) {
        this.expiry = expiry;
        return this;
    }

    @Schema(description="")
    public Expiry getExpiry() {
        return this.expiry;
    }

    public void setExpiry(Expiry expiry) {
        this.expiry = expiry;
    }

    public ItemDetails maximumRetailPrice(Money maximumRetailPrice) {
        this.maximumRetailPrice = maximumRetailPrice;
        return this;
    }

    @Schema(description="")
    public Money getMaximumRetailPrice() {
        return this.maximumRetailPrice;
    }

    public void setMaximumRetailPrice(Money maximumRetailPrice) {
        this.maximumRetailPrice = maximumRetailPrice;
    }

    public ItemDetails handlingCode(HandlingCodeEnum handlingCode) {
        this.handlingCode = handlingCode;
        return this;
    }

    @Schema(description="Identification of the instructions on how specified item/carton/pallet should be handled.")
    public HandlingCodeEnum getHandlingCode() {
        return this.handlingCode;
    }

    public void setHandlingCode(HandlingCodeEnum handlingCode) {
        this.handlingCode = handlingCode;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ItemDetails itemDetails = (ItemDetails)o;
        return Objects.equals(this.purchaseOrderNumber, itemDetails.purchaseOrderNumber) && Objects.equals(this.lotNumber, itemDetails.lotNumber) && Objects.equals(this.expiry, itemDetails.expiry) && Objects.equals(this.maximumRetailPrice, itemDetails.maximumRetailPrice) && Objects.equals((Object)this.handlingCode, (Object)itemDetails.handlingCode);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.purchaseOrderNumber, this.lotNumber, this.expiry, this.maximumRetailPrice, this.handlingCode});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ItemDetails {\n");
        sb.append("    purchaseOrderNumber: ").append(this.toIndentedString(this.purchaseOrderNumber)).append("\n");
        sb.append("    lotNumber: ").append(this.toIndentedString(this.lotNumber)).append("\n");
        sb.append("    expiry: ").append(this.toIndentedString(this.expiry)).append("\n");
        sb.append("    maximumRetailPrice: ").append(this.toIndentedString(this.maximumRetailPrice)).append("\n");
        sb.append("    handlingCode: ").append(this.toIndentedString((Object)this.handlingCode)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum HandlingCodeEnum {
        OVERSIZED("Oversized"),
        FRAGILE("Fragile"),
        FOOD("Food"),
        HANDLEWITHCARE("HandleWithCare");

        private String value;

        private HandlingCodeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static HandlingCodeEnum fromValue(String input) {
            for (HandlingCodeEnum b : HandlingCodeEnum.values()) {
                if (!b.value.equals(input)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<HandlingCodeEnum> {
            public void write(JsonWriter jsonWriter, HandlingCodeEnum enumeration) throws IOException {
                jsonWriter.value(String.valueOf(enumeration.getValue()));
            }

            public HandlingCodeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return HandlingCodeEnum.fromValue(value);
            }
        }
    }
}

