/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.models.vendor.shipments.v1;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.IOException;
import java.util.Objects;
import org.threeten.bp.OffsetDateTime;
import software.amazon.spapi.models.vendor.shipments.v1.Route;
import software.amazon.spapi.models.vendor.shipments.v1.Weight;

@Schema(description="Provide these fields only if this shipment is a direct import.")
public class ImportDetails {
    @SerializedName(value="methodOfPayment")
    private MethodOfPaymentEnum methodOfPayment = null;
    @SerializedName(value="sealNumber")
    private String sealNumber = null;
    @SerializedName(value="route")
    private Route route = null;
    @SerializedName(value="importContainers")
    private String importContainers = null;
    @SerializedName(value="billableWeight")
    private Weight billableWeight = null;
    @SerializedName(value="estimatedShipByDate")
    private OffsetDateTime estimatedShipByDate = null;
    @SerializedName(value="handlingInstructions")
    private HandlingInstructionsEnum handlingInstructions = null;

    public ImportDetails methodOfPayment(MethodOfPaymentEnum methodOfPayment) {
        this.methodOfPayment = methodOfPayment;
        return this;
    }

    @Schema(description="This is used for import purchase orders only. If the recipient requests, this field will contain the shipment method of payment.")
    public MethodOfPaymentEnum getMethodOfPayment() {
        return this.methodOfPayment;
    }

    public void setMethodOfPayment(MethodOfPaymentEnum methodOfPayment) {
        this.methodOfPayment = methodOfPayment;
    }

    public ImportDetails sealNumber(String sealNumber) {
        this.sealNumber = sealNumber;
        return this;
    }

    @Schema(description="The container's seal number.")
    public String getSealNumber() {
        return this.sealNumber;
    }

    public void setSealNumber(String sealNumber) {
        this.sealNumber = sealNumber;
    }

    public ImportDetails route(Route route) {
        this.route = route;
        return this;
    }

    @Schema(description="")
    public Route getRoute() {
        return this.route;
    }

    public void setRoute(Route route) {
        this.route = route;
    }

    public ImportDetails importContainers(String importContainers) {
        this.importContainers = importContainers;
        return this;
    }

    @Schema(description="Types and numbers of container(s) for import purchase orders. Can be a comma-separated list if shipment has multiple containers.")
    public String getImportContainers() {
        return this.importContainers;
    }

    public void setImportContainers(String importContainers) {
        this.importContainers = importContainers;
    }

    public ImportDetails billableWeight(Weight billableWeight) {
        this.billableWeight = billableWeight;
        return this;
    }

    @Schema(description="")
    public Weight getBillableWeight() {
        return this.billableWeight;
    }

    public void setBillableWeight(Weight billableWeight) {
        this.billableWeight = billableWeight;
    }

    public ImportDetails estimatedShipByDate(OffsetDateTime estimatedShipByDate) {
        this.estimatedShipByDate = estimatedShipByDate;
        return this;
    }

    @Schema(description="Date on which the shipment is expected to be shipped. This value should not be in the past and not more than 60 days out in the future.")
    public OffsetDateTime getEstimatedShipByDate() {
        return this.estimatedShipByDate;
    }

    public void setEstimatedShipByDate(OffsetDateTime estimatedShipByDate) {
        this.estimatedShipByDate = estimatedShipByDate;
    }

    public ImportDetails handlingInstructions(HandlingInstructionsEnum handlingInstructions) {
        this.handlingInstructions = handlingInstructions;
        return this;
    }

    @Schema(description="Identification of the instructions on how specified item/carton/pallet should be handled.")
    public HandlingInstructionsEnum getHandlingInstructions() {
        return this.handlingInstructions;
    }

    public void setHandlingInstructions(HandlingInstructionsEnum handlingInstructions) {
        this.handlingInstructions = handlingInstructions;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ImportDetails importDetails = (ImportDetails)o;
        return Objects.equals((Object)this.methodOfPayment, (Object)importDetails.methodOfPayment) && Objects.equals(this.sealNumber, importDetails.sealNumber) && Objects.equals(this.route, importDetails.route) && Objects.equals(this.importContainers, importDetails.importContainers) && Objects.equals(this.billableWeight, importDetails.billableWeight) && Objects.equals(this.estimatedShipByDate, importDetails.estimatedShipByDate) && Objects.equals((Object)this.handlingInstructions, (Object)importDetails.handlingInstructions);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.methodOfPayment, this.sealNumber, this.route, this.importContainers, this.billableWeight, this.estimatedShipByDate, this.handlingInstructions});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ImportDetails {\n");
        sb.append("    methodOfPayment: ").append(this.toIndentedString((Object)this.methodOfPayment)).append("\n");
        sb.append("    sealNumber: ").append(this.toIndentedString(this.sealNumber)).append("\n");
        sb.append("    route: ").append(this.toIndentedString(this.route)).append("\n");
        sb.append("    importContainers: ").append(this.toIndentedString(this.importContainers)).append("\n");
        sb.append("    billableWeight: ").append(this.toIndentedString(this.billableWeight)).append("\n");
        sb.append("    estimatedShipByDate: ").append(this.toIndentedString(this.estimatedShipByDate)).append("\n");
        sb.append("    handlingInstructions: ").append(this.toIndentedString((Object)this.handlingInstructions)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum HandlingInstructionsEnum {
        OVERSIZED("Oversized"),
        FRAGILE("Fragile"),
        FOOD("Food"),
        HANDLEWITHCARE("HandleWithCare");

        private String value;

        private HandlingInstructionsEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static HandlingInstructionsEnum fromValue(String input) {
            for (HandlingInstructionsEnum b : HandlingInstructionsEnum.values()) {
                if (!b.value.equals(input)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<HandlingInstructionsEnum> {
            public void write(JsonWriter jsonWriter, HandlingInstructionsEnum enumeration) throws IOException {
                jsonWriter.value(String.valueOf(enumeration.getValue()));
            }

            public HandlingInstructionsEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return HandlingInstructionsEnum.fromValue(value);
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum MethodOfPaymentEnum {
        PAIDBYBUYER("PaidByBuyer"),
        COLLECTONDELIVERY("CollectOnDelivery"),
        DEFINEDBYBUYERANDSELLER("DefinedByBuyerAndSeller"),
        FOBPORTOFCALL("FOBPortOfCall"),
        PREPAIDBYSELLER("PrepaidBySeller"),
        PAIDBYSELLER("PaidBySeller");

        private String value;

        private MethodOfPaymentEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static MethodOfPaymentEnum fromValue(String input) {
            for (MethodOfPaymentEnum b : MethodOfPaymentEnum.values()) {
                if (!b.value.equals(input)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<MethodOfPaymentEnum> {
            public void write(JsonWriter jsonWriter, MethodOfPaymentEnum enumeration) throws IOException {
                jsonWriter.value(String.valueOf(enumeration.getValue()));
            }

            public MethodOfPaymentEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return MethodOfPaymentEnum.fromValue(value);
            }
        }
    }
}

